/*
    icqeditaccountwidget.h - ICQ Account Widget

    Copyright (c) 2003 by Chris TenHarmsel  <tenharmsel@staticmethod.net>
    Copyright (c) 2004-2005 by Matt Rogers <mattr@kde.org>
    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef ICQEDITACCOUNTWIDGET_H
#define ICQEDITACCOUNTWIDGET_H

#include <tqwidget.h>
#include <tqdatetime.h>
#include "editaccountwidget.h"

namespace Kopete { class Account; }

class ICQAccount;
class ICQProtocol;
class ICQEditAccountUI;

class ICQEditAccountWidget : public TQWidget, public KopeteEditAccountWidget
{
Q_OBJECT
  
	
public:
	ICQEditAccountWidget(ICQProtocol *, Kopete::Account *,
	                     TQWidget *parent=0, const char *name=0);
	
	virtual bool validateData();
	virtual Kopete::Account *apply();
	
private slots:
	void slotOpenRegister();
	
protected:
	ICQAccount *mAccount;
	ICQProtocol *mProtocol;
	ICQEditAccountUI *mAccountSettings;
};
#endif
