/*
    kopeteprefs.cpp - Kopete Preferences Container-Class

    Copyright (c) 2002      by Stefan Gehn            <metz AT gehn.net>
    Kopete    (c) 2002-2005 by the Kopete developers  <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef __KOPETEPREFS_H__
#define __KOPETEPREFS_H__

#include <tqobject.h>
#include <tdeversion.h>
#include <tqcolor.h>
#include <tqfont.h>

#include "kopete_export.h"

class TDEConfig;

class KOPETE_EXPORT KopetePrefs : public TQObject
{
	Q_OBJECT
  
	// here so we can use TQt to translate enums<-->strings
	TQ_PROPERTY( ContactDisplayMode contactListDisplayMode READ contactListDisplayMode WRITE setContactListDisplayMode )
	TQ_PROPERTY( IconDisplayMode contactListIconMode READ contactListIconMode WRITE setContactListIconMode )
        TQ_ENUMS( ContactDisplayMode IconDisplayMode )

public:
	/**
	 * The prefs container-class is a singleton object. Use this method to retrieve
	 * the instance.
	 */
	static KopetePrefs *prefs();

	/**
	 * Reads all pref-variables from TDEConfig
	 * usually you don't need this as KopetePrefs loads settings
	 * when an instance is created
	 */
	void load();

	/**
	 * Stores all pref-variables into TDEConfig
	 */
	void save();

	TQString iconTheme() const { return mIconTheme; }
	bool useEmoticons() const { return mUseEmoticons; }
	bool showOffline() const { return mShowOffline; }
	bool showEmptyGroups() const { return mShowEmptyGroups; }
	bool treeView() const { return mTreeView; }
	bool sortByGroup() const { return mSortByGroup; }
	bool greyIdleMetaContacts() const { return mGreyIdle; }
	bool startDocked() const { return mStartDocked; }
	bool useQueue() const { return mUseQueue; }
	bool useStack() const { return mUseStack; }
	bool raiseMsgWindow() const{ return mRaiseMsgWindow; }
	bool showEvents() const{ return mShowEvents; }
	bool trayflashNotify() const { return mTrayflashNotify; }
	bool spellCheck() const { return mSpellCheck; }
	bool queueUnreadMessages() const { return mQueueUnreadMessages; }
	bool queueOnlyHighlightedMessagesInGroupChats() const { return mQueueOnlyHighlightedMessagesInGroupChats; }
	bool queueOnlyMessagesOnAnotherDesktop() const { return mQueueOnlyMessagesOnAnotherDesktop; }
	bool trayflashNotifyLeftClickOpensMessage() const { return mTrayflashNotifyLeftClickOpensMessage; }
	bool trayflashNotifySetCurrentDesktopToChatView() const { return mTrayflashNotifySetCurrentDesktopToChatView; }
	bool balloonNotify() const { return mBalloonNotify; }
	bool balloonNotifyIgnoreClosesChatView() const { return mBalloonNotifyIgnoreClosesChatView; }
	bool balloonClose() const { return mBalloonClose; }
	int balloonCloseDelay() const { return mBalloonCloseDelay; }
	bool soundIfAway() const { return mSoundIfAway; }
	int chatViewBufferSize() const { return mChatViewBufferSize; }
	int rememberedMessages() const { return mRememberedMessages; }
	const TQColor &highlightBackground() const { return mHighlightBackground; }
	const TQColor &highlightForeground() const { return mHighlightForeground; }
	const TQColor &textColor() const { return mTextColor; }
	const TQColor &bgColor() const { return mBgColor; }
	const TQColor &linkColor() const { return mLinkColor; }
	const TQFont &fontFace() const { return mFontFace; }
	const TQColor &idleContactColor() const { return mIdleContactColor; }
	bool highlightEnabled() const { return mHighlightEnabled; }
	bool bgOverride() const { return mBgOverride; }
	bool fgOverride() const { return mFgOverride; }
	bool rtfOverride() const { return mRtfOverride; }

	TQString interfacePreference() const { return mInterfacePreference; }
	bool showTray() const { return mShowTray; }
	bool richText() const { return mRichText; }
	bool chatWShowSend() const { return mChatWShowSend; }
	bool autoConnect() const { return mAutoConnect; }

	int chatWindowPolicy() const { return mChatWindowPolicy; }

	//Styles
	TQString defaultTheme() const { return TQString::fromLatin1("Default"); }
	//for Adium (xhtml+css)
	TQString stylePath() const { return mStylePath; }
	TQString styleVariant() const { return mStyleVariant; }

	TQStringList toolTipContents() const { return mToolTipContents; }

	TQString themeURL() const { return mThemeURL; }

	///
	enum ContactDisplayMode { Classic, RightAligned, Detailed, Yagami, Default = Classic };
	///
	enum IconDisplayMode { IconPic, PhotoPic, IconDefault = IconPic };
	bool contactListIndentContacts() const { return mContactListIndentContacts; }
	ContactDisplayMode contactListDisplayMode() const { return mContactListDisplayMode; }
	IconDisplayMode contactListIconMode() const { return mContactListIconMode; }
	bool contactListUseCustomFonts() const { return mContactListUseCustomFonts; }
	TQFont contactListCustomGroupFont() const { return mContactListGroupFont; }
	TQFont contactListCustomNormalFont() const { return mContactListNormalFont; }
	TQFont contactListCustomSmallFont() const { return mContactListSmallFont; }
	TQFont contactListSmallFont() const;
	TQColor contactListGroupNameColor() const { return mContactListGroupNameColor; }
	bool contactListAnimation() const { return mContactListAnimation; }
	bool contactListFading() const { return mContactListFading; }
	bool contactListFolding() const { return mContactListFolding; }
	bool contactListAutoHide() const { return mContactListAutoHide; }
	unsigned int contactListAutoHideTimeout() const { return mContactListAutoHideTimeout; }

	bool reconnectOnDisconnect() const { return mReconnectOnDisconnect; }

	bool truncateContactNames() const { return mTruncateContactNames; }
	int maxConactNameLength() const { return mMaxContactNameLength; }
	bool emoticonsRequireSpaces() const { return mEmoticonsRequireSpaces; }
	bool groupConsecutiveMessages() const { return mGroupConsecutiveMessages; }

	void setIconTheme(const TQString &value);
	void setUseEmoticons(bool value);
	void setShowOffline(bool value);
	void setShowEmptyGroups(bool value);
	void setTreeView(bool);
	void setSortByGroup(bool);
	void setGreyIdleMetaContacts(bool);
	void setStartDocked(bool);
	void setUseQueue(bool);
	void setUseStack(bool);
	void setRaiseMsgWindow(bool);
	void setShowEvents(bool);
	void setTrayflashNotify(bool);
	void setSpellCheck(bool);
	void setQueueUnreadMessages(bool);
	void setQueueOnlyHighlightedMessagesInGroupChats(bool);
	void setQueueOnlyMessagesOnAnotherDesktop(bool);
	void setTrayflashNotifyLeftClickOpensMessage(bool);
	void setTrayflashNotifySetCurrentDesktopToChatView(bool);
	void setBalloonNotify(bool);
	void setBalloonNotifyIgnoreClosesChatView(bool);
	void setSoundIfAway(bool);
	void setBeepNotify(bool);
	void setChatWindowPolicy(int);
	void setThemeURL(const TQString &);
	void setStylePath(const TQString &);
	void setStyleVariant(const TQString &);
	void setChatViewBufferSize(int);
	void setHighlightBackground(const TQColor &);
	void setHighlightForeground(const TQColor &);
	void setHighlightEnabled(bool);
	void setBgOverride(bool);
	void setFgOverride(bool);
	void setRtfOverride(bool);
	void setInterfacePreference(const TQString &viewPlugin);
	void setTextColor(const TQColor &);
	void setBgColor(const TQColor &);
	void setLinkColor(const TQColor &);
	void setFontFace(const TQFont &);
	void setIdleContactColor(const TQColor &);
	void setShowTray(bool);
	void setRichText(bool);
	void setRememberedMessages(int);
	void setToolTipContents(const TQStringList &);
	void setContactListIndentContacts( bool v );
	void setContactListDisplayMode( ContactDisplayMode v );
	void setContactListIconMode( IconDisplayMode v );
	void setContactListUseCustomFonts( bool v );
	void setContactListCustomGroupFont( const TQFont & v );
	void setContactListCustomNormalFont( const TQFont & v );
	void setContactListCustomSmallFont( const TQFont & v );
	void setContactListGroupNameColor( const TQColor & v );
	void setContactListAnimation( bool );
	void setContactListFading( bool );
	void setContactListFolding( bool );
	void setContactListAutoHide( bool );
	void setContactListAutoHideTimeout( unsigned int );
	void setReconnectOnDisconnect( bool newSetting );
	void setTruncateContactNames( bool );
	void setMaxContactNameLength( int );
	void setAutoConnect( bool );
	void setEmoticonsRequireSpaces( bool );
	void setBalloonClose( bool );
	void setBalloonDelay( int );
	void setGroupConsecutiveMessages( bool );

signals:
	/**
	 * Emitted when config gets saved by save()
	 */
	void saved();
	/**
	 * Emitted when config gets saved by save() and a certain
	 * setting has changed.
	 * Naming scheme is the same as with the config vars.
	 */
	void windowAppearanceChanged();
	void messageAppearanceChanged();
	void contactListAppearanceChanged();
	/**
	 * Emitted when chat Window Style changed.
	 * @param stylePath New stylePath
	 */
	void styleChanged(const TQString &stylePath);
	/**
	 * Emitted when ChatWindowStyle variant changed.
	 * @param variantPath New variant Path.
	 */
	void styleVariantChanged(const TQString &variantPath);

private:
	/**
	 * Private constructor: we are a singleton
	 */
	KopetePrefs();

	/**
	 * Our instance
	 */
	static KopetePrefs *s_prefs;

	TDEConfig *config;

	TQString mIconTheme;
	bool mUseEmoticons;
	bool mShowOffline;
	bool mShowEmptyGroups;
	bool mGreyIdle;
	bool mTreeView;
	bool mSortByGroup;
	bool mStartDocked;
	bool mUseQueue;
	bool mUseStack;
	bool mRaiseMsgWindow;
	bool mShowEvents;
	bool mTrayflashNotify;
	bool mSpellCheck;
	bool mQueueUnreadMessages;
	bool mQueueOnlyHighlightedMessagesInGroupChats;
	bool mQueueOnlyMessagesOnAnotherDesktop;
	bool mTrayflashNotifyLeftClickOpensMessage;
	bool mTrayflashNotifySetCurrentDesktopToChatView;
	bool mBalloonNotify;
	bool mBalloonNotifyIgnoreClosesChatView;
	bool mBalloonClose;
	int mBalloonCloseDelay;
	bool mSoundIfAway;
	int mRememberedMessages;
	TQString mInterfacePreference;
	int mChatViewBufferSize;
	TQColor mHighlightBackground;
	TQColor mHighlightForeground;
	TQColor mTextColor;
	TQColor mBgColor;
	TQColor mLinkColor;
	TQFont mFontFace;
	TQColor mIdleContactColor;
	bool mHighlightEnabled;
	bool mBgOverride;
	bool mFgOverride;
	bool mRtfOverride;
	bool mShowTray;
	bool mWindowAppearanceChanged;
	bool mMessageAppearanceChanged;
	bool mContactListAppearanceChanged;
	bool mChatWShowSend;
	bool mAutoConnect;

	int mChatWindowPolicy;

	bool mTruncateContactNames;
	int mMaxContactNameLength;

	bool mRichText;

	// xhtml+css
	//for Adium (xhtml+css)
	TQString mThemeURL;
	TQString mStylePath;
	TQString mStyleVariant;
	bool mStylePathChanged;
	bool mStyleVariantChanged;

	TQStringList mToolTipContents;

	bool mContactListIndentContacts;
	ContactDisplayMode mContactListDisplayMode;
	IconDisplayMode mContactListIconMode;
	bool mContactListUseCustomFonts;
	TQFont mContactListGroupFont;
	TQFont mContactListNormalFont;
	TQFont mContactListSmallFont;
	TQColor mContactListGroupNameColor;
	bool mContactListAnimation;
	bool mContactListFading;
	bool mContactListFolding;
	bool mContactListAutoHide;
	unsigned int mContactListAutoHideTimeout;

	bool mReconnectOnDisconnect;
	bool mEmoticonsRequireSpaces;
	bool mGroupConsecutiveMessages;

	TQString fileContents(const TQString &path);
	void _setStylePath (const TQString &);
};
#endif
