/*
	fastaddcontactwizard.h - Kopete's Fast Add Contact Wizard
	
	Copyright (c) 2003 by Will Stephenson        <will@stevello.free-online.co.uk>
	
	Derived from AddContactWizard
	Copyright (c) 2002 by Nick Betcher           <nbetcher@kde.org>
	Copyright (c) 2002 by Duncan Mac-Vicar Prett <duncan@kde.org>
	
	Kopete    (c) 2002 by the Kopete developers  <kopete-devel@kde.org>
	
	*************************************************************************
	*                                                                       *
	* This program is free software; you can redistribute it and/or modify  *
	* it under the terms of the GNU General Public License as published by  *
	* the Free Software Foundation; either version 2 of the License, or     *
	* (at your option) any later version.                                   *
	*                                                                       *
	*************************************************************************
*/
#ifndef FASTADDCONTACTWIZARD_H
#define FASTADDCONTACTWIZARD_H
#include <kdebug.h>
#include <tdelistview.h>

#include <tqptrlist.h>
#include <tqvaluelist.h>
#include <tqmap.h>

#include <kdebug.h>
#include <tdelistview.h>

#include "fastaddcontactwizard_base.h"

class AddContactPage;
class TQListViewItem;

namespace Kopete
{
class Account;
}

/**
 * This is a streamlined add contact wizard for users with simple tastes.
 * @author Will Stephenson
 */
 
class FastAddContactWizard : public FastAddContactWizard_Base
{
	Q_OBJECT
  
public:
	FastAddContactWizard( TQWidget *parent = 0, const char *name = 0 );
	~FastAddContactWizard();
private:
	TQMap <Kopete::Account*,AddContactPage*> protocolPages;
	TQMap <TQListViewItem*,Kopete::Account*> m_accountItems;
public slots:
	virtual void accept();
	void slotProtocolListClicked( TQListViewItem * );
protected slots:
	virtual void next();
};

#endif
