/*

Copyright (C) 2010 Timothy Pearson <kb9vqf@pearsoncomputing.net>

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public License
along with this library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
Boston, MA 02110-1301, USA.

*/

#include <tqt.h>
#include <ntqstringlist.h>

#ifdef USE_QT4

void TQStringList::sort()
{
    qHeapSort( *this );
}

TQStringList TQStringList::split( const QChar &sep, const QString &str,
				bool allowEmptyEntries )
{
    return split( QString(sep), str, allowEmptyEntries );
}

TQStringList TQStringList::split( const QString &sep, const QString &str,
				bool allowEmptyEntries )
{
    TQStringList lst;

    int j = 0;
    int i = str.find( sep, j );

    while ( i != -1 ) {
	if ( i > j && i <= (int)str.length() )
	    lst << str.mid( j, i - j );
	else if ( allowEmptyEntries )
	    lst << QString::null;
	j = i + sep.length();
	i = str.find( sep, sep.length() > 0 ? j : j+1 );
    }

    int l = str.length() - 1;
    if ( str.mid( j, l - j + 1 ).length() > 0 )
	lst << str.mid( j, l - j + 1 );
    else if ( allowEmptyEntries )
	lst << QString::null;

    return lst;
}

#ifndef QT_NO_REGEXP
TQStringList TQStringList::split( const QRegExp &sep, const QString &str,
				bool allowEmptyEntries )
{
    TQStringList lst;

    QRegExp tep = sep;

    int j = 0;
    int i = tep.search( str, j );

    while ( i != -1 ) {
	if ( str.mid( j, i - j ).length() > 0 )
	    lst << str.mid( j, i - j );
	else if ( allowEmptyEntries )
	    lst << QString::null;
	if ( tep.matchedLength() == 0 )
	    j = i + 1;
	else
	    j = i + tep.matchedLength();
	i = tep.search( str, j );
    }

    int l = str.length() - 1;
    if ( str.mid( j, l - j + 1 ).length() > 0 )
	lst << str.mid( j, l - j + 1 );
    else if ( allowEmptyEntries )
	lst << QString::null;

    return lst;
}
#endif

TQStringList TQStringList::grep( const QString &str, bool cs ) const
{
    TQStringList res;
    for ( TQStringList::ConstIterator it = begin(); it != end(); ++it )
	if ( (*it).contains(str, cs) )
	    res << *it;

    return res;
}


#ifndef QT_NO_REGEXP
TQStringList TQStringList::grep( const QRegExp &rx ) const
{
    TQStringList res;
    for ( TQStringList::ConstIterator it = begin(); it != end(); ++it )
	if ( (*it).find(rx) != -1 )
	    res << *it;

    return res;
}
#endif

TQStringList& TQStringList::gres( const QString &before, const QString &after,
				bool cs )
{
    TQStringList::Iterator it = begin();
    while ( it != end() ) {
	(*it).replace( before, after, cs );
	++it;
    }
    return *this;
}

#ifndef QT_NO_REGEXP_CAPTURE
TQStringList& TQStringList::gres( const QRegExp &rx, const QString &after )
{
    TQStringList::Iterator it = begin();
    while ( it != end() ) {
	(*it).replace( rx, after );
	++it;
    }
    return *this;
}
#endif

QString TQStringList::join( const QString &sep ) const
{
    QString res;
    bool alredy = FALSE;
    for ( TQStringList::ConstIterator it = begin(); it != end(); ++it ) {
	if ( alredy )
	    res += sep;
	alredy = TRUE;
	res += *it;
    }

    return res;
}

#ifndef QT_NO_DATASTREAM
QDataStream &operator>>( QDataStream & s, TQStringList& l )
{
    return s >> (TQValueList<QString>&)l;
}

QDataStream &operator<<( QDataStream & s, const TQStringList& l )
{
    return s << (const TQValueList<QString>&)l;
}
#endif

TQStringList TQStringList::fromStrList(const TQStrList& ascii)
{
    TQStringList res;
    const char * s;
    for ( TQStrListIterator it(ascii); (s=it.current()); ++it )
	res << s;
    return res;
}

#endif // USE_QT4
