/***************************************************************************
                     titleproxy.h  -  description
                        -------------------
begin                : Nov 20 14:35:18 CEST 2003
copyright            : (C) 2003 by Mark Kretschmann
email                :
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMAROK_TITLEPROXY_H
#define AMAROK_TITLEPROXY_H

#include <kurl.h>             //stack allocated

#include <tqobject.h>
#include <tqserversocket.h>    //baseclass
#include <tqsocket.h>          //stack allocated

class TQString;

namespace TitleProxy
{
    /**
     * Proxy Concept:
     * 1. Connect to streamserver
     * 2. Listen on localhost, let aRts connect to proxyserver
     * 3. Write GET request to streamserver, containing Icy-MetaData:1 token
     * 4. Read MetaInt token from streamserver (==metadata offset)
     *
     * 5. Read stream data (mp3 + metadata) from streamserver
     * 6. Filter out metadata, send to app
     * 7. Write mp3 data to proxyserver
     * 8. Goto 5
     *
     * Some info on the shoutcast metadata protocol can be found at:
     * @see http://www.smackfu.com/stuff/programming/shoutcast.html
     *
     * @short A proxy server for extracting metadata from Shoutcast streams.
     */

    class Proxy : public TQObject
    {
            Q_OBJECT
  
        public:
            Proxy( KURL url );
            ~Proxy();

            bool initSuccess() { return m_initSuccess; }
            KURL proxyUrl();

        signals:
				void metaData(
					const TQString &streamName,
					const TQString &streamGenre,
					const TQString &streamUrl,
					const TQString &streamBitrate,
					const TQString &trackTitle,
					const TQString &trackUrl);
            void proxyError();

        private slots:
            void accept( int socket );
            void connectToHost();
            void sendRequest();
            void readRemote();
            void connectError();

        private:
            bool processHeader( TQ_LONG &index, TQ_LONG bytesRead );
            void transmitData( const TQString &data );
            void error();
            TQString extractStr( const TQString &str, const TQString &key );

        //ATTRIBUTES:
            KURL m_url;
            int m_streamingMode;
            bool m_initSuccess;
            bool m_connectSuccess;

            int m_metaInt;
            TQString m_bitRate;
            int m_byteCount;
            uint m_metaLen;

            TQString m_metaData;
            bool m_headerFinished;
            TQString m_headerStr;
            int m_usedPort;
            TQString m_lastMetadata;
            bool m_icyMode;

            TQString m_streamName;
            TQString m_streamGenre;
            TQString m_streamUrl;

            char *m_pBuf;

            TQSocket m_sockRemote;
            TQSocket m_sockProxy;
    };


    class Server : public TQServerSocket
    {
            Q_OBJECT
  

        public:
            Server( TQ_UINT16 port, TQObject* parent )
                    : TQServerSocket( port, 1, parent, "TitleProxyServer" ) {};

        signals:
            void connected( int socket );

        private:
            void newConnection( int socket ) { emit connected( socket ); }
    };

} //namespace TitleProxy

#endif /*AMAROK_TITLEPROXY_H*/

