/***************************************************************************
    copyright            : (C) 2003 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2 of the License.               *
 *                                                                         *
 ***************************************************************************/

#include "krecconfig_files.h"
#include "krecconfig_files.moc"

#include "krecconfig_fileswidget.h"

#include <kgenericfactory.h>
#include <kdebug.h>
#include <tqlayout.h>
#include <tqbuttongroup.h>
#include <tqradiobutton.h>
#include <tqlineedit.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdelocale.h>

typedef KGenericFactory<KRecConfigFiles, TQWidget> KRecConfigFilesFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_krec_files, KRecConfigFilesFactory( "krec" ) )

KRecConfigFiles::KRecConfigFiles( TQWidget* p, const char*, const TQStringList& s )
 : TDECModule( KRecConfigFilesFactory::instance(), p, s )
 , _layout( 0 )
 , _filewidget( 0 )
{
	_layout = new TQBoxLayout( this, TQBoxLayout::TopToBottom );

	_layout->addSpacing( 10 );

	_filewidget = new KRecConfigFilesWidget( this );
	connect( _filewidget, TQT_SIGNAL( sRateChanged( int ) ), this, TQT_SLOT( ratechanged( int ) ) );
	connect( _filewidget, TQT_SIGNAL( sChannelsChanged( int ) ), this, TQT_SLOT( channelschanged( int ) ) );
	connect( _filewidget, TQT_SIGNAL( sBitsChanged( int ) ), this, TQT_SLOT( bitschanged( int ) ) );
	connect( _filewidget, TQT_SIGNAL( sUseDefaultsChanged( bool ) ), this, TQT_SLOT( usedefaultschanged( bool ) ) );
	_layout->addWidget( _filewidget );

	_layout->addStretch( 100 );

	load();
}

KRecConfigFiles::~KRecConfigFiles() {
}

void KRecConfigFiles::load() {
kdDebug( 60005 ) << k_funcinfo << endl;
	defaults();
	_filewidget->load();
}

void KRecConfigFiles::save() {
	_filewidget->save();
	emit changed( false );
}

void KRecConfigFiles::defaults() {
	_filewidget->defaults();
}

void KRecConfigFiles::ratechanged( int ) {
	emit changed( true );
}
void KRecConfigFiles::channelschanged( int ) {
	emit changed( true );
}
void KRecConfigFiles::bitschanged( int ) {
	emit changed( true );
}
void KRecConfigFiles::usedefaultschanged( bool ) {
	emit changed( true );
}

