/*
    This file is part of tdepim.

    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "bloggingcalendaradaptor.h"
#include "bloggingglobals.h"
#include <libemailfunctions/idmapper.h>
#include <folderlister.h>

#include <libkcal/calendarlocal.h>
#include <libkcal/icalformat.h>
#include <libkcal/resourcecached.h>

#include <kdebug.h>

using namespace KCal;

// That terribly long app key was generated at
// http://www.blogger.com/developers/api/1_docs/register.html
// for the "KDE-Pim libkcal blogging resource".
// TODO:
/*TQString BloggingCalendarAdaptor::mAppID =
    TQString("20ffffffd7ffffffc5ffffffbdffffff87ffffffb72d39fffffffe5c4bfffff"
            "fcfffffff80ffffffd4665cfffffff375ffffff88ffffff871a0cffffff8029");
*/


BloggingUploadItem::BloggingUploadItem( KBlog::APIBlog *api, CalendarAdaptor *adaptor, KCal::Incidence *incidence, KPIM::GroupwareUploadItem::UploadType type )
    : GroupwareUploadItem( type ), mPosting( 0 ), mAPI( 0 )
{
  Journal* j = dynamic_cast<Journal*>( incidence );
  if ( api && j && adaptor ) {
    mItemType = KPIM::FolderLister::Journal;

    setUrl( j->customProperty( adaptor->identifier(), "storagelocation" ) );
    setUid( j->uid() );

    mPosting = api->postingFromJournal( j );
    mAPI = api;
  }
}

BloggingUploadItem::~BloggingUploadItem()
{
  delete mPosting;
}

TDEIO::TransferJob *BloggingUploadItem::createUploadJob( KPIM::GroupwareDataAdaptor *adaptor, const KURL &baseurl )
{
kdDebug()<<"BloggingUploadItem::createUploadJob, adaptor="<<adaptor<<", URL="<<baseurl.url()<<endl;
  Q_ASSERT( adaptor );
  if ( !adaptor || !mAPI ) return 0;
  kdDebug() << "Uploading to: " << url().prettyURL() << endl;
  mAPI->setURL( baseurl );
  return mAPI->createUploadJob( url(), mPosting );
}

TDEIO::TransferJob *BloggingUploadItem::createUploadNewJob( KPIM::GroupwareDataAdaptor *adaptor, const KURL &baseurl )
{
kdDebug()<<"BloggingUploadItem::createUploadNewJob"<<endl;
  Q_ASSERT( adaptor );
  if ( !adaptor || !mAPI ) return 0;
  kdDebug() << "Uploading new item to: " << baseurl.prettyURL() << endl;
  mAPI->setURL( baseurl );
  return mAPI->createUploadNewJob( mPosting );
}






BloggingCalendarAdaptor::BloggingCalendarAdaptor() : mAPI( 0 ), mAuthenticated( false )
{
}


KBlog::APIBlog *BloggingCalendarAdaptor::api() const
{
  return mAPI;
}

void BloggingCalendarAdaptor::setAPI( KBlog::APIBlog *api )
{
  delete mAPI;
  mAPI = api;
  mAuthenticated = false;
  connect( api, TQT_SIGNAL( userInfoRetrieved( const TQString &, const TQString &,
                                           const TQString & ) ),
           TQT_SLOT( slotUserInfoRetrieved( const TQString &, const TQString &,
                                    const TQString & ) ) );
  connect( api, TQT_SIGNAL( folderInfoRetrieved( const TQString &, const TQString & ) ),
           TQT_SLOT( slotFolderInfoRetrieved( const TQString&, const TQString & ) ) );
  connect( api, TQT_SIGNAL( itemOnServer( const KURL & ) ),
           TQT_SIGNAL( itemOnServer( const KURL & ) ) );
  connect( api, TQT_SIGNAL( itemDownloaded( KCal::Incidence *, const TQString &,
                                        const KURL &, const TQString &, const TQString & ) ),
           TQT_SLOT( calendarItemDownloaded( KCal::Incidence *, const TQString &,
                                         const KURL &, const TQString &, const TQString & ) ) );

}

KPIM::GroupwareUploadItem *BloggingCalendarAdaptor::newUploadItem( KCal::Incidence*it,
           KPIM::GroupwareUploadItem::UploadType type )
{
  return new BloggingUploadItem( mAPI, this, it, type );
}



void BloggingCalendarAdaptor::slotFolderInfoRetrieved( const TQString &id, const TQString &name )
{
  emit folderInfoRetrieved( KURL(id), name, KPIM::FolderLister::Journal );
}

void BloggingCalendarAdaptor::slotUserInfoRetrieved( const TQString &/*nick*/,
       const TQString &/*user*/, const TQString &/*email*/ )
{
kdDebug() << "BloggingCalendarAdaptor::slotUserInfoRetrieved"<<endl;
  mAuthenticated = true;
}

void BloggingCalendarAdaptor::setBaseURL( const KURL &url )
{
  if ( mAPI ) {
    mAPI->setURL( url );
  }
}

void BloggingCalendarAdaptor::setUser( const TQString &user )
{
  CalendarAdaptor::setUser( user );
  if ( mAPI ) {
    mAPI->setUsername( user );
  }
}

void BloggingCalendarAdaptor::setPassword( const TQString &password )
{
  CalendarAdaptor::setPassword( password );
  if ( mAPI ) {
    mAPI->setPassword( password );
  }
}

void BloggingCalendarAdaptor::setUserPassword( KURL & )
{
  kdDebug(5800) << "BloggingCalendarAdaptor::setUserPassword" << endl;
}



TDEIO::Job *BloggingCalendarAdaptor::createLoginJob( const KURL &url,
                                                   const TQString &user,
                                                   const TQString &password )
{
  if ( mAPI ) {
    mAPI->setURL( url );
    mAPI->setUsername( user );
    mAPI->setPassword( password );
    return mAPI->createUserInfoJob();
  } else return 0;
}

TDEIO::Job *BloggingCalendarAdaptor::createListFoldersJob( const KURL &/*url*/ )
{
  if ( mAPI ) {
    return mAPI->createListFoldersJob();
  } else return 0;
}

TDEIO::TransferJob *BloggingCalendarAdaptor::createListItemsJob( const KURL &url )
{
  if ( mAPI ) {
    return mAPI->createListItemsJob( url );
  } else return 0;
}

TDEIO::TransferJob *BloggingCalendarAdaptor::createDownloadJob( const KURL &url,
                                     KPIM::FolderLister::ContentType ctype )
{
  if ( mAPI && (ctype & KPIM::FolderLister::Journal) ) {
    return mAPI->createDownloadJob( url );
  } else return 0;
}

TDEIO::Job *BloggingCalendarAdaptor::createRemoveJob( const KURL &url,
                         KPIM::GroupwareUploadItem *deleteItem )
{
kdDebug()<<"BloggingCalendarAdaptor::createRemoveJob( " << url.url() << ", ..)" << endl;
  if ( mAPI && deleteItem ) {
    return mAPI->createRemoveJob( url, deleteItem->url().url() );
  } else return 0;
}




bool BloggingCalendarAdaptor::interpretLoginJob( TDEIO::Job *job )
{
kdDebug()<<"BloggingCalendarAdaptor::interpretLoginJob"<<endl;
  if ( mAPI && job ) {
kdDebug()<<"We have an API and a job"<<endl;
    mAuthenticated = false;
    mAPI->interpretUserInfoJob( job );
kdDebug() << "authenticated=" << mAuthenticated << endl;
    return mAuthenticated;
  } else return false;
}


void BloggingCalendarAdaptor::interpretListFoldersJob( TDEIO::Job *job, KPIM::FolderLister * )
{
kdDebug() << "BloggingCalendarAdaptor::interpretListFoldersJob" << endl;
  if ( mAPI && job ) {
    mAPI->interpretListFoldersJob( job );
  }
}


bool BloggingCalendarAdaptor::interpretListItemsJob( TDEIO::Job *job,
                                                    const TQString &/*jobData*/ )
{
  if ( mAPI ) {
    return mAPI->interpretListItemsJob( job );
  } else {
    return false;
  }
}


bool BloggingCalendarAdaptor::interpretDownloadItemsJob( TDEIO::Job *job,
                                                    const TQString &/*jobData*/ )
{
  if ( mAPI ) {
    return mAPI->interpretDownloadItemsJob( job );
  } else {
    return false;
  }
}

#include "bloggingcalendaradaptor.moc"
