/*
    This file is part of KMail.
    Copyright (c) 2002-2003 Don Sanders <sanders@kde.org>,
    Copyright (c) 2003      Zack Rusin  <zack@kde.org>,
    Based on the work of Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "kmail_part.h"

#include "kmmainwin.h"
#include "kmmainwidget.h"
#include "kmfoldertree.h"
#include "kmstartup.h"
#include "aboutdata.h"
#include "kmfolder.h"
#include "accountmanager.h"
using KMail::AccountManager;
#include "sidebarextension.h"
#include "infoextension.h"
#include "recentaddresses.h"
using TDERecentAddress::RecentAddresses;

#include <tdeapplication.h>
#include <tdeparts/mainwindow.h>
#include <tdeparts/genericfactory.h>
#include <knotifyclient.h>
#include <dcopclient.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <kstatusbar.h>
#include <ksettings/dispatcher.h>


#include <tqlayout.h>


typedef KParts::GenericFactory< KMailPart > KMailFactory;
K_EXPORT_COMPONENT_FACTORY( libkmailpart, KMailFactory )

KMailPart::KMailPart(TQWidget *parentWidget, const char *widgetName,
		     TQObject *parent, const char *name, const TQStringList &) :
  DCOPObject("KMailIface"), KParts::ReadOnlyPart(parent, name),
  mParentWidget( parentWidget )
{
  kdDebug(5006) << "KMailPart()" << endl;
  kdDebug(5006) << "  InstanceName: " << kapp->instanceName() << endl;

  setInstance(KMailFactory::instance());

  kdDebug(5006) << "KMailPart()..." << endl;
  kdDebug(5006) << "  InstanceName: " << kapp->instanceName() << endl;

  // import i18n data and icons from libraries:
  KMail::insertLibraryCataloguesAndIcons();

  // Make sure that the KNotify Daemon is running (this is necessary for people
  // using KMail without KDE)
  KNotifyClient::startDaemon();

  KMail::lockOrDie();

  kapp->dcopClient()->suspend(); // Don't handle DCOP requests yet

  //local, do the init
  KMKernel *mKMailKernel = new KMKernel();
  mKMailKernel->init();
  mKMailKernel->setXmlGuiInstance( KMailFactory::instance() );

  // and session management
  mKMailKernel->doSessionManagement();

  // any dead letters?
  mKMailKernel->recoverDeadLetters();

  kmsetSignalHandler(kmsignalHandler);
  kapp->dcopClient()->resume(); // Ok. We are ready for DCOP requests.

  // create a canvas to insert our widget
  TQWidget *canvas = new TQWidget(parentWidget, widgetName);
  canvas->setFocusPolicy(TQ_ClickFocus);
  setWidget(canvas);
  TDEGlobal::iconLoader()->addAppDir("kmail");
#if 0
  //It's also possible to make a part out of a readerWin
  KMReaderWin *mReaderWin = new KMReaderWin( canvas, canvas, actionCollection() );
  connect(mReaderWin, TQT_SIGNAL(urlClicked(const KURL&,int)),
	  mReaderWin, TQT_SLOT(slotUrlClicked()));
  TQVBoxLayout *topLayout = new TQVBoxLayout(canvas);
  topLayout->addWidget(mReaderWin);
  mReaderWin->setAutoDelete( true );
  kmkernel->inboxFolder()->open();
  KMMessage *msg = kmkernel->inboxFolder()->getMsg(0);
  mReaderWin->setMsg( msg, true );
  mReaderWin->setFocusPolicy(TQWidget::ClickFocus);
  mStatusBar  = new KMailStatusBarExtension(this);
  //new KParts::SideBarExtension( kmkernel->mainWin()-mainKMWidget()->leftFrame(), this );
  TDEGlobal::iconLoader()->addAppDir("kmail");
  setXMLFile( "kmail_part.rc" );
  kmkernel->inboxFolder()->close();
#else
  mainWidget = new KMMainWidget( canvas, "mainWidget", this, actionCollection(),
                                 kapp->config());
  TQVBoxLayout *topLayout = new TQVBoxLayout(canvas);
  topLayout->addWidget(mainWidget);
  mainWidget->setFocusPolicy(TQ_ClickFocus);
  mStatusBar  = new KMailStatusBarExtension(this);
  mStatusBar->addStatusBarItem( mainWidget->vacationScriptIndicator(), 2, false );

  new KParts::SideBarExtension( mainWidget->folderTree(),
                                this,
                                "KMailSidebar" );

  // Get to know when the user clicked on a folder in the KMail part and update the headerWidget of Kontact
  KParts::InfoExtension *ie = new KParts::InfoExtension( this, "KMailInfo" );
  connect( mainWidget->folderTree(), TQT_SIGNAL(folderSelected(KMFolder*)), this, TQT_SLOT(exportFolder(KMFolder*)) );
  connect( mainWidget->folderTree(), TQT_SIGNAL(iconChanged(KMFolderTreeItem*)),
           this, TQT_SLOT(slotIconChanged(KMFolderTreeItem*)) );
  connect( mainWidget->folderTree(), TQT_SIGNAL(nameChanged(KMFolderTreeItem*)),
           this, TQT_SLOT(slotNameChanged(KMFolderTreeItem*)) );
  connect( this, TQT_SIGNAL(textChanged(const TQString&)), ie, TQT_SIGNAL(textChanged(const TQString&)) );
  connect( this, TQT_SIGNAL(iconChanged(const TQPixmap&)), ie, TQT_SIGNAL(iconChanged(const TQPixmap&)) );

  TDEGlobal::iconLoader()->addAppDir( "kmail" );
  setXMLFile( "kmail_part.rc" );
#endif

  KSettings::Dispatcher::self()->registerInstance( KMailFactory::instance(), mKMailKernel,
                                                   TQT_SLOT( slotConfigChanged() ) );
}

KMailPart::~KMailPart()
{
  kdDebug(5006) << "Closing last KMMainWin: stopping mail check" << endl;
  // Running TDEIO jobs prevent kapp from exiting, so we need to kill them
  // if they are only about checking mail (not important stuff like moving messages)
  kmkernel->abortMailCheck();
  kmkernel->acctMgr()->cancelMailCheck();

  mainWidget->destruct();
  kmkernel->cleanup();
  delete kmkernel;
  KMail::cleanup(); // pid file (see kmstartup.cpp)
}

TDEAboutData *KMailPart::createAboutData()
{
  return new KMail::AboutData();
}

bool KMailPart::openFile()
{
  kdDebug(5006) << "KMailPart:openFile()" << endl;

  mainWidget->show();
  return true;
}

void KMailPart::exportFolder( KMFolder *folder )
{
  KMFolderTreeItem* fti = static_cast< KMFolderTreeItem* >( mainWidget->folderTree()->currentItem() );

  if ( folder != 0 )
    emit textChanged( folder->label() );

  if ( fti )
    emit iconChanged( fti->normalIcon( 22 ) );
}

void KMailPart::slotIconChanged( KMFolderTreeItem *fti )
{
  emit iconChanged( fti->normalIcon( 22 ) );
}

void KMailPart::slotNameChanged( KMFolderTreeItem *fti )
{
  emit textChanged( fti->folder()->label() );
}

//-----------------------------------------------------------------------------

// The sole purpose of the following class is to publicize the protected
// method KParts::MainWindow::createGUI() since we need to call it so that
// the toolbar is redrawn when necessary.
// It can be removed once createGUI() has been made public _and_ we don't
// longer rely on tdelibs 3.2.
class KPartsMainWindowWithPublicizedCreateGUI : public KParts::MainWindow
{
public:
  void createGUIPublic( KParts::Part *part ) {
    createGUI( part );
  }
};

//-----------------------------------------------------------------------------

void KMailPart::guiActivateEvent(KParts::GUIActivateEvent *e)
{
  kdDebug(5006) << "KMailPart::guiActivateEvent" << endl;
  KParts::ReadOnlyPart::guiActivateEvent(e);
  mainWidget->initializeFilterActions();
  mainWidget->initializeFolderShortcutActions();
  mainWidget->setupForwardingActionsList();
  mainWidget->updateVactionScripStatus();
}

void KMailPart::exit()
{
  delete this;
}

TQWidget* KMailPart::parentWidget() const
{
  return mParentWidget;
}


KMailStatusBarExtension::KMailStatusBarExtension( KMailPart *parent )
  : KParts::StatusBarExtension( parent ), mParent( parent )
{
}

TDEMainWindow * KMailStatusBarExtension::mainWindow() const
{
  return static_cast<TDEMainWindow*>( mParent->parentWidget() );
}

#include "kmail_part.moc"

