/*
    This file is part of libtdepim.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef KSYNC_ADDRESSEEDIFFALGO_H
#define KSYNC_ADDRESSEEDIFFALGO_H

#include <tdeabc/addressee.h>
#include <libtdepim/diffalgo.h>

using namespace KPIM;

namespace KSync {

class AddresseeDiffAlgo : public DiffAlgo
{
  public:
    AddresseeDiffAlgo( const TDEABC::Addressee &leftAddressee, const TDEABC::Addressee &rightAddressee );
    AddresseeDiffAlgo( const TQString &leftAddressee, const TQString &rightAddressee );

    void run();

  private:
    template <class L>
    void diffList( const TQString &id, const TQValueList<L> &left, const TQValueList<L> &right );

    TQString toString( const TDEABC::PhoneNumber &number );
    TQString toString( const TDEABC::Address &address );

    TDEABC::Addressee mLeftAddressee;
    TDEABC::Addressee mRightAddressee;
};

}

#endif
