/***************************************************************************
 *   Copyright (C) 2005 by Florian Roth   *
 *   florian@synatic.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
 
#ifndef METABAR_FUNCTIONS_H
#define METABAR_FUNCTIONS_H

#include <dom_string.h>

#include <tqtimer.h>
#include <tqmap.h>

#include <kurl.h>
#include <tdehtml_part.h>

class MetabarFunctions : public TQObject
{
  Q_OBJECT
  
  
  public:
    MetabarFunctions(TDEHTMLPart *html, TQObject *parent = 0, const char* name=0);
    ~MetabarFunctions();
    
    void toggle(DOM::DOMString item);
    void adjustSize(DOM::DOMString item);
    void hide(DOM::DOMString item);
    void show(DOM::DOMString item);
    void handleRequest(const KURL &url);
    
  protected:
    TDEHTMLPart *m_html;
    
  private:
    TQTimer *timer;
    
    TQMap<TQString, int> resizeMap;
    int getHeight(DOM::HTMLElement &element);
    
  private slots:
    void animate();
};

#endif
