/*
    KQApplication.cpp

    KNode, the KDE newsreader
    Copyright (c) 1999-2001 the KNode authors.
    See file AUTHORS for details

    Rewritten for Quanta Plus: (C) 2002, 2003 Andras Mantia <amantia@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, US
*/

#include <tqtimer.h>

#include <tdeconfig.h>
#include <kdebug.h>
#include <twin.h>
#include <tdecmdlineargs.h>
#include <kurl.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <tdeglobalsettings.h>
#include <ksplashscreen.h>
#include <dcopclient.h>
#include <tdeversion.h>

#include "config.h"
#include "quantacommon.h"
#include "project.h"
#include "quanta.h"
#include "quanta_init.h"
#include "kqapp.h"

QuantaApp *quantaApp = 0L; //global pointer to the main application object
#define SPLASH_PICTURE "quantalogo"

KSplash::KSplash()
 : TQFrame( 0L, "Quanta" QUANTA_VERSION,
   TQWidget::WStyle_NoBorder | TQWidget::WStyle_Customize | WX11BypassWM)
{
   TQPixmap pm( UserIcon(SPLASH_PICTURE) );

   setBackgroundPixmap(pm);
  TQRect desk = TDEGlobalSettings::splashScreenDesktopGeometry();
  setGeometry( desk.center().x()-225, desk.center().y()-150, 450, 300 );
  setLineWidth(0);
  show();
}


KSplash::~KSplash()
{
}


KQApplication::KQApplication()
 : TDEApplication()
{
   args = TDECmdLineArgs::parsedArgs();
   splash = 0L;

   TDEGlobal::dirs()->addPrefix(PREFIX);
   dcopClient()->registerAs("quanta", true);

//FIXME: Do not hide the problem, but really fix the session restoration.
//I have no idea how to do it, but it may be broken because of delayed
//initialization in QuantaApp
/*   if (isRestored())
   {
     RESTORE(QuantaApp);
   }
   else */
   {
     TDEConfig *config = kapp->config();
     config->setGroup("General Options");
     int mdiMode = config->readNumEntry("MDI mode", KMdi::IDEAlMode);
     TQString layout = config->readEntry("Window layout", "Default");
     if (layout == "Default" || args->isSet("resetlayout"))
     {
         mdiMode = KMdi::IDEAlMode;
         config->writeEntry("MDI mode", KMdi::IDEAlMode);
         config->writeEntry("Window layout", "Default");
     }
     quantaApp = new QuantaApp(mdiMode);
     config->setGroup("General Options");
    if (config->readBoolEntry("Show Splash", true) && args->isSet("logo"))
     {
      sp = new KSplashScreen(UserIcon(SPLASH_PICTURE));
      sp->show();
      connect(quantaApp, TQT_SIGNAL(showSplash(bool)), sp, TQT_SLOT(setShown(bool)));
      TQTimer::singleShot(10*1000, this, TQT_SLOT(slotSplashTimeout()));
     }
     setMainWidget(quantaApp);
     slotInit();
   }
}

void KQApplication::slotInit()
{
  KQApplicationPrivate::init();
}

KQApplication::~KQApplication()
{
}

void KQApplication::slotSplashTimeout()
{
  delete splash;
  delete sp;
  splash = 0L;
  sp = 0L;
}

KQUniqueApplication::KQUniqueApplication()
 : KUniqueApplication()
{
  TDEGlobal::dirs()->addPrefix(PREFIX);
  dcopClient()->registerAs("quanta", false);
}

KQUniqueApplication::~KQUniqueApplication()
{
}


int KQUniqueApplication::newInstance()
{
  args = TDECmdLineArgs::parsedArgs();
  if (mainWidget())
  {
    KWin::activateWindow( mainWidget()->winId() );
    quantaApp = static_cast<QuantaApp*>(mainWidget());
    quantaApp->setParserEnabled(false);
    for (int i = 0; i < args->count(); i++)
    {
      quantaApp->slotFileOpen(args->url(i), quantaApp->defaultEncoding());  // load initial files
    }
    quantaApp->setParserEnabled(true);
    quantaApp->reparse(true);
  }
  else
  {
    splash = 0L;
    TDEConfig *config = kapp->config();
    config->setGroup("General Options");
    int mdiMode = config->readNumEntry("MDI mode", KMdi::IDEAlMode);
    TQString layout = config->readEntry("Window layout", "Default");
    if (layout == "Default" || args->isSet("resetlayout"))
    {
        mdiMode = KMdi::IDEAlMode;
        config->writeEntry("Window layout", "Default");
        config->writeEntry("MDI mode", KMdi::IDEAlMode);
    }
    quantaApp = new QuantaApp(mdiMode);
    config->setGroup("General Options");
    if (config->readBoolEntry("Show Splash", true) && args->isSet("logo"))
    {
      sp = new KSplashScreen(UserIcon(SPLASH_PICTURE));
      sp->show();
      connect(quantaApp, TQT_SIGNAL(showSplash(bool)), sp, TQT_SLOT(setShown(bool)));
      TQTimer::singleShot(10*1000, this, TQT_SLOT(slotSplashTimeout()));
    }
    setMainWidget(quantaApp);
    slotInit();
  }

  return 0;
}

void KQUniqueApplication::slotInit()
{
  KQApplicationPrivate::init();
}

void KQUniqueApplication::slotSplashTimeout()
{
  delete splash;
  delete sp;
  splash = 0L;
  sp = 0L;
}


void KQApplicationPrivate::init()
{
  if (quantaApp->quantaStarted)
  {
    quantaApp->slotEnableIdleTimer(false);
    quantaApp->setParserEnabled(false); //will be enabled in quantaApp->m_quantaInit->openLastFiles();
    quantaApp->m_quantaInit->initQuanta();
    quantaApp->show();

    TQString initialProject;
    TQStringList initialFiles;
    for (int i = 0; i < args->count(); i++ )
    {
      TQString arg = args->url(i).url();

      if(arg.findRev(TQRegExp(".+\\.webprj")) != -1)
        initialProject = arg;
      else
        initialFiles += arg;
    }
    quantaApp->m_quantaInit->loadInitialProject(initialProject);
    //recoverCrashed manages the autosaved copies
    quantaApp->m_quantaInit->recoverCrashed(initialFiles);

    for(TQStringList::Iterator it = initialFiles.begin();it != initialFiles.end();++it)
    {
      KURL url;
      QuantaCommon::setUrl(url, (*it));
      quantaApp->slotFileOpen(url, quantaApp->defaultEncoding());  // load initial files
    }
    quantaApp->m_quantaInit->openLastFiles();
  }
  args->clear();
  delete splash;
  splash = 0L;
  delete sp;
  sp = 0L;
  delete quantaApp->m_quantaInit;
  quantaApp->m_quantaInit = 0L;
  quantaApp->slotEnableIdleTimer(true);
}

#include "kqapp.moc"
