/***************************************************************************
                          projectupload.h  -  description
                             -------------------
    begin                : Wed Nov 15 2000
    copyright            : (C) 2000 by Dmitry Poplavsky & Alexander Yakovlev & Eric Laffoon <pdima@users.sourceforge.net,yshurik@penguinpowered.com,sequitur@easystreet.com>
                           (C) 2002, 2004 Andras Mantia <amantia@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROJECTUPLOAD_H
#define PROJECTUPLOAD_H

#include "projectuploads.h"
#include "project.h"

#include <tqdom.h>
#include <tqptrlist.h>
#include <tqstringlist.h>

#include <tdeio/job.h>

/**
  *@author Dmitry Poplavsky & Alexander Yakovlev & Andras Mantia
  */

class KURL;
class Project;
class UploadProfileDlgS;

class ProjectUpload : public ProjectUploadS
{
  Q_OBJECT
  
public:
  /** Initializes the dialog. If showOnlyProfiles is true, the dialog
  displays only the list of profiles, no real upload can be performed.
  If quickUpload is true, the upload starts immediately without checking
  for modifications or confirmation from the user. The url will be
  uploaded to the default profile */
  ProjectUpload(const KURL& url, const TQString& profileName = TQString(), bool showOnlyProfiles = false, bool quickUpload = false, bool markOnly = false, const char * name = 0);
  ~ProjectUpload();
  TQString defaultProfile();

public slots: // Public slots
  /** No descriptions */
  void slotBuildTree();

protected slots:
  void startUpload();
  void upload();
  void uploadFinished( TDEIO::Job *job );
  void uploadProgress ( TDEIO::Job *job, unsigned long percent );
  void uploadMessage ( TDEIO::Job *, const TQString & msg );
  void slotUploadNext();

  void clearSelection();
  void selectAll();
  void selectModified();
  void invertSelection();
  void expandAll();
  void collapseAll();
  void clearProjectModified();

  void slotNewProfile();
  void slotEditProfile();
  void slotRemoveProfile();
  void slotNewProfileSelected(const TQString &profileName);

  virtual void resizeEvent( TQResizeEvent * );
  virtual void reject();


signals: // Signals
  /** No descriptions */
  void uploadNext();
  void eventHappened(const TQString&, const TQString&, const TQString&);

private:
  void buildSelectedItemList();
  void fillProfileDlg(UploadProfileDlgS *profileDlg);
  void readProfileDlg(UploadProfileDlgS *profileDlg);
  void setProfileTooltip();
  void loadRemoteUploadInfo();
  void saveRemoteUploadInfo();
  void initProjectInfo(const TQString& defaultProfile);
  void initBaseUrl(); /// Reads the current profile setting and initialize the baseUrl from it

  KURL::List modified; // modified files
  TQValueList<TQListViewItem*> needsConfirmation;
  TQPtrList<TQListViewItem> toUpload; // list of files , still didn't uploaded
  TQListViewItem *currentItem;
  KURL currentURL;
  KURL::List madeDirs;
  KURL *baseUrl;
  KURL startUrl;
  bool stopUpload;
  bool uploadInProgress;
  bool suspendUpload;
  TQString m_lastPassword;
  Project *m_project;
  TQString m_defaultProfile;
  TQDomElement m_currentProfileElement;
  TQDomElement m_lastEditedProfileElement;
  TQDomNode m_profilesNode;
  TQDomDocument m_uploadStatusDom;
  TQMap<TQString, int> m_uploadTimeList;
  bool m_profilesOnly;
  bool m_quickUpload;
};

#endif
