/*
 * Copyright (C) 2005 by Linus McCabe, <Linus@McCabe.nu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef dbgpnetwork_H
#define dbgpnetwork_H

#include <kserversocket.h>
#include <kstreamsocket.h>

#include "qbytearrayfifo.h"

//using namespace KNetwork;
class KResolverEntry;

class DBGpNetwork : public TQObject
{
    Q_OBJECT
  

  private:
    KNetwork::KStreamSocket *m_socket;
    KNetwork::TDEServerSocket *m_server;
    TQByteArrayFifo m_fifo;
    bool m_useproxy;
    long m_datalen;
    long  m_transaction_id;

    void connected();

   signals:
    void active(bool isOnline);
    void connected(bool isConnected);
    void networkError(const TQString &error, bool log);
    void command(const TQString& data);

  public:
    DBGpNetwork();
    ~DBGpNetwork();

    virtual void sessionStart(bool useproxy, const TQString& server, const TQString & service);
    virtual void sessionEnd();

    bool isConnected();
    bool isActive();

    long sendCommand(const TQString & command);
    long sendCommand(const TQString & command, const TQString & arguments);
    long sendCommand(const TQString & command, const TQString & arguments, const TQString & data);

  public slots:
    // Socket slots
    void slotConnected(const KResolverEntry &);
    void slotConnectionClosed();
    void slotError(int);
    void slotReadyRead();
    void slotReadyAccept();
    void slotSocketDestroyed();
};


#endif // dbgpnetwork_H
