/*
    From WebMaker - KDE HTML Editor
    Copyright (C) 1998, 1999 Alexei Dets <dets@services.ru>
    Rewritten for Quanta Plus: (C) 2002 Andras Mantia <amantia@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

#ifndef _TQEXTFILEINFO_H_
#define _TQEXTFILEINFO_H_

#include <tdeio/global.h>
#include <tdeio/job.h>
#include <kurl.h>
#include <tdefileitem.h>

#include <tqobject.h>
#include <tqptrlist.h>
#include <tqdict.h>
#include <tqregexp.h>

class QExtFileInfo:public TQObject
{
 Q_OBJECT
  
public:
  QExtFileInfo() {};
  ~QExtFileInfo() {};

  /**
   * Works like TQDir::canonicalPath, but it does not return an empty
   * string if the path does not exists, but tries to find if there
   * is a part of the path which exists and resolv the symlinks for
   * that part. The ending slash is kept in the result.
   * Example:
   * /home/user/foo points to /mnt/foo
   * /home/user/foo/foo2 does not exists
   * QExtFileInfo::canonicalPath("/home/user/foo/foo2/") will return
   * /mnt/foo/foo2/ .
   * @param path the path to resolve
   * @return the canonical path (symlinks resolved)
   */
  static TQString canonicalPath(const TQString& path);

  /**
   * Similar to TQDir::homeDirPath(), but returns a resolved path.
   *
   */
  static TQString homeDirPath();

  /** Returns the relative url of urlToConvert to baseURL. */
  static KURL toRelative(const KURL& urlToConvert, const KURL& baseURL, bool resolveSymlinks = true);
  /** Convert relative url to absolute, based on baseURL. */
  static KURL toAbsolute(const KURL& urlToConvert, const KURL& baseURL);
  /** Returns a recursive list of files under path, matching the specified file mask. */
  static KURL::List allFiles( const KURL& path, const TQString &mask, TQWidget *window);
  /** Returns a recursive list of files under path, matching the specified file mask.
      The returned urls are relative to path.
  */
  static KURL::List allFilesRelative( const KURL& path, const TQString &mask, TQWidget *window, bool resolveSymlinks = true);
  /** Returns a recursive list of files under path, matching the specified file mask.
      The returned list contains detailed information about each url.
      The user should delete the KFileItems and clear the dict
      after they are not needed.
  */
  static TQDict<KFileItem> allFilesDetailed(const KURL& path, const TQString &mask, TQWidget *window);
  /** Creates a dir if don't exists. */
  static bool createDir(const KURL & path, TQWidget *window);
  /** Returns the parent directory of dir. */
  static KURL cdUp(const KURL &dir);
  /** Returns the filename from a path string. */
  static TQString shortName(const TQString &fname );
  /** Returns the path to the url. */
  static KURL path(const KURL &);
  /** Returns the user's home directory as an url. */
  static KURL home();
  /** A slightly better working alternative of TDEIO::NetAccess::exists().
      Checks for the existance of the url. readingOnly is true if we check if
      the url is readable, and false if we check if it is writable.*/
  static bool exists(const KURL& url, bool readingOnly, TQWidget *window);
  /** Synchronous copy, like NetAccess::file_copy in KDE 3.2, just that it doesn't show a progress dialog */
  static bool copy( const KURL& src, const KURL& dest, int permissions=-1,
                    bool overwrite=false, bool resume=false, TQWidget* window = 0L );
  /** Reenters the event loop. You must call tqApp->exit_loop() to exit it. */
  void enter_loop();

private:
  /** Internal methods called by the above ones. They start their own event loop and
      exit when the even loop is exited */
  bool internalExists(const KURL& url, bool readingOnly, TQWidget *window);
  bool internalCopy(const KURL& src, const KURL& target, int permissions,
                    bool overwrite, bool resume, TQWidget* window);
  KURL::List allFilesInternal(const KURL& startURL, const TQString& mask, TQWidget *window);
  TQDict<KFileItem> allFilesDetailedInternal(const KURL& startURL, const TQString& mask, TQWidget *window);
  KURL::List allLocalFiles(const TQString& startPath, const TQString& mask);

  bool bJobOK;
  static TQString lastErrorMsg;
  TDEIO::UDSEntry m_entry;
  KURL::List dirListItems;
  TQDict<KFileItem> detailedDirListItems;
  TQPtrList<TQRegExp> lstFilters;
  int m_listJobCount;
  TQString m_listStartURL;

private slots:
  void slotListResult(TDEIO::Job *job);
  void slotResult(TDEIO::Job * job);
  void slotNewEntries(TDEIO::Job *job, const TDEIO::UDSEntryList& udsList);
  void slotNewDetailedEntries(TDEIO::Job *job, const TDEIO::UDSEntryList& udsList);
public slots:
  /** Timeout occurred while waiting for some network function to return. */
  void slotTimeout();
};


#endif
