/***************************************************************************
                          slider.h - Slider widget
                             -------------------
    copyright            : (C) 2004      Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _HAVE_SLIDER_H_
#define _HAVE_SLIDER_H_

/* KDE INCLUDES */
#include <tqslider.h>

/* QT INCLUDES */
#include <tqstringlist.h>
#include <tqstring.h>

/* OTHER INCLUDES */
#include <kommanderwidget.h>
#include <kommander_export.h>
class TQShowEvent;
class KOMMANDER_EXPORT Slider: public TQSlider, public KommanderWidget
{
  Q_OBJECT
  
  TQ_PROPERTY(TQString populationText READ populationText WRITE setPopulationText DESIGNABLE false)
  TQ_PROPERTY(TQStringList associations READ associatedText WRITE setAssociatedText DESIGNABLE false)
  TQ_PROPERTY(bool KommanderWidget READ isKommanderWidget) 
public:
  Slider(TQWidget*, const char*);
  virtual ~Slider();
  
  virtual bool isKommanderWidget() const;
  virtual void setAssociatedText(const TQStringList &);
  virtual TQStringList associatedText() const;
  virtual TQString currentState() const;
  virtual TQString populationText() const;
  virtual void setPopulationText(const TQString &);
  
  virtual TQString handleDCOP(int function, const TQStringList& args);
  virtual bool isFunctionSupported(int function);

public slots:
  virtual void setWidgetText(const TQString &);
  virtual void populate();

signals: 
  void widgetOpened();

protected:
  void showEvent(TQShowEvent* e);
};

#endif
