/**********************************************************************
** Copyright (C) 2000 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tdelocale.h>
#include <kommanderfactory.h>

#include "kmdrmainwindow.h"
#include <tqvariant.h> // HP-UX compiler need this here
#include "widgetfactory.h"
#include "widgetdatabase.h"
#include "metadatabase.h"
#include "mainwindow.h"
#include "formwindow.h"
#include "pixmapchooser.h"
#include "tqlayout.h"
#include "listboxeditorimpl.h"
#include "listvieweditorimpl.h"
#include "iconvieweditorimpl.h"
#include "multilineeditorimpl.h"
#ifndef KOMMANDER
#include "widgetinterface.h"
#endif
#ifndef TQT_NO_TABLE
#include "tableeditorimpl.h"
#endif

#include <tqfeatures.h>

#include <tqpixmap.h>
#include <tqgroupbox.h>
#include <tqiconview.h>
#ifndef TQT_NO_TABLE
#include <tqtable.h>
#endif
#ifndef TQT_NO_SQL
#include <tqdatatable.h>
#endif
#include <tqdatetimeedit.h>
#include <tqlineedit.h>
#include <tqspinbox.h>
#include <tqmultilineedit.h>
#include <tqtextedit.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqwidgetstack.h>
#include <tqcombobox.h>
#include <tqtabbar.h>
#include <tqlistbox.h>
#include <tqlistview.h>
#include <tqobjectlist.h>
#include <tqlcdnumber.h>
#include <tqslider.h>
#include <tqdial.h>
#include <tqprogressbar.h>
#include <tqtextview.h>
#include <tqtextbrowser.h>
#include <tqframe.h>
#include <tqmetaobject.h>
#include <tqwizard.h>
#include <tqvaluelist.h>
#include <tqtimer.h>
#include <tqscrollbar.h>
#include <tqmainwindow.h>
#include <tqmenubar.h>
#include <tqapplication.h>
#include <tqsplitter.h>
#ifndef TQT_NO_SQL
#include "database.h"
#endif

//#define NO_STATIC_COLORS
#include "globaldefs.h"

/* KOMMANDER INCLUDES */
#include <lineedit.h>
#include <dialog.h>
#include <execbutton.h>
#include <closebutton.h>
#include <textedit.h>
#include <fileselector.h>
#include <textedit.h>
#include <radiobutton.h>
#include <groupbox.h>
#include <buttongroup.h>
#include <checkbox.h>
#include <combobox.h>
#include <spinboxint.h>
#include <wizard.h>
#include <tabwidget.h>
#include <subdialog.h>
#include <listbox.h>
#include <scriptobject.h>
#include <richtexteditor.h>
#include <treewidget.h>
#include <slider.h>
#include <datepicker.h>
#include <popupmenu.h>
#include "toolbox.h"
#include "fontdialog.h"
#include "aboutdialog.h"

FormWindow *find_formwindow( TQWidget *w )
{
    if ( !w )
	return 0;
    for (;;) {
	if ( w->inherits( "FormWindow" ) )
	    return (FormWindow*)w;
	if ( !w->parentWidget() )
	    return 0;
	w = w->parentWidget();
    }
}

void TQLayoutWidget::paintEvent( TQPaintEvent* )
{
    TQPainter p ( this );
    p.setPen( red );
    p.drawRect( rect() );
}


QDesignerTabWidget::QDesignerTabWidget( TQWidget *parent, const char *name )
    : TQTabWidget( parent, name ), dropIndicator( 0 ), dragPage( 0 ), mousePressed( false )
{
    tabBar()->setAcceptDrops( true );
    tabBar()->installEventFilter( this );
}

int QDesignerTabWidget::currentPage() const
{
    return tabBar()->currentTab();
}

void QDesignerTabWidget::setCurrentPage( int i )
{
    tabBar()->setCurrentTab( i );
}

TQString QDesignerTabWidget::pageTitle() const
{
    return ((TQTabWidget*)this)->tabLabel( TQTabWidget::currentPage() );
}

void QDesignerTabWidget::setPageTitle( const TQString& title )
{
    changeTab( TQTabWidget::currentPage(), title );
}

void QDesignerTabWidget::setPageName( const TQCString& name )
{
    if ( TQTabWidget::currentPage() )
	TQTabWidget::currentPage()->setName( name );
}

TQCString QDesignerTabWidget::pageName() const
{
    if ( !TQTabWidget::currentPage() )
	return 0;
    return TQTabWidget::currentPage()->name();
}

int QDesignerTabWidget::count() const
{
    return tabBar()->count();
}

bool QDesignerTabWidget::eventFilter( TQObject *o, TQEvent *e )
{
    if ( TQT_BASE_OBJECT(o) != TQT_BASE_OBJECT(tabBar()) ) return false;

    switch ( e->type() ) {
    case TQEvent::MouseButtonPress: {
	mousePressed = true;
	TQMouseEvent *me = (TQMouseEvent*)e;
	pressPoint = me->pos();
    }
    break;
    case TQEvent::MouseMove: {
	TQMouseEvent *me = (TQMouseEvent*)e;
	if ( mousePressed && ( pressPoint - me->pos()).manhattanLength() > TQApplication::startDragDistance() ) {
	    TQTextDrag *drg = new TQTextDrag( TQString::number( (long) this ) , this );
	    mousePressed = false;
	    dragPage = TQTabWidget::currentPage();
	    dragLabel = TQTabWidget::tabLabel( dragPage );

	    int index = indexOf( dragPage );

	    removePage( dragPage );
	    if ( !drg->dragMove() ) {
		insertTab( dragPage, dragLabel, index );
		showPage( dragPage );
	    }
	    if ( dropIndicator )
		dropIndicator->hide();
	}
    }
    break;
    case TQEvent::DragLeave:	{
	if ( dropIndicator )
	    dropIndicator->hide();
    }
    break;
    case TQEvent::DragMove: {
	TQDragEnterEvent *de = (TQDragEnterEvent*) e;
	if ( TQTextDrag::canDecode( de ) ) {
	    TQString text;
	    TQTextDrag::decode( de, text );
	    if ( text == TQString::number( (long)this ) )
		de->accept();
	    else
		return false;
	}

	int index = 0;
	TQRect rect;
	for ( ; index < tabBar()->count(); index++ ) {
	    if ( tabBar()->tabAt( index )->rect().contains( de->pos() ) ) {
		rect = tabBar()->tabAt( index )->rect();
		break;
	    }
	}

	if ( index == tabBar()->count() -1 ) {
	    TQRect rect2 = rect;
	    rect2.setLeft( rect2.left() + rect2.width() / 2 );
	    if ( rect2.contains( de->pos() ) )
		index++;
	}

	if ( ! dropIndicator ) {
	    dropIndicator = new TQWidget( this );
	    dropIndicator->setBackgroundColor( red );
	}

	TQPoint pos;
	if ( index == tabBar()->count() )
	    pos = tabBar()->mapToParent( TQPoint( rect.x() + rect.width(), rect.y() ) );
	else
	    pos = tabBar()->mapToParent( TQPoint( rect.x(), rect.y() ) );

	dropIndicator->setGeometry( pos.x(), pos.y() , 3, rect.height() );
	dropIndicator->show();
    }
    break;
    case TQEvent::Drop: {
	TQDragEnterEvent *de = (TQDragEnterEvent*) e;
	if ( TQTextDrag::canDecode( de ) ) {
	    TQString text;
	    TQTextDrag::decode( de, text );
	    if ( text == TQString::number( (long)this ) ) {

		int newIndex = 0;
		for ( ; newIndex < tabBar()->count(); newIndex++ ) {
		    if ( tabBar()->tabAt( newIndex )->rect().contains( de->pos() ) )
			break;
		}

		if ( newIndex == tabBar()->count() -1 ) {
		    TQRect rect2 = tabBar()->tabAt( newIndex )->rect();
		    rect2.setLeft( rect2.left() + rect2.width() / 2 );
		    if ( rect2.contains( de->pos() ) )
			newIndex++;
		}

		int oldIndex = 0;
		for ( ; oldIndex < tabBar()->count(); oldIndex++ ) {
		    if ( tabBar()->tabAt( oldIndex )->rect().contains( pressPoint ) )
			break;
		}

		FormWindow *fw = find_formwindow( this );
		MoveTabPageCommand *cmd =
		    new MoveTabPageCommand( i18n("Move Tab Page" ), fw, this,
					    dragPage, dragLabel, newIndex, oldIndex );
		fw->commandHistory()->addCommand( cmd );
		cmd->execute();
		de->accept();
	    }
	}
    }
    break;
    default:
	break;
    }
    return false;
}

int QDesignerWizard::currentPageNum() const
{
    for ( int i = 0; i < pageCount(); ++i ) {
	if ( page( i ) == currentPage() )
	    return i;
    }
    return 0;
}

void QDesignerWizard::setCurrentPage( int i )
{
    if ( i < currentPageNum() ) {
	while ( i < currentPageNum() ) {
	    if ( currentPageNum() == 0 )
		break;
	    back();
	}

    } else {
	while ( i > currentPageNum() ) {
	    if ( currentPageNum() == pageCount() - 1 )
		break;
	    next();
	}
    }
}

TQString QDesignerWizard::pageTitle() const
{
    return title( currentPage() );
}

void QDesignerWizard::setPageTitle( const TQString& title )
{
    setTitle( currentPage(), title );
}

void QDesignerWizard::setPageName( const TQCString& name )
{
    if ( TQWizard::currentPage() )
	TQWizard::currentPage()->setName( name );
}

TQCString QDesignerWizard::pageName() const
{
    if ( !TQWizard::currentPage() )
	return 0;
    return TQWizard::currentPage()->name();
}

int QDesignerWizard::pageNum( TQWidget *p )
{
    for ( int i = 0; i < pageCount(); ++i ) {
	if ( page( i ) == p )
	    return i;
    }
    return -1;
}

void QDesignerWizard::addPage( TQWidget *p, const TQString &t )
{
    TQWizard::addPage( p, t );
    if ( removedPages.find( p ) )
	removedPages.remove( p );
}

void QDesignerWizard::removePage( TQWidget *p )
{
    TQWizard::removePage( p );
    removedPages.insert( p, p );
}

void QDesignerWizard::insertPage( TQWidget *p, const TQString &t, int index )
{
    TQWizard::insertPage( p, t, index );
    if ( removedPages.find( p ) )
	removedPages.remove( p );
}

TQMap< int, TQMap< TQString, TQVariant> > *defaultProperties = 0;
TQMap< int, TQStringList > *changedProperties = 0;

/*!
  \class WidgetFactory widgetfactory.h
  \brief Set of static functions for creating widgets, layouts and do other stuff

  The widget factory offers functions to create widgets, create and
  delete layouts find out other details - all based on the
  WidgetDatabase's data. So the functions that use ids use the same
  ids as in the WidgetDatabase.
*/


void WidgetFactory::saveDefaultProperties( TQWidget *w, int id )
{
    TQMap< TQString, TQVariant> propMap;
    TQStrList lst = w->metaObject()->propertyNames( true );
    for ( uint i = 0; i < lst.count(); ++i ) {
	TQVariant var = w->property( lst.at( i ) );
	if ( !var.isValid() && qstrcmp( "pixmap", lst.at( i ) ) == 0 )
	    var = TQVariant( TQPixmap() );
	else if ( !var.isValid() && qstrcmp( "iconSet", lst.at( i ) ) == 0 )
	    var = TQVariant( TQIconSet() );
	propMap.replace( lst.at( i ), var );
    }
    defaultProperties->replace( id, propMap );
}

static void saveChangedProperties( TQWidget *w, int id )
{
    TQStringList l = MetaDataBase::changedProperties( TQT_TQOBJECT(w) );
    changedProperties->insert( id, l );
}

EditorTabWidget::EditorTabWidget( TQWidget *parent, const char *name )
    : TabWidget( parent, name ), dropIndicator( 0 ), dragPage( 0 ), mousePressed( false )
{
    tabBar()->setAcceptDrops( true );
    tabBar()->installEventFilter( this );
}

int EditorTabWidget::currentPage() const
{
    return tabBar()->currentTab();
}

void EditorTabWidget::setCurrentPage( int i )
{
    tabBar()->setCurrentTab( i );
}

TQString EditorTabWidget::pageTitle() const
{
    return ((TQTabWidget*)this)->tabLabel( TQTabWidget::currentPage() );
}

void EditorTabWidget::setPageTitle( const TQString& title )
{
    changeTab( TQTabWidget::currentPage(), title );
}

void EditorTabWidget::setPageName( const TQCString& name )
{
    if ( TQTabWidget::currentPage() )
	TQTabWidget::currentPage()->setName( name );
}

TQCString EditorTabWidget::pageName() const
{
    if ( !TQTabWidget::currentPage() )
	return 0;
    return TQTabWidget::currentPage()->name();
}

int EditorTabWidget::count() const
{
    return tabBar()->count();
}

bool EditorTabWidget::eventFilter( TQObject *o, TQEvent *e )
{
    if ( TQT_BASE_OBJECT(o) != TQT_BASE_OBJECT(tabBar()) ) return false;

    switch ( e->type() ) {
    case TQEvent::MouseButtonPress: {
	mousePressed = true;
	TQMouseEvent *me = (TQMouseEvent*)e;
	pressPoint = me->pos();
    }
    break;
    case TQEvent::MouseMove: {
	TQMouseEvent *me = (TQMouseEvent*)e;
	if ( mousePressed && ( pressPoint - me->pos()).manhattanLength() > TQApplication::startDragDistance() ) {
	    TQTextDrag *drg = new TQTextDrag( TQString::number( (long) this ) , this );
	    mousePressed = false;
	    dragPage = TQTabWidget::currentPage();
	    dragLabel = TQTabWidget::tabLabel( dragPage );

	    int index = indexOf( dragPage );

	    removePage( dragPage );
	    if ( !drg->dragMove() ) {
		insertTab( dragPage, dragLabel, index );
		showPage( dragPage );
	    }
	    if ( dropIndicator )
		dropIndicator->hide();
	}
    }
    break;
    case TQEvent::DragLeave:	{
	if ( dropIndicator )
	    dropIndicator->hide();
    }
    break;
    case TQEvent::DragMove: {
	TQDragEnterEvent *de = (TQDragEnterEvent*) e;
	if ( TQTextDrag::canDecode( de ) ) {
	    TQString text;
	    TQTextDrag::decode( de, text );
	    if ( text == TQString::number( (long)this ) )
		de->accept();
	    else
		return false;
	}

	int index = 0;
	TQRect rect;
	for ( ; index < tabBar()->count(); index++ ) {
	    if ( tabBar()->tabAt( index )->rect().contains( de->pos() ) ) {
		rect = tabBar()->tabAt( index )->rect();
		break;
	    }
	}

	if ( index == tabBar()->count() -1 ) {
	    TQRect rect2 = rect;
	    rect2.setLeft( rect2.left() + rect2.width() / 2 );
	    if ( rect2.contains( de->pos() ) )
		index++;
	}

	if ( ! dropIndicator ) {
	    dropIndicator = new TQWidget( this );
	    dropIndicator->setBackgroundColor( red );
	}

	TQPoint pos;
	if ( index == tabBar()->count() )
	    pos = tabBar()->mapToParent( TQPoint( rect.x() + rect.width(), rect.y() ) );
	else
	    pos = tabBar()->mapToParent( TQPoint( rect.x(), rect.y() ) );

	dropIndicator->setGeometry( pos.x(), pos.y() , 3, rect.height() );
	dropIndicator->show();
    }
    break;
    case TQEvent::Drop: {
	TQDragEnterEvent *de = (TQDragEnterEvent*) e;
	if ( TQTextDrag::canDecode( de ) ) {
	    TQString text;
	    TQTextDrag::decode( de, text );
	    if ( text == TQString::number( (long)this ) ) {

		int newIndex = 0;
		for ( ; newIndex < tabBar()->count(); newIndex++ ) {
		    if ( tabBar()->tabAt( newIndex )->rect().contains( de->pos() ) )
			break;
		}

		if ( newIndex == tabBar()->count() -1 ) {
		    TQRect rect2 = tabBar()->tabAt( newIndex )->rect();
		    rect2.setLeft( rect2.left() + rect2.width() / 2 );
		    if ( rect2.contains( de->pos() ) )
			newIndex++;
		}

		int oldIndex = 0;
		for ( ; oldIndex < tabBar()->count(); oldIndex++ ) {
		    if ( tabBar()->tabAt( oldIndex )->rect().contains( pressPoint ) )
			break;
		}

		FormWindow *fw = find_formwindow( this );
		MoveTabPageCommand *cmd =
		    new MoveTabPageCommand( i18n("Move Tab Page" ), fw, this,
					    dragPage, dragLabel, newIndex, oldIndex );
		fw->commandHistory()->addCommand( cmd );
		cmd->execute();
		de->accept();
	    }
	}
    }
    break;
    default:
	break;
    }
    return false;
}


EditorToolBox::EditorToolBox( TQWidget *parent, const char *name )
    : ToolBox( parent, name )
{
    setAcceptDrops( true );
}

int EditorToolBox::currentPage() const
{
    return currentIndex();
}

void EditorToolBox::setCurrentPage( int i )
{
    setCurrentItem( item( i ) );
}

TQString EditorToolBox::pageTitle() const
{
    return itemLabel( currentIndex() );
}

void EditorToolBox::setPageTitle( const TQString& title )
{
    setItemLabel( currentIndex(), title );
}

void EditorToolBox::setPageName( const TQCString& name )
{
    if ( currentItem() )
    currentItem()->setName( name );
}

TQCString EditorToolBox::pageName() const
{
    if ( !currentItem() )
    return 0;
    return currentItem()->name();
}

int EditorToolBox::count() const
{
    return TQToolBox::count();
}



/*!  Creates a widget of the type which is registered as \a id as
  child of \a parent. The \a name is optional. If \a init is true, the
  widget is initialized with some defaults, else the plain widget is
  created.
*/

TQWidget *WidgetFactory::create( int id, TQWidget *parent, const char *name, bool init, const TQRect *r, Qt::Orientation orient )
{
  TQString n = WidgetDatabase::className(id);
  //tqDebug("Trying to create '%s'", n.latin1());
  if (n.isEmpty())
    return 0;

  if (!defaultProperties)
  {
    defaultProperties = new TQMap < int, TQMap < TQString, TQVariant > >();
    changedProperties = new TQMap < int, TQStringList > ();
  }

  TQWidget *w = 0;
  TQString str = WidgetDatabase::createWidgetName(id);
  const char *s = str.latin1();
  w = createWidget(n, parent, name ? name : s, init, r, orient);
  //tqDebug("Trying to create '%s', widget (id=%d) - %s", s, id, w ? "successful" : "failure");
  if (!w && WidgetDatabase::isCustomWidget(id))
    w = createCustomWidget(parent, name ? name : s, MetaDataBase::customWidget(id));
  if (!w)
    return 0;
  MetaDataBase::addEntry(TQT_TQOBJECT(w));

  if (!defaultProperties->contains(id))
    saveDefaultProperties(w, id);
  if (!changedProperties->contains(id))
    saveChangedProperties(w, id);

  return w;
}

/*!  Creates a layout on the widget \a widget of the type \a type
  which can be \c HBox, \c VBox or \c Grid.
*/

TQLayout *WidgetFactory::createLayout( TQWidget *widget, TQLayout *layout, LayoutType type )
{
    int spacing = MainWindow::self->currentLayoutDefaultSpacing();
    int margin = 0;

    if ( widget && !widget->inherits( "TQLayoutWidget" ) &&
	 ( WidgetDatabase::isContainer( WidgetDatabase::idFromClassName( WidgetFactory::classNameOf( TQT_TQOBJECT(widget) ) ) ) ||
	   widget && widget->parentWidget() && widget->parentWidget()->inherits( "FormWindow" ) ) )
	margin = MainWindow::self->currentLayoutDefaultMargin();

    if ( !layout && widget && widget->inherits( "TQTabWidget" ) )
	widget = ((TQTabWidget*)widget)->currentPage();

    if ( !layout && widget && widget->inherits( "TQToolBox" ) )
    widget = ((TQToolBox*)widget)->currentItem();

    if ( !layout && widget && widget->inherits( "TQWizard" ) )
	widget = ((TQWizard*)widget)->currentPage();

    if ( !layout && widget && widget->inherits( "TQMainWindow" ) )
	widget = ((TQMainWindow*)widget)->centralWidget();

    if ( !layout && widget && widget->inherits( "TQWidgetStack" ) )
	widget = ((TQWidgetStack*)widget)->visibleWidget();

    MetaDataBase::addEntry( TQT_TQOBJECT(widget) );

    if ( !layout && widget && widget->inherits( "TQGroupBox" ) ) {
	TQGroupBox *gb = (TQGroupBox*)widget;
	gb->setColumnLayout( 0, Qt::Vertical );
	gb->layout()->setMargin( 0 );
	gb->layout()->setSpacing( 0 );
	TQLayout *l;
	switch ( type ) {
	case HBox:
	    l = new TQHBoxLayout( gb->layout() );
	    MetaDataBase::setMargin( TQT_TQOBJECT(gb), margin );
	    MetaDataBase::setSpacing( TQT_TQOBJECT(gb), spacing );
	    l->setAlignment( AlignTop );
	    MetaDataBase::addEntry( TQT_TQOBJECT(l) );
	    return l;
	case VBox:
	    l = new TQVBoxLayout( gb->layout(), spacing );
	    MetaDataBase::setMargin( TQT_TQOBJECT(gb), margin );
	    MetaDataBase::setSpacing( TQT_TQOBJECT(gb), spacing );
	    l->setAlignment( AlignTop );
	    MetaDataBase::addEntry( TQT_TQOBJECT(l) );
	    return l;
	case Grid:
	    l = new QDesignerGridLayout( gb->layout() );
	    MetaDataBase::setMargin( TQT_TQOBJECT(gb), margin );
	    MetaDataBase::setSpacing( TQT_TQOBJECT(gb), spacing );
	    l->setAlignment( AlignTop );
	    MetaDataBase::addEntry( TQT_TQOBJECT(l) );
	    return l;
	default:
	    return 0;
	}
    } else {
	if ( layout ) {
	    TQLayout *l;
	    switch ( type ) {
	    case HBox:
		l = new TQHBoxLayout( layout );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		l->setSpacing( spacing );
		l->setMargin( margin );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		return l;
	    case VBox:
		l = new TQVBoxLayout( layout );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		l->setSpacing( spacing );
		l->setMargin( margin );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		return l;
	    case Grid: {
		l = new QDesignerGridLayout( layout );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		l->setSpacing( spacing );
		l->setMargin( margin );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		return l;
	    }
	    default:
		return 0;
	    }
	} else {
	    TQLayout *l;
	    switch ( type ) {
	    case HBox:
		l = new TQHBoxLayout( widget );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		if ( widget ) {
		    MetaDataBase::setMargin( TQT_TQOBJECT(widget), margin );
		    MetaDataBase::setSpacing( TQT_TQOBJECT(widget), spacing );
		} else {
		    l->setMargin( margin );
		    l->setSpacing( margin );
		}
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		return l;
	    case VBox:
		l = new TQVBoxLayout( widget );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		if ( widget ) {
		    MetaDataBase::setMargin( TQT_TQOBJECT(widget), margin );
		    MetaDataBase::setSpacing( TQT_TQOBJECT(widget), spacing );
		} else {
		    l->setMargin( margin );
		    l->setSpacing( margin );
		}
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		return l;
	    case Grid: {
		l = new QDesignerGridLayout( widget );
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		if ( widget ) {
		    MetaDataBase::setMargin( TQT_TQOBJECT(widget), margin );
		    MetaDataBase::setSpacing( TQT_TQOBJECT(widget), spacing );
		} else {
		    l->setMargin( margin );
		    l->setSpacing( margin );
		}
		MetaDataBase::addEntry( TQT_TQOBJECT(l) );
		return l;
	    }
	    default:
		return 0;
	    }
	}
    }
}

void WidgetFactory::deleteLayout( TQWidget *widget )
{
    if ( !widget )
	return;

    if ( widget->inherits( "TQTabWidget" ) )
	widget = ((TQTabWidget*)widget)->currentPage();
    if ( widget->inherits( "TQWizard" ) )
	widget = ((TQWizard*)widget)->currentPage();
    if ( widget->inherits( "TQMainWindow" ) )
	widget = ((TQMainWindow*)widget)->centralWidget();
    if ( widget->inherits( "TQWidgetStack" ) )
	widget = ((TQWidgetStack*)widget)->visibleWidget();
    delete widget->layout();
}

/*!  Factory functions for creating a widget of the type \a className
  as child of \a parent with the name \a name.

  If \a init is true, some initial default properties are set. This
  has to be in sync with the initChangedProperties() function!
*/

TQWidget *WidgetFactory::createWidget( const TQString &className, TQWidget *parent, const char *name, bool init,
  const TQRect *r, Qt::Orientation orient )
{
  if (className == "TQPushButton")
  {
    TQPushButton *b = 0;
    if (init)
    {
      b = new QDesignerPushButton(parent, name);
      b->setText(TQString::fromLatin1(name));
    } else
    {
      b = new QDesignerPushButton(parent, name);
    }
    TQWidget *w = find_formwindow(b);
    b->setAutoDefault(w && ((FormWindow *) w)->mainContainer()->inherits("TQDialog"));
    return b;
  } else if (className == "TQToolButton")
  {
    if (init)
    {
      QDesignerToolButton *tb = new QDesignerToolButton(parent, name);
      tb->setText("...");
      return tb;
    }
    return new QDesignerToolButton(parent, name);
  } else if (className == "TQCheckBox")
  {
    if (init)
    {
      QDesignerCheckBox *cb = new QDesignerCheckBox(parent, name);
      cb->setText(TQString::fromLatin1(name));
      return cb;
    }
    return new QDesignerCheckBox(parent, name);
  } else if (className == "TQRadioButton")
  {
    if (init)
    {
      QDesignerRadioButton *rb = new QDesignerRadioButton(parent, name);
      rb->setText(TQString::fromLatin1(name));
      return rb;
    }
    return new QDesignerRadioButton(parent, name);
  } else if (className == "TQGroupBox")
  {
    if (init)
      return new TQGroupBox(TQString::fromLatin1(name), parent, name);
    return new TQGroupBox(parent, name);
  } else if (className == "TQButtonGroup")
  {
    if (init)
      return new TQButtonGroup(TQString::fromLatin1(name), parent, name);
    return new TQButtonGroup(parent, name);
  } else if (className == "TQIconView")
  {
#if !defined(TQT_NO_ICONVIEW)
    TQIconView *iv = new TQIconView(parent, name);
    if (init)
      (void) new TQIconViewItem(iv, i18n("New Item"));
    return iv;
#else
    return 0;
#endif
  } else if (className == "TQTable")
  {
#if !defined(TQT_NO_TABLE)
    if (init)
      return new TQTable(3, 3, parent, name);
    return new TQTable(parent, name);
#else
    return 0;
#endif
#ifndef TQT_NO_SQL
  } else if (className == "TQDataTable")
  {
    return new TQDataTable(parent, name);
#endif //TQT_NO_SQL
  } else if (className == "TQDateEdit")
  {
    return new TQDateEdit(parent, name);
  } else if (className == "TQTimeEdit")
  {
    return new TQTimeEdit(parent, name);
  } else if (className == "TQDateTimeEdit")
  {
    return new TQDateTimeEdit(parent, name);
  } else if (className == "TQListBox")
  {
    TQListBox *lb = new TQListBox(parent, name);
    if (init)
    {
      lb->insertItem(i18n("New Item"));
      lb->setCurrentItem(0);
    }
    return lb;
  } else if (className == "TQListView")
  {
    TQListView *lv = new TQListView(parent, name);
    lv->setSorting(-1);
    if (init)
    {
      lv->addColumn(i18n("Column 1"));
      lv->setCurrentItem(new TQListViewItem(lv, i18n("New Item")));
    }
    return lv;
  } else if (className == "TQLineEdit")
    return new TQLineEdit(parent, name);
  else if (className == "TQSpinBox")
    return new TQSpinBox(parent, name);
  else if (className == "TQSplitter")
    return new TQSplitter(parent, name);
  else if (className == "TQMultiLineEdit")
    return new TQMultiLineEdit(parent, name);
  else if (className == "TQTextEdit")
    return new TQTextEdit(parent, name);
  else if (className == "TQLabel")
  {
    QDesignerLabel *l = new QDesignerLabel(parent, name);
    if (init)
    {
      l->setText(TQString::fromLatin1(name));
      MetaDataBase::addEntry(TQT_TQOBJECT(l));
      MetaDataBase::setPropertyChanged(TQT_TQOBJECT(l), "text", true);
    }
    return l;
  } else if (className == "TQLayoutWidget")
    return new TQLayoutWidget(parent, name);
  else if (className == "TQTabWidget")
  {
    TQTabWidget *tw = new QDesignerTabWidget(parent, name);
    if (init)
    {
      FormWindow *fw = find_formwindow(parent);
      TQWidget *w = fw ? new QDesignerWidget(fw, tw, "tab") : new TQWidget(tw, "tab");
      tw->addTab(w, i18n("Tab 1"));
      MetaDataBase::addEntry(TQT_TQOBJECT(w));
      w = fw ? new QDesignerWidget(fw, tw, "tab") : new TQWidget(tw, "tab");
      tw->addTab(w, i18n("Tab 2"));
      MetaDataBase::addEntry(TQT_TQOBJECT(tw));
      MetaDataBase::addEntry(TQT_TQOBJECT(w));
    }
    return tw;
  } else if (className == "TQComboBox")
  {
    return new TQComboBox(false, parent, name);
  } else if (className == "TQWidget")
  {
    if (parent &&
        (parent->inherits("FormWindow") || parent->inherits("TQWizard")
            || parent->inherits("TQTabWidget") || parent->inherits("TQToolBox") || parent->inherits("TQMainWindow")))
    {
      FormWindow *fw = find_formwindow(parent);
      if (fw)
      {
        QDesignerWidget *dw = new QDesignerWidget(fw, parent, name);
        MetaDataBase::addEntry(TQT_TQOBJECT(dw));
        return dw;
      }
    }
    return new TQWidget(parent, name);
  } else if (className == "TQDialog")
  {
    TQDialog *dia = 0;
    if (parent && parent->inherits("FormWindow"))
      dia = new QDesignerDialog((FormWindow *) parent, parent, name);
    else
      dia = new TQDialog(parent, name);
    if (parent && !parent->inherits("MainWindow"))
      dia->reparent(parent, TQPoint(0, 0), true);
    return dia;
  } else if (className == "TQWizard")
  {
    TQWizard *wiz = new QDesignerWizard(parent, name);
    if (parent && !parent->inherits("MainWindow"))
    {
      wiz->reparent(parent, TQPoint(0, 0), true);
    }
    if (init && parent && parent->inherits("FormWindow"))
    {
      QDesignerWidget *dw = new QDesignerWidget((FormWindow *) parent, wiz, "page");
      MetaDataBase::addEntry(TQT_TQOBJECT(dw));
      wiz->addPage(dw, i18n("Page"));
      TQTimer::singleShot(0, wiz, TQT_SLOT(next()));
    }
    return wiz;
  } else if (className == "Spacer")
  {
    Spacer *s = new Spacer(parent, name);
    MetaDataBase::addEntry(TQT_TQOBJECT(s));
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(s), "orientation", true);
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(s), "sizeType", true);
    if (!r)
      return s;
    if (!r->isValid() || r->width() < 2 && r->height() < 2)
      s->setOrientation(orient);
    else if (r->width() < r->height())
      s->setOrientation(Qt::Vertical);
    else
      s->setOrientation(Qt::Horizontal);
    return s;
  } else if (className == "TQLCDNumber")
    return new TQLCDNumber(parent, name);
  else if (className == "TQProgressBar")
    return new TQProgressBar(parent, name);
  else if (className == "TQTextView")
    return new TQTextView(parent, name);
  else if (className == "TQTextBrowser")
    return new TQTextBrowser(parent, name);
  else if (className == "TQDial")
    return new TQDial(parent, name);
  else if (className == "TQSlider")
  {
    TQSlider *s = new TQSlider(parent, name);
    if (!r)
      return s;
    if (!r->isValid() || r->width() < 2 && r->height() < 2)
      s->setOrientation(orient);
    else if (r->width() > r->height())
      s->setOrientation(Qt::Horizontal);
    MetaDataBase::addEntry(TQT_TQOBJECT(s));
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(s), "orientation", true);
    return s;
  } else if (className == "TQScrollBar")
  {
    TQScrollBar *s = new TQScrollBar(parent, name);
    if (!r)
      return s;
    if (!r->isValid() || r->width() < 2 && r->height() < 2)
      s->setOrientation(orient);
    else if (r->width() > r->height())
      s->setOrientation(Qt::Horizontal);
    MetaDataBase::addEntry(TQT_TQOBJECT(s));
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(s), "orientation", true);
    return s;
  } else if (className == "TQFrame")
  {
    if (!init)
      return new TQFrame(parent, name);
    TQFrame *f = new TQFrame(parent, name);
    f->setFrameStyle(TQFrame::StyledPanel | TQFrame::Raised);
    return f;
  } else if (className == "Line")
  {
    Line *l = new Line(parent, name);
    MetaDataBase::addEntry(TQT_TQOBJECT(l));
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(l), "orientation", true);
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(l), "frameShadow", true);
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(l), "frameShape", true);
    if (!r)
      return l;
    if (!r->isValid() || r->width() < 2 && r->height() < 2)
      l->setOrientation(orient);
    else if (r->width() < r->height())
      l->setOrientation(Qt::Vertical);
    return l;
  } else if (className == "TQMainWindow")
  {
    TQMainWindow *mw = new KmdrMainWindow(parent, name, 0);
    mw->setDockEnabled(TQt::DockMinimized, false);
    QDesignerWidget *dw = new QDesignerWidget((FormWindow *) parent, mw, "central widget");
    mw->setDockMenuEnabled(false);
    MetaDataBase::addEntry(TQT_TQOBJECT(dw));
    mw->setCentralWidget(dw);
    (void) mw->statusBar();
    dw->show();
    return mw;
  }
#ifndef TQT_NO_SQL
  else if (className == "TQDataBrowser")
  {
    TQWidget *w = new QDesignerDataBrowser(parent, name);
    if (parent)
      w->reparent(parent, TQPoint(0, 0), true);
    return w;
  } else if (className == "TQDataView")
  {
    TQWidget *w = new QDesignerDataView(parent, name);
    if (parent)
      w->reparent(parent, TQPoint(0, 0), true);
    return w;
  }
#endif
#ifdef KOMMANDER

  if (className == "LineEdit")
    return new LineEdit(parent, name);
  else if (className == "ListView")
  {
    TQListView *lv = new TQListView(parent, name);
    lv->setSorting(-1);
    if (init)
    {
      lv->addColumn(i18n("Column 1"));
      lv->setCurrentItem(new TQListViewItem(lv, i18n("New Item")));
    }
    return lv;
  } 
  else if (className == "Dialog")
  {
    TQDialog *dia = 0;
    if (parent && parent->inherits("FormWindow"))
      dia = new EditorDialog((FormWindow *) parent, parent, name);
    else
      dia = new Dialog(parent, name, false);

    if (parent)
      dia->reparent(parent, TQPoint(0, 0), true);
    return dia;
  } 
  else if (className == "Wizard")
  {
    //tqDebug("Creating Wizard...");
    TQWizard *wiz;
    if (parent && parent->inherits("FormWindow"))
      wiz = new QDesignerWizard(parent, name);
    else
      wiz = new Wizard(parent, name);
    if (parent)
      wiz->reparent(parent, TQPoint(0, 0), true);
    if (init && parent && parent->inherits("FormWindow"))
    {
      QDesignerWidget *dw = new QDesignerWidget((FormWindow *) parent, wiz, "page");
      MetaDataBase::addEntry(TQT_TQOBJECT(dw));
      wiz->addPage(dw, i18n("Page 1"));
      wiz->addPage(dw, i18n("Page 2"));
      TQTimer::singleShot(0, wiz, TQT_SLOT(next()));
    }
    return wiz;
  } 
  else if (className == "TabWidget")
  {
    TQTabWidget *tw = new EditorTabWidget(parent, name);
    if (init)
    {
      FormWindow *fw = find_formwindow(parent);
      TQWidget *w = fw ? new QDesignerWidget(fw, tw, "tab") : new TQWidget(tw, "tab");
      tw->addTab(w, i18n("Tab 1"));
      MetaDataBase::addEntry(TQT_TQOBJECT(w));
      w = fw ? new QDesignerWidget(fw, tw, "tab") : new TQWidget(tw, "tab");
      tw->addTab(w, i18n("Tab 2"));
      MetaDataBase::addEntry(TQT_TQOBJECT(tw));
      MetaDataBase::addEntry(TQT_TQOBJECT(w));
    }
    return tw;
  } else if (className == "ToolBox")
  {
    TQToolBox *tw = new EditorToolBox(parent, name);
    if (init)
    {
      FormWindow *fw = find_formwindow(parent);
      TQWidget *w = fw ? new QDesignerWidget(fw, tw, "toolbox") : new TQWidget(tw, "toolbox");
      tw->addItem(w, i18n("Page 1"));
      MetaDataBase::addEntry(TQT_TQOBJECT(w));
      w = fw ? new QDesignerWidget(fw, tw, "toolbox") : new TQWidget(tw, "toolbox");
      tw->addItem(w, i18n("Page 2"));
      MetaDataBase::addEntry(TQT_TQOBJECT(tw));
      MetaDataBase::addEntry(TQT_TQOBJECT(w));
    }
    return tw;
  }
  else if (className == "ExecButton")
    return new ExecButton(parent, name);
  else if (className == "CloseButton")
    return new CloseButton(parent, name);
  else if (className == "SubDialog")
    return new SubDialog(parent, name);
  else if (className == "FileSelector")
    return new FileSelector(parent, name);
  else if (className == "TextEdit")
    return new TextEdit(parent, name);
  else if (className == "RadioButton")
    return new RadioButton(parent, name);
  else if (className == "ButtonGroup")
    return new ButtonGroup(parent, name);
  else if (className == "GroupBox")
    return new GroupBox(parent, name);
  else if (className == "CheckBox")
    return new CheckBox(parent, name);
  else if (className == "ComboBox")
    return new ComboBox(parent, name);
  else if (className == "SpinBoxInt")
    return new SpinBoxInt(parent, name);
  else if (className == "ListBox")
    return new ListBox(parent, name);
  else if (className == "ScriptObject")
    return new ScriptObject(parent, name);
  else if (className == "RichTextEditor")
    return new RichTextEditor(parent, name);
  else if (className == "DatePicker")
    return new DatePicker(parent, name);
  else if (className == "PopupMenu")
    return new PopupMenu(parent, name);
  else if (className == "FontDialog")
    return new FontDialog(parent, name);
  else if (className == "AboutDialog")
    return new AboutDialog(parent, name);
  else if (className == "TreeWidget")
  {
    TQListView *lv = new TreeWidget(parent, name);
    lv->setSorting(-1);
    if (init)
    {
      lv->addColumn(i18n("Column 1"));
      lv->setCurrentItem(new TQListViewItem(lv, i18n("New Item")));
    }
    return lv;
  } else if (className == "Slider")
  {
    Slider *s = new Slider(parent, name);
    if (!r)
      return s;
    if (!r->isValid() || r->width() < 2 && r->height() < 2)
      s->setOrientation(orient);
    else if (r->width() > r->height())
      s->setOrientation(Qt::Horizontal);
    MetaDataBase::addEntry(TQT_TQOBJECT(s));
    MetaDataBase::setPropertyChanged(TQT_TQOBJECT(s), "orientation", true);
    return s;
  }
#endif

  TQWidget *w = KommanderFactory::createWidget(className, parent, name);
  return w;
}



/*!  Find out which type the layout of the widget is. Returns \c HBox,
  \c VBox, \c Grid or \c NoLayout.  \a layout points to this
  TQWidget::layout() of \a w or to 0 after the function call.
*/

WidgetFactory::LayoutType WidgetFactory::layoutType( TQWidget *w, TQLayout *&layout )
{
    layout = 0;

    if ( w && w->inherits( "TQTabWidget" ) )
	w = ((TQTabWidget*)w)->currentPage();
    if ( w->inherits( "TQToolBox" ) )
    w = ((TQToolBox*)w)->currentItem();
    if ( w && w->inherits( "TQWizard" ) )
	w = ((TQWizard*)w)->currentPage();
    if ( w && w->inherits( "TQMainWindow" ) )
	w = ((TQMainWindow*)w)->centralWidget();
    if ( w && w->inherits( "TQWidgetStack" ) )
	w = ((TQWidgetStack*)w)->visibleWidget();

    if ( w && w->inherits( "TQSplitter" ) )
	return ( (TQSplitter*)w )->orientation() ==Qt::Horizontal ? HBox : VBox;

    if ( !w || !w->layout() )
	return NoLayout;
    TQLayout *lay = w->layout();

    if ( w->inherits( "TQGroupBox" ) ) {
	TQObjectList *l = TQT_TQOBJECT(lay)->queryList( "TQLayout" );
	if ( l && l->first() )
	    lay = (TQLayout*)l->first();
	delete l;
    }
    layout = lay;

    if ( lay->inherits( "TQHBoxLayout" ) )
	return HBox;
    else if ( lay->inherits( "TQVBoxLayout" ) )
	return VBox;
    else if ( lay->inherits( "TQGridLayout" ) )
	return Grid;
    return NoLayout;
}

/*!
  \overload
*/
WidgetFactory::LayoutType WidgetFactory::layoutType( TQLayout *layout )
{
    if ( layout->inherits( "TQHBoxLayout" ) )
	return HBox;
    else if ( layout->inherits( "TQVBoxLayout" ) )
	return VBox;
    else if ( layout->inherits( "TQGridLayout" ) )
	return Grid;
    return NoLayout;
}

/*!
  \overload
*/
WidgetFactory::LayoutType WidgetFactory::layoutType( TQWidget *w )
{
    TQLayout *l = 0;
    return layoutType( w, l );
}


TQWidget *WidgetFactory::layoutParent( TQLayout *layout )
{
    TQObject *o = TQT_TQOBJECT(layout);
    while ( o ) {
	if ( o->isWidgetType() )
	    return (TQWidget*)o;
	o = o->parent();
    }
    return 0;
}

/*!  Returns the widget into which children should be inserted when \a
  w is a container known to the designer.

  Usually that is \a w itself, sometimes it is different (e.g. a
  tabwidget is known to the designer as a container but the child
  widgets should be inserted into the current page of the
  tabwidget. So in this case this function returns the current page of
  the tabwidget.)
 */
TQWidget* WidgetFactory::containerOfWidget( TQWidget *w )
{
    if ( !w )
	return w;
    if ( w->inherits( "TQTabWidget" ) )
	return ((TQTabWidget*)w)->currentPage();
    if ( w->inherits( "TQToolBox" ) )
    return ((TQToolBox*)w)->currentItem();
    if ( w->inherits( "TQWizard" ) )
	return ((TQWizard*)w)->currentPage();
    if ( w->inherits( "TQWidgetStack" ) )
	return ((TQWidgetStack*)w)->visibleWidget();
    if ( w->inherits( "TQMainWindow" ) )
	return ((TQMainWindow*)w)->centralWidget();
    return w;
}

/*!  Returns the actual designer widget of the container \a w. This is
  normally \a w itself, but might be a parent or grand parent of \a w
  (e.g. when working with a tabwidget and \a w is the container which
  contains and layouts childs, but the actual widget known to the
  designer is the tabwidget which is the parent of \a w. So this
  function returns the tabwidget then.)
*/

TQWidget* WidgetFactory::widgetOfContainer( TQWidget *w )
{
    if ( w->parentWidget() && w->parentWidget()->inherits( "TQWidgetStack" ) )
	w = w->parentWidget();
    while ( w ) {
	if ( WidgetDatabase::isContainer( WidgetDatabase::idFromClassName( WidgetFactory::classNameOf( TQT_TQOBJECT(w) ) ) ) ||
	     w && w->parentWidget() && w->parentWidget()->inherits( "FormWindow" ) )
	    return w;
	w = w->parentWidget();
    }
    return w;
}

/*!
  Returns whether \a o is a passive interactor or not.
 */
bool WidgetFactory::isPassiveInteractor( TQObject* o )
{
    if ( TQApplication::activePopupWidget() ) // if a popup is open, we have to make sure that this one is closed, else X might do funny things
	return true;

    if ( o->inherits( "TQTabBar" ) || ::tqqt_cast<TQToolBox*>(o->parent()) )
	return true;
    else if ( o->inherits( "TQSizeGrip" ) )
	return true;
    else if ( o->inherits( "TQToolButton" ) && o->parent() && o->parent()->inherits( "TQTabBar" ) )
	return true;
    else if ( o->parent() && o->parent()->inherits( "TQWizard" ) && o->inherits( "TQPushButton" ) )
	return true;
    else if ( o->parent() && o->parent()->inherits( "TQMainWindow" ) && o->inherits( "TQMenuBar" ) )
	return true;
    else if ( o->inherits( "TQDockWindowHandle" ) )
	return true;
    else if ( o->inherits( "TQHideDock" ) )
	return true;

    return false;
}


/*!
  Returns the class name of object \a o that should be used for externally (i.e. for saving)
 */
const char* WidgetFactory::classNameOf( TQObject* o )
{
  if (o->inherits("QDesignerTabWidget"))
    return "TQTabWidget";
#ifdef KOMMANDER
  else if (o->inherits("EditorTabWidget"))
    return "TabWidget";
  else if (o->inherits("EditorToolBox"))
    return "ToolBox";
#endif
  else if (o->inherits("QDesignerDialog"))
    return "TQDialog";
  else if (o->inherits("QDesignerWidget"))
    return "TQWidget";
  else if (o->inherits("CustomWidget"))
    return ((CustomWidget *) o)->realClassName().latin1();
  else if (o->inherits("QDesignerLabel"))
    return "TQLabel";
  else if (o->inherits("QDesignerWizard"))
    return "TQWizard";
  else if (o->inherits("EditorWizard"))
    return "Wizard";
  else if (o->inherits("QDesignerPushButton"))
    return "TQPushButton";
  else if (o->inherits("QDesignerToolButton"))
    return "TQToolButton";
  else if (o->inherits("QDesignerRadioButton"))
    return "TQRadioButton";
  else if (o->inherits("QDesignerCheckBox"))
    return "TQCheckBox";
  else if (o->inherits("QDesignerMenuBar"))
    return "TQMenuBar";
  else if (o->inherits("QDesignerToolBar"))
    return "TQToolBar";
#ifndef TQT_NO_SQL
  else if (o->inherits("QDesignerDataBrowser"))
    return "TQDataBrowser";
  else if (o->inherits("QDesignerDataView"))
    return "TQDataView";
#endif
  else if (o->inherits("EditorDialog"))
    return "Dialog";
  return o->className();
}

/*!  As some properties are set by default when creating a widget this
  functions markes this properties as changed. Has to be in sync with
  createWidget()!
*/

void WidgetFactory::initChangedProperties( TQObject *o )
{
    MetaDataBase::setPropertyChanged( o, "name", true );
    if ( !o->inherits( "QDesignerToolBar" ) && !o->inherits( "QDesignerMenuBar" ) )
	MetaDataBase::setPropertyChanged( o, "geometry", true );

    if ( o->inherits( "TQPushButton" ) || o->inherits("TQRadioButton") || o->inherits( "TQCheckBox" ) || o->inherits( "TQToolButton" ) )
	MetaDataBase::setPropertyChanged( o, "text", true );
    else if (::tqqt_cast<TQToolButton*>(o) && ::tqqt_cast<TQToolBox*>(widgetOfContainer((TQWidget*)o->parent()))) {
        MetaDataBase::setPropertyChanged( o, "usesTextLabel", TRUE );
        MetaDataBase::setPropertyChanged( o, "textLabel", TRUE );
        MetaDataBase::setPropertyChanged( o, "autoRaise", TRUE );
        MetaDataBase::setPropertyChanged( o, "textPosition", TRUE );
    }    else if ( o->inherits( "TQGroupBox" ) )
	MetaDataBase::setPropertyChanged( o, "title", true );
    else if ( o->isA( "TQFrame" ) ) {
	MetaDataBase::setPropertyChanged( o, "frameShadow", true );
	MetaDataBase::setPropertyChanged( o, "frameShape", true );
    } else if ( o->inherits( "TQTabWidget" ) || o->inherits( "TQWizard" ) ) {
	MetaDataBase::setPropertyChanged( o, "pageTitle", true );
	MetaDataBase::setPropertyChanged( o, "pageName", true );
#ifndef TQT_NO_TABLE
    } else if ( o->inherits( "TQTable" ) && !o->inherits( "TQDataTable" ) ) {
	MetaDataBase::setPropertyChanged( o, "numRows", true );
	MetaDataBase::setPropertyChanged( o, "numCols", true );
	TQTable *t = (TQTable*)o;
	for ( int i = 0; i < 3; ++i ) {
	    t->horizontalHeader()->setLabel( i, TQString::number( i + 1 ) );
	    t->verticalHeader()->setLabel( i, TQString::number( i + 1 ) );
	}
#endif
    } else if ( ::tqqt_cast<TQToolBox*>(o) ) {
        MetaDataBase::setPropertyChanged( o, "currentIndex", true );
        MetaDataBase::setPropertyChanged( o, "itemName", true );
        MetaDataBase::setPropertyChanged( o, "itemLabel", true );
        MetaDataBase::setPropertyChanged( o, "itemIconSet", true );
        MetaDataBase::setPropertyChanged( o, "itemToolTip", true );
        MetaDataBase::setPropertyChanged( o, "itemBackgroundMode", true );
    } else if ( o->inherits( "TQSplitter" )  ) {
	MetaDataBase::setPropertyChanged( o, "orientation", true );
    } else if ( o->inherits( "QDesignerToolBar" )  ) {
	MetaDataBase::setPropertyChanged( o, "label", true );
    } else if ( o->inherits( "QDesignerMenuBar" )  ) {
	MetaDataBase::setPropertyChanged( o, "itemName", true );
	MetaDataBase::setPropertyChanged( o, "itemNumber", true );
	MetaDataBase::setPropertyChanged( o, "itemText", true );
    }
}

bool WidgetFactory::hasSpecialEditor( int id )
{
  TQString className = WidgetDatabase::className(id);

  if (className == "TextEdit" || className == "ComboBox" || className == "ListBox" || className ==
      "TreeWidget" || className == "TextBrowser")
    return true;

  if (className.mid(1) == "ListBox")
    return true;
  if (className.mid(1) == "ComboBox")
    return true;
  if (className.mid(1) == "ListView")
    return true;
  if (className.mid(1) == "IconView")
    return true;
  if (className == "TQTextEdit" || className == "TQMultiLineEdit")
    return true;
  if (className.contains("Table"))
    return true;

  return false;
}

bool WidgetFactory::hasItems( int id )
{
  TQString className = WidgetDatabase::className(id);

  if (className == "ComboBox" || className == "ListBox" || className == "TreeWidget")
    return true;
  if (className.mid(1) == "ListBox" || className.mid(1) == "ListView" ||
      className.mid(1) == "IconView" || className.mid(1) == "ComboBox" ||
      className.contains("Table"))
    return true;

  return false;
}

void WidgetFactory::editWidget( int id, TQWidget *parent, TQWidget *editWidget, FormWindow *fw )
{
  TQString className = WidgetDatabase::className(id);

#ifdef KOMMANDER
  if (className == "ComboBox")
  {
    if (!editWidget->inherits("TQComboBox"))
      return;

    TQComboBox *cb = (TQComboBox *) editWidget;

    ListBoxEditor *e = new ListBoxEditor(parent, cb->listBox(), fw);
    e->exec();
    delete e;

    cb->update();

    return;
  }
  if (className == "TextEdit" || className == "TextBrowser")
  {
    MultiLineEditor *e = new MultiLineEditor(parent, editWidget, fw);
    e->exec();
    delete e;
    return;
  }
  if (className == "TreeWidget")
  {
    if (!editWidget->inherits("TQListView"))
      return;
    TQListView *lv = (TQListView *) editWidget;
    ListViewEditor *e = new ListViewEditor(parent, lv, fw);
    e->exec();
    delete e;
    return;
  }
  if (className == "ListBox")
  {
    if (!editWidget->inherits("TQListBox"))
      return;
    ListBoxEditor *e = new ListBoxEditor(parent, editWidget, fw);
    e->exec();
    delete e;
    return;
  }
#endif
  if (className.mid(1) == "ListBox")
  {
    if (!editWidget->inherits("TQListBox"))
      return;
    ListBoxEditor *e = new ListBoxEditor(parent, editWidget, fw);
    e->exec();
    delete e;
    return;
  }

  if (className.mid(1) == "ComboBox")
  {
    if (!editWidget->inherits("TQComboBox"))
      return;
    TQComboBox *cb = (TQComboBox *) editWidget;
    ListBoxEditor *e = new ListBoxEditor(parent, cb->listBox(), fw);
    e->exec();
    delete e;
    cb->update();
    return;
  }

  if (className.mid(1) == "ListView")
  {
    if (!editWidget->inherits("TQListView"))
      return;
    TQListView *lv = (TQListView *) editWidget;
    ListViewEditor *e = new ListViewEditor(parent, lv, fw);
    e->exec();
    delete e;
    return;
  }

  if (className.mid(1) == "IconView")
  {
    if (!editWidget->inherits("TQIconView"))
      return;
    IconViewEditor *e = new IconViewEditor(parent, editWidget, fw);
    e->exec();
    delete e;
    return;
  }

  if (className == "TQMultiLineEdit" || className == "TQTextEdit")
  {
    MultiLineEditor *e = new MultiLineEditor(parent, editWidget, fw);
    e->exec();
    delete e;
    return;
  }
#ifndef TQT_NO_TABLE
  if (className.contains("Table"))
  {
    TableEditor *e = new TableEditor(parent, editWidget, fw);
    e->exec();
    delete e;
    return;
  }
#endif
}

bool WidgetFactory::canResetProperty( TQObject *w, const TQString &propName )
{
    if ( propName == "name" || propName == "geometry" )
	return false;
    TQStringList l = *changedProperties->find( WidgetDatabase::idFromClassName( WidgetFactory::classNameOf( w ) ) );
    return l.findIndex( propName ) == -1;
}

bool WidgetFactory::resetProperty( TQObject *w, const TQString &propName )
{
    const TQMetaProperty *p = w->metaObject()->property( w->metaObject()->
							findProperty( propName.latin1(), true ), true );
    if (!p )
	return false;
    return p->reset( w );
}

TQVariant WidgetFactory::defaultValue( TQObject *w, const TQString &propName )
{
    if ( propName == "wordwrap" ) {
	int v = defaultValue( w, "alignment" ).toInt();
	return TQVariant( ( v & WordBreak ) == WordBreak, 0 );
    } else if ( propName == "toolTip" || propName == "whatsThis" ) {
	return TQVariant( TQString::fromLatin1( "" ) );
    } else if ( w->inherits( "CustomWidget" ) ) {
	return TQVariant();
    } else if ( propName == "frameworkCode" ) {
	return TQVariant( true, 0 );
    } else if ( propName == "layoutMargin" ) {
	if ( w->inherits( "TQLayoutWidget" ) )
	    return TQVariant( 0 );
	else if ( MainWindow::self->formWindow() )
	    return TQVariant( MainWindow::self->formWindow()->layoutDefaultMargin() );
    } else if ( propName == "layoutSpacing" ) {
	if ( MainWindow::self->formWindow() )
	    return TQVariant( MainWindow::self->formWindow()->layoutDefaultSpacing() );
    }

    return *( *defaultProperties->find( WidgetDatabase::idFromClassName( classNameOf( w ) ) ) ).find( propName );
}

TQString WidgetFactory::defaultCurrentItem( TQObject *w, const TQString &propName )
{
    const TQMetaProperty *p = w->metaObject()->
			     property( w->metaObject()->findProperty( propName.latin1(), true ), true );
    if ( !p ) {
	int v = defaultValue( w, "alignment" ).toInt();
	if ( propName == "hAlign" ) {
	    if ( ( v & AlignAuto ) == AlignAuto )
		return "AlignAuto";
	    if ( ( v & AlignLeft ) == AlignLeft )
		return "AlignLeft";
	    if ( ( v & AlignCenter ) == AlignCenter || ( v & AlignHCenter ) == AlignHCenter )
		return "AlignHCenter";
	    if ( ( v & AlignRight ) == AlignRight )
		return "AlignRight";
	    if ( ( v & AlignJustify ) == AlignJustify )
		return "AlignJustify";
	} else if ( propName == "vAlign" ) {
	    if ( ( v & AlignTop ) == AlignTop )
		return "AlignTop";
	    if ( ( v & AlignCenter ) == AlignCenter || ( v & AlignVCenter ) == AlignVCenter )
		return "AlignVCenter";
	    if ( ( v & AlignBottom ) == AlignBottom )
		return "AlignBottom";
	}
	return TQString();

    }
    return p->valueToKey( defaultValue( w, propName ).toInt() );
}

TQWidget *WidgetFactory::createCustomWidget( TQWidget *parent, const char *name, MetaDataBase::CustomWidget *w )
{
    if ( !w )
	return 0;
    return new CustomWidget( parent, name, w );
}

TQVariant WidgetFactory::property( TQObject *w, const char *name )
{
    TQVariant v = w->property( name );
    if ( v.isValid() )
	return v;
    return MetaDataBase::fakeProperty( w, name );
}

void QDesignerLabel::updateBuddy()
{

    if ( myBuddy.isEmpty() )
	return;

    TQObjectList *l = topLevelWidget()->queryList( "TQWidget", myBuddy, false, true );
    if ( !l || !l->first() ) {
	delete l;
	return;
    }

    TQLabel::setBuddy( (TQWidget*)l->first() );
    delete l;
}

void QDesignerWidget::paintEvent( TQPaintEvent *e )
{
    formwindow->paintGrid( this, e );
}

void QDesignerDialog::paintEvent( TQPaintEvent *e )
{
    formwindow->paintGrid( this, e );
}

void EditorDialog::paintEvent( TQPaintEvent *e )
{
    formwindow->paintGrid( this, e );
}

TQSizePolicy TQLayoutWidget::sizePolicy() const
{
    return sp;
}

bool TQLayoutWidget::event( TQEvent *e )
{
    if ( e && ( e->type() == TQEvent::ChildInserted ||
		e->type() == TQEvent::ChildRemoved ||
		e->type() == TQEvent::LayoutHint ||
		e->type() == TQEvent::Reparent ) )
	updateSizePolicy();
    return TQWidget::event( e );
}

/*
  This function must be called on TQLayoutWidget creation and whenever
  the TQLayoutWidget's parent layout changes (e.g., from a TQHBoxLayout
  to a TQVBoxLayout), because of the (illogical) way layouting works.
*/
void TQLayoutWidget::updateSizePolicy()
{
    TQObjectList clo = childrenListObject();
    if ( clo.isEmpty() || clo.count() == 0 ) {
	sp = TQWidget::sizePolicy();
	return;
    }

    /*
      TQSizePolicy::MayShrink & friends are private. Here we assume the
      following:

	  Fixed = 0
	  Maximum = MayShrink
	  Minimum = MayGrow
	  Preferred = MayShrink | MayGrow
    */

    int ht = (int) TQSizePolicy::Preferred;
    int vt = (int) TQSizePolicy::Preferred;

    if ( layout() ) {
	/*
	  parentLayout is set to the parent layout if there is one and if it is
	  top level, in which case layouting is illogical.
	*/
	TQLayout *parentLayout = 0;
	if ( parent() && parent()->isWidgetType() ) {
	    parentLayout = ((TQWidget *)parent())->layout();
	    if ( parentLayout && parentLayout->mainWidget()->inherits("TQLayoutWidget") )
		parentLayout = 0;
	}

	TQObjectListIt it( childrenListObject() );
	TQObject *o;

	if ( layout()->inherits("TQVBoxLayout") ) {
	    if ( parentLayout && parentLayout->inherits("TQHBoxLayout") )
		vt = TQSizePolicy::Minimum;
	    else
		vt = TQSizePolicy::Fixed;

	    while ( ( o = it.current() ) ) {
		++it;
		if ( !o->isWidgetType() || ( (TQWidget*)o )->testWState( WState_ForceHide ) )
		    continue;
		TQWidget *w = (TQWidget*)o;

		if ( !w->sizePolicy().mayGrowHorizontally() )
		    ht &= ~TQSizePolicy::Minimum;
		if ( !w->sizePolicy().mayShrinkHorizontally() )
		    ht &= ~TQSizePolicy::Maximum;
		if ( w->sizePolicy().mayGrowVertically() )
		    vt |= TQSizePolicy::Minimum;
		if ( w->sizePolicy().mayShrinkVertically() )
		    vt |= TQSizePolicy::Maximum;
	    }
	} else if ( layout()->inherits("TQHBoxLayout") ) {
	    if ( parentLayout && parentLayout->inherits("TQVBoxLayout") )
		ht = TQSizePolicy::Minimum;
	    else
		ht = TQSizePolicy::Fixed;

	    while ( ( o = it.current() ) ) {
		++it;
		if ( !o->isWidgetType() || ( (TQWidget*)o )->testWState( WState_ForceHide ) )
		    continue;
		TQWidget *w = (TQWidget*)o;

		if ( w->sizePolicy().mayGrowHorizontally() )
		    ht |= TQSizePolicy::Minimum;
		if ( w->sizePolicy().mayShrinkHorizontally() )
		    ht |= TQSizePolicy::Maximum;
		if ( !w->sizePolicy().mayGrowVertically() )
		    vt &= ~TQSizePolicy::Minimum;
		if ( !w->sizePolicy().mayShrinkVertically() )
		    vt &= ~TQSizePolicy::Maximum;
	    }
	} else if ( layout()->inherits("TQGridLayout") ) {
	    ht = TQSizePolicy::Fixed;
	    vt = TQSizePolicy::Fixed;
	    if ( parentLayout ) {
		if ( parentLayout->inherits("TQVBoxLayout") )
		    ht = TQSizePolicy::Minimum;
		else if ( parentLayout->inherits("TQHBoxLayout") )
		    vt = TQSizePolicy::Minimum;
	    }

	    while ( ( o = it.current() ) ) {
		++it;
		if ( !o->isWidgetType() || ( (TQWidget*)o )->testWState( WState_ForceHide ) )
		    continue;
		TQWidget *w = (TQWidget*)o;

		if ( w->sizePolicy().mayGrowHorizontally() )
		    ht |= TQSizePolicy::Minimum;
		if ( w->sizePolicy().mayShrinkHorizontally() )
		    ht |= TQSizePolicy::Maximum;
		if ( w->sizePolicy().mayGrowVertically() )
		    vt |= TQSizePolicy::Minimum;
		if ( w->sizePolicy().mayShrinkVertically() )
		    vt |= TQSizePolicy::Maximum;
	    }
	}
#ifdef USE_QT4
	if ( layout()->expanding() & TQSizePolicy::Horizontally )
	    ht = TQSizePolicy::Expanding;
	if ( layout()->expanding() & TQSizePolicy::Vertically )
	    vt = TQSizePolicy::Expanding;
#else // USE_QT4
	if ( layout()->expanding() & TQSizePolicy::Horizontally )
	    ht = TQSizePolicy::Expanding;
	if ( layout()->expanding() & TQSizePolicy::Vertically )
	    vt = TQSizePolicy::Expanding;
#endif // USE_QT4

	layout()->invalidate();
    }

    sp = TQSizePolicy( (TQSizePolicy::SizeType) ht, (TQSizePolicy::SizeType) vt );
    updateGeometry();
}

void CustomWidget::paintEvent( TQPaintEvent *e )
{
    if ( parentWidget() && parentWidget()->inherits( "FormWindow" ) ) {
	( (FormWindow*)parentWidget() )->paintGrid( this, e );
    } else {
	TQPainter p( this );
	p.fillRect( rect(), colorGroup().dark() );
	p.drawPixmap( ( width() - cusw->pixmap->width() ) / 2,
		      ( height() - cusw->pixmap->height() ) / 2,
		      *cusw->pixmap );
    }
}


#include "widgetfactory.moc"
