 /***************************************************************************
                          choosewidgetimpl.cpp  - dialog to choose widget
                             -------------------
    begin                :  Thu 13 Apr 2004
    copyright            : (C) 2000 Michal Rudolf <mrudolf@kdewebdev.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

 /** KDE INCLUDES */ 
#include <tdelistview.h>
#include <tdelocale.h>

/** QT INCLUDES */
#include <tqptrstack.h>
#include <tqobject.h>
#include <tqobjectlist.h>
#include <tqlineedit.h>
#include "tqmetaobject.h"

/** OTHER INCLUDES */
#include "choosewidgetimpl.h"
#include "choosewidgetimpl.moc"
 
ChooseWidget::ChooseWidget(TQWidget* a_parent, const char* a_name, bool a_modal)
   : ChooseWidgetBase(a_parent, a_name, a_modal)
{
  connect( nameEdit, TQT_SIGNAL(textChanged(const TQString&)), TQT_SLOT(textChanged(const TQString&)) );
  connect( widgetView, TQT_SIGNAL(executed(TQListViewItem*)), TQT_SLOT(selectedItem(TQListViewItem*)));
  widgetView->setFullWidth(true);
  widgetView->addColumn(i18n("Widgets"));
  widgetView->setRootIsDecorated(true);
  nameEdit->setFocus();
}

ChooseWidget::~ChooseWidget()
{
  
}

void ChooseWidget::setWidget(TQWidget* w)
{
  widgetView->clear();
  if (!w)
    return;
  
  TQListViewItem* item;
  TQPtrStack<TQWidget> p_widgets;
  TQPtrStack<TQListViewItem> p_items;
  
  item = new TQListViewItem(widgetView, TQString("%1 (%2)").arg(w->name()).arg(w->className()));
  item->setOpen(true);
  
  p_widgets.push(w);
  p_items.push(item);
  
  while (!p_widgets.isEmpty()) {
    w = p_widgets.pop();
    item = p_items.pop();
    TQObjectList *objectList = w->queryList(0, 0, true, false);
    for (TQObjectListIt it(*objectList); it.current(); ++it) {
      TQListViewItem* newItem = item;
      if (isKommanderWidget(*it)) 
        newItem = new TQListViewItem(item, TQString("%1 (%2)").arg((*it)->name()).arg((*it)->className()));
      if (!(*it)->childrenListObject().isEmpty()) {
          p_widgets.push((TQWidget*)(*it));
          p_items.push(newItem);
      }
    }
    delete objectList;
  }
  if (widgetView->childCount()) {
    widgetView->setCurrentItem(widgetView->firstChild());
    widgetView->firstChild()->setSelected(true);
  }
}


TQString ChooseWidget::selection()
{
   if (widgetView->currentItem())
     return widgetView->currentItem()->text(0);
   else
     return TQString();
}

void ChooseWidget::textChanged(const TQString& text)
{
  TQListViewItem* item = widgetView->findItem(text, 0, TQt::BeginsWith);
  if (item) {
    widgetView->setCurrentItem(item);
    widgetView->ensureItemVisible(item);
  }
}

bool ChooseWidget::isKommanderWidget(TQObject* w)
{
  bool pExists = false;
  TQMetaObject *metaObj = w->metaObject();
  if (metaObj)
  {
    int id = metaObj->findProperty("KommanderWidget", true);
    const TQMetaProperty *metaProp = metaObj->property(id, true);
    if (metaProp && metaProp->isValid())
      pExists = true;
  }
  if (pExists)
  {
    TQVariant flag = (w)->property("KommanderWidget");
    if(flag.isValid() && !(TQString(w->name()).startsWith("qt_"))) 
      return true;
  }
  return false;
}

void ChooseWidget::selectedItem(TQListViewItem* item)
{
  if (item)
    accept();
}

