#!/usr/bin/env ruby
$VERBOSE = true; $:.unshift File.dirname($0)

require 'Qt'
require 'lcdrange.rb'

class MyWidget < TQt::VBox

def initialize()
	super
    quit = TQt::PushButton.new('Quit', self, 'quit')
    quit.setFont(TQt::Font.new('Times', 18, TQt::Font::Bold))
    
	connect(quit, SIGNAL('clicked()'), $qApp, SLOT('quit()'))
	grid = TQt::Grid.new( 4, self )

	previous = nil	
	for c in 0..3
		for r in 0..3
			lr = LCDRange.new(grid)
			if previous != nil
				connect( lr, SIGNAL('valueChanged(int)'),
						previous, SLOT('setValue(int)') )
			end
			previous = lr
		end
	end
end

end    

a = TQt::Application.new(ARGV)

w = MyWidget.new
a.setMainWidget(w)
w.show
a.exec
