


#include <tqcstring.h>
#include <tqimage.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqpixmap.h>
#include <tqfont.h>

#include <kjs/object.h>

#include <kjsembed/global.h>
#include <kjsembed/jsobjectproxy.h>
#include <kjsembed/jsopaqueproxy.h>
#include <kjsembed/jsbinding.h>

#include <tqcanvas.h>
#include "qcanvasitem_imp.h"

/**
 * Namespace containing the KJSEmbed library.
 */
namespace KJSEmbed {

TQCanvasItemImp::TQCanvasItemImp( KJS::ExecState *exec, int mid, bool constructor )
   : JSProxyImp(exec), id(mid), cons(constructor)
{
}

TQCanvasItemImp::~TQCanvasItemImp()
{
}

/**
 * Adds bindings for static methods and enum constants to the specified Object.
 */
void TQCanvasItemImp::addStaticBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasItemImp *meth = new TQCanvasItemImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }


    //
    // Define the enum constants
    //
    struct EnumValue {
	const char *id;
	int val;
    };

    EnumValue enums[] = {

        // enum RttiValues
        { "Rtti_Item", TQCanvasItem::Rtti_Item },
        { "Rtti_Sprite", TQCanvasItem::Rtti_Sprite },
        { "Rtti_PolygonalItem", TQCanvasItem::Rtti_PolygonalItem },
        { "Rtti_Text", TQCanvasItem::Rtti_Text },
        { "Rtti_Polygon", TQCanvasItem::Rtti_Polygon },
        { "Rtti_Rectangle", TQCanvasItem::Rtti_Rectangle },
        { "Rtti_Ellipse", TQCanvasItem::Rtti_Ellipse },
        { "Rtti_Line", TQCanvasItem::Rtti_Line },
        { "Rtti_Spline", TQCanvasItem::Rtti_Spline },
	{ 0, 0 }
    };

    int enumidx = 0;
    while( enums[enumidx].id ) {
        object.put( exec, enums[enumidx].id, KJS::Number(enums[enumidx].val), KJS::ReadOnly );
        ++enumidx;
    }

}

/**
 * Adds bindings for instance methods to the specified Object.
 */
void TQCanvasItemImp::addBindings( KJS::ExecState *exec, KJS::Object &object )
{
    JSProxy::MethodTable methods[] = {

        { Method_x_3, "x" },
        { Method_y_4, "y" },
        { Method_z_5, "z" },
        { Method_moveBy_6, "moveBy" },
        { Method_move_7, "move" },
        { Method_setX_8, "setX" },
        { Method_setY_9, "setY" },
        { Method_setZ_10, "setZ" },
        { Method_animated_11, "animated" },
        { Method_setAnimated_12, "setAnimated" },
        { Method_setVelocity_13, "setVelocity" },
        { Method_setXVelocity_14, "setXVelocity" },
        { Method_setYVelocity_15, "setYVelocity" },
        { Method_xVelocity_16, "xVelocity" },
        { Method_yVelocity_17, "yVelocity" },
        { Method_advance_18, "advance" },
        { Method_collidesWith_19, "collidesWith" },
        { Method_collisions_20, "collisions" },
        { Method_setCanvas_21, "setCanvas" },
        { Method_draw_22, "draw" },
        { Method_show_23, "show" },
        { Method_hide_24, "hide" },
        { Method_setVisible_25, "setVisible" },
        { Method_isVisible_26, "isVisible" },
        { Method_setSelected_27, "setSelected" },
        { Method_isSelected_28, "isSelected" },
        { Method_setEnabled_29, "setEnabled" },
        { Method_isEnabled_30, "isEnabled" },
        { Method_setActive_31, "setActive" },
        { Method_isActive_32, "isActive" },
        { Method_visible_33, "visible" },
        { Method_selected_34, "selected" },
        { Method_enabled_35, "enabled" },
        { Method_active_36, "active" },
        { Method_rtti_37, "rtti" },
        { Method_boundingRect_38, "boundingRect" },
        { Method_boundingRectAdvanced_39, "boundingRectAdvanced" },
        { Method_canvas_40, "canvas" },
	{ 0, 0 }
    };

    int idx = 0;
    TQCString lastName;

    while( methods[idx].name ) {
        if ( lastName != methods[idx].name ) {
            TQCanvasItemImp *meth = new TQCanvasItemImp( exec, methods[idx].id );
            object.put( exec , methods[idx].name, KJS::Object(meth) );
            lastName = methods[idx].name;
        }
        ++idx;
    }
}

/**
 * Extract a TQCanvasItem pointer from an Object.
 */
TQCanvasItem *TQCanvasItemImp::toTQCanvasItem( KJS::Object &self )
{
    JSObjectProxy *ob = JSProxy::toObjectProxy( self.imp() );
    if ( ob ) {
        TQObject *obj = ob->object();
	if ( obj )
           return dynamic_cast<TQCanvasItem *>( obj );
    }

    JSOpaqueProxy *op = JSProxy::toOpaqueProxy( self.imp() );
    if ( !op )
        return 0;
/*
    if ( !op->inherits(TQCANVASITEM_OBJECT_NAME_STRING) ) {
	kdDebug() << "Typename of opaque canvas item is " << op->typeName() << endl;
	// Check superclasses
        return 0;
    }
*/
    return op->toNative<TQCanvasItem>();
}

/**
 * Select and invoke the correct constructor.
 */
KJS::Object TQCanvasItemImp::construct( KJS::ExecState *exec, const KJS::List &args )
{
   switch( id ) {

         case Constructor_QCanvasItem_1:
             return TQCanvasItem_1( exec, args );
             break;

         default:
             break;
    }

    TQString msg = i18n("TQCanvasItemCons has no constructor with id '%1'.").arg(id);
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Object TQCanvasItemImp::TQCanvasItem_1( KJS::ExecState *exec, const KJS::List &args )
{

#if 0 // This constructor has been disabled by the XSL template

    // Unsupported parameter TQCanvas *
    return KJS::Object();

    TQCanvas * arg0; // Dummy


    // We should now create an instance of the TQCanvasItem object

    TQCanvasItem *ret = new TQCanvasItem(

          arg0 );


#endif // This constructor has been disabled by the XSL template
	return KJS::Object();

}

KJS::Value TQCanvasItemImp::call( KJS::ExecState *exec, KJS::Object &self, const KJS::List &args )
{
    instance = TQCanvasItemImp::toTQCanvasItem( self );
    /*
    if ( !instance )
    {
       TQString msg = i18n( "TQCanvasItemImp was not valid" );
    return throwError(exec, msg,KJS::ReferenceError);
    }
    */
    
    switch( id ) {

    case Method_x_3:
        return x_3( exec, self, args );
        break;

    case Method_y_4:
        return y_4( exec, self, args );
        break;

    case Method_z_5:
        return z_5( exec, self, args );
        break;

    case Method_moveBy_6:
        return moveBy_6( exec, self, args );
        break;

    case Method_move_7:
        return move_7( exec, self, args );
        break;

    case Method_setX_8:
        return setX_8( exec, self, args );
        break;

    case Method_setY_9:
        return setY_9( exec, self, args );
        break;

    case Method_setZ_10:
        return setZ_10( exec, self, args );
        break;

    case Method_animated_11:
        return animated_11( exec, self, args );
        break;

    case Method_setAnimated_12:
        return setAnimated_12( exec, self, args );
        break;

    case Method_setVelocity_13:
        return setVelocity_13( exec, self, args );
        break;

    case Method_setXVelocity_14:
        return setXVelocity_14( exec, self, args );
        break;

    case Method_setYVelocity_15:
        return setYVelocity_15( exec, self, args );
        break;

    case Method_xVelocity_16:
        return xVelocity_16( exec, self, args );
        break;

    case Method_yVelocity_17:
        return yVelocity_17( exec, self, args );
        break;

    case Method_advance_18:
        return advance_18( exec, self, args );
        break;

    case Method_collidesWith_19:
        return collidesWith_19( exec, self, args );
        break;

    case Method_collisions_20:
        return collisions_20( exec, self, args );
        break;

    case Method_setCanvas_21:
        return setCanvas_21( exec, self, args );
        break;

    case Method_draw_22:
        return draw_22( exec, self, args );
        break;

    case Method_show_23:
        return show_23( exec, self, args );
        break;

    case Method_hide_24:
        return hide_24( exec, self, args );
        break;

    case Method_setVisible_25:
        return setVisible_25( exec, self, args );
        break;

    case Method_isVisible_26:
        return isVisible_26( exec, self, args );
        break;

    case Method_setSelected_27:
        return setSelected_27( exec, self, args );
        break;

    case Method_isSelected_28:
        return isSelected_28( exec, self, args );
        break;

    case Method_setEnabled_29:
        return setEnabled_29( exec, self, args );
        break;

    case Method_isEnabled_30:
        return isEnabled_30( exec, self, args );
        break;

    case Method_setActive_31:
        return setActive_31( exec, self, args );
        break;

    case Method_isActive_32:
        return isActive_32( exec, self, args );
        break;

    case Method_visible_33:
        return visible_33( exec, self, args );
        break;

    case Method_selected_34:
        return selected_34( exec, self, args );
        break;

    case Method_enabled_35:
        return enabled_35( exec, self, args );
        break;

    case Method_active_36:
        return active_36( exec, self, args );
        break;

    case Method_rtti_37:
        return rtti_37( exec, self, args );
        break;

    case Method_boundingRect_38:
        return boundingRect_38( exec, self, args );
        break;

    case Method_boundingRectAdvanced_39:
        return boundingRectAdvanced_39( exec, self, args );
        break;

    case Method_canvas_40:
        return canvas_40( exec, self, args );
        break;

    default:
        break;
    }

    TQString msg = i18n( "TQCanvasItemImp has no method with id '%1'." ).arg( id );
    return throwError(exec, msg,KJS::ReferenceError);
}


KJS::Value TQCanvasItemImp::x_3( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      double ret;
      ret = instance->x(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasItemImp::y_4( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      double ret;
      ret = instance->y(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasItemImp::z_5( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      double ret;
      ret = instance->z(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasItemImp::moveBy_6( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

    double arg1 = extractDouble(exec, args, 1);

      instance->moveBy(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::move_7( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

    double arg1 = extractDouble(exec, args, 1);

      instance->move(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::setX_8( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

      instance->setX(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::setY_9( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

      instance->setY(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::setZ_10( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

      instance->setZ(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::animated_11( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->animated(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::setAnimated_12( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setAnimated(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::setVelocity_13( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

    double arg1 = extractDouble(exec, args, 1);

      instance->setVelocity(
       arg0,
       arg1 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::setXVelocity_14( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

      instance->setXVelocity(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::setYVelocity_15( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    double arg0 = extractDouble(exec, args, 0);

      instance->setYVelocity(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::xVelocity_16( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      double ret;
      ret = instance->xVelocity(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasItemImp::yVelocity_17( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      double ret;
      ret = instance->yVelocity(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasItemImp::advance_18( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    int arg0 = extractInt(exec, args, 0);

      instance->advance(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::collidesWith_19( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter const TQCanvasItem *
    return KJS::Value();

    const TQCanvasItem * arg0; // Dummy

      bool ret;
      ret = instance->collidesWith(
       arg0 );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::collisions_20( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->collisions(
       arg0 );
      return KJS::Value(); // Returns 'TQCanvasItemList'

}

KJS::Value TQCanvasItemImp::setCanvas_21( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    // Unsupported parameter TQCanvas *
    return KJS::Value();

    TQCanvas * arg0; // Dummy

      instance->setCanvas(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::draw_22( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    TQPainter arg0; // TODO (hack for qcanvas)

      instance->draw(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::show_23( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->show(  );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::hide_24( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->hide(  );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::setVisible_25( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setVisible(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::isVisible_26( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isVisible(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::setSelected_27( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setSelected(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::isSelected_28( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isSelected(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::setEnabled_29( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setEnabled(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::isEnabled_30( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isEnabled(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::setActive_31( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

    bool arg0 = extractBool(exec, args, 0);

      instance->setActive(
       arg0 );
      return KJS::Value(); // Returns void

}

KJS::Value TQCanvasItemImp::isActive_32( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->isActive(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::visible_33( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->visible(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::selected_34( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->selected(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::enabled_35( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->enabled(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::active_36( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      bool ret;
      ret = instance->active(  );
      return KJS::Boolean( ret );

}

KJS::Value TQCanvasItemImp::rtti_37( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      int ret;
      ret = instance->rtti(  );
      return KJS::Number( ret );

}

KJS::Value TQCanvasItemImp::boundingRect_38( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQRect ret;
      ret = instance->boundingRect(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasItemImp::boundingRectAdvanced_39( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{
    TQRect ret;
      ret = instance->boundingRectAdvanced(  );

       return convertToValue( exec, ret );

}

KJS::Value TQCanvasItemImp::canvas_40( KJS::ExecState *exec, KJS::Object &obj, const KJS::List &args )
{

      instance->canvas(  );
      return KJS::Value(); // Returns 'TQCanvas *'

}


} // namespace KJSEmbed
