#***************************************************************************
#                            kalyptusDataDict.pm -  A Qt/KDE types data dictionary
#                             -------------------
#    begin                : Fri Oct 20 12:00:00 2000
#    copyright            : (C) 2000-2001 Lost Highway Ltd. All Rights Reserved.
#    email                : Richard_Dale@tipitina.demon.co.uk
#    author               : Richard Dale.
#***************************************************************************/

#/***************************************************************************
# *                                                                         *
# *   This program is free software; you can redistribute it and/or modify  *
# *   it under the terms of the GNU General Public License as published by  *
# *   the Free Software Foundation; either version 2 of the License, or     *
# *   (at your option) any later version.                                   *
# *                                                                         *
#***************************************************************************/

package kalyptusDataDict;

use strict;
no strict "subs";

use vars qw/ %interfacemap %ctypemap %builtins /;

BEGIN
{

%interfacemap = (
'TQGL' => 'TQGLInterface',
'TQPaintDevice' => 'TQPaintDeviceInterface',
'TQMenuData' => 'TQMenuDataInterface',
'TQRangeControl' => 'TQRangeControlInterface',
'TQMimeSource' => 'TQMimeSourceInterface',
'TQLayoutItem' => 'TQLayoutItemInterface',
'TQUrl' => 'TQUrlInterface',
'TQIODevice' => 'TQIODeviceInterface',
'TQXmlContentHandler' => 'TQXmlContentHandlerInterface',
'TQXmlErrorHandler' => 'TQXmlErrorHandlerInterface',
'TQXmlDTDHandler' => 'TQXmlDTDHandlerInterface',
'TQXmlEntityResolver' => 'TQXmlEntityResolverInterface',
'TQXmlLexicalHandler' => 'TQXmlLexicalHandlerInterface',
'TQXmlDeclHandler' => 'TQXmlDeclHandlerInterface',
'TDEInstance' => 'TDEInstanceInterface',
'QwAbsSpriteFieldView' => 'QwAbsSpriteFieldViewInterface',
'PartBase' => 'PartBaseInterface',
'TDECompletionBase' => 'TDECompletionBaseInterface',
'KDirNotify' => 'KDirNotifyInterface',
'KXMLGUIClient' => 'KXMLGUIClientInterface',
'KFileView' => 'KFileViewInterface',
'KXMLGUIBuilder' => 'KXMLGUIBuilderInterface',
'DCOPObject' => 'DCOPObjectInterface',
'KDevCore' => 'KDevCoreInterface',
'TQSqlQuery' => 'TQSqlQueryInterface',

);

# A hard coded type translation table (the idea from the Roberto Alsina's Qtc
# python conversion scripts). The particular format used here makes it possible to use
# the same table with three different kdoc based Qt/KDE language binding generators;
# C, Objective-C and Java.
%ctypemap = (

'ASConsumer*' => 'tde_ASConsumer*',
'ASProducer*' => 'tde_ASProducer*',
'ASYNC'  =>  'void' ,
'Address&'  =>  'tde_Address*' ,
'Address*' => 'tde_Address*',
'AddressBook*' => 'tde_AddressBook*',
'AddressBook::Entry&'  =>  'tde_Entry*' ,
'Addressee&' => 'tde_Addressee*',
'Addressee*' => 'tde_Addressee*',
'AddresseeData*' => 'tde_AddresseeData*',
'AddresseeDialog*' => 'tde_AddresseeDialog*',
'AddresseeItem*' => 'tde_AddresseeItem*',
'AlsaOut*' => 'tde_AlsaOut*',
'AnyConstRef&' => 'tde_AnyConstRef*',
'AnyConstRef*' => 'tde_AnyConstRef*',
'AnyRef&' => 'tde_AnyRef*',
'AnyRef*' => 'tde_AnyRef*',
'AnyRefBase&' => 'tde_AnyRefBase*',
'AnyRefBase*' => 'tde_AnyRefBase*',
'ArgList'  =>  'int' ,
'ArrowType'  =>  'int' ,
'Arts*' => 'tde_Arts*',
'Arts::AudioManagerClient' => 'int',
'Arts::Buffer&' => 'tde_Arts_Buffer*',
'Arts::Buffer*' => 'tde_Arts_Buffer*',
'Arts::ByteSoundProducer' => 'tde_Arts_ByteSoundProducer*',
'Arts::Connection*' => 'tde_Arts_Connection*',
'Arts::DynamicCast&' => 'tde_Arts_DynamicCast*',
'Arts::FlowSystemReceiver' => 'tde_Arts_FlowSystemReceiver*',
'Arts::FlowSystemSender' => 'tde_Arts_FlowSystemSender*',
'Arts::Format&' => 'tde_Arts_Format*',
'Arts::Format' => 'tde_Arts_Format',
'Arts::GenericAsyncStream*' => 'tde_Arts_GenericAsyncStream*',
'Arts::GenericDataChannel*' => 'tde_Arts_GenericDataChannel*',
'Arts::InterfaceDef' => 'tde_Arts_InterfaceDef*',
'Arts::MethodDef&' => 'tde_Arts_MethodDef*',
'Arts::ModuleDef&' => 'tde_Arts_ModuleDef*',
'Arts::Notification&' => 'tde_Arts_Notification*',
'Arts::Object' => 'tde_Arts_Object*',
'Arts::Object::Pool&' => 'tde_Arts_Object_Pool*',
'Arts::ObjectReference' => 'tde_Arts_ObjectReference*',
'Arts::PlayObject' => 'tde_Arts_PlayObject*',
'Arts::Reference&' => 'tde_Arts_Reference*',
'Arts::StereoEffect' => 'tde_Arts_StereoEffect*',
'Arts::StereoEffectStack' => 'tde_Arts_StereoEffectStack*',
'Arts::SubClass&' => 'tde_Arts_SubClass*',
'Arts::TypeDef' => 'tde_Arts_TypeDef*',
'Arts::poTime&' => 'tde_Arts_poTime*',
'Arts::poTime' => 'tde_Arts_poTime',
'AsyncStream*' => 'tde_AsyncStream*',
'Attr&' => 'tde_Attr*',
'Attr' => 'tde_Attr*',
'Attr*' => 'tde_Attr*',
'AttrImpl*' => 'tde_AttrImpl*',
'AttributeDef&' => 'tde_AttributeDef*',
'AttributeDef*' => 'tde_AttributeDef*',
'AudioManager&' => 'tde_AudioManager*',
'AudioManager' => 'tde_AudioManager*',
'AudioManager*' => 'tde_AudioManager*',
'AudioManagerClient&' => 'tde_AudioManagerClient*',
'AudioManagerClient' => 'tde_AudioManagerClient*',
'AudioManagerClient*' => 'tde_AudioManagerClient*',
'AudioManagerClient_base*' => 'tde_AudioManagerClient_base*',
'AudioManagerClient_skel*' => 'tde_AudioManagerClient_skel*',
'AudioManagerClient_stub*' => 'tde_AudioManagerClient_stub*',
'AudioManagerInfo&' => 'tde_AudioManagerInfo*',
'AudioManagerInfo*' => 'tde_AudioManagerInfo*',
'AudioManager_base*' => 'tde_AudioManager_base*',
'AudioManager_skel*' => 'tde_AudioManager_skel*',
'AudioManager_stub*' => 'tde_AudioManager_stub*',
'AudioPort*' => 'tde_AudioPort*',
'AudioSubSystem*' => 'tde_AudioSubSystem*',
'AudioSubSystemStart*' => 'tde_AudioSubSystemStart*',
'AuthAccept&' => 'tde_AuthAccept*',
'AuthAccept*' => 'tde_AuthAccept*',
'BGMode' => 'int',
'BMToken*' => 'tde_BMToken*',
'BackgroundMode' => 'int',
'BlockSelectionInterface*' => 'tde_BlockSelectionInterface*',
'BookmarkTokenizer*' => 'tde_BookmarkTokenizer*',
'Bool'  =>  'int' ,
'Boolean&' => 'tde_Boolean*',
'Boolean*' => 'tde_Boolean*',
'BrowserExtension*' => 'tde_BrowserExtension*',
'BrowserHostExtension*' => 'tde_BrowserHostExtension*',
'BrowserInterface*' => 'tde_BrowserInterface*',
'BrushStyle' => 'int',
'Buffer&' => 'tde_Buffer*',
'Buffer*' => 'tde_Buffer*',
'ButtonCode'  =>  'int' ,
'ButtonState'  =>  'int' ,
'ByteAsyncStream*' => 'tde_ByteAsyncStream*',
'ByteDataPacket*' => 'tde_ByteDataPacket*',
'ByteSoundProducer&' => 'tde_ByteSoundProducer*',
'ByteSoundProducer' => 'tde_ByteSoundProducer*',
'ByteSoundProducer*' => 'tde_ByteSoundProducer*',
'ByteSoundProducer_base*' => 'tde_ByteSoundProducer_base*',
'ByteSoundProducer_skel*' => 'tde_ByteSoundProducer_skel*',
'ByteSoundProducer_stub*' => 'tde_ByteSoundProducer_stub*',
'ByteStreamToAudio&' => 'tde_ByteStreamToAudio*',
'ByteStreamToAudio' => 'tde_ByteStreamToAudio*',
'ByteStreamToAudio*' => 'tde_ByteStreamToAudio*',
'ByteStreamToAudio_base*' => 'tde_ByteStreamToAudio_base*',
'ByteStreamToAudio_skel*' => 'tde_ByteStreamToAudio_skel*',
'ByteStreamToAudio_stub*' => 'tde_ByteStreamToAudio_stub*',
'CDATASection&' => 'tde_CDATASection*',
'CDATASection' => 'tde_CDATASection*',
'CDATASection*' => 'tde_CDATASection*',
'CFlags' => 'int',
'COORD'  =>  'short' ,
'CSSCharsetRule&' => 'tde_CSSCharsetRule*',
'CSSCharsetRule*' => 'tde_CSSCharsetRule*',
'CSSCharsetRuleImpl*' => 'tde_CSSCharsetRuleImpl*',
'CSSException&' => 'tde_CSSException*',
'CSSException*' => 'tde_CSSException*',
'CSSFontFaceRule&' => 'tde_CSSFontFaceRule*',
'CSSFontFaceRule*' => 'tde_CSSFontFaceRule*',
'CSSFontFaceRuleImpl*' => 'tde_CSSFontFaceRuleImpl*',
'CSSImportRule&' => 'tde_CSSImportRule*',
'CSSImportRule*' => 'tde_CSSImportRule*',
'CSSImportRuleImpl*' => 'tde_CSSImportRuleImpl*',
'CSSMediaRule&' => 'tde_CSSMediaRule*',
'CSSMediaRule*' => 'tde_CSSMediaRule*',
'CSSMediaRuleImpl*' => 'tde_CSSMediaRuleImpl*',
'CSSPageRule&' => 'tde_CSSPageRule*',
'CSSPageRule*' => 'tde_CSSPageRule*',
'CSSPageRuleImpl*' => 'tde_CSSPageRuleImpl*',
'CSSPrimitiveValue&' => 'tde_CSSPrimitiveValue*',
'CSSPrimitiveValue' => 'tde_CSSPrimitiveValue*',
'CSSPrimitiveValue*' => 'tde_CSSPrimitiveValue*',
'CSSPrimitiveValueImpl*' => 'tde_CSSPrimitiveValueImpl*',
'CSSRule&' => 'tde_CSSRule*',
'CSSRule' => 'tde_CSSRule*',
'CSSRule*' => 'tde_CSSRule*',
'CSSRuleImpl*' => 'tde_CSSRuleImpl*',
'CSSRuleList&' => 'tde_CSSRuleList*',
'CSSRuleList' => 'tde_CSSRuleList*',
'CSSRuleList*' => 'tde_CSSRuleList*',
'CSSRuleListImpl*' => 'tde_CSSRuleListImpl*',
'CSSStyleDeclaration&' => 'tde_CSSStyleDeclaration*',
'CSSStyleDeclaration' => 'tde_CSSStyleDeclaration*',
'CSSStyleDeclaration*' => 'tde_CSSStyleDeclaration*',
'CSSStyleDeclarationImpl*' => 'tde_CSSStyleDeclarationImpl*',
'CSSStyleRule&' => 'tde_CSSStyleRule*',
'CSSStyleRule*' => 'tde_CSSStyleRule*',
'CSSStyleRuleImpl*' => 'tde_CSSStyleRuleImpl*',
'CSSStyleSheet&' => 'tde_CSSStyleSheet*',
'CSSStyleSheet' => 'tde_CSSStyleSheet*',
'CSSStyleSheet*' => 'tde_CSSStyleSheet*',
'CSSStyleSheetImpl*' => 'tde_CSSStyleSheetImpl*',
'CSSUnknownRule&' => 'tde_CSSUnknownRule*',
'CSSUnknownRule*' => 'tde_CSSUnknownRule*',
'CSSUnknownRuleImpl*' => 'tde_CSSUnknownRuleImpl*',
'CSSValue&' => 'tde_CSSValue*',
'CSSValue' => 'tde_CSSValue*',
'CSSValue*' => 'tde_CSSValue*',
'CSSValueImpl*' => 'tde_CSSValueImpl*',
'CSSValueList&' => 'tde_CSSValueList*',
'CSSValueList*' => 'tde_CSSValueList*',
'CSSValueListImpl*' => 'tde_CSSValueListImpl*',
'CString&' => 'tde_CString*',
'CString' => 'tde_CString*',
'CString*' => 'tde_CString*',
'Cache*' => 'tde_Cache*',
'CacheInfo*' => 'tde_CacheInfo*',
'CachedObject*' => 'tde_CachedObject*',
'CachedWav*' => 'tde_CachedWav*',
'Cardinal'  =>  'int' ,
'CharSet' => 'int',
'CharacterData&' => 'tde_CharacterData*',
'CharacterData*' => 'tde_CharacterData*',
'CharacterDataImpl*' => 'tde_CharacterDataImpl*',
'ChmodJob*' => 'tde_ChmodJob*',
'ClassInfo*' => 'tde_ClassInfo*',
'ClassStore*' => 'tde_ClassStore*',
'ClassTreeNode*' => 'tde_ClassTreeNode*',
'ClientHello&' => 'tde_ClientHello*',
'ClientHello*' => 'tde_ClientHello*',
'ClipboardInterface*' => 'tde_ClipboardInterface*',
'CodeCompletionInterface*' => 'tde_CodeCompletionInterface*',
'ColorMode' => 'int',
'Comment&' => 'tde_Comment*',
'Comment' => 'tde_Comment*',
'Comment*' => 'tde_Comment*',
'CommentImpl*' => 'tde_CommentImpl*',
'ComparisonFlags' => 'int',
'Compl' => 'tde_Compl',
'Completion&' => 'tde_Completion*',
'Completion*' => 'tde_Completion*',
'CompletionEntry&' => 'tde_CompletionEntry*',
'CompletionEntry*' => 'tde_CompletionEntry*',
'ComplexControl' => 'int',
'ComponentFactory*' => 'tde_ComponentFactory*',
'ConfigInterface*' => 'tde_ConfigInterface*',
'Connection*' => 'tde_Connection*',
'ConstIterator'  =>  'int' ,
'Constructor' => 'tde_Constructor*',
'Constructor*' => 'tde_Constructor*',
'ConstructorImp*' => 'tde_ConstructorImp*',
'ContentsType' => 'int',
'Context&' => 'tde_Context*',
'Context*' => 'tde_Context*',
'ControlElement' => 'int',
'CopyInfo*' => 'tde_CopyInfo*',
'CopyJob*' => 'tde_CopyJob*',
'Core*' => 'tde_Core*',
'Counter&' => 'tde_Counter*',
'Counter' => 'tde_Counter*',
'Counter*' => 'tde_Counter*',
'Cursor*' => 'tde_Cursor*',
'CursorInterface*' => 'tde_CursorInterface*',
'DCOPClient*' => 'tde_DCOPClient*',
'DCOPObject*' => 'tde_DCOPObject*',
'DCOPObjectProxy*' => 'tde_DCOPObjectProxy*',
'DCOPRef&'  =>  'tde_DCOPRef*' ,
'DCOPRef*' => 'tde_DCOPRef*',
'DCOPStub*' => 'tde_DCOPStub*',
'DOM*' => 'tde_DOM*',
'DOM::CSSProperty*'  =>  'tde_CSSProperty*' ,
'DOM::DOMString&'  =>  'tde_DOMString*' ,
'DOM::DOMString'  =>  'tde_DOMString*' ,
'DOM::Document&'  =>  'tde_Document*' ,
'DOM::Document'  =>  'tde_Document*' ,
'DOM::Document*'  =>  'tde_Document*' ,
'DOM::HTMLDocument'  =>  'tde_HTMLDocument*' ,
'DOM::MediaList&' => 'tde_MediaList*',
'DOM::MediaList' => 'tde_MediaList*',
'DOM::MediaList*' => 'tde_MediaList*',
'DOM::Node&'  =>  'tde_Node*' ,
'DOM::Node'  =>  'tde_Node*' ,
'DOM::NodeList&' => 'tde_DOMNodeList*',
'DOM::NodeList' => 'tde_DOMNodeList*',
'DOM::NodeList*' => 'tde_DOMNodeList*',
'DOM::Range'  =>  'tde_Range*' ,
'DOM::StyleSheetList&' => 'tde_StyleSheetList*',
'DOM::StyleSheetList' => 'tde_StyleSheetList*',
'DOM::StyleSheetList*' => 'tde_StyleSheetList*',
'StyleSheetList&' => 'tde_StyleSheetList*',
'StyleSheetList' => 'tde_StyleSheetList*',
'StyleSheetList*' => 'tde_StyleSheetList*',
'DOMException&' => 'tde_DOMException*',
'DOMException*' => 'tde_DOMException*',
'DOMImplementation&' => 'tde_DOMImplementation*',
'DOMImplementation' => 'tde_DOMImplementation*',
'DOMImplementation*' => 'tde_DOMImplementation*',
'DOMImplementationImpl*' => 'tde_DOMImplementationImpl*',
'DOMString&' => 'tde_DOMString*',
'DOMString' => 'tde_DOMString*',
'DOMString*' => 'tde_DOMString*',
'DOMStringImpl*' => 'tde_DOMStringImpl*',
'DW_EXPORT*' => 'void*',
'DataPacket*' => 'tde_DataPacket*',
'DateFormat' => 'int',
'Debug*' => 'tde_Debug*',
'DecoderFn'  =>  'int' ,
'DefaultProgress*' => 'tde_DefaultProgress*',
'DeleteJob*' => 'tde_DeleteJob*',
'DeviceManager*' => 'tde_DeviceManager*',
'Direction' => 'int',
'DispatchFunction' => 'tde_DispatchFunction*',
'Dispatcher*' => 'tde_Dispatcher*',
'DistributionList*' => 'tde_DistributionList*',
'DistributionListEditor*' => 'tde_DistributionListEditor*',
'DistributionListManager*' => 'tde_DistributionListManager*',
'Dock&' => 'int',
'Dock' => 'int',
'DockMainWindow*' => 'tde_DockMainWindow*',
'DockPosData&'  =>  'tde_DockPosData*' ,
'DockPosData*' => 'tde_DockPosData*',
'DockWindowData*' => 'long',
'Document&' => 'tde_Document*',
'Document' => 'tde_Document*',
'Document*' => 'tde_Document*',
'DocumentFragment&' => 'tde_DocumentFragment*',
'DocumentFragment' => 'tde_DocumentFragment*',
'DocumentFragment*' => 'tde_DocumentFragment*',
'DocumentFragmentImpl*' => 'tde_DocumentFragmentImpl*',
'DocumentImpl*' => 'tde_DocumentImpl*',
'DocumentStyle&' => 'tde_DocumentStyle*',
'DocumentStyle*' => 'tde_DocumentStyle*',
'DocumentType&' => 'tde_DocumentType*',
'DocumentType' => 'tde_DocumentType*',
'DocumentType*' => 'tde_DocumentType*',
'DocumentationContext*' => 'tde_DocumentationContext*',
'DomShared*' => 'tde_DomShared*',
'DrageMode' => 'int',
'DrawContentsEvent*' => 'tde_DrawContentsEvent*',
'DwAddress&' => 'tde_DwAddress*',
'DwAddress*' => 'tde_DwAddress*',
'DwAddressList&' => 'tde_DwAddressList*',
'DwAddressList*' => 'tde_DwAddressList*',
'DwBody&' => 'tde_DwBody*',
'DwBody*' => 'tde_DwBody*',
'DwBodyPart&' => 'tde_DwBodyPart*',
'DwBodyPart*' => 'tde_DwBodyPart*',
'DwBool' => 'int',
'DwDateTime&' => 'tde_DwDateTime*',
'DwDateTime*' => 'tde_DwDateTime*',
'DwDispositionType&' => 'tde_DwDispositionType*',
'DwDispositionType*' => 'tde_DwDispositionType*',
'DwEntity&' => 'tde_DwEntity*',
'DwField&' => 'tde_DwField*',
'DwField*' => 'tde_DwField*',
'DwFieldBody&' => 'tde_DwFieldBody*',
'DwFieldBody*' => 'tde_DwFieldBody*',
'DwGroup&' => 'tde_DwGroup*',
'DwGroup*' => 'tde_DwGroup*',
'DwHeaders&' => 'tde_DwHeaders*',
'DwHeaders*' => 'tde_DwHeaders*',
'DwInt32' => 'int',
'DwMailbox&' => 'tde_DwMailbox*',
'DwMailbox*' => 'tde_DwMailbox*',
'DwMailboxList&' => 'tde_DwMailboxList*',
'DwMailboxList*' => 'tde_DwMailboxList*',
'DwMechanism&' => 'tde_DwMechanism*',
'DwMechanism*' => 'tde_DwMechanism*',
'DwMediaType&' => 'tde_DwMediaType*',
'DwMediaType*' => 'tde_DwMediaType*',
'DwMessage&' => 'tde_DwMessage*',
'DwMessage*' => 'tde_DwMessage*',
'DwMessageComponent&' => 'tde_DwMessageComponent*',
'DwMessageComponent*' => 'tde_DwMessageComponent*',
'DwMime*' => 'tde_DwMime*',
'DwMsgId&' => 'tde_DwMsgId*',
'DwMsgId*' => 'tde_DwMsgId*',
'DwObserver*' => 'tde_DwObserver*',
'DwParameter&' => 'tde_DwParameter*',
'DwParameter*' => 'tde_DwParameter*',
'DwProtocolClient*' => 'tde_DwProtocolClient*',
'DwString&' => 'tde_DwString*',
'DwString' => 'tde_DwString',
'DwString*' => 'tde_DwString*',
'DwText&' => 'tde_DwText*',
'DwText*' => 'tde_DwText*',
'DwTokenizer&' => 'tde_DwTokenizer*',
'DwUint16' => 'unsigned short',
'DwUint32' => 'unsigned int',
'DwUint8' => 'unsigned char',
'DynamicCast*' => 'tde_DynamicCast*',
'DynamicRequest&' => 'tde_DynamicRequest*',
'DynamicRequest*' => 'tde_DynamicRequest*',
'EXPORT_DOCKCLASS*' => 'tde_EXPORT_DOCKCLASS*',
'EchoMode' => 'int',
'EditInterface*' => 'tde_EditInterface*',
'Editor*' => 'tde_Editor*',
'EditorContext*' => 'tde_EditorContext*',
'Element&' => 'tde_Element*',
'Element' => 'tde_Element*',
'Element*' => 'tde_Element*',
'EmailSelectDialog*' => 'tde_EmailSelectDialog*',
'EncoderFn'  =>  'int' ,
'Endian' => 'int',
'Entity&' => 'tde_Entity*',
'Entity*' => 'tde_Entity*',
'EntityReference&' => 'tde_EntityReference*',
'EntityReference' => 'tde_EntityReference*',
'EntityReference*' => 'tde_EntityReference*',
'Entry&'  =>  'tde_Entry*' ,
'Entry*' => 'tde_Entry*',
'Entry::Address&'  =>  'tde_EntryAddress' ,
'EnumComponent&' => 'tde_EnumComponent*',
'EnumComponent*' => 'tde_EnumComponent*',
'EnumDef&' => 'tde_EnumDef*',
'EnumDef*' => 'tde_EnumDef*',
'EnumEntry*' => 'tde_EnumEntry*',
'Error*' => 'tde_Error*',
'Event*' => 'tde_Event*',
'ExecState*' => 'tde_ExecState*',
'ExtensionLoader*' => 'tde_ExtensionLoader*',
'FALSE' => '0',
'FMOut*' => 'tde_FMOut*',
'Factory*' => 'tde_Factory*',
'False' => '0',
'FileCopyJob*' => 'tde_FileCopyJob*',
'FileProtocol*' => 'tde_FileProtocol*',
'FileView&'  =>  'int' ,
'FloatAsyncStream*' => 'tde_FloatAsyncStream*',
'FloatDataPacket*' => 'tde_FloatDataPacket*',
'FlowSystem&' => 'tde_FlowSystem*',
'FlowSystem' => 'tde_FlowSystem*',
'FlowSystem*' => 'tde_FlowSystem*',
'FlowSystemReceiver&' => 'tde_FlowSystemReceiver*',
'FlowSystemReceiver' => 'tde_FlowSystemReceiver*',
'FlowSystemReceiver*' => 'tde_FlowSystemReceiver*',
'FlowSystemReceiver_base*' => 'tde_FlowSystemReceiver_base*',
'FlowSystemReceiver_skel*' => 'tde_FlowSystemReceiver_skel*',
'FlowSystemReceiver_stub*' => 'tde_FlowSystemReceiver_stub*',
'FlowSystemSender&' => 'tde_FlowSystemSender*',
'FlowSystemSender' => 'tde_FlowSystemSender*',
'FlowSystemSender*' => 'tde_FlowSystemSender*',
'FlowSystemSender_base*' => 'tde_FlowSystemSender_base*',
'FlowSystemSender_skel*' => 'tde_FlowSystemSender_skel*',
'FlowSystemSender_stub*' => 'tde_FlowSystemSender_stub*',
'FlowSystem_base*' => 'tde_FlowSystem_base*',
'FlowSystem_impl*' => 'tde_FlowSystem_impl*',
'FlowSystem_skel*' => 'tde_FlowSystem_skel*',
'FlowSystem_stub*' => 'tde_FlowSystem_stub*',
'FocusPolicy' => 'int',
'Format&' => 'tde_Format*',
'Format*' => 'tde_Format*',
'Function*' => 'tde_Function*',
'FunctionImp*' => 'tde_FunctionImp*',
'GCI&'  =>  'GCI*' ,
'GCI'  =>  'GCI*' ,
'GCI*'  =>  'GCI*' ,
'GUIActivateEvent*' => 'tde_GUIActivateEvent*',
'GUIStyle' => 'int',
'GUSOut*' => 'tde_GUSOut*',
'GenericAsyncStream*' => 'tde_GenericAsyncStream*',
'GenericDataChannel*' => 'tde_GenericDataChannel*',
'GenericDataPacket*' => 'tde_GenericDataPacket*',
'GenericFactory*' => 'tde_GenericFactory*',
'GenericFactoryBase*' => 'tde_GenericFactoryBase*',
'Global*' => 'tde_Global*',
'GlobalComm&' => 'tde_GlobalComm*',
'GlobalComm' => 'tde_GlobalComm*',
'GlobalComm*' => 'tde_GlobalComm*',
'GlobalComm_base*' => 'tde_GlobalComm_base*',
'GlobalComm_skel*' => 'tde_GlobalComm_skel*',
'GlobalComm_stub*' => 'tde_GlobalComm_stub*',
'HANDLE' => 'unsigned int',
'HBITMAP'  =>  'void*' ,
'HCURSOR'  =>  'void*' ,
'HDC'  =>  'void*' ,
'HFONT'  =>  'void*' ,
'HPALETTE'  =>  'void*' ,
'HRGN'  =>  'void*' ,
'HTMLAnchorElement&' => 'tde_HTMLAnchorElement*',
'HTMLAnchorElement*' => 'tde_HTMLAnchorElement*',
'HTMLAnchorElementImpl*' => 'tde_HTMLAnchorElementImpl*',
'HTMLAppletElement&' => 'tde_HTMLAppletElement*',
'HTMLAppletElement*' => 'tde_HTMLAppletElement*',
'HTMLAppletElementImpl*' => 'tde_HTMLAppletElementImpl*',
'HTMLAreaElement&' => 'tde_HTMLAreaElement*',
'HTMLAreaElement*' => 'tde_HTMLAreaElement*',
'HTMLAreaElementImpl*' => 'tde_HTMLAreaElementImpl*',
'HTMLBRElement&' => 'tde_HTMLBRElement*',
'HTMLBRElement*' => 'tde_HTMLBRElement*',
'HTMLBRElementImpl*' => 'tde_HTMLBRElementImpl*',
'HTMLBaseElement&' => 'tde_HTMLBaseElement*',
'HTMLBaseElement*' => 'tde_HTMLBaseElement*',
'HTMLBaseElementImpl*' => 'tde_HTMLBaseElementImpl*',
'HTMLBaseFontElement&' => 'tde_HTMLBaseFontElement*',
'HTMLBaseFontElement*' => 'tde_HTMLBaseFontElement*',
'HTMLBaseFontElementImpl*' => 'tde_HTMLBaseFontElementImpl*',
'HTMLBlockquoteElement&' => 'tde_HTMLBlockquoteElement*',
'HTMLBlockquoteElement*' => 'tde_HTMLBlockquoteElement*',
'HTMLBlockquoteElementImpl*' => 'tde_HTMLBlockquoteElementImpl*',
'HTMLBodyElement&' => 'tde_HTMLBodyElement*',
'HTMLBodyElement*' => 'tde_HTMLBodyElement*',
'HTMLBodyElementImpl*' => 'tde_HTMLBodyElementImpl*',
'HTMLButtonElement&' => 'tde_HTMLButtonElement*',
'HTMLButtonElement*' => 'tde_HTMLButtonElement*',
'HTMLButtonElementImpl*' => 'tde_HTMLButtonElementImpl*',
'HTMLCollection&' => 'tde_HTMLCollection*',
'HTMLCollection' => 'tde_HTMLCollection*',
'HTMLCollection*' => 'tde_HTMLCollection*',
'HTMLCollectionImpl*' => 'tde_HTMLCollectionImpl*',
'HTMLDListElement&' => 'tde_HTMLDListElement*',
'HTMLDListElement*' => 'tde_HTMLDListElement*',
'HTMLDListElementImpl*' => 'tde_HTMLDListElementImpl*',
'HTMLDirectoryElement&' => 'tde_HTMLDirectoryElement*',
'HTMLDirectoryElement*' => 'tde_HTMLDirectoryElement*',
'HTMLDirectoryElementImpl*' => 'tde_HTMLDirectoryElementImpl*',
'HTMLDivElement&' => 'tde_HTMLDivElement*',
'HTMLDivElement*' => 'tde_HTMLDivElement*',
'HTMLDivElementImpl*' => 'tde_HTMLDivElementImpl*',
'HTMLDocument&' => 'tde_HTMLDocument*',
'HTMLDocument*' => 'tde_HTMLDocument*',
'HTMLDocumentImpl*' => 'tde_HTMLDocumentImpl*',
'HTMLElement&' => 'tde_HTMLElement*',
'HTMLElement' => 'tde_HTMLElement*',
'HTMLElement*' => 'tde_HTMLElement*',
'HTMLElementImpl*' => 'tde_HTMLElementImpl*',
'HTMLFieldSetElement&' => 'tde_HTMLFieldSetElement*',
'HTMLFieldSetElement*' => 'tde_HTMLFieldSetElement*',
'HTMLFieldSetElementImpl*' => 'tde_HTMLFieldSetElementImpl*',
'HTMLFontElement&' => 'tde_HTMLFontElement*',
'HTMLFontElement*' => 'tde_HTMLFontElement*',
'HTMLFontElementImpl*' => 'tde_HTMLFontElementImpl*',
'HTMLFormElement&' => 'tde_HTMLFormElement*',
'HTMLFormElement' => 'tde_HTMLFormElement*',
'HTMLFormElement*' => 'tde_HTMLFormElement*',
'HTMLFormElementImpl*' => 'tde_HTMLFormElementImpl*',
'HTMLFrameElement&' => 'tde_HTMLFrameElement*',
'HTMLFrameElement*' => 'tde_HTMLFrameElement*',
'HTMLFrameElementImpl*' => 'tde_HTMLFrameElementImpl*',
'HTMLFrameSetElement&' => 'tde_HTMLFrameSetElement*',
'HTMLFrameSetElement*' => 'tde_HTMLFrameSetElement*',
'HTMLFrameSetElementImpl*' => 'tde_HTMLFrameSetElementImpl*',
'HTMLHRElement&' => 'tde_HTMLHRElement*',
'HTMLHRElement*' => 'tde_HTMLHRElement*',
'HTMLHRElementImpl*' => 'tde_HTMLHRElementImpl*',
'HTMLHeadElement&' => 'tde_HTMLHeadElement*',
'HTMLHeadElement*' => 'tde_HTMLHeadElement*',
'HTMLHeadElementImpl*' => 'tde_HTMLHeadElementImpl*',
'HTMLHeadingElement&' => 'tde_HTMLHeadingElement*',
'HTMLHeadingElement*' => 'tde_HTMLHeadingElement*',
'HTMLHeadingElementImpl*' => 'tde_HTMLHeadingElementImpl*',
'HTMLHtmlElement&' => 'tde_HTMLHtmlElement*',
'HTMLHtmlElement*' => 'tde_HTMLHtmlElement*',
'HTMLHtmlElementImpl*' => 'tde_HTMLHtmlElementImpl*',
'HTMLIFrameElement&' => 'tde_HTMLIFrameElement*',
'HTMLIFrameElement*' => 'tde_HTMLIFrameElement*',
'HTMLIFrameElementImpl*' => 'tde_HTMLIFrameElementImpl*',
'HTMLImageElement&' => 'tde_HTMLImageElement*',
'HTMLImageElement*' => 'tde_HTMLImageElement*',
'HTMLImageElementImpl*' => 'tde_HTMLImageElementImpl*',
'HTMLInputElement&' => 'tde_HTMLInputElement*',
'HTMLInputElement*' => 'tde_HTMLInputElement*',
'HTMLInputElementImpl*' => 'tde_HTMLInputElementImpl*',
'HTMLIsIndexElement&' => 'tde_HTMLIsIndexElement*',
'HTMLIsIndexElement*' => 'tde_HTMLIsIndexElement*',
'HTMLIsIndexElementImpl*' => 'tde_HTMLIsIndexElementImpl*',
'HTMLLIElement&' => 'tde_HTMLLIElement*',
'HTMLLIElement*' => 'tde_HTMLLIElement*',
'HTMLLIElementImpl*' => 'tde_HTMLLIElementImpl*',
'HTMLLabelElement&' => 'tde_HTMLLabelElement*',
'HTMLLabelElement*' => 'tde_HTMLLabelElement*',
'HTMLLabelElementImpl*' => 'tde_HTMLLabelElementImpl*',
'HTMLLegendElement&' => 'tde_HTMLLegendElement*',
'HTMLLegendElement*' => 'tde_HTMLLegendElement*',
'HTMLLegendElementImpl*' => 'tde_HTMLLegendElementImpl*',
'HTMLLinkElement&' => 'tde_HTMLLinkElement*',
'HTMLLinkElement*' => 'tde_HTMLLinkElement*',
'HTMLLinkElementImpl*' => 'tde_HTMLLinkElementImpl*',
'HTMLMapElement&' => 'tde_HTMLMapElement*',
'HTMLMapElement*' => 'tde_HTMLMapElement*',
'HTMLMapElementImpl*' => 'tde_HTMLMapElementImpl*',
'HTMLMenuElement&' => 'tde_HTMLMenuElement*',
'HTMLMenuElement*' => 'tde_HTMLMenuElement*',
'HTMLMenuElementImpl*' => 'tde_HTMLMenuElementImpl*',
'HTMLMetaElement&' => 'tde_HTMLMetaElement*',
'HTMLMetaElement*' => 'tde_HTMLMetaElement*',
'HTMLMetaElementImpl*' => 'tde_HTMLMetaElementImpl*',
'HTMLModElement&' => 'tde_HTMLModElement*',
'HTMLModElement*' => 'tde_HTMLModElement*',
'HTMLModElementImpl*' => 'tde_HTMLModElementImpl*',
'HTMLOListElement&' => 'tde_HTMLOListElement*',
'HTMLOListElement*' => 'tde_HTMLOListElement*',
'HTMLOListElementImpl*' => 'tde_HTMLOListElementImpl*',
'HTMLObjectElement&' => 'tde_HTMLObjectElement*',
'HTMLObjectElement*' => 'tde_HTMLObjectElement*',
'HTMLObjectElementImpl*' => 'tde_HTMLObjectElementImpl*',
'HTMLOptGroupElement&' => 'tde_HTMLOptGroupElement*',
'HTMLOptGroupElement*' => 'tde_HTMLOptGroupElement*',
'HTMLOptGroupElementImpl*' => 'tde_HTMLOptGroupElementImpl*',
'HTMLOptionElement&' => 'tde_HTMLOptionElement*',
'HTMLOptionElement*' => 'tde_HTMLOptionElement*',
'HTMLOptionElementImpl*' => 'tde_HTMLOptionElementImpl*',
'HTMLParagraphElement&' => 'tde_HTMLParagraphElement*',
'HTMLParagraphElement*' => 'tde_HTMLParagraphElement*',
'HTMLParagraphElementImpl*' => 'tde_HTMLParagraphElementImpl*',
'HTMLParamElement&' => 'tde_HTMLParamElement*',
'HTMLParamElement*' => 'tde_HTMLParamElement*',
'HTMLParamElementImpl*' => 'tde_HTMLParamElementImpl*',
'HTMLPreElement&' => 'tde_HTMLPreElement*',
'HTMLPreElement*' => 'tde_HTMLPreElement*',
'HTMLPreElementImpl*' => 'tde_HTMLPreElementImpl*',
'HTMLQuoteElement&' => 'tde_HTMLQuoteElement*',
'HTMLQuoteElement*' => 'tde_HTMLQuoteElement*',
'HTMLQuoteElementImpl*' => 'tde_HTMLQuoteElementImpl*',
'HTMLScriptElement&' => 'tde_HTMLScriptElement*',
'HTMLScriptElement*' => 'tde_HTMLScriptElement*',
'HTMLScriptElementImpl*' => 'tde_HTMLScriptElementImpl*',
'HTMLSelectElement&' => 'tde_HTMLSelectElement*',
'HTMLSelectElement*' => 'tde_HTMLSelectElement*',
'HTMLSelectElementImpl*' => 'tde_HTMLSelectElementImpl*',
'HTMLStyleElement&' => 'tde_HTMLStyleElement*',
'HTMLStyleElement*' => 'tde_HTMLStyleElement*',
'HTMLStyleElementImpl*' => 'tde_HTMLStyleElementImpl*',
'HTMLTableCaptionElement&' => 'tde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement' => 'tde_HTMLTableCaptionElement*',
'HTMLTableCaptionElement*' => 'tde_HTMLTableCaptionElement*',
'HTMLTableCaptionElementImpl*' => 'tde_HTMLTableCaptionElementImpl*',
'HTMLTableCellElement&' => 'tde_HTMLTableCellElement*',
'HTMLTableCellElement*' => 'tde_HTMLTableCellElement*',
'HTMLTableCellElementImpl*' => 'tde_HTMLTableCellElementImpl*',
'HTMLTableColElement&' => 'tde_HTMLTableColElement*',
'HTMLTableColElement*' => 'tde_HTMLTableColElement*',
'HTMLTableColElementImpl*' => 'tde_HTMLTableColElementImpl*',
'HTMLTableElement&' => 'tde_HTMLTableElement*',
'HTMLTableElement*' => 'tde_HTMLTableElement*',
'HTMLTableElementImpl*' => 'tde_HTMLTableElementImpl*',
'HTMLTableRowElement&' => 'tde_HTMLTableRowElement*',
'HTMLTableRowElement*' => 'tde_HTMLTableRowElement*',
'HTMLTableRowElementImpl*' => 'tde_HTMLTableRowElementImpl*',
'HTMLTableSectionElement&' => 'tde_HTMLTableSectionElement*',
'HTMLTableSectionElement' => 'tde_HTMLTableSectionElement*',
'HTMLTableSectionElement*' => 'tde_HTMLTableSectionElement*',
'HTMLTableSectionElementImpl*' => 'tde_HTMLTableSectionElementImpl*',
'HTMLTextAreaElement&' => 'tde_HTMLTextAreaElement*',
'HTMLTextAreaElement*' => 'tde_HTMLTextAreaElement*',
'HTMLTextAreaElementImpl*' => 'tde_HTMLTextAreaElementImpl*',
'HTMLTitleElement&' => 'tde_HTMLTitleElement*',
'HTMLTitleElement*' => 'tde_HTMLTitleElement*',
'HTMLTitleElementImpl*' => 'tde_HTMLTitleElementImpl*',
'HTMLUListElement&' => 'tde_HTMLUListElement*',
'HTMLUListElement*' => 'tde_HTMLUListElement*',
'HTMLUListElementImpl*' => 'tde_HTMLUListElementImpl*',
'HandlerType'  =>  'qt_HandlerType*' ,
'HashEntry*' => 'tde_HashEntry*',
'HashTable*' => 'tde_HashTable*',
'Header&' => 'tde_Header*',
'Header*' => 'tde_Header*',
'HighlightingInterface*' => 'tde_HighlightingInterface*',
'HistoryProvider*' => 'tde_HistoryProvider*',
'HostImp*' => 'tde_HostImp*',
'IDLFileReg*' => 'tde_IDLFileReg*',
'IOManager*' => 'tde_IOManager*',
'IONotify*' => 'tde_IONotify*',
'IOType*' => 'tde_IOType*',
'IOWatchFD*' => 'tde_IOWatchFD*',
'Icon' => 'int',
'IconListBox*' => 'tde_IconListBox*',
'Imp*' => 'void*',
'Info*' => 'tde_Info*',
'InterfaceDef&' => 'tde_InterfaceDef*',
'InterfaceDef' => 'tde_InterfaceDef*',
'InterfaceDef*' => 'tde_InterfaceDef*',
'InterfaceEntry*' => 'tde_InterfaceEntry*',
'InterfaceRepo&' => 'tde_InterfaceRepo*',
'InterfaceRepo' => 'tde_InterfaceRepo*',
'InterfaceRepo*' => 'tde_InterfaceRepo*',
'InterfaceRepo_base*' => 'tde_InterfaceRepo_base*',
'InterfaceRepo_impl*' => 'tde_InterfaceRepo_impl*',
'InterfaceRepo_skel*' => 'tde_InterfaceRepo_skel*',
'InterfaceRepo_stub*' => 'tde_InterfaceRepo_stub*',
'InternalFunctionImp*' => 'tde_InternalFunctionImp*',
'Interpreter*' => 'tde_Interpreter*',
'Invocation&' => 'tde_Invocation*',
'Invocation*' => 'tde_Invocation*',
'Iterator'  =>  'Iterator*' ,
'Job*' => 'void*',
'K&'  =>  'K*' ,
'TDEAboutApplication*' => 'tde_TDEAboutApplication*',
'TDEAboutContainer*'  =>  'tde_TDEAboutContainer*' ,
'TDEAboutContributor*' => 'tde_TDEAboutContributor*',
'TDEAboutData*'  =>  'tde_TDEAboutData*' ,
'TDEAboutDialog*' => 'tde_TDEAboutDialog*',
'TDEAboutKDE*' => 'tde_TDEAboutKDE*',
'TDEAboutPerson*' => 'tde_TDEAboutPerson*',
'TDEAboutTranslator*' => 'tde_TDEAboutTranslator*',
'TDEAboutWidget*' => 'tde_TDEAboutWidget*',
'TDEAccel*'  =>  'tde_TDEAccel*' ,
'TDEAccelAction&' => 'tde_TDEAccelAction*',
'TDEAccelAction*' => 'tde_TDEAccelAction*',
'TDEAccelActions&' => 'tde_TDEAccelActions*',
'TDEAccelActions*' => 'tde_TDEAccelActions*',
'TDEAccelBase*' => 'tde_TDEAccelBase*',
'TDEAccelGen*' => 'tde_TDEAccelGen*',
'TDEAccelMenu*' => 'tde_TDEAccelMenu*',
'TDEAccelSequence&' => 'tde_TDEAccelSequence*',
'TDEAccelSequence' => 'tde_TDEAccelSequence*',
'TDEAccelSequence*' => 'tde_TDEAccelSequence*',
'TDEAccelShortcut&' => 'tde_TDEAccelShortcut*',
'TDEAccelShortcut' => 'tde_TDEAccelShortcut*',
'TDEAccelShortcut*' => 'tde_TDEAccelShortcut*',
'TDEAccelShortcuts&' => 'tde_TDEAccelShortcuts*',
'TDEAccelShortcuts*' => 'tde_TDEAccelShortcuts*',
'TDEAction*'  =>  'tde_TDEAction*' ,
'TDEActionCollection&'  => 'tde_TDEActionCollection*' ,
'TDEActionCollection'  => 'tde_TDEActionCollection*' ,
'TDEActionCollection*'  => 'tde_TDEActionCollection*' ,
'TDEActionMenu*' => 'tde_TDEActionMenu*',
'TDEActionSeparator*' => 'tde_TDEActionSeparator*',
'KAddressInfo*' => 'tde_KAddressInfo*',
'KAlphaPainter*' => 'tde_KAlphaPainter*',
'KAnimWidget*'  =>  'tde_KAnimWidget*' ,
'KAppTreeListItem*'  =>  'tde_KAppTreeListItem*' ,
'TDEApplication*'  =>  'tde_TDEApplication*' ,
'TDEApplicationPropsPlugin*' => 'tde_TDEApplicationPropsPlugin*',
'TDEApplicationTree*' => 'tde_TDEApplicationTree*',
'KArchive*' => 'tde_KArchive*',
'KArchiveDirectory*' => 'tde_KArchiveDirectory*',
'KArchiveEntry*' => 'tde_KArchiveEntry*',
'KArchiveFile*' => 'tde_KArchiveFile*',
'KArrowButton*' => 'tde_KArrowButton*',
'KArtsDispatcher*' => 'tde_KArtsDispatcher*',
'KArtsFloatWatch*' => 'tde_KArtsFloatWatch*',
'KAsyncIO*' => 'tde_KAsyncIO*',
'KAudioPlayer*' => 'tde_KAudioPlayer*',
'KAuthIcon*' => 'tde_KAuthIcon*',
'KAutoMount*' => 'tde_KAutoMount*',
'KAutoUnmount*' => 'tde_KAutoUnmount*',
'KBindingPropsPlugin*' => 'tde_KBindingPropsPlugin*',
'KBlankEffect*' => 'tde_KBlankEffect*',
'TDEBufferedIO*' => 'tde_TDEBufferedIO*',
'KBugReport*' => 'tde_KBugReport*',
'KButtonBox*' => 'tde_KButtonBox*',
'TDECModule*'  =>  'tde_TDECModule*' ,
'KCatalogue&' => 'tde_KCatalogue*',
'KCatalogue*' => 'tde_KCatalogue*',
'KCharSelect*' => 'tde_KCharSelect*',
'KCharSelectTable*' => 'tde_KCharSelectTable*',
'KCharsets*'  =>  'tde_KCharsets*' ,
'TDECmdLineArgs*'  =>  'tde_TDECmdLineArgs*' ,
'KCodecs*' => 'tde_KCodecs*',
'KColor&'  => 'tde_KColor*' ,
'KColor*' => 'tde_KColor*',
'KColorButton*' => 'tde_KColorButton*',
'KColorCells*' => 'tde_KColorCells*',
'KColorCombo*' => 'tde_KColorCombo*',
'KColorDialog*' => 'tde_KColorDialog*',
'KColorDrag*'  =>  'tde_KColorDrag*' ,
'KColorPatch*' => 'tde_KColorPatch*',
'KCombiView*' => 'tde_KCombiView*',
'KComboBox*'  =>  'tde_KComboBox*' ,
'KCommand*' => 'tde_KCommand*',
'KCommandHistory*' => 'tde_KCommandHistory*',
'TDECompletion*'  =>  'tde_TDECompletion*' ,
'TDECompletionBase*' => 'tde_TDECompletionBase*',
'TDECompletionBox*' => 'tde_TDECompletionBox*',
'TDEConfig*'  => 'tde_TDEConfig*' ,
'TDEConfigBackEnd*' => 'tde_TDEConfigBackEnd*',
'TDEConfigBase&' => 'tde_TDEConfigBase*',
'TDEConfigBase*'  => 'tde_TDEConfigBase*' ,
'TDEConfigGroup*' => 'tde_TDEConfigGroup*',
'TDEConfigGroupSaver*' => 'tde_TDEConfigGroupSaver*',
'TDEConfigINIBackEnd*' => 'tde_TDEConfigINIBackEnd*',
'KContainerLayout*' => 'tde_KContainerLayout*',
'KContainerLayoutItem*'  => 'tde_KContainerLayoutItem*' ,
'KContextMenuManager*' => 'tde_KContextMenuManager*',
'KCookie*' => 'tde_KCookie*',
'TDECrash*' => 'tde_TDECrash*',
'KCursor*' => 'tde_KCursor*',
'KDBGFUNC'  => 'void*' ,
'KDCOPActionProxy*' => 'tde_KDCOPActionProxy*',
'KDCOPPropertyProxy*' => 'tde_KDCOPPropertyProxy*',
'KDEAniMenu*' => 'tde_KDEAniMenu*',
'KDEDModule*' => 'tde_KDEDModule*',
'KDEDesktopMimeType*' => 'tde_KDEDesktopMimeType*',
'KDESasl*' => 'tde_KDESasl*',
'KDEStyle*' => 'tde_KDEStyle*',
'KDataTool*' => 'tde_KDataTool*',
'KDataToolAction*' => 'tde_KDataToolAction*',
'KDataToolInfo&' => 'tde_KDataToolInfo*',
'KDataToolInfo*' => 'tde_KDataToolInfo*',
'KDateInternalMonthPicker*' => 'tde_KDateInternalMonthPicker*',
'KDateInternalYearSelector*' => 'tde_KDateInternalYearSelector*',
'KDatePicker*' => 'tde_KDatePicker*',
'KDateTable*' => 'tde_KDateTable*',
'KDateValidator*' => 'tde_KDateValidator*',
'KDateWidget*' => 'tde_KDateWidget*',
'KDesktopFile*'  => 'tde_KDesktopFile*' ,
'KDevApi*' => 'tde_KDevApi*',
'KDevAppFrontend*' => 'tde_KDevAppFrontend*',
'KDevCompilerOptions*' => 'tde_KDevCompilerOptions*',
'KDevCore*' => 'tde_KDevCore*',
'KDevFactory*' => 'tde_KDevFactory*',
'KDevLanguageSupport*' => 'tde_KDevLanguageSupport*',
'KDevMakeFrontend*' => 'tde_KDevMakeFrontend*',
'KDevPart*' => 'tde_KDevPart*',
'KDevProject*' => 'tde_KDevProject*',
'KDevVersionControl*' => 'tde_KDevVersionControl*',
'KDevicePropsPlugin*' => 'tde_KDevicePropsPlugin*',
'KDialog*' => 'tde_KDialog*',
'KDialogBase*'  =>  'tde_KDialogBase*' ,
'KDialogBaseTile*' => 'tde_KDialogBaseTile*',
'KDialogQueue*' => 'tde_KDialogQueue*',
'KDirNotify*' => 'tde_KDirNotify*',
'KDirNotify_stub*' => 'tde_KDirNotify_stub*',
'KDirOperator*' => 'tde_KDirOperator*',
'KDirSelectDialog*' => 'tde_KDirSelectDialog*',
'KDirSize*'  =>  'tde_KDirSize*' ,
'KDirWatch*'  =>  'tde_KDirWatch*' ,
'KDirectionButton*' => 'tde_KDirectionButton*',
'KDockArea*' => 'tde_KDockArea*',
'KDockMainWindow*' => 'tde_KDockMainWindow*',
'KDockManager*'  => 'tde_KDockManager*' ,
'KDockTabBar*' => 'tde_KDockTabBar*',
'KDockTabBar::TabPos' => 'int',
'KDockTabBarPainter*' => 'tde_KDockTabBarPainter*',
'KDockTabCtl*' => 'tde_KDockTabCtl*',
'KDockTabCtl_PrivateStruct*'  =>  'tde_KDockTabCtl_PrivateStruct*' ,
'KDockTabGroup*'  =>  'tde_KDockTabGroup*' ,
'KDockWidget*'  => 'tde_KDockWidget*' ,
'KDockWidgetAbstractHeader*'  => 'tde_KDockWidgetAbstractHeader*' ,
'KDockWidgetAbstractHeaderDrag*' => 'tde_KDockWidgetAbstractHeaderDrag*',
'KDockWidgetHeader*' => 'tde_KDockWidgetHeader*',
'KDockWidgetHeaderDrag*' => 'tde_KDockWidgetHeaderDrag*',
'KDockWindow*' => 'tde_KDockWindow*',
'KDoubleNumInput*' => 'tde_KDoubleNumInput*',
'KDualColorButton*' => 'tde_KDualColorButton*',
'KEMailSettings*' => 'tde_KEMailSettings*',
'KEdFind*' => 'tde_KEdFind*',
'KEdGotoLine*' => 'tde_KEdGotoLine*',
'KEdReplace*' => 'tde_KEdReplace*',
'KEdit*' => 'tde_KEdit*',
'KEditListBox*' => 'tde_KEditListBox*',
'KEditToolbar*' => 'tde_KEditToolbar*',
'KEditToolbarWidget*' => 'tde_KEditToolbarWidget*',
'KEntry&'  => 'tde_KEntry*' ,
'KEntry'  => 'tde_KEntry*' ,
'KEntry*' => 'tde_KEntry*',
'KEntryKey&'  => 'tde_KEntryKey*' ,
'KEntryKey*' => 'tde_KEntryKey*',
'KExecMimeType*' => 'tde_KExecMimeType*',
'KExecPropsPlugin*' => 'tde_KExecPropsPlugin*',
'KFile*' => 'tde_KFile*',
'KFile::FileView'  => 'int' ,
'KFile::Mode'  => 'int' ,
'KFile::SelectionMode'  => 'int' ,
'KFileBookmark*'  =>  'tde_KFileBookmark*' ,
'KFileBookmarkManager*' => 'tde_KFileBookmarkManager*',
'KFileComboBox*' => 'tde_KFileComboBox*',
'KFileDetailView*' => 'tde_KFileDetailView*',
'KFileDialog*'  =>  'tde_KFileDialog*' ,
'KFileFilter*' => 'tde_KFileFilter*',
'KFileFilterCombo*' => 'tde_KFileFilterCombo*',
'KFileIconView*' => 'tde_KFileIconView*',
'KFileIconViewItem*' => 'tde_KFileIconViewItem*',
'KFileItemList&'  => 'tde_KFileItemList*' ,
'KFileItemList'  => 'tde_KFileItemList*' ,
'KFileItemList*'  => 'tde_KFileItemList*' ,
'KFileListViewItem*' => 'tde_KFileListViewItem*',
'KFileMetaInfo*' => 'tde_KFileMetaInfo*',
'KFileMetaInfoItem*' => 'tde_KFileMetaInfoItem*',
'KFileMetaInfoProvider*' => 'tde_KFileMetaInfoProvider*',
'KFileOpenWithHandler*' => 'tde_KFileOpenWithHandler*',
'KFilePermissionsPropsPlugin*' => 'tde_KFilePermissionsPropsPlugin*',
'KFilePlugin*' => 'tde_KFilePlugin*',
'KFilePreview*' => 'tde_KFilePreview*',
'KFilePropsPlugin*' => 'tde_KFilePropsPlugin*',
'KFileReader*'  => 'tde_KFileReader*' ,
'KFileTreeBranch*' => 'tde_KFileTreeBranch*',
'KFileTreeView*' => 'tde_KFileTreeView*',
'KFileTreeViewItem*' => 'tde_KFileTreeViewItem*',
'KFileTreeViewToolTip*' => 'tde_KFileTreeViewToolTip*',
'KFileView*'  => 'tde_KFileView*' ,
'KFileView::FileView' => 'int',
'KFileViewItem&' => 'tde_KFileViewItem*',
'KFileViewItem*'  => 'tde_KFileViewItem*' ,
'KFileViewItem**'  => 'tde_KFileViewItem**' ,
'KFileViewItemList&'  => 'tde_KFileViewItemList*' ,
'KFileViewItemList*'  => 'tde_KFileViewItemList*' ,
'KFileViewSignaler*' => 'tde_KFileViewSignaler*',
'KFilterBase*' => 'tde_KFilterBase*',
'KFilterDev*' => 'tde_KFilterDev*',
'KFloatValidator*' => 'tde_KFloatValidator*',
'KFloatWatchProxy&' => 'tde_KFloatWatchProxy*',
'KFloatWatchProxy' => 'tde_KFloatWatchProxy*',
'KFloatWatchProxy*' => 'tde_KFloatWatchProxy*',
'KFolderType*' => 'tde_KFolderType*',
'TDEsuClient*' => 'tde_TDEsuClient*',
'TDEFontAction*' => 'tde_TDEFontAction*',
'TDEFontChooser*' => 'tde_TDEFontChooser*',
'TDEFontCombo*' => 'tde_TDEFontCombo*',
'TDEFontDialog*' => 'tde_TDEFontDialog*',
'TDEFontSizeAction*' => 'tde_TDEFontSizeAction*',
'KGenericFactory*' => 'tde_KGenericFactory*',
'KGenericFactoryBase*' => 'tde_KGenericFactoryBase*',
'TDEGlobal*' => 'tde_TDEGlobal*',
'TDEGlobalAccel*'  =>  'tde_TDEGlobalAccel*' ,
'TDEGlobalSettings*' => 'tde_TDEGlobalSettings*',
'TDEGlobalSettings::Completion'  => 'int' ,
'KGradientSelector*' => 'tde_KGradientSelector*',
'KGuiItem&' => 'tde_KGuiItem*',
'KGuiItem' => 'tde_KGuiItem*',
'KGuiItem*' => 'tde_KGuiItem*',
'KHSSelector*' => 'tde_KHSSelector*',
'TDEHTMLPart*'  =>  'tde_TDEHTMLPart*' ,
'TDEHTMLSettings&' => 'tde_TDEHTMLSettings*',
'TDEHTMLSettings*'  => 'tde_TDEHTMLSettings*' ,
'TDEHTMLView*'  => 'tde_TDEHTMLView*' ,
'KHelpMenu*' => 'tde_KHelpMenu*',
'KHistoryCombo*' => 'tde_KHistoryCombo*',
'TDEIO*' => 'tde_TDEIO*',
'TDEIO::CopyJob*'  => 'tde_CopyJob*' ,
'TDEIO::DeleteJob*'  => 'tde_DeleteJob*' ,
'TDEIO::Job*'  => 'tde_Job*' ,
'TDEIO::ListJob*'  => 'tde_ListJob*' ,
'TDEIO::RenameDlg_Mode' => 'int',
'TDEIO::RenameDlg_Result' => 'int',
'TDEIO::SimpleJob*' => 'tde_SimpleJob*',
'TDEIO::SkipDlg_Result' => 'int',
'TDEIO::Slave*' => 'tde_Slave*',
'TDEIOInputStream&' => 'tde_TDEIOInputStream*',
'TDEIOInputStream*' => 'tde_TDEIOInputStream*',
'KIOTestSlow&' => 'tde_KIOTestSlow*',
'KIOTestSlow' => 'tde_KIOTestSlow*',
'KIOTestSlow*' => 'tde_KIOTestSlow*',
'KIPC*' => 'tde_KIPC*',
'TDEIcon'  => 'tde_TDEIcon*' ,
'TDEIcon*' => 'tde_TDEIcon*',
'TDEIconButton*' => 'tde_TDEIconButton*',
'TDEIconCanvas*' => 'tde_TDEIconCanvas*',
'TDEIconDialog*' => 'tde_TDEIconDialog*',
'TDEIconEffect*'  =>  'tde_TDEIconEffect*' ,
'TDEIconLoader*'  => 'tde_TDEIconLoader*' ,
'TDEIconSelectAction*' => 'tde_TDEIconSelectAction*',
'TDEIconView*' => 'tde_TDEIconView*',
'TDEIconViewItem*' => 'tde_TDEIconViewItem*',
'KImageEffect*' => 'tde_KImageEffect*',
'KImageFilePreview*' => 'tde_KImageFilePreview*',
'KImageIO*' => 'tde_KImageIO*',
'TDEInstance&'  => 'tde_TDEInstance*' ,
'TDEInstance'  => 'tde_TDEInstance*' ,
'TDEInstance*'  => 'tde_TDEInstance*' ,
'KIntNumInput*' => 'tde_KIntNumInput*',
'KIntSpinBox*' => 'tde_KIntSpinBox*',
'KIntValidator*' => 'tde_KIntValidator*',
'KJS*' => 'tde_KJS*',
'KJS::KJSO&' => 'tde_KJS_KJSO*',
'KJS::UString&' => 'tde_KJS_UString*',
'KJSO&' => 'tde_KJSO*',
'KJSO' => 'tde_KJSO*',
'KJSO*' => 'tde_KJSO*',
'KJScript*' => 'tde_KJScript*',
'KJanusWidget*' => 'tde_KJanusWidget*',
'KKeyChooser*' => 'tde_KKeyChooser*',
'KKeyDialog*' => 'tde_KKeyDialog*',
'KKeyEntry&'  => 'tde_KKeyEntry*' ,
'KKeyEntry*' => 'tde_KKeyEntry*',
'KKeyEntryMap&'  => 'tde_KKeyEntryMap*' ,
'KKeyEntryMap'  => 'tde_KKeyEntryMap*' ,
'KKeyEntryMap*'  => 'tde_KKeyEntryMap*' ,
'KKeySequence&' => 'tde_KKeySequence*',
'KKeySequence' => 'tde_KKeySequence*',
'KKeySequence*' => 'tde_KKeySequence*',
'KKeySequence::I18N' => 'int',
'KKeySequences&' => 'tde_KKeySequences*',
'KKeySequences' => 'tde_KKeySequences*',
'KKeySequences*' => 'tde_KKeySequences*',
'KLed*' => 'tde_KLed*',
'KLibFactory*'  =>  'tde_KLibFactory*' ,
'KLibLoader*'  =>  'tde_KLibLoader*' ,
'KLineEdit*'  =>  'tde_KLineEdit*' ,
'KLineEditDlg*' => 'tde_KLineEditDlg*',
'TDEListBox*' => 'tde_TDEListBox*',
'TDEListView*'  => 'tde_TDEListView*' ,
'TDEListViewItem*' => 'tde_TDEListViewItem*',
'TDELocale&'  => 'tde_TDELocale*' ,
'TDELocale*'  => 'tde_TDELocale*' ,
'KMJobViewer*' => 'tde_KMJobViewer*',
'KMMainView*' => 'tde_KMMainView*',
'KMManager*' => 'tde_KMManager*',
'KMObject*' => 'tde_KMObject*',
'KMPrinter&' => 'tde_KMPrinter*',
'KMPrinter*' => 'tde_KMPrinter*',
'KMPrinterList*' => 'tde_KMPrinterList*',
'KMPrinterPage*' => 'tde_KMPrinterPage*',
'TDEMainWindow*' => 'tde_TDEMainWindow*',
'TDEMainWindowInterface*' => 'tde_TDEMainWindowInterface*',
'KMenuBar*'  => 'tde_KMenuBar*' ,
'KMessageBox*' => 'tde_KMessageBox*',
'KMidSimpleAPI*' => 'tde_KMidSimpleAPI*',
'KMimeMagic*'  =>  'tde_KMimeMagic*' ,
'KMimeMagicResult*'  => 'tde_KMimeMagicResult*' ,
'KMimeSourceFactory*'  => 'tde_KMimeSourceFactory*' ,
'KMimeType::List&'  => 'tde_KMimeType_List*' ,
'KMouseSettings*' => 'tde_KMouseSettings*',
'KMultipleDrag*' => 'tde_KMultipleDrag*',
'KNDBGFUNC'  => 'void*' ,
'KNotifyClient*' => 'tde_KNotifyClient*',
'KNumInput*'  => 'tde_KNumInput*' ,
'KOCRDialog*' => 'tde_KOCRDialog*',
'KOCRDialogFactory*' => 'tde_KOCRDialogFactory*',
'KOpenSSLProxy*' => 'tde_KOpenSSLProxy*',
'KOpenWithDlg*' => 'tde_KOpenWithDlg*',
'KOpenWithHandler*'  =>  'tde_KOpenWithHandler*' ,
'KPAC*' => 'tde_KPAC*',
'KPReloadObject*' => 'tde_KPReloadObject*',
'KPalette&'  => 'tde_KPalette*' ,
'KPalette*' => 'tde_KPalette*',
'KPaletteTable*' => 'tde_KPaletteTable*',
'KPanelAppMenu*' => 'tde_KPanelAppMenu*',
'KPanelApplet*' => 'tde_KPanelApplet*',
'KPanelExtension*' => 'tde_KPanelExtension*',
'KPanelMenu*'  =>  'tde_KPanelMenu*' ,
'KParts*' => 'tde_KParts*',
'KParts::BrowserExtension*'  => 'tde_BrowserExtension*' ,
'KParts::GUIActivateEvent*'  => 'tde_GUIActivateEvent*' ,
'KParts::Part*' => 'tde_Part*',
'KParts::ReadOnlyPart*'  => 'tde_ReadOnlyPart*' ,
'KPasswordDialog*' => 'tde_KPasswordDialog*',
'KPasswordEdit*' => 'tde_KPasswordEdit*',
'KPixmap&'  => 'tde_KPixmap*' ,
'KPixmap'  => 'tde_KPixmap*' ,
'KPixmap*' => 'tde_KPixmap*',
'KPixmapEffect*' => 'tde_KPixmapEffect*',
'KPixmapIO*' => 'tde_KPixmapIO*',
'KPixmapProvider*'  => 'tde_KPixmapProvider*' ,
'KPixmapSplitter*' => 'tde_KPixmapSplitter*',
'KPlayObject*' => 'tde_KPlayObject*',
'KPlayObjectFactory*' => 'tde_KPlayObjectFactory*',
'TDEPopupFrame*' => 'tde_TDEPopupFrame*',
'TDEPopupMenu*'  => 'tde_TDEPopupMenu*' ,
'TDEPopupTitle*' => 'tde_TDEPopupTitle*',
'KPreviewWidgetBase*' => 'tde_KPreviewWidgetBase*',
'KPrintAction*' => 'tde_KPrintAction*',
'KPrintDialogPage*' => 'tde_KPrintDialogPage*',
'KPrinter*' => 'tde_KPrinter*',
'KPrinterWrapper*' => 'tde_KPrinterWrapper*',
'KProcIO*'  =>  'tde_KProcIO*' ,
'TDEProcess&'  => 'tde_TDEProcess*' ,
'TDEProcess*'  => 'tde_TDEProcess*' ,
'TDEProcessController*' => 'tde_TDEProcessController*',
'TDEProcessRunner*' => 'tde_TDEProcessRunner*',
'KProgress*' => 'tde_KProgress*',
'KPropertiesDialog*'  => 'tde_KPropertiesDialog*' ,
'KPropsDlgPlugin*'  => 'tde_KPropsDlgPlugin*' ,
'KProtocolInfo*' => 'tde_KProtocolInfo*',
'KProtocolManager*' => 'tde_KProtocolManager*',
'KPushButton*' => 'tde_KPushButton*',
'KRFCDate*' => 'tde_KRFCDate*',
'TDERadioAction*' => 'tde_TDERadioAction*',
'KRandomSequence*' => 'tde_KRandomSequence*',
'TDERecentDocument*' => 'tde_TDERecentDocument*',
'KRegExp*' => 'tde_KRegExp*',
'KRegExpEditor*' => 'tde_KRegExpEditor*',
'KRegExpEditorInterface*' => 'tde_KRegExpEditorInterface*',
'KRestrictedLine*' => 'tde_KRestrictedLine*',
'KRootPermsIcon*' => 'tde_KRootPermsIcon*',
'KRootPixmap*' => 'tde_KRootPixmap*',
'KRootProp*' => 'tde_KRootProp*',
'KRuler*' => 'tde_KRuler*',
'KRun*' => 'tde_KRun*',
'KSSL&' => 'tde_KSSL*',
'KSSL*' => 'tde_KSSL*',
'KSSLAuthAction' => 'int',
'KSSLAuthAction*' => 'int*',
'KSSLCertBox*' => 'tde_KSSLCertBox*',
'KSSLCertChain&' => 'tde_KSSLCertChain*',
'KSSLCertChain*' => 'tde_KSSLCertChain*',
'KSSLCertDlg*' => 'tde_KSSLCertDlg*',
'KSSLCertDlgRet' => 'tde_KSSLCertDlgRet*',
'KSSLCertDlgRet*' => 'tde_KSSLCertDlgRet*',
'KSSLCertificate&' => 'tde_KSSLCertificate*',
'KSSLCertificate*' => 'tde_KSSLCertificate*',
'KSSLCertificateCache*' => 'tde_KSSLCertificateCache*',
'KSSLCertificateFactory*' => 'tde_KSSLCertificateFactory*',
'KSSLCertificateHome*' => 'tde_KSSLCertificateHome*',
'KSSLConnectionInfo&' => 'tde_KSSLConnectionInfo*',
'KSSLConnectionInfo*' => 'tde_KSSLConnectionInfo*',
'KSSLInfoDlg*' => 'tde_KSSLInfoDlg*',
'KSSLKeyGen*' => 'tde_KSSLKeyGen*',
'KSSLKeyType' => 'int',
'KSSLPKCS12*' => 'tde_KSSLPKCS12*',
'KSSLPKCS7*' => 'tde_KSSLPKCS7*',
'KSSLPeerInfo&' => 'tde_KSSLPeerInfo*',
'KSSLPeerInfo*' => 'tde_KSSLPeerInfo*',
'KSSLSettings*' => 'tde_KSSLSettings*',
'KSSLSigners*' => 'tde_KSSLSigners*',
'KSSLX509Map*' => 'tde_KSSLX509Map*',
'KSSLX509V3&' => 'tde_KSSLX509V3*',
'KSSLX509V3*' => 'tde_KSSLX509V3*',
'KSaveFile*' => 'tde_KSaveFile*',
'KScanDialog*' => 'tde_KScanDialog*',
'KScanDialogFactory*' => 'tde_KScanDialogFactory*',
'KScreenSaver*' => 'tde_KScreenSaver*',
'KScriptClientInterface*' => 'tde_KScriptClientInterface*',
'KScriptClientInterface::Result' => 'int',
'KScriptInterface*' => 'tde_KScriptInterface*',
'KScriptManager*' => 'tde_KScriptManager*',
'TDESelectAction*' => 'tde_TDESelectAction*',
'TDESelector*' => 'tde_TDESelector*',
'KSeparator*' => 'tde_KSeparator*',
'KService&'  => 'tde_KService*' ,
'KService*' => 'tde_KService*',
'KServiceGroup*' => 'tde_KServiceGroup*',
'KServiceOffer&'  => 'tde_KServiceOffer*' ,
'KServiceOffer*' => 'tde_KServiceOffer*',
'KServiceType*' => 'tde_KServiceType*',
'KServiceTypeProfile*'  =>  'tde_KServiceTypeProfile*' ,
'KSessionManaged*' => 'tde_KSessionManaged*',
'TDEShared&'  => 'tde_TDEShared*' ,
'TDEShared*' => 'tde_TDEShared*',
'TDESharedPtr&'  => 'tde_TDESharedPtr*' ,
'TDESharedPtr*' => 'tde_TDESharedPtr*',
'KShellCompletion*' => 'tde_KShellCompletion*',
'KShellProcess*' => 'tde_KShellProcess*',
'TDEShortcuts&' => 'tde_TDEShortcuts*',
'TDEShortcuts' => 'tde_TDEShortcuts*',
'TDEShortcuts*' => 'tde_TDEShortcuts*',
'KShred*' => 'tde_KShred*',
'KSimpleConfig&'  => 'tde_KSimpleConfig*' ,
'KSimpleConfig*' => 'tde_KSimpleConfig*',
'KSimpleFileFilter*' => 'tde_KSimpleFileFilter*',
'KSpell*' => 'tde_KSpell*',
'KSpellConfig&'  => 'tde_KSpellConfig*' ,
'KSpellConfig'  => 'tde_KSpellConfig*' ,
'KSpellConfig*'  => 'tde_KSpellConfig*' ,
'KSpellDlg*' => 'tde_KSpellDlg*',
'KSqueezedTextLabel*' => 'tde_KSqueezedTextLabel*',
'TDEStandardDirs*'  => 'tde_TDEStandardDirs*' ,
'TDEStartupInfo*' => 'tde_TDEStartupInfo*',
'TDEStartupInfoData&' => 'tde_TDEStartupInfoData*',
'TDEStartupInfoData*' => 'tde_TDEStartupInfoData*',
'TDEStartupInfoId&' => 'tde_TDEStartupInfoId*',
'TDEStartupInfoId' => 'tde_TDEStartupInfoId*',
'TDEStartupInfoId*' => 'tde_TDEStartupInfoId*',
'KStaticDeleter*' => 'tde_KStaticDeleter*',
'KStaticDeleterBase*'  => 'tde_KStaticDeleterBase*' ,
'KStatusBar*'  => 'tde_KStatusBar*' ,
'KStatusBar::BarStatusstat::Toggle'  =>  'int' ,
'KStatusBarLabel*' => 'tde_KStatusBarLabel*',
'TDEStdAccel*' => 'tde_TDEStdAccel*',
'TDEStdAccel::StdAccel'  => 'int' ,
'KStdAction*' => 'tde_KStdAction*',
'KStdGuiItem*' => 'tde_KStdGuiItem*',
'KStringHandler*' => 'tde_KStringHandler*',
'TDEStyle*'  => 'tde_TDEStyle*' ,
'KSycoca*'  =>  'tde_KSycoca*' ,
'KSycocaEntry*'  => 'tde_KSycocaEntry*' ,
'KSycocaFactoryId'  => 'int' ,
'KSycocaType&'  => 'int' ,
'KSycocaType'  => 'int' ,
'KSystemTray*' => 'tde_KSystemTray*',
'KTMainWindow*' => 'tde_KTMainWindow*',
'KTabButton*' => 'tde_KTabButton*',
'KTabCtl*' => 'tde_KTabCtl*',
'KTar*' => 'tde_KTar*',
'KTarBase*'  =>  'tde_KTarBase*' ,
'KTarData*' => 'tde_KTarData*',
'KTarDirectory*'  => 'tde_KTarDirectory*' ,
'KTarEntry*'  => 'tde_KTarEntry*' ,
'KTarFile*' => 'tde_KTarFile*',
'KTarGz*' => 'tde_KTarGz*',
'KTempFile*' => 'tde_KTempFile*',
'KTextBrowser*' => 'tde_KTextBrowser*',
'KTextEditor*' => 'tde_KTextEditor*',
'KTextEditor__View&'  =>  'tde_KTextEditor__View*',
'KTextEditor__View'  =>  'tde_KTextEditor__View*',
'KTextEditor__View*'  =>  'tde_KTextEditor__View*',
'KThemeBase*'  =>  'tde_KThemeBase*', ,
'KThemeCache*'  =>  'tde_KThemeCache*',
'KThemePixmap&'  => 'tde_KThemePixmap*' ,
'KThemePixmap*'  => 'tde_KThemePixmap*' ,
'KThemeStyle*' => 'tde_KThemeStyle*',
'KTipDatabase*' => 'tde_KTipDatabase*',
'KTipDialog*' => 'tde_KTipDialog*',
'TDEToggleAction*'  => 'tde_TDEToggleAction*' ,
'TDEToolBar*'  => 'tde_TDEToolBar*' ,
'TDEToolBar::BarStatus' => 'int',
'TDEToolBar::BarStatusstat::Toggle'  =>  'int' ,
'TDEToolBarButton*'  => 'tde_TDEToolBarButton*' ,
'TDEToolBarButtonList*' => 'tde_TDEToolBarButtonList*',
'TDEToolBarPopupAction*' => 'tde_TDEToolBarPopupAction*',
'TDEToolBarPos'  => 'int' ,
'TDEToolBarRadioGroup*' => 'tde_TDEToolBarRadioGroup*',
'TDEToolBarSeparator*' => 'tde_TDEToolBarSeparator*',
'TDEToolButtonType'  => 'int' ,
'TDETrader*'  =>  'tde_TDETrader*' ,
'KTypeList*' => 'tde_KTypeList*',
'KURIFilter*'  =>  'tde_KURIFilter*' ,
'KURIFilterData&'  => 'tde_KURIFilterData*' ,
'KURIFilterData*' => 'tde_KURIFilterData*',
'KURIFilterPlugin*' => 'tde_KURIFilterPlugin*',
'KURIFilterPluginList*' => 'tde_KURIFilterPluginList*',
'KURL& url ()' => 'tde_KURL*',
'KURL& urlName ()' => 'tde_KURL*',
'KURL&'  => 'tde_KURL*' ,
'KURL'  => 'tde_KURL*' ,
'KURL*' => 'tde_KURL*',
'KURL::List&'  => 'tde_KURLList*' ,
'KURL::List'  => 'tde_KURLList*' ,
'KURL::List*'  => 'tde_KURLList*' ,
'List&'  => 'tde_KURLList*' ,
'List'  => 'tde_KURLList*' ,
'List*'  => 'tde_KURLList*' ,
'KURLComboBox*' => 'tde_KURLComboBox*',
'KURLComboItem*'  => 'tde_KURLComboItem*' ,
'KURLCompletion*' => 'tde_KURLCompletion*',
'KURLDrag*' => 'tde_KURLDrag*',
'KURLLabel*' => 'tde_KURLLabel*',
'KURLPixmapProvider*' => 'tde_KURLPixmapProvider*',
'KURLPropsPlugin*' => 'tde_KURLPropsPlugin*',
'KURLRequester*' => 'tde_KURLRequester*',
'KURLRequesterDlg*' => 'tde_KURLRequesterDlg*',
'KUniqueApplication*' => 'tde_KUniqueApplication*',
'KUnixSocketAddress*' => 'tde_KUnixSocketAddress*',
'KValueSelector*' => 'tde_KValueSelector*',
'KWin*' => 'tde_KWin*',
'KWinModule*' => 'tde_KWinModule*',
'KWindowListMenu*' => 'tde_KWindowListMenu*',
'KWizard*' => 'tde_KWizard*',
'KWordWrap*' => 'tde_KWordWrap*',
'KWritePermsIcon*' => 'tde_KWritePermsIcon*',
'KXMLGUIBuilder*'  =>  'tde_KXMLGUIBuilder*' ,
'KXMLGUIClient*'  => 'tde_KXMLGUIClient*' ,
'KXMLGUIFactory*'  => 'tde_KXMLGUIFactory*' ,
'KXMessages*' => 'tde_KXMessages*',
'KXYSelector*' => 'tde_KXYSelector*',
'TDEZoneAllocator*' => 'tde_TDEZoneAllocator*',
'KabAPI*' => 'tde_KabAPI*',
'KabKey&'  => 'tde_KabKey*' ,
'KabKey'  => 'tde_KabKey*' ,
'KabKey*' => 'tde_KabKey*',
'Key&'  =>  'Key*' ,
'KeyBindingMap'  => 'tde_KeyBindingMap*' ,
'KeyValueMap&'  => 'tde_KeyValueMap*' ,
'KeyValueMap*&'  => 'tde_KeyValueMap*' ,
'KeyValueMap*'  => 'tde_KeyValueMap*' ,
'Keymap*' => 'tde_Keymap*',
'LinkStyle&' => 'tde_LinkStyle*',
'LinkStyle*' => 'tde_LinkStyle*',
'ListIterator&' => 'tde_ListIterator*',
'ListIterator' => 'tde_ListIterator',
'ListIterator*' => 'tde_ListIterator*',
'ListJob*' => 'tde_ListJob*',
'ListNode*' => 'tde_ListNode*',
'ListProgress*' => 'tde_ListProgress*',
'Lookup*' => 'tde_Lookup*',
'MCOPConfig*' => 'tde_MCOPConfig*',
'MCOPUtils*' => 'tde_MCOPUtils*',
'MailServer&'  =>  'MailServer*' ,
'MailServer*' => 'tde_MailServer*',
'MainWindow*' => 'tde_MainWindow*',
'Mark*' => 'tde_Mark*',
'MarkInterface*' => 'tde_MarkInterface*',
'MediaAsyncStream*' => 'tde_MediaAsyncStream*',
'MediaDataPacket*' => 'tde_MediaDataPacket*',
'MediaFrame*' => 'tde_MediaFrame*',
'MediaList&' => 'tde_MediaList*',
'MediaList' => 'tde_MediaList*',
'MediaList*' => 'tde_MediaList*',
'MediaListImpl*' => 'tde_MediaListImpl*',
'MediaModule&' => 'tde_MediaModule*',
'MediaModule' => 'tde_MediaModule*',
'MediaModule*' => 'tde_MediaModule*',
'MediaModule_base*' => 'tde_MediaModule_base*',
'MediaModule_skel*' => 'tde_MediaModule_skel*',
'MediaModule_stub*' => 'tde_MediaModule_stub*',
'MenuDockData*' => 'tde_MenuDockData*',
'MethodDef&' => 'tde_MethodDef*',
'MethodDef*' => 'tde_MethodDef*',
'MidiEvent*' => 'tde_MidiEvent*',
'MidiFileInfo*' => 'tde_MidiFileInfo*',
'MidiMapper*' => 'tde_MidiMapper*',
'MidiOut*' => 'tde_MidiOut*',
'MidiPlayer*' => 'tde_MidiPlayer*',
'MidiStatus*' => 'tde_MidiStatus*',
'MidiTrack*' => 'tde_MidiTrack*',
'MimetypeJob*' => 'tde_MimetypeJob*',
'Mode' => 'int',
'ModuleDef&' => 'tde_ModuleDef*',
'ModuleDef*' => 'tde_ModuleDef*',
'MouseDoubleClickEvent*' => 'tde_MouseDoubleClickEvent*',
'MouseEvent*' => 'tde_MouseEvent*',
'MouseMoveEvent*' => 'tde_MouseMoveEvent*',
'MousePressEvent*' => 'tde_MousePressEvent*',
'MouseReleaseEvent*' => 'tde_MouseReleaseEvent*',
'MultiGetJob*' => 'tde_MultiGetJob*',
'MultiPort*' => 'tde_MultiPort*',
'NET*' => 'tde_NET*',
'NET::WindowType'  =>  'int' ,
'NETIcon'  =>  'kdeNETIcon*' ,
'NETIcon*' => 'tde_NETIcon*',
'NETPoint&'  =>  'tde_NETPoint*' ,
'NETPoint'  =>  'tde_NETPoint*' ,
'NETPoint*' => 'tde_NETPoint*',
'NETRect&'  =>  'tde_NETRect*' ,
'NETRect'  =>  'tde_NETRect*' ,
'NETRect*' => 'tde_NETRect*',
'NETRootInfo&'  =>  'tde_NETRootInfo*' ,
'NETRootInfo*' => 'tde_NETRootInfo*',
'NETRootInfoPrivate*' => 'tde_NETRootInfoPrivate*',
'NETSize&'  =>  'tde_NETSize*' ,
'NETSize'  =>  'tde_NETSize*' ,
'NETSize*' => 'tde_NETSize*',
'NETStrut'  =>  'tde_NETStrut*' ,
'NETStrut*' => 'tde_NETStrut*',
'NETWinInfo&'  =>  'tde_NETWinInfo*' ,
'NETWinInfo*' => 'tde_NETWinInfo*',
'NETWinInfoPrivate*' => 'tde_NETWinInfoPrivate*',
'NamedNodeMap&' => 'tde_NamedNodeMap*',
'NamedNodeMap' => 'tde_NamedNodeMap*',
'NamedNodeMap*' => 'tde_NamedNodeMap*',
'NamedNodeMapImpl*' => 'tde_NamedNodeMapImpl*',
'NetAccess*' => 'tde_NetAccess*',
'NetRC*' => 'tde_NetRC*',
'Node&' => 'tde_Node*',
'Node' => 'tde_Node*',
'Node*' => 'tde_Node*',
'NodeFilter&' => 'tde_NodeFilter*',
'NodeFilter' => 'tde_NodeFilter*',
'NodeFilter*' => 'tde_NodeFilter*',
'NodeFilterImpl*' => 'tde_NodeFilterImpl*',
'NodeImpl*' => 'tde_NodeImpl*',
'NodeIterator&' => 'tde_NodeIterator*',
'NodeIterator' => 'tde_NodeIterator*',
'NodeIterator*' => 'tde_NodeIterator*',
'NodeIteratorImpl*' => 'tde_NodeIteratorImpl*',
'NodeList&' => 'tde_DOMNodeList*',
'NodeList' => 'tde_DOMNodeList*',
'NodeList*' => 'tde_DOMNodeList*',
'NodeListImpl*' => 'tde_NodeListImpl*',
'NodePtr'  =>  'int' ,
'NodeType'  =>  'int' ,
'Notation&' => 'tde_Notation*',
'Notation*' => 'tde_Notation*',
'NoteArray*' => 'tde_NoteArray*',
'Notification&' => 'tde_Notification*',
'Notification' => 'tde_Notification*',
'Notification*' => 'tde_Notification*',
'NotificationClient*' => 'tde_NotificationClient*',
'NotificationManager*' => 'tde_NotificationManager*',
'Null*' => 'null',
'Number&' => 'tde_Number*',
'Number*' => 'tde_Number*',
'Object&' => 'tde_Object*',
'Object' => 'tde_Object*',
'Object*' => 'tde_Object*',
'ObjectImp*' => 'tde_ObjectImp*',
'ObjectManager*' => 'tde_ObjectManager*',
'ObjectReference&' => 'tde_ObjectReference*',
'ObjectReference*' => 'tde_ObjectReference*',
'Object_base*' => 'tde_Object_base*',
'Object_skel*' => 'tde_Object_skel*',
'Object_stub*' => 'tde_Object_stub*',
'Observer*' => 'tde_Observer*',
'OfferList'  =>  'tde_OfferList*' ,
'TDETrader::OfferList'  =>  'tde_OfferList*' ,
'Offset' => 'int',
'OnewayDispatchFunction' => 'tde_OnewayDispatchFunction*',
'OnewayInvocation&' => 'tde_OnewayInvocation*',
'OnewayInvocation*' => 'tde_OnewayInvocation*',
'OpenURLEvent*' => 'tde_OpenURLEvent*',
'Orientation' => 'int',
'PFlags' => 'int',
'PIAccess' => 'int',
'PID' => 'long',
'PIType' => 'int',
'PTY*' => 'tde_PTY*',
'PageSize' => 'int',
'ParamDef&' => 'tde_ParamDef*',
'ParamDef*' => 'tde_ParamDef*',
'ParsedArgument*' => 'tde_ParsedArgument*',
'ParsedAttribute*' => 'tde_ParsedAttribute*',
'ParsedClass&' => 'tde_ParsedClass&',
'ParsedClass*' => 'tde_ParsedClass*',
'ParsedClassContainer*' => 'tde_ParsedClassContainer*',
'ParsedContainer*' => 'tde_ParsedContainer*',
'ParsedItem*' => 'tde_ParsedItem*',
'ParsedMethod*' => 'tde_ParsedMethod*',
'ParsedParent*' => 'tde_ParsedParent*',
'ParsedScopeContainer*' => 'tde_ParsedScopeContainer*',
'ParsedSignalSlot*' => 'tde_ParsedSignalSlot*',
'ParsedStruct*' => 'tde_ParsedStruct*',
'Part*' => 'tde_Part*',
'PartActivateEvent*' => 'tde_PartActivateEvent*',
'PartBase*' => 'tde_PartBase*',
'PartSelectEvent*' => 'tde_PartSelectEvent*',
'PassDlg*' => 'tde_PassDlg*',
'PasswordDialog*' => 'tde_PasswordDialog*',
'PenCapStyle'  =>  'int' ,
'PenJoinStyle'  =>  'int' ,
'PenStyle' => 'int',
'PersistantClassStore*' => 'tde_PersistantClassStore*',
'PhoneNumber&' => 'tde_PhoneNumber*',
'PhoneNumber*' => 'tde_PhoneNumber*',
'PipeBuffer*' => 'tde_PipeBuffer*',
'PipeSegment*' => 'tde_PipeSegment*',
'Pix&'  =>  'tde_Pix*' ,
'Pix'  =>  'tde_Pix*' ,
'PixelMetric' => 'int',
'PlayObject&' => 'tde_PlayObject*',
'PlayObject' => 'tde_PlayObject*',
'PlayObject*' => 'tde_PlayObject*',
'PlayObjectFactory&' => 'tde_PlayObjectFactory*',
'PlayObjectFactory' => 'tde_PlayObjectFactory',
'PlayObjectFactory*' => 'tde_PlayObjectFactory*',
'PlayObjectFactory_base*' => 'tde_PlayObjectFactory_base*',
'PlayObjectFactory_skel*' => 'tde_PlayObjectFactory_skel*',
'PlayObjectFactory_stub*' => 'tde_PlayObjectFactory_stub*',
'PlayObject_base*' => 'tde_PlayObject_base*',
'PlayObject_private&' => 'tde_PlayObject_private*',
'PlayObject_private' => 'tde_PlayObject_private',
'PlayObject_private*' => 'tde_PlayObject_private*',
'PlayObject_private_base*' => 'tde_PlayObject_private_base*',
'PlayObject_private_skel*' => 'tde_PlayObject_private_skel*',
'PlayObject_private_stub*' => 'tde_PlayObject_private_stub*',
'PlayObject_skel*' => 'tde_PlayObject_skel*',
'PlayObject_stub*' => 'tde_PlayObject_stub*',
'PlayerController*' => 'tde_PlayerController*',
'Plugin*' => 'tde_Plugin*',
'PluginInfo*' => 'tde_PluginInfo*',
'Policy' => 'int',
'Pool&' => 'tde_Pool*',
'Pool*' => 'tde_Pool*',
'PopupMenuInterface*' => 'tde_PopupMenuInterface*',
'Port*' => 'tde_Port*',
'PreviewJob*' => 'tde_PreviewJob*',
'PrimitiveElement' => 'int',
'PrintInterface*' => 'tde_PrintInterface*',
'PrinterMode' => 'int',
'ProcessingInstruction&' => 'tde_ProcessingInstruction*',
'ProcessingInstruction' => 'tde_ProcessingInstruction*',
'ProcessingInstruction*' => 'tde_ProcessingInstruction*',
'ProgressBase*' => 'tde_ProgressBase*',
'ProgressItem*' => 'tde_ProgressItem*',
'PropagationMode' => 'int',
'ProtocolInfo*' => 'tde_ProtocolInfo*',
'Ptr' => 'void*',
'PtyProcess*' => 'tde_PtyProcess*',
'TQAccel*' => 'qt_QAccel*',
'TQAccessible*' => 'qt_QAccessible*',
'TQAccessibleFactoryInterface*' => 'qt_QAccessibleFactoryInterface*',
'TQAccessibleInterface*' => 'qt_QAccessibleInterface*',
'TQAccessibleInterface**' => 'qt_QAccessibleInterface**',
'TQAccessibleObject*' => 'qt_QAccessibleObject*',
'TQAction*'  =>  'qt_QAction*' ,
'TQActionGroup*' => 'qt_QActionGroup*',
'TQApplication*'  => 'qt_QApplication*' ,
'TQArabicCodec*' => 'qt_QArabicCodec*',
'TQArray*' => 'qt_QArray*',
'TQAsciiBucket*' => 'qt_QAsciiBucket*',
'TQAsciiCache*' => 'qt_QAsciiCache*',
'TQAsciiCacheIterator*' => 'qt_QAsciiCacheIterator*',
'TQAsciiDict*' => 'qt_QAsciiDict*',
'TQAsciiDictIterator*' => 'qt_QAsciiDictIterator*',
'TQAsyncIO*' => 'qt_QAsyncIO*',
'TQAuBucket*'  =>  'qt_QAuBucket*' ,
'TQAuServer*' => 'qt_QAuServer*',
'TQBaseBucket*'  =>  'qt_QBaseBucket*' ,
'TQBig5Codec*' => 'qt_QBig5Codec*',
'TQBitArray&'  => 'qt_QBitArray*' ,
'TQBitArray'  => 'qt_QBitArray*' ,
'TQBitArray*'  =>  'qt_QBitArray*' ,
'TQBitVal&'  => 'qt_QBitVal*' ,
'TQBitVal'  => 'qt_QBitVal*' ,
'TQBitVal*' => 'qt_QBitVal*',
'TQBitmap&' => 'qt_QBitmap*',
'TQBitmap' => 'qt_QBitmap*',
'TQBitmap*' => 'qt_QBitmap*',
'TQBoxLayout*' => 'qt_QBoxLayout*',
'TQBrush&' => 'qt_QBrush*',
'TQBrush'  =>  'qt_QBrush*' ,
'TQBrush*'  => 'qt_QBrush*' ,
'TQBrushData*' => 'qt_QBrushData*',
'TQBuffer*' => 'qt_QBuffer*',
'TQButton*' => 'qt_QButton*',
'TQButtonGroup*'  =>  'qt_QButtonGroup*' ,
'TQByteArray& arr ()' => 'qt_QByteArray*',
'TQByteArray&'  => 'qt_QByteArray*' ,
'TQByteArray' => 'qt_QByteArray*',
'TQByteArray*' => 'qt_QByteArray*',
'TQCDEStyle*' => 'qt_QCDEStyle*',
'TQCOORD&' => 'short',
'TQCOORD' => 'short',
'TQCOORD*' => 'short*',
'TQCString&'  =>  'qt_QCString*' ,
'TQCString'  =>  'qt_QCString*' ,
'TQCString*'  =>  'qt_QCString*' ,
'TQCStringLess*'  =>  'qt_QCStringLess*' ,
'QCStringList'  => 'tde_QCStringList*' ,
'TQCache*' => 'qt_QCache*',
'TQCacheIterator*' => 'qt_QCacheIterator*',
'TQCanvas*'  =>  'qt_QCanvas*' ,
'TQCanvasEllipse*' => 'qt_QCanvasEllipse*',
'TQCanvasItem*'  =>  'qt_QCanvasItem*' ,
'TQCanvasItemList'  =>  'qt_QCanvasItemList*' ,
'TQCanvasItemList*' => 'qt_QCanvasItemList*',
'TQCanvasLine*' => 'qt_QCanvasLine*',
'TQCanvasPixmap*'  =>  'qt_QCanvasPixmap*' ,
'TQCanvasPixmapArray*'  =>  'qt_QCanvasPixmapArray*' ,
'TQCanvasPolygon*' => 'qt_QCanvasPolygon*',
'TQCanvasPolygonalItem*' => 'qt_QCanvasPolygonalItem*',
'TQCanvasRectangle*' => 'qt_QCanvasRectangle*',
'TQCanvasSpline*' => 'qt_QCanvasSpline*',
'TQCanvasSprite*' => 'qt_QCanvasSprite*',
'TQCanvasText*' => 'qt_QCanvasText*',
'TQCanvasView*'  =>  'qt_QCanvasView*' ,
'TQChain*'  => 'qt_QChain*' ,
'TQChar::Category'  =>  'int' ,
'TQChar::Decomposition'  =>  'int' ,
'TQChar::Direction'  =>  'int' ,
'TQChar::Joining'  =>  'int' ,
'TQCharRef&'  =>  'qt_QCharRef*' ,
'TQCharRef'  =>  'qt_QCharRef*' ,
'TQCharRef*' => 'qt_QCharRef*',
'TQCheckBox*' => 'qt_QCheckBox*',
'TQCheckListItem*' => 'qt_QCheckListItem*',
'TQCheckTableItem*' => 'qt_QCheckTableItem*',
'TQChildEvent*'  => 'qt_QChildEvent*' ,
'TQClassInfo*'  =>  'qt_QClassInfo*' ,
'TQCleanupHandler*' => 'qt_QCleanupHandler*',
'TQClipboard*' => 'qt_QClipboard*',
'TQCloseEvent*'  => 'qt_QCloseEvent*' ,
'TQCollection&'  => 'qt_QCollection*' ,
'TQCollection*' => 'qt_QCollection*',
'TQCollection::Item&'  =>  'void*' ,
'TQCollection::Item'  =>  'void*' ,
'TQColor &' => 'qt_QColor*',
'TQColor&' => 'qt_QColor*',
'TQColor&fillColor::white'  =>  'int' ,
'TQColor&linkColor::blue'  =>  'int' ,
'TQColor' => 'qt_QColor*',
'TQColor*'  => 'qt_QColor*' ,
'TQColorDialog*' => 'qt_QColorDialog*',
'TQColorDrag*' => 'qt_QColorDrag*',
'TQColorGroup&' => 'qt_QColorGroup*',
'TQColorGroup'  =>  'qt_QColorGroup*' ,
'TQColorGroup*'  => 'qt_QColorGroup*' ,
'TQColorGroup::ColorRole'  => 'int' ,
'TQComboBox*'  =>  'qt_QComboBox*' ,
'TQComboBox::Policy'  => 'int' ,
'TQComboBox::Policypolicy::AtBottom'  => 'int' ,
'TQComboTableItem*' => 'qt_QComboTableItem*',
'TQCommonStyle*' => 'qt_QCommonStyle*',
'TQCompactStyle*' => 'qt_QCompactStyle*',
'TQComponentFactory*' => 'qt_QComponentFactory*',
'TQComponentFactoryInterface*' => 'qt_QComponentFactoryInterface*',
'TQComponentInterface*' => 'qt_QComponentInterface*',
'TQComponentRegistration*' => 'qt_QComponentRegistration*',
'TQComponentServerInterface*' => 'qt_QComponentServerInterface*',
'TQConfigDB*'  =>  'qt_QConfigDB*' ,
'TQConfigDB*'  => 'qt_QConfigDB*' ,
'TQConnection*' => 'qt_QConnection*',
'TQConnectionList&'  => 'qt_QConnectionList*' ,
'TQConnectionList*'  =>  'qt_QConnectionList*' ,
'TQConnectionListIt&'  => 'qt_QConnectionListIt*' ,
'TQConnectionListIt*' => 'qt_QConnectionListIt*',
'TQConstString' => 'qt_QConstString*',
'TQConstString*' => 'qt_QConstString*',
'TQContextMenuEvent*' => 'qt_QContextMenuEvent*',
'TQCursor&' => 'qt_QCursor*',
'TQCursor'  =>  'qt_QCursor*' ,
'TQCursor*' => 'qt_QCursor*',
'TQCustomEvent*'  =>  'qt_QCustomEvent*' ,
'TQCustomMenuItem*'  =>  'qt_QCustomMenuItem*' ,
'TQDOM_NodeListPrivate*'  =>  'void*' ,
'TQDOM_NodePrivate*'  =>  'void*' ,
'TQDataBrowser*' => 'qt_QDataBrowser*',
'TQDataPump*' => 'qt_QDataPump*',
'TQDataSink*'  => 'qt_QDataSink*' ,
'TQDataSource*'  => 'qt_QDataSource*' ,
'TQDataStream&' => 'qt_QDataStream*',
'TQDataStream*'  => 'qt_QDataStream*' ,
'TQDataTable*' => 'qt_QDataTable*',
'TQDataView*' => 'qt_QDataView*',
'TQDate &' => 'qt_QDate*',
'TQDate date()' => 'qt_QDate*',
'TQDate&' => 'qt_QDate*',
'TQDate' => 'qt_QDate*',
'TQDate*' => 'qt_QDate*',
'TQDateEdit*' => 'qt_QDateEdit*',
'TQDateTime&' => 'qt_QDateTime*',
'TQDateTime' => 'qt_QDateTime*',
'TQDateTime*'  => 'qt_QDateTime*' ,
'TQDateTimeEdit*' => 'qt_QDateTimeEdit*',
'TQDateTimeEditBase*' => 'qt_QDateTimeEditBase*',
'TQDesktopWidget*' => 'qt_QDesktopWidget*',
'TQDial*' => 'qt_QDial*',
'TQDialog*' => 'qt_QDialog*',
'TQDict*' => 'qt_QDict*',
'TQDictIterator*' => 'qt_QDictIterator*',
'TQDir&' => 'qt_QDir*',
'TQDir' => 'qt_QDir*',
'TQDir*' => 'qt_QDir*',
'TQDir::SortSpec&'  => 'int' ,
'TQDir::SortSpec'  => 'int' ,
'TQDirSortItem*' => 'qt_QDirSortItem*',
'TQDiskFont*' => 'qt_QDiskFont*',
'TQDispatchInterface*' => 'qt_QDispatchInterface*',
'TQDns*' => 'qt_QDns*',
'TQDnsSocket*' => 'qt_QDnsSocket*',
'TQDockArea*' => 'qt_QDockArea*',
'TQDockAreaLayout*' => 'qt_QDockAreaLayout*',
'TQDockWindow*' => 'qt_QDockWindow*',
'TQDomAttr&'  =>  'qt_QDomAttr*' ,
'TQDomAttr'  =>  'qt_QDomAttr*' ,
'TQDomAttr*' => 'qt_QDomAttr*',
'TQDomCDATASection&'  =>  'qt_QDomCDATASection*' ,
'TQDomCDATASection'  =>  'qt_QDomCDATASection*' ,
'TQDomCDATASection*' => 'qt_QDomCDATASection*',
'TQDomCharacterData&'  =>  'qt_QDomCharacterData*' ,
'TQDomCharacterData'  =>  'qt_QDomCharacterData*' ,
'TQDomCharacterData*' => 'qt_QDomCharacterData*',
'TQDomComment&'  =>  'qt_QDomComment*' ,
'TQDomComment'  =>  'qt_QDomComment*' ,
'TQDomComment*' => 'qt_QDomComment*',
'TQDomDocument&'  =>  'qt_QDomDocument*' ,
'TQDomDocument'  =>  'qt_QDomDocument*' ,
'TQDomDocument*' => 'qt_QDomDocument*',
'TQDomDocumentFragment&'  =>  'qt_QDomDocumentFragment*' ,
'TQDomDocumentFragment'  =>  'qt_QDomDocumentFragment*' ,
'TQDomDocumentFragment*' => 'qt_QDomDocumentFragment*',
'TQDomDocumentType&'  =>  'qt_QDomDocumentType*' ,
'TQDomDocumentType'  =>  'qt_QDomDocumentType*' ,
'TQDomDocumentType*' => 'qt_QDomDocumentType*',
'TQDomElement&'  =>  'qt_QDomElement*' ,
'TQDomElement'  =>  'qt_QDomElement*' ,
'TQDomElement*' => 'qt_QDomElement*',
'TQDomEntity&'  =>  'qt_QDomEntity*' ,
'TQDomEntity'  =>  'qt_QDomEntity*' ,
'TQDomEntity*' => 'qt_QDomEntity*',
'TQDomEntityReference&'  =>  'qt_QDomEntityReference*' ,
'TQDomEntityReference'  =>  'qt_QDomEntityReference*' ,
'TQDomEntityReference*' => 'qt_QDomEntityReference*',
'TQDomImplementation&'  =>  'qt_QDomImplementation*' ,
'TQDomImplementation'  =>  'qt_QDomImplementation*' ,
'TQDomImplementation*' => 'qt_QDomImplementation*',
'TQDomNamedNodeMap&'  =>  'qt_QDomNamedNodeMap*' ,
'TQDomNamedNodeMap'  =>  'qt_QDomNamedNodeMap*' ,
'TQDomNamedNodeMap*' => 'qt_QDomNamedNodeMap*',
'TQDomNode&'  =>  'qt_QDomNode*' ,
'TQDomNode'  =>  'qt_QDomNode*' ,
'TQDomNode*' => 'qt_QDomNode*',
'TQDomNode::NodeType' => 'int',
'TQDomNodeList&'  =>  'qt_QDomNodeList*' ,
'TQDomNodeList'  =>  'qt_QDomNodeList*' ,
'TQDomNodeList*' => 'qt_QDomNodeList*',
'TQDomNodePrivate*' => 'qt_QDomNodePrivate*',
'TQDomNotation&'  =>  'qt_QDomNotation*' ,
'TQDomNotation'  =>  'qt_QDomNotation*' ,
'TQDomNotation*' => 'qt_QDomNotation*',
'TQDomProcessingInstruction&'  =>  'qt_QDomProcessingInstruction*' ,
'TQDomProcessingInstruction'  =>  'qt_QDomProcessingInstruction*' ,
'TQDomProcessingInstruction*' => 'qt_QDomProcessingInstruction*',
'TQDomText&'  =>  'qt_QDomText*' ,
'TQDomText'  =>  'qt_QDomText*' ,
'TQDomText*' => 'qt_QDomText*',
'TQDoubleValidator*' => 'qt_QDoubleValidator*',
'TQDragEnterEvent*'  => 'qt_QDragEnterEvent*' ,
'TQDragLeaveEvent*'  => 'qt_QDragLeaveEvent*' ,
'TQDragManager*' => 'qt_QDragManager*',
'TQDragMoveEvent*'  => 'qt_QDragMoveEvent*' ,
'TQDragObject*'  => 'qt_QDragObject*' ,
'TQDragResponseEvent*' => 'qt_QDragResponseEvent*',
'TQDropEvent*'  => 'qt_QDropEvent*' ,
'TQDropSite*' => 'qt_QDropSite*',
'TQEditorFactory*' => 'qt_QEditorFactory*',
'TQErrorMessage*' => 'qt_QErrorMessage*',
'TQEucJpCodec*' => 'qt_QEucJpCodec*',
'TQEucKrCodec*' => 'qt_QEucKrCodec*',
'TQEvent*' => 'qt_QEvent*',
'TQEventLoop::ProcessEventsFlags' => 'uint',
'TQFeatureListInterface*' => 'qt_QFeatureListInterface*',
'TQFile&' => 'qt_QFile*',
'TQFile*'  => 'qt_QFile*' ,
'TQFileDialog*' => 'qt_QFileDialog*',
'TQFileIconProvider*'  => 'qt_QFileIconProvider*' ,
'TQFileInfo&' => 'qt_QFileInfo*',
'TQFileInfo*' => 'qt_QFileInfo*',
'TQFileInfoList*'  => 'qt_QFileInfoList*' ,
'TQFilePreview*'  =>  'qt_QFilePreview*' ,
'TQFocusData*'  =>  'qt_QFocusData*' ,
'TQFocusEvent*'  => 'qt_QFocusEvent*' ,
'TQFont&' => 'qt_QFont*',
'TQFont' => 'qt_QFont*',
'TQFont*' => 'qt_QFont*',
'TQFont::CharSet' => 'int',
'TQFont::CharSetcharset::Unicode'  => 'int' ,
'TQFont::StyleHint' => 'int',
'TQFontData&'  => 'qt_QFontData*' ,
'TQFontDatabase*' => 'qt_QFontDatabase*',
'TQFontDialog*' => 'qt_QFontDialog*',
'TQFontInfo&' => 'qt_QFontInfo*',
'TQFontInfo' => 'qt_QFontInfo*',
'TQFontInfo*' => 'qt_QFontInfo*',
'TQFontMetrics&' => 'qt_QFontMetrics*',
'TQFontMetrics' => 'qt_QFontMetrics*',
'TQFontMetrics*' => 'qt_QFontMetrics*',
'TQFrame*'  => 'qt_QFrame*' ,
'TQFtp*' => 'qt_QFtp*',
'TQGArray&'  => 'qt_QGArray*' ,
'TQGArray*' => 'qt_QGArray*',
'TQGCache&'  => 'qt_QGCache*' ,
'TQGCache*' => 'qt_QGCache*',
'TQGCacheIterator&'  => 'qt_QGCacheIterator*' ,
'TQGCacheIterator*' => 'qt_QGCacheIterator*',
'TQGDict&'  => 'qt_QGDict*' ,
'TQGDict*' => 'qt_QGDict*',
'TQGDictIterator&'  => 'qt_QGDictIterator*' ,
'TQGDictIterator*' => 'qt_QGDictIterator*',
'TQGL*' => 'qt_QGL*',
'TQGLColormap&' => 'qt_QGLColormap*',
'TQGLColormap*' => 'qt_QGLColormap*',
'TQGLContext*'  =>  'qt_QGLContext*' ,
'TQGLFormat&'  =>  'qt_QGLFormat*' ,
'TQGLFormat'  =>  'qt_QGLFormat*' ,
'TQGLFormat*' => 'qt_QGLFormat*',
'TQGLWidget*'  =>  'qt_QGLWidget*' ,
'TQGLayoutIterator*'  =>  'qt_QGLayoutIterator*' ,
'TQGListIterator&'  => 'qt_QGListIterator*' ,
'TQGListIterator*' => 'qt_QGListIterator*',
'TQGPlugin*' => 'qt_QGPlugin*',
'TQGPluginManager*' => 'qt_QGPluginManager*',
'TQGbkCodec*' => 'qt_QGbkCodec*',
'TQGfx*'  =>  'qt_QGfx*' ,
'TQGrid*'  => 'qt_QGrid*' ,
'TQGrid::Direction'  => 'int' ,
'TQGridLayout*' => 'qt_QGridLayout*',
'TQGridView*' => 'qt_QGridView*',
'TQGroupBox*' => 'qt_QGroupBox*',
'TQGuardedPtr*' => 'qt_QGuardedPtr*',
'TQGuardedPtrPrivate*' => 'qt_QGuardedPtrPrivate*',
'TQHBox*'  => 'qt_QHBox*' ,
'TQHBoxLayout*'  =>  'qt_QHBoxLayout*' ,
'TQHButtonGroup*' => 'qt_QHButtonGroup*',
'TQHGroupBox*' => 'qt_QHGroupBox*',
'TQHeader*' => 'qt_QHeader*',
'TQHebrewCodec*' => 'qt_QHebrewCodec*',
'TQHideEvent*'  => 'qt_QHideEvent*' ,
'TQHostAddress&'  =>  'qt_QHostAddress*' ,
'TQHostAddress'  =>  'qt_QHostAddress*' ,
'TQHostAddress*'  =>  'qt_QHostAddress*' ,
'TQHttp*' => 'qt_QHttp*',
'TQIMEvent*' => 'qt_QIMEvent*',
'TQIODevice*' => 'qt_QIODevice*',
'TQIODevice::Offset' => 'int',
'TQIODeviceSource*' => 'qt_QIODeviceSource*',
'TQIOManager*' => 'qt_QIOManager*',
'TQIOWatch*' => 'qt_QIOWatch*',
'TQIconDrag*' => 'qt_QIconDrag*',
'TQIconDragItem&'  =>  'qt_QIconDragItem*' ,
'TQIconDragItem*' => 'qt_QIconDragItem*',
'TQIconSet&'  => 'qt_QIconSet*' ,
'TQIconSet'  => 'qt_QIconSet*' ,
'TQIconSet*'  =>  'qt_QIconSet*' ,
'TQIconView*'  => 'qt_QIconView*' ,
'TQIconViewItem*'  =>  'qt_QIconViewItem*' ,
'TQImage&' => 'qt_QImage*',
'TQImage' => 'qt_QImage*',
'TQImage*'  => 'qt_QImage*' ,
'TQImageConsumer*'  =>  'qt_QImageConsumer*' ,
'TQImageData*' => 'qt_QImageData*',
'TQImageDecoder*' => 'qt_QImageDecoder*',
'TQImageDrag*' => 'qt_QImageDrag*',
'TQImageFormat*'  =>  'qt_QImageFormat*' ,
'TQImageFormatInterface*' => 'qt_QImageFormatInterface*',
'TQImageFormatPlugin*' => 'qt_QImageFormatPlugin*',
'TQImageFormatType*'  => 'qt_QImageFormatType*' ,
'TQImageIO*' => 'qt_QImageIO*',
'TQImageTextKeyLang&'  =>  'qt_QImageTextKeyLang*' ,
'TQImageTextKeyLang*' => 'qt_QImageTextKeyLang*',
'TQInputDialog*' => 'qt_QInputDialog*',
'TQIntBucket*' => 'qt_QIntBucket*',
'TQIntCache*' => 'qt_QIntCache*',
'TQIntCacheIterator*' => 'qt_QIntCacheIterator*',
'TQIntDict*' => 'qt_QIntDict*',
'TQIntDictIterator*' => 'qt_QIntDictIterator*',
'TQIntValidator*' => 'qt_QIntValidator*',
'TQInterfaceListInterface*' => 'qt_QInterfaceListInterface*',
'TQInterfacePtr*' => 'qt_QInterfacePtr*',
'TQInterlaceStyle*' => 'qt_QInterlaceStyle*',
'TQInternal*' => 'qt_QInternal*',
'TQJisCodec*' => 'qt_QJisCodec*',
'TQJpUnicodeConv*'  =>  'qt_QJpUnicodeConv*' ,
'TQKeyEvent*'  => 'qt_QKeyEvent*' ,
'TQKeySequence&' => 'qt_QKeySequence*',
'TQKeySequence' => 'qt_QKeySequence*',
'TQKeySequence*' => 'qt_QKeySequence*',
'TQKoi8Codec*' => 'qt_QKoi8Codec*',
'TQLCDNumber*' => 'qt_QLCDNumber*',
'TQLNode*'  => 'qt_QLNode*' ,
'TQLabel*' => 'qt_QLabel*',
'TQLayout*' => 'qt_QLayout*',
'TQLayoutItem*'  =>  'qt_QLayoutItem*' ,
'TQLayoutIterator&'  =>  'qt_QLayoutIterator*' ,
'TQLayoutIterator'  =>  'qt_QLayoutIterator*' ,
'TQLayoutIterator*' => 'qt_QLayoutIterator*',
'TQLibrary*' => 'qt_QLibrary*',
'TQLibrary::Policy' => 'int',
'TQLibraryInterface*' => 'qt_QLibraryInterface*',
'TQLineEdit*'  =>  'qt_QLineEdit*' ,
'TQLineEdit::EchoMode'  =>  'int' ,
'TQList*' => 'qt_QList*',
'TQListBox*' => 'qt_QListBox*',
'TQListBoxItem*' => 'qt_QListBoxItem*',
'TQListBoxPixmap*' => 'qt_QListBoxPixmap*',
'TQListBoxText*' => 'qt_QListBoxText*',
'TQListIterator*' => 'qt_QListIterator*',
'TQListView*' => 'qt_QListView*',
'TQListViewItem*&' => 'qt_QListViewItem*',
'TQListViewItem*' => 'qt_QListViewItem*',
'TQListViewItemIterator&'  =>  'qt_QListViewItemIterator*' ,
'TQListViewItemIterator'  =>  'qt_QListViewItemIterator*' ,
'TQListViewItemIterator*' => 'qt_QListViewItemIterator*',
'TQLocalFs*' => 'qt_QLocalFs*',
'TQMCPI*' => 'qt_QMCPI*',
'TQMainWindow*'  =>  'qt_QMainWindow*' ,
'TQMainWindow::ToolBarDock' => 'int',
'TQMainWindow::ToolBarDock::Top'  =>  'int' ,
'TQMap&'  =>  'qt_QMap*' ,
'TQMap*' => 'qt_QMap*',
'TQMapConstIterator*' => 'qt_QMapConstIterator*',
'TQMapIterator*' => 'qt_QMapIterator*',
'TQMapNode*' => 'qt_QMapNode*',
'TQMapNodeBase*&'  =>  'qt_QMapNodeBase*' ,
'TQMapNodeBase*'  =>  'qt_QMapNodeBase*' ,
'TQMapPrivate*' => 'qt_QMapPrivate*',
'TQMapPrivateBase*'  =>  'qt_QMapPrivateBase*' ,
'TQMemArray*' => 'qt_QMemArray*',
'TQMember'  => 'qt_QMember*' ,
'TQMember*'  => 'qt_QMember*' ,
'TQMenuBar*' => 'qt_QMenuBar*',
'TQMenuData*' => 'qt_QMenuData*',
'TQMenuItem*' => 'qt_QMenuItem*',
'TQMessageBox*' => 'qt_QMessageBox*',
'TQMetaData*'  =>  'qt_QMetaData*' ,
'TQMetaData::Access*'  =>  'int*' ,
'TQMetaEnum*'  =>  'qt_QMetaEnum*' ,
'TQMetaEnum::Item*'  =>  'int*' ,
'TQMetaObject*&' => 'qt_QMetaObject*',
'TQMetaObject*' => 'qt_QMetaObject*',
'TQMetaObjectCleanUp*' => 'qt_QMetaObjectCleanUp*',
'TQMetaObjectInit*' => 'qt_QMetaObjectInit*',
'TQMetaProperty*'  =>  'qt_QMetaProperty*' ,
'TQMimeSource*'  =>  'qt_QMimeSource*' ,
'TQMimeSourceFactory*'  =>  'qt_QMimeSourceFactory*' ,
'TQMotifPlusStyle*' => 'qt_QMotifPlusStyle*',
'TQMotifStyle*' => 'qt_QMotifStyle*',
'TQMouseEvent*'  => 'qt_QMouseEvent*' ,
'TQMoveEvent*'  =>  'qt_QMoveEvent*' ,
'TQMovie&' => 'qt_QMovie*',
'TQMovie*' => 'qt_QMovie*',
'TQMultiLineEdit*' => 'qt_QMultiLineEdit*',
'TQMultiLineEditRow*' => 'qt_QMultiLineEditRow*',
'TQMutex*' => 'qt_QMutex*',
'TQNPInstance*' => 'qt_QNPInstance*',
'TQNPStream*' => 'qt_QNPStream*',
'TQNPWidget*' => 'qt_QNPWidget*',
'TQNPlugin*' => 'qt_QNPlugin*',
'TQNetworkOperation*'  =>  'qt_QNetworkOperation*' ,
'TQNetworkProtocol*'  =>  'qt_QNetworkProtocol*' ,
'TQNetworkProtocol::Operation'  =>  'int' ,
'TQNetworkProtocol::State'  =>  'int' ,
'TQNetworkProtocolFactory*' => 'qt_QNetworkProtocolFactory*',
'TQNetworkProtocolFactoryBase*'  =>  'qt_QNetworkProtocolFactoryBase*' ,
'TQObject*' => 'qt_QObject*',
'TQObjectCleanupHandler*' => 'qt_QObjectCleanupHandler*',
'TQObjectDictionary&'  => 'qt_QObjectDictionary*' ,
'TQObjectDictionary*' => 'qt_QObjectDictionary*',
'TQObjectInterface*' => 'qt_QObjectInterface*',
'TQObjectList&'  => 'qt_QObjectList*' ,
'TQObjectList*' => 'qt_QObjectList*',
'TQObjectListIt&'  => 'qt_QObjectListIt*' ,
'TQObjectListIt*' => 'qt_QObjectListIt*',
'TQPNGImagePacker*' => 'qt_QPNGImagePacker*',
'TQPNGImageWriter*' => 'qt_QPNGImageWriter*',
'TQPaintDevice*' => 'qt_QPaintDevice*',
'TQPaintDeviceMetrics*' => 'qt_QPaintDeviceMetrics*',
'TQPaintDeviceX11Data*'  =>  'qt_QPaintDeviceX11Data*' ,
'TQPaintEvent*'  => 'qt_QPaintEvent*' ,
'TQPainter&'  =>  'qt_QPainter*' ,
'TQPainter*' => 'qt_QPainter*',
'TQPair*' => 'qt_QPair*',
'TQPalData*' => 'qt_QPalData*',
'TQPalette&' => 'qt_QPalette*',
'TQPalette' => 'qt_QPalette*',
'TQPalette*' => 'qt_QPalette*',
'TQPen&' => 'qt_QPen*',
'TQPen'  =>  'qt_QPen*' ,
'TQPen*' => 'qt_QPen*',
'TQPenData*' => 'qt_QPenData*',
'TQPicture&' => 'qt_QPicture*',
'TQPicture' => 'qt_QPicture*',
'TQPicture*' => 'qt_QPicture*',
'TQPicturePrivate*' => 'qt_QPicturePrivate*',
'TQPixmap& pixmap()' => 'tde_QPixmap*',
'TQPixmap&' => 'qt_QPixmap*',
'TQPixmap' => 'qt_QPixmap*',
'TQPixmap*' => 'qt_QPixmap*',
'TQPixmap::Optimization'  =>  'int' ,
'TQPixmap::Optimization' => 'int',
'TQPixmap::Optimization::DefaultOptim'  =>  'int' ,
'TQPixmapCache*' => 'qt_QPixmapCache*',
'TQPixmapData*' => 'qt_QPixmapData*',
'TQPlatinumStyle*' => 'qt_QPlatinumStyle*',
'TQPluginManager*' => 'qt_QPluginManager*',
'TQPoint&' => 'qt_QPoint*',
'TQPoint&pos()'  =>  'int' ,
'TQPoint&pos::pos()'  =>  'int' ,
'TQPoint' => 'qt_QPoint*',
'TQPoint*'  => 'qt_QPoint*' ,
'TQPointArray&' => 'qt_QPointArray*',
'TQPointArray' => 'qt_QPointArray*',
'TQPointArray*' => 'qt_QPointArray*',
'TQPointVal&'  => 'qt_QPointVal*' ,
'TQPointVal'  => 'qt_QPointVal*' ,
'TQPolygonScanner*' => 'qt_QPolygonScanner*',
'TQPopupMenu*' => 'qt_QPopupMenu*',
'TQPrintDialog*' => 'qt_QPrintDialog*',
'TQPrinter*'  => 'qt_QPrinter*' ,
'TQPrinter::PrinterMode' => 'int',
'TQProcess*' => 'qt_QProcess*',
'TQProgressBar*' => 'qt_QProgressBar*',
'TQProgressDialog*' => 'qt_QProgressDialog*',
'TQPtrBucket*' => 'qt_QPtrBucket*',
'TQPtrCollection&' => 'qt_QPtrCollection*',
'TQPtrCollection*' => 'qt_QPtrCollection*',
'TQPtrDict*' => 'qt_QPtrDict*',
'TQPtrDictIterator*' => 'qt_QPtrDictIterator*',
'TQPtrList*' => 'qt_QPtrList*',
'TQPtrListIterator*' => 'qt_QPtrListIterator*',
'TQPtrQueue*' => 'qt_QPtrQueue*',
'TQPtrStack*' => 'qt_QPtrStack*',
'TQPtrVector*' => 'qt_QPtrVector*',
'TQPushButton*' => 'qt_QPushButton*',
'TQQueue*' => 'qt_QQueue*',
'TQRESULT' => 'long',
'TQRadioButton*' => 'qt_QRadioButton*',
'TQRangeControl*' => 'qt_QRangeControl*',
'TQRect&' => 'qt_QRect*',
'TQRect' => 'qt_QRect*',
'TQRect*' => 'qt_QRect*',
'TQRegExp&' => 'qt_QRegExp*',
'TQRegExp*' => 'qt_QRegExp*',
'TQRegExpValidator*' => 'qt_QRegExpValidator*',
'TQRegion&' => 'qt_QRegion*',
'TQRegion' => 'qt_QRegion*',
'TQRegion*' => 'qt_QRegion*',
'TQRegionData*' => 'qt_QRegionData*',
'TQRemoteFactory*' => 'qt_QRemoteFactory*',
'TQRemotePlugin*' => 'qt_QRemotePlugin*',
'TQResizeEvent*'  => 'qt_QResizeEvent*' ,
'TQRgb' => 'unsigned int',
'TQRgb*' => 'int*',
'TQRichText&'  =>  'qt_QRichText*' ,
'TQSGIStyle*' => 'qt_QSGIStyle*',
'TQScrollBar&'  =>  'qt_QScrollBar*' ,
'TQScrollBar*'  =>  'qt_QScrollBar*' ,
'TQScrollView*' => 'qt_QScrollView*',
'TQSemaphore*' => 'qt_QSemaphore*',
'TQSemiModal*' => 'qt_QSemiModal*',
'TQSenderObject*' => 'qt_QSenderObject*',
'TQServerSocket*' => 'qt_QServerSocket*',
'TQSessionManager&'  =>  'qt_QSessionManager*' ,
'TQSessionManager*' => 'qt_QSessionManager*',
'TQSettings*' => 'qt_QSettings*',
'TQShared*' => 'qt_QShared*',
'TQShowEvent*'  =>  'qt_QShowEvent*' ,
'TQSignal*' => 'qt_QSignal*',
'TQSignalDict&'  => 'qt_QSignalDict*' ,
'TQSignalDict*' => 'qt_QSignalDict*',
'TQSignalDictIt&'  => 'qt_QSignalDictIt*' ,
'TQSignalDictIt*' => 'qt_QSignalDictIt*',
'TQSignalMapper*' => 'qt_QSignalMapper*',
'TQSignalVec&' => 'qt_QSignalVec*',
'TQSignalVec*' => 'qt_QSignalVec*',
'TQSimpleRichText*' => 'qt_QSimpleRichText*',
'TQSize&' => 'qt_QSize*',
'TQSize' => 'qt_QSize*',
'TQSize*'  => 'qt_QSize*' ,
'TQSizeGrip*' => 'qt_QSizeGrip*',
'TQSizePolicy&'  =>  'qt_QSizePolicy*' ,
'TQSizePolicy'  =>  'qt_QSizePolicy*' ,
'TQSizePolicy*' => 'qt_QSizePolicy*',
'TQSizePolicy::ExpandData'  =>  'int' ,
'TQSizePolicy::SizeTypehData::Minimum'  =>  'int' ,
'TQSizePolicy::SizeTypevData::Minimum'  =>  'int' ,
'TQSjisCodec*' => 'qt_QSjisCodec*',
'TQSlider*' => 'qt_QSlider*',
'TQSmartPtr&'  =>  'qt_QSmartPtr*' ,
'TQSmartPtr*' => 'qt_QSmartPtr*',
'TQSmartPtrPrivate*' => 'qt_QSmartPtrPrivate*',
'TQSocket*' => 'qt_QSocket*',
'TQSocketDevice*'  =>  'qt_QSocketDevice*' ,
'TQSocketNotifier*' => 'qt_QSocketNotifier*',
'TQSocketNotifier::Type' => 'int',
'TQSortedList*' => 'qt_QSortedList*',
'TQSound*' => 'qt_QSound*',
'TQSpacerItem*'  =>  'qt_QSpacerItem*' ,
'TQSpinBox*' => 'qt_QSpinBox*',
'TQSpinWidget*' => 'qt_QSpinWidget*',
'TQSplitter*' => 'qt_QSplitter*',
'TQSql*' => 'qt_QSql*',
'TQSql::Confirm' => 'int',
'TQSql::Op' => 'int',
'TQSqlCursor&' => 'qt_QSqlCursor*',
'TQSqlCursor' => 'qt_QSqlCursor*',
'TQSqlCursor*' => 'qt_QSqlCursor*',
'TQSqlDatabase*' => 'qt_QSqlDatabase*',
'TQSqlDriver*' => 'qt_QSqlDriver*',
'TQSqlDriverCreator*' => 'qt_QSqlDriverCreator*',
'TQSqlDriverCreatorBase*' => 'qt_QSqlDriverCreatorBase*',
'TQSqlDriverFactoryInterface*' => 'qt_QSqlDriverFactoryInterface*',
'TQSqlDriverPlugin*' => 'qt_QSqlDriverPlugin*',
'TQSqlEditorFactory*' => 'qt_QSqlEditorFactory*',
'TQSqlError&' => 'qt_QSqlError*',
'TQSqlError' => 'qt_QSqlError*',
'TQSqlError*' => 'qt_QSqlError*',
'TQSqlField&' => 'qt_QSqlField*',
'TQSqlField' => 'qt_QSqlField*',
'TQSqlField*' => 'qt_QSqlField*',
'TQSqlFieldInfo&' => 'qt_QSqlFieldInfo*',
'TQSqlFieldInfo*' => 'qt_QSqlFieldInfo*',
'TQSqlForm' => 'qt_QSqlForm*',
'TQSqlForm*' => 'qt_QSqlForm*',
'TQSqlIndex&' => 'qt_QSqlIndex*',
'TQSqlIndex' => 'qt_QSqlIndex*',
'TQSqlIndex*' => 'qt_QSqlIndex*',
'TQSqlPropertyMap*' => 'qt_QSqlPropertyMap*',
'TQSqlQuery&' => 'qt_QSqlQuery*',
'TQSqlQuery' => 'qt_QSqlQuery*',
'TQSqlQuery*' => 'qt_QSqlQuery*',
'TQSqlRecord&' => 'qt_QSqlRecord*',
'TQSqlRecord' => 'qt_QSqlRecord*',
'TQSqlRecord*' => 'qt_QSqlRecord*',
'TQSqlRecordInfo&' => 'qt_QSqlRecordInfo*',
'TQSqlRecordInfo' => 'qt_QSqlRecordInfo*',
'TQSqlRecordInfo*' => 'qt_QSqlRecordInfo*',
'TQSqlRecordPrivate*' => 'qt_QSqlRecordPrivate*',
'TQSqlRecordShared*' => 'qt_QSqlRecordShared*',
'TQSqlResult' => 'qt_QSqlResult*',
'TQSqlResult*' => 'qt_QSqlResult*',
'TQSqlResultShared*' => 'qt_QSqlResultShared*',
'TQStack*' => 'qt_QStack*',
'TQStatusBar*'  => 'qt_QStatusBar*' ,
'TQStoredDrag*' => 'qt_QStoredDrag*',
'TQStrIList' => 'tde_QStrIList',
'TQStrIList*' => 'qt_QStrIList*',
'TQStrIVec*' => 'qt_QStrIVec*',
'TQStrList&' => 'qt_QStrList*',
'TQStrList' => 'qt_QStrList*',
'TQStrList*' => 'qt_QStrList*',
'TQStrListIterator*' => 'qt_QStrListIterator*',
'TQStrVec*' => 'qt_QStrVec*',
'TQString&' => 'qt_QString*',
'TQString&::null'  =>  'qt_QString*' ,
'TQString&button0Text::null'  =>  'qt_QString*' ,
'TQString&button1Text::null'  =>  'qt_QString*' ,
'TQString&button2Text::null'  =>  'qt_QString*' ,
'TQString&buttonText::null'  =>  'qt_QString*' ,
'TQString&caption::null'  =>  'qt_QString*' ,
'TQString&charSet::null'  =>  'qt_QString*' ,
'TQString&context::null'  =>  'qt_QString*' ,
'TQString&defValue::null'  =>  'qt_QString*' ,
'TQString&dir::null'  =>  'qt_QString*' ,
'TQString&directory::null'  =>  'qt_QString*' ,
'TQString&filter::null'  =>  'qt_QString*' ,
'TQString&initially::null'  =>  'qt_QString*' ,
'TQString&location::null'  =>  'qt_QString*' ,
'TQString&n::null'  =>  'qt_QString*' ,
'TQString&nameFilter::null'  =>  'qt_QString*' ,
'TQString&noButtonText::null'  =>  'qt_QString*' ,
'TQString&search_delimiters::null'  =>  'qt_QString*' ,
'TQString&style::null'  =>  'qt_QString*' ,
'TQString&suffix::null'  =>  'qt_QString*' ,
'TQString&text::null'  =>  'qt_QString*' ,
'TQString&text_::null'  =>  'qt_QString*' ,
'TQString&translation::null'  =>  'qt_QString*' ,
'TQString&yesButtonText::null'  =>  'qt_QString*' ,
'TQString' => 'qt_QString*',
'TQString*'  => 'qt_QString*' ,
'TQString::null'  =>  'qt_QString_null()' ,
'TQStringBucket*' => 'qt_QStringBucket*',
'TQStringData*' => 'qt_QStringData*',
'TQStringList&'  =>  'qt_QStringList*' ,
'TQStringList'  =>  'qt_QStringList*' ,
'TQStringList*'  => 'qt_QStringList*' ,
'TQStringcharSetName::null'  =>  'qt_QStringcharSetName*' ,
'TQStyle&'  =>  'qt_QStyle*' ,
'TQStyle*'  =>  'qt_QStyle*' ,
'TQStyle::ScrollControl'  => 'int' ,
'TQStyle::StylePixmap' => 'int',
'TQStyle::SubControl' => 'int',
'TQStyle::SubRect' => 'int',
'TQStyleFactory*' => 'qt_QStyleFactory*',
'TQStyleFactoryInterface*' => 'qt_QStyleFactoryInterface*',
'TQStyleOption&' => 'int',
'TQStyleOption' => 'int',
'TQStyleOption*' => 'int*',
'TQStylePlugin*' => 'qt_QStylePlugin*',
'TQStyleSheet*'  =>  'qt_QStyleSheet*' ,
'TQStyleSheetItem&'  =>  'qt_QStyleSheetItem*' ,
'TQStyleSheetItem*'  =>  'qt_QStyleSheetItem*' ,
'TQStyleSheetItem::DisplayMode*' => 'int',
'TQStyleSheetItem::ListStyle*' => 'int',
'TQStyleSheetItem::WhiteSpaceMode' => 'int',
'TQTSCIICodec*' => 'qt_QTSCIICodec*',
'TQTSMFI'  =>  'int' ,
'TQTab*' => 'qt_QTab*',
'TQTabBar*'  =>  'qt_QTabBar*' ,
'TQTabBar::Shape'  => 'int' ,
'TQTabDialog*' => 'qt_QTabDialog*',
'TQTabWidget*' => 'qt_QTabWidget*',
'TQTable*'  =>  'qt_QTable*' ,
'TQTableHeader*' => 'qt_QTableHeader*',
'TQTableItem*'  =>  'qt_QTableItem*' ,
'TQTableSelection&'  =>  'qt_QTableSelection*' ,
'TQTableSelection'  =>  'qt_QTableSelection*' ,
'TQTableSelection*' => 'qt_QTableSelection*',
'TQTableView*' => 'qt_QTableView*',
'TQTabletEvent*' => 'qt_QTabletEvent*',
'TQTextBrowser*' => 'qt_QTextBrowser*',
'TQTextCodec*'  =>  'qt_QTextCodec*' ,
'TQTextCodecFactory*' => 'qt_QTextCodecFactory*',
'TQTextCodecFactoryInterface*' => 'qt_QTextCodecFactoryInterface*',
'TQTextCodecPlugin*' => 'qt_QTextCodecPlugin*',
'TQTextCursor*' => 'qt_QTextCursor*',
'TQTextDecoder*'  =>  'qt_QTextDecoder*' ,
'TQTextDocument*' => 'qt_QTextDocument*',
'TQTextDrag*' => 'qt_QTextDrag*',
'TQTextEdit*' => 'qt_QTextEdit*',
'TQTextEncoder*'  =>  'qt_QTextEncoder*' ,
'TQTextFormat*' => 'qt_QTextFormat*',
'TQTextIStream*' => 'qt_QTextIStream*',
'TQTextOStream&'  =>  'qt_QTextOStream*' ,
'TQTextOStream*' => 'qt_QTextOStream*',
'TQTextOStreamIterator*' => 'qt_QTextOStreamIterator*',
'TQTextParag**' => 'qt_QTextParag**',
'TQTextStream&'  => 'qt_QTextStream*' ,
'TQTextStream*'  => 'qt_QTextStream*' ,
'TQTextView*' => 'qt_QTextView*',
'TQThread*' => 'qt_QThread*',
'TQThreadData*' => 'qt_QThreadData*',
'TQThreadEvent*' => 'qt_QThreadEvent*',
'TQTime&' => 'qt_QTime*',
'TQTime' => 'qt_QTime*',
'TQTime*' => 'qt_QTime*',
'TQTimeEdit*' => 'qt_QTimeEdit*',
'TQTimeWatch*' => 'qt_QTimeWatch*',
'TQTimer*' => 'qt_QTimer*',
'TQTimerEvent*'  => 'qt_QTimerEvent*' ,
'TQToolBar*'  => 'qt_QToolBar*' ,
'TQToolButton*'  =>  'qt_QToolButton*' ,
'TQToolTip*' => 'qt_QToolTip*',
'TQToolTipGroup*' => 'qt_QToolTipGroup*',
'TQTranslator*'  =>  'qt_QTranslator*' ,
'TQTranslatorMessage&'  =>  'qt_QTranslatorMessage*' ,
'TQTranslatorMessage'  =>  'qt_QTranslatorMessage*' ,
'TQTranslatorMessage*' => 'qt_QTranslatorMessage*',
'TQTsciiCodec*' => 'qt_QTsciiCodec*',
'TQUObject*' => 'qt_QUObject*',
'TQUnknownInterface*' => 'qt_QUnknownInterface*',
'TQUnknownInterface**' => 'qt_QUnknownInterface**',
'TQUriDrag*' => 'qt_QUriDrag*',
'TQUrl&'  =>  'qt_QUrl*' ,
'TQUrl'  =>  'qt_QUrl*' ,
'TQUrl*' => 'qt_QUrl*',
'TQUrlInfo&'  =>  'qt_QUrlInfo*' ,
'TQUrlInfo'  =>  'qt_QUrlInfo*' ,
'TQUrlInfo*' => 'qt_QUrlInfo*',
'TQUrlOperator&'  =>  'qt_QUrlOperator*' ,
'TQUrlOperator*'  =>  'qt_QUrlOperator*' ,
'TQUtf16Codec*' => 'qt_QUtf16Codec*',
'TQUtf8Codec*' => 'qt_QUtf8Codec*',
'TQUuid&' => 'qt_QUuid*',
'TQUuid*' => 'qt_QUuid*',
'TQVBox*'  => 'qt_QVBox*' ,
'TQVBoxLayout*' => 'qt_QVBoxLayout*',
'TQVButtonGroup*' => 'qt_QVButtonGroup*',
'TQVFbHeader*' => 'qt_QVFbHeader*',
'TQVFbKeyData*' => 'qt_QVFbKeyData*',
'TQVGroupBox*' => 'qt_QVGroupBox*',
'TQValidator*' => 'qt_QValidator*',
'TQValidator::State' => 'int',
'TQValueList*' => 'qt_QValueList*',
'TQValueListConstIterator*' => 'qt_QValueListConstIterator*',
'TQValueListIterator*' => 'qt_QValueListIterator*',
'TQValueListNode*' => 'qt_QValueListNode*',
'TQValueListPrivate*' => 'qt_QValueListPrivate*',
'TQValueStack*' => 'qt_QValueStack*',
'TQValueVector*' => 'qt_QValueVector*',
'TQValueVectorPrivate*' => 'qt_QValueVectorPrivate*',
'TQVariant&' => 'qt_QVariant*',
'TQVariant' => 'qt_QVariant*',
'TQVariant*' => 'qt_QVariant*',
'TQVariant::Type'  => 'int' ,
'TQVariantPrivate*'  =>  'qt_QVariantPrivate*' ,
'TQVector*' => 'qt_QVector*',
'TQWMatrix&' => 'qt_QWMatrix*',
'TQWMatrix' => 'qt_QWMatrix*',
'TQWMatrix*' => 'qt_QWMatrix*',
'TQWSDecoration&'  =>  'qt_QWSDecoration*' ,
'TQWSDecoration*'  =>  'qt_QWSDecoration*' ,
'TQWSDisplay*'  =>  'qt_QWSDisplay*' ,
'TQWSEvent*'  =>  'qt_QWSEvent*' ,
'TQWaitCondition*' => 'qt_QWaitCondition*',
'TQWhatsThis*' => 'qt_QWhatsThis*',
'TQWheelEvent*'  =>  'qt_QWheelEvent*' ,
'TQWidget*' => 'qt_QWidget*',
'TQWidget' => 'qt_QWidget*',
'TQWidget*' => 'qt_QWidget*',
'TQWidgetFactory*' => 'qt_QWidgetFactory*',
'TQWidgetIntDict&'  => 'qt_QWidgetIntDict*' ,
'TQWidgetIntDict*' => 'qt_QWidgetIntDict*',
'TQWidgetIntDictIt&'  => 'qt_QWidgetIntDictIt*' ,
'TQWidgetIntDictIt*' => 'qt_QWidgetIntDictIt*',
'TQWidgetItem*' => 'qt_QWidgetItem*',
'TQWidgetList&'  => 'qt_QWidgetList*' ,
'TQWidgetList&'  => 'qt_QWidgetList*' ,
'TQWidgetList'  =>  'qt_QWidgetList*' ,
'TQWidgetList'  =>  'qt_QWidgetList*' ,
'TQWidgetList*' => 'qt_QWidgetList*',
'TQWidgetList*' => 'qt_QWidgetList*',
'TQWidgetListIt&'  => 'qt_QWidgetListIt*' ,
'TQWidgetListIt*' => 'qt_QWidgetListIt*',
'TQWidgetMapper*' => 'qt_QWidgetMapper*',
'TQWidgetPlugin*' => 'qt_QWidgetPlugin*',
'TQWidgetStack*' => 'qt_QWidgetStack*',
'TQWindowsMime*'  =>  'qt_QWindowsMime*' ,
'TQWindowsStyle*' => 'qt_QWindowsStyle*',
'TQWizard*' => 'qt_QWizard*',
'TQWorkspace*' => 'qt_QWorkspace*',
'QXEmbed*'  =>  'qt_QXEmbed*' ,
'TQXmlAttributes&'  =>  'qt_QXmlAttributes*' ,
'TQXmlAttributes*' => 'qt_QXmlAttributes*',
'TQXmlContentHandler*'  =>  'qt_QXmlContentHandler*' ,
'TQXmlDTDHandler*'  =>  'qt_QXmlDTDHandler*' ,
'TQXmlDeclHandler*'  =>  'qt_QXmlDeclHandler*' ,
'TQXmlDefaultHandler*' => 'qt_QXmlDefaultHandler*',
'TQXmlEntityResolver*'  =>  'qt_QXmlEntityResolver*' ,
'TQXmlErrorHandler*'  =>  'qt_QXmlErrorHandler*' ,
'TQXmlInputSource&'  =>  'qt_QXmlInputSource*' ,
'TQXmlInputSource*&' => 'qt_QXmlInputSource*',
'TQXmlInputSource*'  =>  'qt_QXmlInputSource*' ,
'TQXmlLexicalHandler*'  =>  'qt_QXmlLexicalHandler*' ,
'TQXmlLocator*'  =>  'qt_QXmlLocator*' ,
'TQXmlNamespaceSupport*' => 'qt_QXmlNamespaceSupport*',
'TQXmlParseException&'  =>  'qt_QXmlParseException*' ,
'TQXmlParseException*' => 'qt_QXmlParseException*',
'TQXmlReader*' => 'qt_QXmlReader*',
'TQXmlSimpleReader*'  =>  'qt_QXmlSimpleReader*' ,
'TQXtApplication*' => 'qt_QXtApplication*',
'TQXtWidget*' => 'qt_QXtWidget*',
'TQ_INT16&' => 'short',
'TQ_INT16' => 'short',
'TQ_INT32&' => 'int',
'TQ_INT32' => 'int',
'TQ_INT8&' => 'char',
'TQ_INT8' => 'char',
'TQ_LONG&' => 'long',
'TQ_LONG' => 'long',
'TQ_PACKED*' => 'void*',
'TQ_UINT16&' => 'unsigned short',
'TQ_UINT16' => 'unsigned short',
'TQ_UINT32&' => 'unsigned int',
'TQ_UINT32' => 'unsigned int',
'TQ_UINT8&' => 'unsigned char',
'TQ_UINT8' => 'unsigned char',
'TQ_UINT8*'  =>  'unsigned char*' ,
'TQ_ULONG&' => 'long',
'TQ_ULONG' => 'long',
'Qt*'  =>  'qt_Qt*' ,
'TQt::ArrowType'  =>  'int' ,
'TQt::BackgroundMode' => 'int',
'TQt::DateFormat' => 'int',
'TQt::GUIStyle'  => 'int' ,
'TQt::GUIStylecolorStyle::WindowsStyle'  => 'int' ,
'TQt::GUIStylestyle::WindowsStyle'  => 'int' ,
'TQt::Orientation'  =>  'int' ,
'TQt::RasterOp'  =>  'int' ,
'TQt::UIEffect'  =>  'int' ,
'TQt::WFlags'  =>  'int' ,
'QtMultiLineEdit*' => 'qt_QtMultiLineEdit*',
'QtMultiLineEditRow*' => 'qt_QtMultiLineEditRow*',
'QtTableView*' => 'qt_QtTableView*',
'QwAbsSpriteFieldView*'  =>  'qt_QwAbsSpriteFieldView*' ,
'QwClusterizer*'  =>  'qt_QwClusterizer*' ,
'QwEllipse*' => 'qt_QwEllipse*',
'QwImageSpriteField*' => 'qt_QwImageSpriteField*',
'QwMobilePositionedSprite*' => 'qt_QwMobilePositionedSprite*',
'QwMobileSprite*' => 'qt_QwMobileSprite*',
'QwPolygon*' => 'qt_QwPolygon*',
'QwPolygonalGraphic*' => 'qt_QwPolygonalGraphic*',
'QwPositionedSprite*' => 'qt_QwPositionedSprite*',
'QwPublicList*'  =>  'qt_QwPublicList*' ,
'QwRealMobileSprite*' => 'qt_QwRealMobileSprite*',
'QwRealSprite*' => 'qt_QwRealSprite*',
'QwRectangle*' => 'qt_QwRectangle*',
'QwScrollingSpriteFieldView*' => 'qt_QwScrollingSpriteFieldView*',
'QwSprite*' => 'qt_QwSprite*',
'QwSpriteField*'  =>  'qt_QwSpriteField*' ,
'QwSpriteField*'  => 'qt_QwSpriteField*' ,
'QwSpriteFieldGraphic&'  => 'qt_QwSpriteFieldGraphic*' ,
'QwSpriteFieldGraphic*'  =>  'qt_QwSpriteFieldGraphic*' ,
'QwSpriteFieldView*' => 'qt_QwSpriteFieldView*',
'QwSpritePixmap*'  =>  'qt_QwSpritePixmap*' ,
'QwSpritePixmapSequence*'  => 'qt_QwSpritePixmapSequence*' ,
'QwTextSprite*' => 'qt_QwTextSprite*',
'QwTiledSpriteField*' => 'qt_QwTiledSpriteField*',
'QwVirtualSprite*' => 'qt_QwVirtualSprite*',
'RArray*' => 'tde_RArray*',
'RGBColor&' => 'tde_RGBColor*',
'RGBColor' => 'tde_RGBColor*',
'RGBColor*' => 'tde_RGBColor*',
'Range&' => 'tde_Range*',
'Range' => 'tde_Range*',
'Range*' => 'tde_Range*',
'RangeException&' => 'tde_RangeException*',
'RangeException*' => 'tde_RangeException*',
'RangeImpl*' => 'tde_RangeImpl*',
'RasterOp' => 'int',
'RawDataPacket*' => 'tde_RawDataPacket*',
'ReadOnlyPart*' => 'tde_ReadOnlyPart*',
'ReadWritePart*' => 'tde_ReadWritePart*',
'Rect&' => 'tde_Rect*',
'Rect' => 'tde_Rect*',
'Rect*' => 'tde_Rect*',
'Reference&' => 'tde_Reference*',
'Reference*' => 'tde_Reference*',
'ReferenceClean*' => 'tde_ReferenceClean*',
'ReferenceHelper*' => 'tde_ReferenceHelper*',
'Region' => 'int',
'RegionType' => 'int',
'RemoteScheduleNode*' => 'tde_RemoteScheduleNode*',
'RenameDlg*' => 'tde_RenameDlg*',
'RenderStyle*'  =>  'tde_RenderStyle*' ,
'Rep*' => 'tde_Rep*',
'RunMode'  =>  'int' ,
'SButton*' => 'tde_SButton*',
'SCFlags' => 'int',
'SFlags' => 'int',
'ScheduleNode*' => 'tde_ScheduleNode*',
'Scheduler*' => 'tde_Scheduler*',
'ScrollBarMode' => 'int',
'ScrollControl'  =>  'int' ,
'SearchInterface*' => 'tde_SearchInterface*',
'Section&'  =>  'tde_Section*' ,
'Section*&'  =>  'tde_Section*' ,
'Section*'  =>  'tde_Section*' ,
'SegmentStyle' => 'int',
'SelectionInterface*' => 'tde_SelectionInterface*',
'Separator' => 'int',
'Server&'  =>  'Server*' ,
'Server*' => 'tde_Server*',
'ServerHello&' => 'tde_ServerHello*',
'ServerHello*' => 'tde_ServerHello*',
'Service*' => 'tde_Service*',
'SessionData*' => 'tde_SessionData*',
'SimpleFormat*' => 'tde_SimpleFormat*',
'SimpleJob*' => 'tde_SimpleJob*',
'SimpleSoundServer&' => 'tde_SimpleSoundServer*',
'SimpleSoundServer' => 'tde_SimpleSoundServer*',
'SimpleSoundServer*' => 'tde_SimpleSoundServer*',
'SimpleSoundServer_base*' => 'tde_SimpleSoundServer_base*',
'SimpleSoundServer_skel*' => 'tde_SimpleSoundServer_skel*',
'SimpleSoundServer_stub*' => 'tde_SimpleSoundServer_stub*',
'SkipDlg*' => 'tde_SkipDlg*',
'Slave*' => 'tde_Slave*',
'SlaveBase*' => 'tde_SlaveBase*',
'SlaveBasePrivate*' => 'tde_SlaveBasePrivate*',
'SlaveConfig*' => 'tde_SlaveConfig*',
'SlaveInterface*' => 'tde_SlaveInterface*',
'SocketConnection*' => 'tde_SocketConnection*',
'Spec' => 'int',
'SpecialEvent*' => 'tde_SpecialEvent*',
'SshProcess*' => 'tde_SshProcess*',
'SshProcessPrivate*' => 'tde_SshProcessPrivate*',
'StartupClass*' => 'tde_StartupClass*',
'StartupManager*' => 'tde_StartupManager*',
'StatJob*' => 'tde_StatJob*',
'State' => 'int',
'TQSocket::State' => 'int',
'StatusbarProgress*' => 'tde_StatusbarProgress*',
'StdAddressBook*' => 'tde_StdAddressBook*',
'StdFlowSystem*' => 'tde_StdFlowSystem*',
'StdIOManager*' => 'tde_StdIOManager*',
'StdScheduleNode*' => 'tde_StdScheduleNode*',
'StdSynthModule*' => 'tde_StdSynthModule*',
'StereoEffect&' => 'tde_StereoEffect*',
'StereoEffect' => 'tde_StereoEffect*',
'StereoEffect*' => 'tde_StereoEffect*',
'StereoEffectStack&' => 'tde_StereoEffectStack*',
'StereoEffectStack' => 'tde_StereoEffectStack*',
'StereoEffectStack*' => 'tde_StereoEffectStack*',
'StereoEffectStack_base*' => 'tde_StereoEffectStack_base*',
'StereoEffectStack_skel*' => 'tde_StereoEffectStack_skel*',
'StereoEffectStack_stub*' => 'tde_StereoEffectStack_stub*',
'StereoEffect_base*' => 'tde_StereoEffect_base*',
'StereoEffect_skel*' => 'tde_StereoEffect_skel*',
'StereoEffect_stub*' => 'tde_StereoEffect_stub*',
'StereoFFTScope&' => 'tde_StereoFFTScope*',
'StereoFFTScope' => 'tde_StereoFFTScope*',
'StereoFFTScope*' => 'tde_StereoFFTScope*',
'StereoFFTScope_base*' => 'tde_StereoFFTScope_base*',
'StereoFFTScope_skel*' => 'tde_StereoFFTScope_skel*',
'StereoFFTScope_stub*' => 'tde_StereoFFTScope_stub*',
'StereoVolumeControl&' => 'tde_StereoVolumeControl*',
'StereoVolumeControl' => 'tde_StereoVolumeControl*',
'StereoVolumeControl*' => 'tde_StereoVolumeControl*',
'StereoVolumeControl_base*' => 'tde_StereoVolumeControl_base*',
'StereoVolumeControl_skel*' => 'tde_StereoVolumeControl_skel*',
'StereoVolumeControl_stub*' => 'tde_StereoVolumeControl_stub*',
'StreamMode&' => 'int',
'String*' => 'tde_String*',
'StringSectionMap::iterator&'  =>  'tde_StringSectionMap*' ,
'StringSectionMap::iterator'  =>  'tde_StringSectionMap*r' ,
'StubProcess*' => 'tde_StubProcess*',
'StyleHint' => 'int',
'StyleListImpl*' => 'tde_StyleListImpl*',
'StylePixmap' => 'int',
'StyleSheet&' => 'tde_StyleSheet*',
'StyleSheet' => 'tde_StyleSheet*',
'StyleSheet*' => 'tde_StyleSheet*',
'StyleSheetImpl*' => 'tde_StyleSheetImpl*',
'StyleSheetList&' => 'tde_StyleSheetList*',
'StyleSheetList' => 'tde_StyleSheetList',
'StyleSheetList*' => 'tde_StyleSheetList*',
'StyleSheetListImpl*' => 'tde_StyleSheetListImpl*',
'StyleStrategy' => 'int',
'SuProcess*' => 'tde_SuProcess*',
'SubClass&' => 'tde_SubClass*',
'SubClass*' => 'tde_SubClass*',
'SubControl' => 'int',
'SubRect' => 'int',
'SynthBuffer*' => 'tde_SynthBuffer*',
'SynthModule&' => 'tde_SynthModule*',
'SynthModule' => 'tde_SynthModule*',
'SynthModule*' => 'tde_SynthModule*',
'SynthModule_base*' => 'tde_SynthModule_base*',
'SynthModule_skel*' => 'tde_SynthModule_skel*',
'SynthModule_stub*' => 'tde_SynthModule_stub*',
'SynthOut*' => 'tde_SynthOut*',
'Synth_ADD&' => 'tde_Synth_ADD*',
'Synth_ADD' => 'tde_Synth_ADD*',
'Synth_ADD*' => 'tde_Synth_ADD*',
'Synth_ADD_base*' => 'tde_Synth_ADD_base*',
'Synth_ADD_skel*' => 'tde_Synth_ADD_skel*',
'Synth_ADD_stub*' => 'tde_Synth_ADD_stub*',
'Synth_AMAN_PLAY&' => 'tde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY' => 'tde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY*' => 'tde_Synth_AMAN_PLAY*',
'Synth_AMAN_PLAY_base*' => 'tde_Synth_AMAN_PLAY_base*',
'Synth_AMAN_PLAY_skel*' => 'tde_Synth_AMAN_PLAY_skel*',
'Synth_AMAN_PLAY_stub*' => 'tde_Synth_AMAN_PLAY_stub*',
'Synth_AMAN_RECORD&' => 'tde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD' => 'tde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD*' => 'tde_Synth_AMAN_RECORD*',
'Synth_AMAN_RECORD_base*' => 'tde_Synth_AMAN_RECORD_base*',
'Synth_AMAN_RECORD_skel*' => 'tde_Synth_AMAN_RECORD_skel*',
'Synth_AMAN_RECORD_stub*' => 'tde_Synth_AMAN_RECORD_stub*',
'Synth_BUS_DOWNLINK&' => 'tde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK' => 'tde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK*' => 'tde_Synth_BUS_DOWNLINK*',
'Synth_BUS_DOWNLINK_base*' => 'tde_Synth_BUS_DOWNLINK_base*',
'Synth_BUS_DOWNLINK_skel*' => 'tde_Synth_BUS_DOWNLINK_skel*',
'Synth_BUS_DOWNLINK_stub*' => 'tde_Synth_BUS_DOWNLINK_stub*',
'Synth_BUS_UPLINK&' => 'tde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK' => 'tde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK*' => 'tde_Synth_BUS_UPLINK*',
'Synth_BUS_UPLINK_base*' => 'tde_Synth_BUS_UPLINK_base*',
'Synth_BUS_UPLINK_skel*' => 'tde_Synth_BUS_UPLINK_skel*',
'Synth_BUS_UPLINK_stub*' => 'tde_Synth_BUS_UPLINK_stub*',
'Synth_FREQUENCY&' => 'tde_Synth_FREQUENCY*',
'Synth_FREQUENCY' => 'tde_Synth_FREQUENCY*',
'Synth_FREQUENCY*' => 'tde_Synth_FREQUENCY*',
'Synth_FREQUENCY_base*' => 'tde_Synth_FREQUENCY_base*',
'Synth_FREQUENCY_skel*' => 'tde_Synth_FREQUENCY_skel*',
'Synth_FREQUENCY_stub*' => 'tde_Synth_FREQUENCY_stub*',
'Synth_MUL&' => 'tde_Synth_MUL*',
'Synth_MUL' => 'tde_Synth_MUL*',
'Synth_MUL*' => 'tde_Synth_MUL*',
'Synth_MULTI_ADD&' => 'tde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD' => 'tde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD*' => 'tde_Synth_MULTI_ADD*',
'Synth_MULTI_ADD_base*' => 'tde_Synth_MULTI_ADD_base*',
'Synth_MULTI_ADD_skel*' => 'tde_Synth_MULTI_ADD_skel*',
'Synth_MULTI_ADD_stub*' => 'tde_Synth_MULTI_ADD_stub*',
'Synth_MUL_base*' => 'tde_Synth_MUL_base*',
'Synth_MUL_skel*' => 'tde_Synth_MUL_skel*',
'Synth_MUL_stub*' => 'tde_Synth_MUL_stub*',
'Synth_PLAY&' => 'tde_Synth_PLAY*',
'Synth_PLAY' => 'tde_Synth_PLAY*',
'Synth_PLAY*' => 'tde_Synth_PLAY*',
'Synth_PLAY_WAV&' => 'tde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV' => 'tde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV*' => 'tde_Synth_PLAY_WAV*',
'Synth_PLAY_WAV_base*' => 'tde_Synth_PLAY_WAV_base*',
'Synth_PLAY_WAV_skel*' => 'tde_Synth_PLAY_WAV_skel*',
'Synth_PLAY_WAV_stub*' => 'tde_Synth_PLAY_WAV_stub*',
'Synth_PLAY_base*' => 'tde_Synth_PLAY_base*',
'Synth_PLAY_skel*' => 'tde_Synth_PLAY_skel*',
'Synth_PLAY_stub*' => 'tde_Synth_PLAY_stub*',
'Synth_RECORD&' => 'tde_Synth_RECORD*',
'Synth_RECORD' => 'tde_Synth_RECORD*',
'Synth_RECORD*' => 'tde_Synth_RECORD*',
'Synth_RECORD_base*' => 'tde_Synth_RECORD_base*',
'Synth_RECORD_skel*' => 'tde_Synth_RECORD_skel*',
'Synth_RECORD_stub*' => 'tde_Synth_RECORD_stub*',
'Synth_WAVE_SIN&' => 'tde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN' => 'tde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN*' => 'tde_Synth_WAVE_SIN*',
'Synth_WAVE_SIN_base*' => 'tde_Synth_WAVE_SIN_base*',
'Synth_WAVE_SIN_skel*' => 'tde_Synth_WAVE_SIN_skel*',
'Synth_WAVE_SIN_stub*' => 'tde_Synth_WAVE_SIN_stub*',
'T&'  =>  'T*' ,
'T'  =>  'T*' ,
'T*'  =>  'T*' ,
'TCPConnection*' => 'tde_TCPConnection*',
'TCPServer*' => 'tde_TCPServer*',
'TCPSlaveBase*' => 'tde_TCPSlaveBase*',
'TRUE' => '1',
'Task*' => 'tde_Task*',
'Text&' => 'tde_Text*',
'Text' => 'tde_Text*',
'Text*' => 'tde_Text*',
'TextFormat'  =>  'int' ,
'TextImpl*' => 'tde_TextImpl*',
'ThumbCreator*' => 'tde_ThumbCreator*',
'TickSetting' => 'int',
'Ticket*' => 'tde_Ticket*',
'TimeNotify*' => 'tde_TimeNotify*',
'TimeWatcher*' => 'tde_TimeWatcher*',
'TimeZone&' => 'tde_TimeZone*',
'TimeZone*' => 'tde_TimeZone*',
'TmpGlobalComm&' => 'tde_TmpGlobalComm*',
'TmpGlobalComm' => 'tde_TmpGlobalComm*',
'TmpGlobalComm*' => 'tde_TmpGlobalComm*',
'TmpGlobalComm_base*' => 'tde_TmpGlobalComm_base*',
'TmpGlobalComm_skel*' => 'tde_TmpGlobalComm_skel*',
'TmpGlobalComm_stub*' => 'tde_TmpGlobalComm_stub*',
'ToolBarDock&'  =>  'int' ,
'ToolBarDock' => 'int',
'TraderOffer&' => 'tde_TraderOffer*',
'TraderOffer' => 'tde_TraderOffer*',
'TraderOffer*' => 'tde_TraderOffer*',
'TraderOffer_base*' => 'tde_TraderOffer_base*',
'TraderOffer_skel*' => 'tde_TraderOffer_skel*',
'TraderOffer_stub*' => 'tde_TraderOffer_stub*',
'TraderQuery&' => 'tde_TraderQuery*',
'TraderQuery' => 'tde_TraderQuery*',
'TraderQuery*' => 'tde_TraderQuery*',
'TraderQuery_base*' => 'tde_TraderQuery_base*',
'TraderQuery_skel*' => 'tde_TraderQuery_skel*',
'TraderQuery_stub*' => 'tde_TraderQuery_stub*',
'TransferJob*' => 'tde_TransferJob*',
'TreeWalker&' => 'tde_TreeWalker*',
'TreeWalker' => 'tde_TreeWalker*',
'TreeWalker*' => 'tde_TreeWalker*',
'TreeWalkerImpl*' => 'tde_TreeWalkerImpl*',
'True' => '1',
'Type&' => 'tde_Type*',
'Type' => 'int',
'Type*' => 'tde_Type*',
'TypeComponent&' => 'tde_TypeComponent*',
'TypeComponent*' => 'tde_TypeComponent*',
'TypeDef&' => 'tde_TypeDef*',
'TypeDef' => 'tde_TypeDef*',
'TypeDef*' => 'tde_TypeDef*',
'TypeEntry*' => 'tde_TypeEntry*',
'TypeInfo*' => 'tde_TypeInfo*',
'UChar&' => 'tde_UChar*',
'UChar' => 'tde_UChar*',
'UChar*' => 'tde_UChar*',
'UCharReference&' => 'tde_UCharReference*',
'UCharReference' => 'tde_UCharReference*',
'UCharReference*' => 'tde_UCharReference*',
'UDSAtom*' => 'tde_UDSAtom*',
'UIServer*' => 'tde_UIServer*',
'UIServer_stub*' => 'tde_UIServer_stub*',
'ULONG_MAX' => 'ULONG_MAX',
'UString&' => 'tde_UString*',
'UString' => 'tde_UString*',
'UString*' => 'tde_UString*',
'Undefined*' => 'tde_Undefined*',
'UndoInterface*' => 'tde_UndoInterface*',
'UndoRedoInfo*' => 'int*',
'UnixConnection*' => 'tde_UnixConnection*',
'UnixServer*' => 'tde_UnixServer*',
'VCardFormat*' => 'tde_VCardFormat*',
'VPort*' => 'tde_VPort*',
'Value&' => 'tde_Value*',
'Value' => 'tde_Value*',
'Value*' => 'tde_Value*',
'VerticalAlignment*' => 'int*',
'View*'  =>  'tde_View*' ,
'ViewCursorInterface*' => 'tde_ViewCursorInterface*',
'VoiceManager*' => 'tde_VoiceManager*',
'WFlags' => 'int',
'WId' => 'unsigned int',
'WState' => 'int',
'WavPlayObject&' => 'tde_WavPlayObject*',
'WavPlayObject' => 'tde_WavPlayObject*',
'WavPlayObject*' => 'tde_WavPlayObject*',
'WavPlayObject_base*' => 'tde_WavPlayObject_base*',
'WavPlayObject_skel*' => 'tde_WavPlayObject_skel*',
'WavPlayObject_stub*' => 'tde_WavPlayObject_stub*',
'WeakReference*' => 'tde_WeakReference*',
'WeakReferenceBase*' => 'tde_WeakReferenceBase*',
'Widget'  =>  'int' ,
'WidgetClass'  =>  'int' ,
'WidthMode' => 'int',
'Window' => 'tde_Window*',
'Window*' => 'tde_Window*',
'WindowArgs&' => 'tde_WindowArgs*',
'WindowArgs*' => 'tde_WindowArgs*',
'WindowsVersion'  =>  'int' ,
'XrmOptionDescRec*'  =>  'XrmOptionDescRec*' ,
'array_data*'  =>  'void*' ,
'bitarr_data*' => 'void*',
'bool&'  =>  'int' ,
'bool' => 'int',
'bool*' => 'int*',
'char*' => 'char*',
'char&'  =>  'char' ,
'char' => 'char',
'char* bugsEmailAddress @bugs.trinitydesktop.org"' => 'String',
'char*&' => 'char*',
'char*' => 'char*',
'char**' => 'char**',
'char*xpm[]'  =>  'char**' ,
'classConnection*' => 'tde_classConnection*',
'classDeviceManager*' => 'tde_classDeviceManager*',
'classExtensionLoader*' => 'tde_classExtensionLoader*',
'classMidiStatus*' => 'tde_classMidiStatus*',
'classObjectReference' => 'tde_classObjectReference*',
'classTQPainter*' => 'tde_classTQPainter*',
'classStartupClass*' => 'tde_classStartupClass*',
'double d .0' => 'double',
'double nDefault .0' => 'double',
'double pri .0' => 'double',
'double&'  =>  'double' ,
'double' => 'double',
'double*'  =>  'double*' ,
'false' => '0',
'float desat .3' => 'float',
'float&'  =>  'float' ,
'float' => 'float',
'float*' => 'float*',
'image_io_handler'  =>  'int' ,
'int a  |' => 'int',
'int buttonMask|Apply|Cancel' => 'int',
'int buttonMask|No|Cancel' => 'int',
'int desktop' => 'int',
'int&' => 'int',
'int' => 'int',
'int*' => 'int*',
'int short' => 'short',
'kdbgstream&'  => 'tde_Kdbgstream*' ,
'kdbgstream*'  =>  'tde_kdbgstream*',
'kndbgstream&'  => 'void**' ,
'kndbgstream*'  =>  'tde_kndbgstream*',
'ksockaddr_in*'  => 'void*' ,
'long _blockSize*' => 'long*',
'long int' => 'long',
'long unsigned int' => 'long',
'long&'  =>  'long' ,
'long' => 'long',
'long_blockSize*'  =>  'long_blockSize*' ,
'longint' => 'long',
'longunsigned int' => 'unsigned long',
'lt_dlhandle'  =>  'void*' ,
'lt_user_dlloader*'  =>  'tde_lt_user_dlloader*',
'mcopbyte&' => 'void*',
'mcopbyte' => 'unsigned char',
'mode_t _mode (mode_t) -1' => 'int',
'mode_t'  =>  'long' ,
'noteCmd' => 'tde_noteCmd*',
'noteCmd*' => 'tde_noteCmd*',
'ostream&' => 'int',
'ostream*' => 'int',
'pid_t'  =>  'long' ,
'poTime&' => 'tde_poTime*',
'poTime*' => 'tde_poTime*',
'short unsigned' => 'short',
'short' => 'short',
'short*' => 'short*',
'shortunsigned' => 'unsigned short',
'signed int&'  =>  'signed int' ,
'signed long&'  =>  'signed long' ,
'signed short&'  =>  'signed short' ,
'signed'  =>  'signed' ,
'size_t'  =>  'int' ,
'size_t*' => 'int*',
'size_type'  =>  'int' ,
'snd_seq_event_t*' => 'int*',
'ssize_t' => 'int',
'std*' => 'tde_std*',
'std::string&'  =>  'char*' ,
'std::string'  =>  'char*' ,
'time_t'  =>  'long' ,
'timeval&' => 'int',
'true' => '1',
'type&'  =>  'int' ,
'type*'  =>  'int*' ,
'type**'  =>  'int**' ,
'uchar&'  =>  'unsigned char' ,
'uchar'  =>  'unsigned char' ,
'uchar*' => 'unsigned char*',
'uchar**' => 'unsigned char**',
'uint&' => 'unsigned int',
'uint' => 'unsigned int',
'uint*'  =>  'unsigned int*' ,
'uintf~0'  =>  'unsigned int' ,
'ulong' => 'unsigned long',
'unsigned char&' => 'unsigned char',
'unsigned char'  =>  'unsigned char' ,
'unsigned char*'  =>  'unsigned char*' ,
'unsigned int&'  =>  'unsigned int' ,
'unsigned int'  =>  'unsigned int' ,
'unsigned int*'  =>  'int*' ,
'unsigned long int' => 'long',
'unsigned long&'  =>  'unsigned long' ,
'unsigned long'  =>  'unsigned long' ,
'unsigned short int'  =>  'unsigned short' ,
'unsigned short&'  =>  'unsigned short' ,
'unsigned short'  =>  'unsigned short' ,
'unsigned short*'  =>  'short*' ,
'unsigned shortint'  =>  'unsigned short' ,
'unsigned'  =>  'unsigned int' ,
'ushort' => 'unsigned short',
'ushort*'  =>  'short*' ,
'voice*' => 'int',
'void' => 'void',
'void(*)()'  =>  'void(*)()' ,
'void*' => 'void*',
'~' => '~',
'TQValueList<int>' => 'qt_QIntValueList*',
'TQValueList<int>&' => 'qt_QIntValueList*',
'TQValueList<TQIconDragItem>' => 'qt_QIconDragItemValueList*',
'TQValueList<TQIconDragItem>&' => 'qt_QIconDragItemValueList*',
'TQValueList<TQPixmap>' => 'qt_QPixmapValueList*',
'TQValueList<TQString>&' => 'qt_QStringValueList*',
'TQValueList<TQVariant>&' => 'qt_QVariantValueList*',
'TQValueList<TQUrlInfo>*' => 'qt_QUrlInfoValueList*',
'TQValueList<KDataToolInfo>&' => 'tde_KDataToolInfoValueList*',
'TQPtrList<TQDockWindow>*' => 'qt_QDockWindowPtrList*',
'TQPtrList<TQPixmap>' => 'qt_QPixmapPtrList*',
'TQPtrList<TQPoint>' => 'qt_QPointPtrList*',
'ClassContext*' => 'tde_ClassContext*',
'ClassStoreIface*' => 'tde_ClassStoreIface*',
'ClipboardDocumentIface*' => 'tde_ClipboardDocumentIface*',
'CodeCompletionDocumentIface*' => 'tde_CodeCompletionDocumentIface*',
'CursorDocumentIface*' => 'tde_CursorDocumentIface*',
'DebugDocumentIface*' => 'tde_DebugDocumentIface*',
'DocumentInterface*' => 'tde_DocumentInterface*',
'EditDocumentIface*' => 'tde_EditDocumentIface*',
'EditorInterface*' => 'tde_EditorInterface*',
'FileContext*' => 'tde_FileContext*',
'KDevAppFrontendIface*' => 'tde_KDevAppFrontendIface*',
'KDevCoreIface*' => 'tde_KDevCoreIface*',
'KDevMakeFrontendIface*' => 'tde_KDevMakeFrontendIface*',
'KEditor*' => 'tde_KEditor*',
'KEditor::Document*' => 'tde_Document*',
'ParsedClassContainer&' => 'tde_ParsedClassContainer*',
'ParsedContainer&' => 'tde_ParsedContainer*',
'ParsedScopeContainer&' => 'tde_ParsedScopeContainer*',
'TQValueList<ParsedMethod>*' => 'tde_ParsedMethodList*',
'TQValueList<CompletionEntry>' => 'tde_CompletionEntryValueList*',
'StatusDocumentIface*' => 'tde_StatusDocumentIface*',
'UndoDocumentIface*' => 'tde_UndoDocumentIface*',
'TDEShortcut&' => 'tde_TDEShortcut*',
'TDEShortcut' => 'tde_TDEShortcut*',
'TDEShortcut*' => 'tde_TDEShortcut*',
'KKey&' => 'tde_KKey*',
'KKey*' => 'tde_KKey*',
'KKeyNative&' => 'tde_KKeyNative*',
'KKeyNative*' => 'tde_KKeyNative*',
'KKeyVariations&' => 'tde_KKeyVariations*',
'KKeyVariations*' => 'tde_KKeyVariations*',
'KKeyX11&' => 'tde_KKeyX11*',
'KKeyX11' => 'tde_KKeyX11*',
'KKeyX11*' => 'tde_KKeyX11*',
'TDEAccelActions' => 'tde_TDEAccelActions*',
'KRandomSequence&' => 'tde_KRandomSequence*',
'TDEIcon::Context' => 'int',
'TDEIcon::Group' => 'int',
);


  # Initialize %builtins, used by resolveType
  my @noreflist = qw( const int char long double template 
		    unsigned signed float void bool true false uint 
		    uint32 uint64 extern static inline virtual operator );
  foreach my $r ( @noreflist ) {
     $builtins{ $r } = $r;
  }

}

sub interfacemap
{
	my ( $interfaceType )  = @_;
	return $interfacemap{$interfaceType};
}

sub ctypemap
{
	my ( $cType )  = @_;
	return $ctypemap{$cType};
}

sub setctypemap
{
	my ( $cType, $cValue )  = @_;

	$ctypemap{$cType} = $cValue;
	return;
}

sub addNamespace
{
	my ( $className )  = @_;

	if ( $className =~ /Bridge$/ ) {
		return $className;
	}

	if ( $className =~ /^(AbstractView|Attr|CDATASection|CSSCharsetRule|CSSException|CSSFontFaceRule|CSSImportRule|CSSMediaRule|CSSPageRule|CSSPrimitiveValue|CSSRule|CSSRuleList|CSSStyleDeclaration|CSSStyleRule|CSSStyleSheet|CSSUnknownRule|CSSValue|CSSValueList|CharacterData|Comment|Counter|CustomNodeFilter|DOMException|DOMImplementation|DOMString|Document|DocumentFragment|DocumentStyle|DocumentType|DomShared|Element|Entity|EntityReference|EventException|EventListener|LinkStyle|MediaList|MutationEvent|NamedNodeMap|Node|NodeFilter|NodeIterator|NodeList|Notation|ProcessingInstruction|RGBColor|Range|RangeException|Rect|StyleSheet|StyleSheetList|Text|TreeWalker|UIEvent|HTML.*)/ )
	{
		return "DOM::".$className;
	}

	if ( $className =~ /^(BrowserExtension|BrowserHostExtensionBrowserInterface|ComponentFactory|DockMainWindow|Event|Factory|GUIActivateEvent|HistoryProvider|MainWindow|OpenURLEvent|Part|PartActivateEvent|PartBase|PartManager|PartSelectEvent|Plugin|PluginInfo|ReadOnlyPart|ReadWritePart|URLArgs|WindowArgs)/ )
	{
		return "KParts::".$className;
	}

	if ( $className =~ /^(AuthInfo|AutoLogin|CacheInfo|ChmodJob|Connection|CopyInfo|CopyJob|DefaultProgress|DeleteJob|FileCopyJob|Job|ListJob|MetaData|MimetypeJob|MultiGetJob|NetAccess|NetRC|PasswordDialog|PreviewJob|ProgressBase|RenameDlg|Scheduler|SessionData|SimpleJob|SkipDlg|Slave|SlaveBase|SlaveConfig|SlaveInterface|StatJob|StatusbarProgress|TCPSlaveBase|Task|TransferJob|UDSAtom)/ )
	{
		return "TDEIO::".$className;
	}

	if ( $className =~ /^(DrawContentsEvent|MouseDoubleClickEvent|MouseEvent|MouseMoveEvent|MousePressEvent|MouseReleaseEvent)/ )
	{
		return "tdehtml::".$className;
	}

	if ( $className =~ /^(OfferList)/ )
	{
		return "TDETrader::".$className;
	}

	if ( $className =~ /^(BlockSelectionInterface|ClipboardInterface|CodeCompletionInterface|CompletionEntry|ConfigInterface|Cursor|CursorInterface|Document|EditInterface|Editor|HighlightingInterface|Mark|MarkInterface|PopupMenuInterface|PrintInterface|SearchInterface|SelectionInterface|UndoInterface|View|ViewCursorInterface)/ )
	{
		return "KTextEditor::".$className;
	}


	return $className;
}


# Helper for resolveType. This one is recursive and returns undef if not found.
sub resolveTypeInternal($$$)
{
	my ( $argType, $contextClass, $rootnode ) = @_;

	#print "resolveTypeInternal type:'$argType' context:'$contextClass->{astNodeName}' ($contextClass)\n";

	my $contextClassName = join( "::", kdocAstUtil::heritage($contextClass) );

	# 'A' resolves to 'A' in context 'A' ;)  (i.e. classname itself)
	return $contextClassName if ( $argType eq $contextClass->{astNodeName} );

	# Try as an identifier of contextClass
	#print "Trying as ".$contextClassName."::".$argType."\n";

	my $node = kdocAstUtil::findRef( $rootnode, $contextClassName."::".$argType );

	#print "Found as $node->{NodeType}\n" if $node;

	return $contextClassName."::".$argType if ( $node
		 && $node->{NodeType} ne 'method'
		 && $node->{NodeType} ne 'deleted'
	         && $node->{NodeType} ne 'var' );

	my $found;

	# Then look at ancestors, and try for each one
	Iter::Ancestors( $contextClass, $rootnode, undef, undef,
		   sub {
		     my ( $ances, $name, $type, $template ) = @_;
		     unless ($found) {
			$found = resolveTypeInternal( $argType, $ances, $rootnode );
		     }
		   },
		   undef
		 );

	return $found;
}

=head2

  Look up a type, following the class hierarchy.
  e.g. "Mode", if ContextClassName is A, will be looked as A::Mode,
  then as B::Mode (if B is a parent class of A), then as TQt::Mode,
  then as just Mode.

=cut

sub resolveType($$$)
{
	my ( $argType, $contextClass, $rootnode ) = @_;
	$argType =~ s/\s*(\*)\s*$/$1/g; # remove space before *
	#print "resolveType: '$argType'\n";

	# Look for builtin words (int etc.)
	return $builtins{ $argType } if exists $builtins{ $argType };

        # take recursive care of templated types
	if($argType =~ /([\w_]+\s*)<(.*)>/) {
	    my $tmpl = $2;
            my $before = $`.$1;
            my $after = $';
            my @args = kdocUtil::splitUnnested( ',', $tmpl);
            grep s/^\s+//, @args;
            grep s/\s+$//, @args;
            for my $a(@args) {
		$a = resolveType( $a, $contextClass, $rootnode );
            }
            # normalize
	    $argType = $before."<".join( ", ", @args).">".$after;
		$argType =~ s/>>/> >/g;  # Nested template types must have a space
        }

	# Parse 'const' in front of it, and '*' or '&' after it
	my $prefix = $argType =~ s/^const\s+// ? 'const ' : '';
	my $suffix = $argType =~ s/\s*([\&\*]+)$// ? $1 : '';
	#print "resolveType: prefix:$prefix, '$argType', suffix:$suffix\n";

	# Launch the (possibly recursive) resolveTypeInternal
	my $result = resolveTypeInternal( $argType, $contextClass, $rootnode );
	return $prefix.$result.$suffix if $result;

	# If the parent is a namespace, have a look there
	if ($contextClass->{Parent} && $contextClass->{Parent}->{NodeType} eq 'namespace') {
		$result = resolveTypeInternal( $argType, $contextClass->{Parent}, $rootnode );
		return $prefix.$result.$suffix if $result;
	}
	
	# Not found, so look as a toplevel class
	#print "Checking that ".$argType." exists.\n";
	return $prefix.$argType.$suffix if ( kdocAstUtil::findRef( $rootnode, $argType ) );

	#print "resolveType: $argType not found (context $contextClass->{astNodeName})\n\n";

	return $prefix.$argType.$suffix;
}

1;
