use ExtUtils::MakeMaker;
use Config;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

print "Trying to find some configuration information...\n";
my $tde_dirs = $ENV{TDEDIRS} || '/opt/trinity';
my $qt_dir = $ENV{QTDIR} || '/opt/trinity/lib';
my $tde_inc = "$tde_dirs/include";
my $tde_lib = "$tde_dirs/lib";
my $qt_inc = "$qt_dir/include";
my $qt_lib = "$qt_dir/lib";
$tde_inc = undef unless -f "$tde_inc/dcopclient.h";
$tde_lib = undef unless -f "$tde_lib/libDCOP.$Config{dlext}";
$qt_dir = undef unless -f "$qt_inc/qglobal.h";

print "Path to Qt headers? [$qt_inc]: ";
chomp $input, $qt_inc = $input if (($input = <>) =~ /\S/);
print "Path to Qt libraries? [$qt_lib]: ";
chomp $input, $qt_lib = $input if (($input = <>) =~ /\S/);
print "Path to TDE headers? [$tde_inc]: ";
chomp $input, $tde_inc = $input if (($input = <>) =~ /\S/);
print "Path to TDE libraries? [$tde_lib]: ";
chomp $input, $tde_lib = $input if (($input = <>) =~ /\S/);

WriteMakefile(
    NAME	=> 'DCOP',
    VERSION_FROM => 'DCOP.pm',
    INC		=> "-I$qt_inc -I$tde_inc -I/usr/include/tqt",
    LIBS	=> "-L$qt_lib -ltqt-mt -L$tde_lib -ltdecore -lDCOP",
    XS		=> {'DCOP.xs' => 'DCOP.cpp'},
    XSOPT	=> '-C++',
    CCFLAGS	=> '-x c++',
);

sub MY::xs_c {
    package MY;
    my $hack = shift->SUPER::xs_c(@_);
    $hack =~ s/\.c/.cpp/g;
    $hack;
}

