/***************************************************************************
 *   Copyright (C) 1999-2001 by Bernd Gehrmann                             *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _MAKEWIDGET_H_
#define _MAKEWIDGET_H_

#include <tqptrstack.h>
#include <tqregexp.h>
#include <tqtextedit.h>
#include <tqvaluevector.h>
#include <tqintdict.h>

#include "outputfilter.h"
#include "directorystatusmessagefilter.h"
#include "compileerrorfilter.h"
#include "commandcontinuationfilter.h"
#include "makeactionfilter.h"
#include "otherfilter.h"
#include "makeitem.h"

class MakeViewPart;
class MakeItem;
class TDEProcess;
class ProcessLineMaker;
class KURL;

namespace KTextEditor { class Document; }

class MakeWidget : public TQTextEdit
{
    Q_OBJECT
  

public:
    MakeWidget(MakeViewPart *part);
    ~MakeWidget();

    void queueJob(const TQString &dir, const TQString &command);
    bool isRunning();
    void updateSettingsFromConfig();
    void processLine( const TQString& line );

public slots:
    void startNextJob();
    void killJob();
    void nextError();
    void prevError();
    void copy();

protected:
    virtual TQPopupMenu *createPopupMenu( const TQPoint& pos );
    virtual void contentsMouseReleaseEvent( TQMouseEvent* e );

private slots:
    void insertStdoutLine(const TQCString& line);
    void insertStderrLine(const TQCString& line);
    void storePartialStdoutLine(const TQCString& line);
    void storePartialStderrLine(const TQCString& line);
    void slotProcessExited(TDEProcess *);
    void verticScrollingOn() { m_vertScrolling = true; }
    void verticScrollingOff() { m_vertScrolling = false; }
    void horizScrollingOn() { m_horizScrolling = true; }
    void horizScrollingOff() { m_horizScrolling = false; }
    void toggleLineWrapping();
    void slotVeryShortCompilerOutput();
    void slotShortCompilerOutput();
    void slotFullCompilerOutput();
    void toggleShowDirNavigMessages();
    void slotEnteredDirectory( EnteringDirectoryItem* );
    void slotExitedDirectory( ExitingDirectoryItem* );
    void insertItem( MakeItem* );

private:
    void specialCheck( const TQString& file, TQString& fName ) const;
    virtual void keyPressEvent(TQKeyEvent *e);
    void searchItem(int parag);
    TQString guessFileName( const TQString& fName, int parag ) const;
    TQString directory(int parag) const;
    bool brightBg();
    void refill();
    void createCursor(ErrorItem* e, KTextEditor::Document* doc);

    bool scanErrorForward(int parag);
    bool scanErrorBackward(int parag);

    DirectoryStatusMessageFilter  m_directoryStatusFilter;
    CompileErrorFilter            m_errorFilter;
    CommandContinuationFilter     m_continuationFilter;
    MakeActionFilter              m_actionFilter;
    OtherFilter                   m_otherFilter;

    void setPendingItem(MakeItem* new_item);
    void displayPendingItem();
	bool appendToLastLine( const TQString& text );
	void setCompilerOutputLevel(EOutputLevel level);

    TQStringList commandList;
    TQStringList dirList;
    TQString m_lastBuildDir; //stores directory of last build, for the case we don't have proper path information
    TQString currentCommand;
    TDEProcess *childproc;
    ProcessLineMaker* procLineMaker;
    TQPtrStack<TQString> dirstack;
    MakeItem* m_pendingItem;
    TQValueVector<MakeItem*> m_items;
    TQIntDict<MakeItem> m_paragraphToItem;
    long m_paragraphs;
    int m_lastErrorSelected;

    MakeViewPart *m_part;

    bool m_vertScrolling, m_horizScrolling;
    bool m_bCompiling;

    TQCString stderrbuf;
    TQCString stdoutbuf;

    bool m_bLineWrapping;
    EOutputLevel m_compilerOutputLevel;
};

#endif
