/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey                                   *
 *   linux@jrockey.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "filecreate_filedialog.h"

#include <tqfileinfo.h>
#include <tdeversion.h>
#include <kurlcombobox.h>
#include <kdebug.h>

#include "filecreate_part.h"
#include "filecreate_filetype.h"

namespace FileCreate {

  FileDialog::FileDialog(const TQString& startDir, const TQString& filter,
                         TQWidget *parent, const char *name,
                         bool modal, TQWidget * extraWidget) :
    KFileDialog(startDir, filter, parent, name, modal, extraWidget) {

    setOperationMode(Saving);

    m_extraWidget = extraWidget;
    m_typeChooser = dynamic_cast<TypeChooser*>(extraWidget);

    connect(this, TQT_SIGNAL(filterChanged(const TQString &)), this, TQT_SLOT(slotActionFilterChanged(const TQString &)) );
    connect(locationEdit, TQT_SIGNAL(textChanged(const TQString &)), this, TQT_SLOT(slotActionTextChanged(const TQString &)) );

  }

  FileDialog::~FileDialog() { }


  void FileDialog::initGUI()
  {
    KFileDialog::initGUI();
  }

  void FileDialog::slotActionFilterChanged(const TQString & /*filter*/) {
  }

  void FileDialog::slotActionTextChanged(const TQString & text) {
    kdDebug(9034) << "slotActionTextChanged - " << text << endl;
    if (!m_typeChooser) return;
    TQString ext = TQFileInfo(text).extension();
    kdDebug(9034) << "Extension is: " << ext << endl;
    FileType * filetype = m_typeChooser->part()->getType(ext);
    if (!filetype) return;
    kdDebug(9034) << "found matching extension: " << ext << endl;
    kdDebug(9034) << "Description: " << filetype->descr() << endl;
    m_typeChooser->setCurrent(filetype);
  }



}

#include "filecreate_filedialog.moc"
