/***************************************************************************
 *   Copyright (C) 2001 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DIGRAPHVIEW_H_
#define _DIGRAPHVIEW_H_

#include <tqptrlist.h>
#include <tqscrollview.h>
#include <tqstringlist.h>
#include <tqimage.h>

class DigraphNode;
class DigraphEdge;


class DigraphView : public TQScrollView
{
    Q_OBJECT
  
    
public:
    DigraphView(TQWidget *parent, const char *name);
    ~DigraphView();

    void addEdge(const TQString &name1, const TQString &name2);
    void process(const TQString& file = "", const TQString& ext = "");
    void clear();
    void setSelected(const TQString &name);
    void ensureVisible(const TQString &name);
    
signals:
    void selected(const TQString &name);

protected:
    virtual void drawContents(TQPainter* p, int clipx, int clipy, int clipw, int cliph);
    virtual void contentsMousePressEvent(TQMouseEvent *e);
    virtual TQSize sizeHint() const;

private:
    int toXPixel(double x);
    int toYPixel(double x);

    void setRenderedExtent(double w, double h);
    void addRenderedNode(const TQString &name,
                         double x, double y, double w, double h);
    void addRenderedEdge(const TQString &name1, const TQString &name2,
                         TQMemArray<double> coords);
    static TQStringList splitLine(TQString str);
    void parseDotResults(const TQStringList &list);
    
    double xscale, yscale;
    int width, height;
    TQStringList inputs;
    TQPtrList<DigraphNode> nodes;
    TQPtrList<DigraphEdge> edges;
    DigraphNode *selNode;
};

#endif
