/***************************************************************************
 *   Copyright (C) 2002-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pcombobox.h"

#include <tqcombobox.h>
#include <tqlayout.h>

namespace PropertyLib{

PComboBox::PComboBox(MultiProperty *property, const TQMap<TQString, TQVariant> &list, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name), m_valueList(list)
{
    init(false);
}

PComboBox::PComboBox(MultiProperty *property, const TQMap<TQString, TQVariant> &list, bool rw, TQWidget *parent, const char *name)
    :PropertyWidget(property, parent, name), m_valueList(list)
{
    init(rw);
}

void PComboBox::init(bool rw)
{
    TQHBoxLayout *l = new TQHBoxLayout(this, 0, 0);
    m_edit = new TQComboBox(rw, this);
    m_edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(m_edit);
    
    fillBox();
    
    connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
}

void PComboBox::fillBox()
{
    for (TQMap<TQString, TQVariant>::const_iterator it = m_valueList.begin(); it != m_valueList.end(); it++)
    {
        m_edit->insertItem(it.key());
    }
}

TQVariant PComboBox::value() const
{
    TQMap<TQString, TQVariant>::const_iterator it = m_valueList.find(m_edit->currentText());
    if (it == m_valueList.end())
        return TQVariant("");
    return TQVariant(it.data());
}

void PComboBox::setValue(const TQVariant &value, bool emitChange)
{
    if (!value.isNull())
    {
        disconnect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
        m_edit->setCurrentText(findDescription(value));
        connect(m_edit, TQT_SIGNAL(activated(int)), this, TQT_SLOT(updateProperty(int)));
        if (emitChange)
            emit propertyChanged(m_property, value);
    }
}

void PComboBox::updateProperty(int /*val*/)
{
    emit propertyChanged(m_property, value());
}

TQString PComboBox::findDescription(const TQVariant &value)
{
    for (TQMap<TQString, TQVariant>::const_iterator it = m_valueList.begin(); it != m_valueList.end(); ++ it)
    {
        if (it.data() == value)
            return it.key();
    }
    return "";
}

void PComboBox::setValueList(const TQMap<TQString, TQVariant> &valueList)
{
    m_valueList = valueList;
    m_edit->clear();
    fillBox();
}

}

#ifndef PURE_QT
#include "pcombobox.moc"
#endif

