/* This file is part of the KDE project
   Copyright (C) 2002 John Firebaugh <jfirebaugh@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef _PROCESSLINEMAKER_H_
#define _PROCESSLINEMAKER_H_

#include <tqobject.h>

/**
@file processlinemaker.h
Utility objects for process output views.
*/

class TDEProcess;

/**
Convenience class to catch output of TDEProcess.
*/
class ProcessLineMaker : public TQObject
{
Q_OBJECT
  

public:
	ProcessLineMaker();
	ProcessLineMaker( const TDEProcess* );

	void clearBuffers();
	void flush();

public slots:
	void slotReceivedStdout(const char*);
	void slotReceivedStderr(const char*);

protected slots:
	void slotReceivedStdout(TDEProcess *, char *buffer, int buflen);
	void slotReceivedStderr(TDEProcess *, char *buffer, int buflen);

signals:
	void receivedStdoutLine( const TQCString& line );
        void receivedStderrLine( const TQCString& line );
        void receivedPartialStdoutLine( const TQCString& line );
        void receivedPartialStderrLine( const TQCString& line );

private:
	TQCString stdoutbuf;
	TQCString stderrbuf;
};

#endif
