/***************************************************************************
*   Copyright (C) 2004 by ian geiser                                      *
*   geiseri@sourcextreme.com                                              *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/
#ifndef TDEScriptAction_H
#define TDEScriptAction_H

#include <scriptclientinterface.h>
#include <tqobject.h>
#include <tqptrlist.h>

class TDEAction;
class TDEActionCollection;
class KScriptInterface;
class KScriptActionManager;
class TQTimer;

/**
* Connects a TDEAction to a script runner.
* 
* @author ian geiser geiseri@sourcextreme.com
*/
class KScriptAction : public TQObject, public KScriptClientInterface {
    Q_OBJECT
  
public:

    KScriptAction( const TQString &scriptDesktopFile, TQObject *interface, TDEActionCollection *ac );

    virtual ~KScriptAction();

    /**
    * TDEAction for the current script
     */
    TDEAction *action();

    /**
    * Returns the validity of the current script.
     */
    bool isValid() const;
    
signals:
    // Reimplemented from KScript
    void error ( const TQString &msg );
    void warning ( const TQString &msg );
    void output ( const TQString &msg );
    void progress ( int percent );
    void done ( KScriptClientInterface::Result result, const TQVariant &returned );

signals:
    void scriptError ( const TQString &msg );
    void scriptWarning ( const TQString &msg );
    void scriptOutput ( const TQString &msg );
    void scriptProgress ( int percent );
    void scriptDone ( KScriptClientInterface::Result result, const TQVariant &returned );

private slots:
    void activate();
    void cleanup();
    void scriptFinished();

private:
    TDEAction *m_action;
    TQString m_scriptName;
    TQString m_scriptType;
    TQString m_scriptFile;
    TQString m_scriptMethod;
    KScriptInterface *m_interface;
    bool m_isValid;
    TQTimer *m_timeout;
    uint m_refs;
};

/**
 * Provides an actionlist of scripts that are currently available.
 * Scripts are not actually loaded until they are actually executed.
 * @author ian geiser <geiseri@sourcextreme.com>
 */
class KScriptActionManager : public TQObject {
Q_OBJECT
  

public:
    /**
    * Create a script manager that is attached to an action collection.
     */
    KScriptActionManager( TQObject *parent, TDEActionCollection *ac );
    ~KScriptActionManager();

    /**
    * Return all currently loaded scripts in a direcotry and attaches them
    * to a TQObject interface.  If the dirs are empty the current applications
    * scripts directory is used.  The dirs are actual directories to search
    * in the $KDEPATH/data/ direcories.  So if you add "coolapp/data" then
    * the manager will search in $KDEPATH/data/coolapp/data for all desktop
    * files that are scripts.
     */
    TQPtrList<TDEAction> scripts( TQObject *interface, const TQStringList &dirs = TQStringList() ) const;

signals:
    /**
    * Returns an error message from a script.
    */
    void scriptError ( const TQString &msg );
    /**
    * Returns a warning message from a script.
    */
    void scriptWarning ( const TQString &msg );
    /**
    * Returns a standard out message from a script.
    */
    void scriptOutput ( const TQString &msg );
    /**
    * Returns the percentage complete of an operation in the script.
    */
    void scriptProgress ( int percent );
    /**
    * Notifies that the script has finished.
    */
    void scriptDone( KScriptClientInterface::Result result, const TQVariant &returned );

private:
    mutable TQPtrList<KScriptAction> m_actions;
    TDEActionCollection *m_ac;
};
#endif
