/***************************************************************************
 *   Copyright (C) 2003 by Roberto Raggi                                   *
 *   roberto@kdevelop.org                                                  *
 *                                                                         *
 *   Copyright (C) 2006 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdelistbox.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include <kdebug.h>
#include <klineedit.h>
#include <tdemessagebox.h>
#include <tdelocale.h>

#include <tqfile.h>
#include <tqdir.h>
#include <tqregexp.h>
#include <cstdlib>

#include "settingsdialog.h"

TQListBoxItem* TQListBox_selectedItem(TQListBox* cpTQListBox)
{
    if ( cpTQListBox->selectionMode() != TQListBox::Single )
    return 0;
    if ( cpTQListBox->isSelected( cpTQListBox->currentItem() ) )
    return  cpTQListBox->item(cpTQListBox->currentItem());
    return 0;
}

SettingsDialog::SettingsDialog(TQWidget* parent, const char* name, WFlags fl)
    : SettingsDialogBase(parent,name,fl)
{
    TQStringList qtdirs;
	qtdirs.push_back( ::getenv("QTDIR") + TQString("/include") );
	qtdirs.push_back( TQString::fromLocal8Bit(::getenv("HOME")) + "/dev/qt/include" );
	qtdirs.push_back( TQString::fromLocal8Bit(::getenv("HOME")) + "/dev/qt-main/include" );
	qtdirs.push_back( "/usr/qt/4/include" );

    for( TQStringList::Iterator it=qtdirs.begin(); it!=qtdirs.end(); ++it )
    {
        TQString qtdir = *it;
        if( !qtdir.isEmpty() && isValidTQtDir(qtdir) )
            if (!qtListBox->findItem(qtdir, ExactMatch))
                qtListBox->insertItem( qtdir );
    }

	qtUrl->setMode( KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly );

	connect( addUrlButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(addUrlButton_clicked()) );
}

SettingsDialog::~SettingsDialog()
{
}

void SettingsDialog::slotSelectionChanged(TQListBoxItem* item)
{
    if( !qtListBox->selectedItem() )
	{
        emit enabled( false );
        return;
    }


    emit enabled( true );
}

bool SettingsDialog::isValidTQtDir( const TQString & path ) const
{
    return TQFile::exists( path + "/TQtCore/TQtCore" );
}

TQString SettingsDialog::qtDir( ) const
{
    return qtListBox->currentText();
}

TQString SettingsDialog::configuration( ) const
{
    return "";
}

void SettingsDialog::addUrlButton_clicked( )
{
	kdDebug(9000) << k_funcinfo << endl;

	if ( isValidTQtDir( qtUrl->url() ) )
	{
		qtListBox->insertItem( qtUrl->url() );
		if ( TQListBoxItem * item = qtListBox->findItem( qtUrl->url(), ExactMatch ) )
		{
			qtListBox->setSelected( item, true );
		}
		qtUrl->lineEdit()->clear();
	}
	else
	{
		KMessageBox::error( this, i18n("This does not appear to be a valid TQt4 include directory.\nPlease select a different directory."), i18n("Invalid Directory") );
	}
}


#include "settingsdialog.moc"
