#include <tqlabel.h>
#include <tqpainter.h>
#include <tqmessagebox.h>

#include <tqpe/applnk.h> // for AppLnk
#include <tqpe/resource.h> // for Resource loading

#include "%{APPNAMELC}.h"


%{APPNAME}::%{APPNAME}(TQWidget *parent)
    : TQWidget( parent,  "%{APPNAME} Applet" ) {
/*
 * we will load an Image, scale it for the right usage
 * remember your applet might be used by different
 * resolutions.
 * Then we will convert the image back to an Pixmap
 * and draw this Pimxap. We need to use Image because its
 * the only class that allows scaling.
 */

    TQImage image = Resource::loadImage("%{APPNAMELC}/%{APPNAMELC}");
    /*
     * smooth scale to AppLnk smallIconSize for applest
     * smallIconSize gets adjusted to the resolution
     * so on some displays like SIMpad and a C-750 the smallIconSize
     * is greater than on a iPAQ h3870
     */
    image = image.smoothScale(AppLnk::smallIconSize(), AppLnk::smallIconSize() );

    /*
     * now we need to convert the Image to a Pixmap cause these
     * can be drawn more easily
     */
    m_pix = new TQPixmap();
    m_pix->convertFromImage( image );

    /*
     * Now we will say that we don't want to be bigger than our
     * Pixmap
     */
    setFixedHeight(AppLnk::smallIconSize() );
    setFixedWidth( AppLnk::smallIconSize() );

}

%{APPNAME}::~%{APPNAME}() {
    delete m_pix;
}


/*
 * here you would normal show or do something
 * useful. If you want to show a widget at the top left
 * of your icon you need to map your rect().topLeft() to
 * global with mapToGlobal(). Then you might also need to
 * move the widgets so it is visible
 */
void %{APPNAME}::mousePressEvent(TQMouseEvent* ) {
    TQMessageBox::information(this, tr("No action taken"),
                             tr("<qt>This Plugin does not yet support anything usefule aye.</qt>"),
                             TQMessageBox::Ok );

}

void %{APPNAME}::paintEvent( TQPaintEvent* ) {
    TQPainter p(this);

    /* simpy draw the pixmap from the start of this widget */
    p.drawPixmap(0, 0,  *m_pix );
}

/*
 * Here comes the implementation of the interface
 */
%{APPNAME}Impl::%{APPNAME}Impl() {
}
/* needed cause until it is only pure virtual */
%{APPNAME}Impl::~%{APPNAME}Impl() {
    /*
     * we will delete our applets as well
     * setAUtoDelete makes the TQList free
     * the objects behind the pointers
     */
    m_applets.setAutoDelete( true );
    m_applets.clear();
}

/*
 * For the taskbar interface return a Widget
 */
TQWidget* %{APPNAME}Impl::applet( TQWidget* parent ) {
    /*
     * There are problems with ownership. So we add
     * our ownlist and clear this;
     */
    %{APPNAME}* ap = new %{APPNAME}( parent );
    m_applets.append( ap );

    return ap;
}

/*
 * A small hint where the Applet Should be displayed
 */
int %{APPNAME}Impl::position()const {
    return 1;
}


/*
 * Now the important TQUnkownInterface method without
 * this one your applet won't load
 * @param uuid The uuid of the interface
 * @param iface The pointer to the interface ptr
 */
TQRESULT %{APPNAME}Impl::queryInterface( const TQUuid& uuid, TQUnknownInterface** iface) {
    /* set the pointer to the interface to 0 */
    *iface = 0;

    /*
     * we check if we support the requested interface
     * and then assign to the pointer.
     * You may alos create another interface here so
     * *iface = this is only in this simple case true you
     * could also support more interfaces.
     * But this example below is the most common use.
     * Now the caller knows that the Interface Pointer
     * is valid and the interface supported
     */
    if ( uuid == IID_TQUnknown )
        *iface = this;
    else if ( uuid == IID_TaskbarApplet )
        *iface = this;
    else
        return TQS_FALSE;

    if ( *iface )
        (*iface)->addRef();

    return TQS_OK;
}


/*
 * Finally we need to export the Interface.
 * CREATE_INSTANCE creates a interface and calls
 * queryInterface for the TQUnknownInterface once
 * With out this function the applet can't be loaded.
 *
 * NOTE: If your applet does not load it's likely you've an
 * unresolved symbol. Change the .pro TEMPLATE = lib to TEMPLATE= app
 * and recompile. If the linker only complains about a missing
 * main method the problem is more complex. In most cases it'll say
 * you which symbols are missing and you can implement them.
 * The main(int argc, char* argv[] ) does not need to be
 * included in a library so it's ok that the linker complains
 */
TQ_EXPORT_INTERFACE() {
    TQ_CREATE_INSTANCE( %{APPNAME}Impl )
}

