/**********************************************************************
** Copyright (C) 2001 Trolltech AS.  All rights reserved.
**
** This file is part of TQt Designer.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid TQt Enterprise Edition or TQt Professional Edition
** licenses may use this file in accordance with the TQt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/gpl/ for GPL licensing information.
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about TQt Commercial License Agreements.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef FILECHOOSER_H
#define FILECHOOSER_H

#include <tqwidget.h>

class TQLineEdit;
class TQPushButton;

class FileChooser : public TQWidget
{
    Q_OBJECT
  

    TQ_ENUMS( Mode )
    TQ_PROPERTY( Mode mode READ mode WRITE setMode )
    TQ_PROPERTY( TQString fileName READ fileName WRITE setFileName )

public:
    FileChooser( TQWidget *parent = 0, const char *name = 0);

    enum Mode { File, Directory };

    TQString fileName() const;
    Mode mode() const;

public slots:
    void setFileName( const TQString &fn );
    void setMode( Mode m );

signals:
    void fileNameChanged( const TQString & );

private slots:
    void chooseFile();

private:
    TQLineEdit *lineEdit;
    TQPushButton *button;
    Mode md;

};

#endif
