/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "rtfcontrolwords.hxx"
#include <oox/token/namespaces.hxx>
#include <cstring>

namespace writerfilter
{
namespace rtftok
{
RTFSymbol const aRTFControlWords[] = {
    // sKeyword nControlType nIndex
    { "'", CONTROL_SYMBOL, RTF_HEXCHAR, 0 },
    { "-", CONTROL_SYMBOL, RTF_OPTHYPH, 0 },
    { "*", CONTROL_SYMBOL, RTF_IGNORE, 0 },
    { ":", CONTROL_SYMBOL, RTF_SUBENTRY, 0 },
    { "\\", CONTROL_SYMBOL, RTF_BACKSLASH, 0 },
    { "\n", CONTROL_SYMBOL, RTF_PAR, 0 },
    { "\r", CONTROL_SYMBOL, RTF_PAR, 0 },
    { "\r\n", CONTROL_SYMBOL, RTF_PAR, 0 },
    { "_", CONTROL_SYMBOL, RTF_NOBRKHYPH, 0 },
    { "{", CONTROL_SYMBOL, RTF_LBRACE, 0 },
    { "|", CONTROL_SYMBOL, RTF_FORMULA, 0 },
    { "}", CONTROL_SYMBOL, RTF_RBRACE, 0 },
    { "~", CONTROL_SYMBOL, RTF_NOBREAK, 0 },
    { "ab", CONTROL_TOGGLE, RTF_AB, 1 },
    { "absh", CONTROL_VALUE, RTF_ABSH, 0 },
    { "abslock", CONTROL_FLAG, RTF_ABSLOCK, 0 },
    { "absnoovrlp", CONTROL_TOGGLE, RTF_ABSNOOVRLP, 1 },
    { "absw", CONTROL_VALUE, RTF_ABSW, 0 },
    { "acaps", CONTROL_TOGGLE, RTF_ACAPS, 1 },
    { "acccircle", CONTROL_TOGGLE, RTF_ACCCIRCLE, 1 },
    { "acccomma", CONTROL_TOGGLE, RTF_ACCCOMMA, 1 },
    { "accdot", CONTROL_TOGGLE, RTF_ACCDOT, 1 },
    { "accnone", CONTROL_TOGGLE, RTF_ACCNONE, 1 },
    { "accunderdot", CONTROL_TOGGLE, RTF_ACCUNDERDOT, 1 },
    { "acf", CONTROL_VALUE, RTF_ACF, 0 },
    { "adeff", CONTROL_VALUE, RTF_ADEFF, 0 },
    { "additive", CONTROL_FLAG, RTF_ADDITIVE, 0 },
    { "adeflang", CONTROL_VALUE, RTF_ADEFLANG, 0 },
    { "adjustright", CONTROL_FLAG, RTF_ADJUSTRIGHT, 0 },
    { "adn", CONTROL_VALUE, RTF_ADN, 6 },
    { "aenddoc", CONTROL_FLAG, RTF_AENDDOC, 0 },
    { "aendnotes", CONTROL_FLAG, RTF_AENDNOTES, 0 },
    { "aexpnd", CONTROL_VALUE, RTF_AEXPND, 0 },
    { "af", CONTROL_VALUE, RTF_AF, 0 },
    { "afelev", CONTROL_FLAG, RTF_AFELEV, 0 },
    { "afs", CONTROL_VALUE, RTF_AFS, 24 },
    { "aftnbj", CONTROL_FLAG, RTF_AFTNBJ, 0 },
    { "aftncn", CONTROL_DESTINATION, RTF_AFTNCN, 0 },
    { "aftnnalc", CONTROL_FLAG, RTF_AFTNNALC, 0 },
    { "aftnnar", CONTROL_FLAG, RTF_AFTNNAR, 0 },
    { "aftnnauc", CONTROL_FLAG, RTF_AFTNNAUC, 0 },
    { "aftnnchi", CONTROL_FLAG, RTF_AFTNNCHI, 0 },
    { "aftnnchosung", CONTROL_FLAG, RTF_AFTNNCHOSUNG, 0 },
    { "aftnncnum", CONTROL_FLAG, RTF_AFTNNCNUM, 0 },
    { "aftnndbar", CONTROL_FLAG, RTF_AFTNNDBAR, 0 },
    { "aftnndbnum", CONTROL_FLAG, RTF_AFTNNDBNUM, 0 },
    { "aftnndbnumd", CONTROL_FLAG, RTF_AFTNNDBNUMD, 0 },
    { "aftnndbnumk", CONTROL_FLAG, RTF_AFTNNDBNUMK, 0 },
    { "aftnndbnumt", CONTROL_FLAG, RTF_AFTNNDBNUMT, 0 },
    { "aftnnganada", CONTROL_FLAG, RTF_AFTNNGANADA, 0 },
    { "aftnngbnum", CONTROL_FLAG, RTF_AFTNNGBNUM, 0 },
    { "aftnngbnumd", CONTROL_FLAG, RTF_AFTNNGBNUMD, 0 },
    { "aftnngbnumk", CONTROL_FLAG, RTF_AFTNNGBNUMK, 0 },
    { "aftnngbnuml", CONTROL_FLAG, RTF_AFTNNGBNUML, 0 },
    { "aftnnrlc", CONTROL_FLAG, RTF_AFTNNRLC, 0 },
    { "aftnnruc", CONTROL_FLAG, RTF_AFTNNRUC, 0 },
    { "aftnnzodiac", CONTROL_FLAG, RTF_AFTNNZODIAC, 0 },
    { "aftnnzodiacd", CONTROL_FLAG, RTF_AFTNNZODIACD, 0 },
    { "aftnnzodiacl", CONTROL_FLAG, RTF_AFTNNZODIACL, 0 },
    { "aftnrestart", CONTROL_FLAG, RTF_AFTNRESTART, 0 },
    { "aftnrstcont", CONTROL_FLAG, RTF_AFTNRSTCONT, 0 },
    { "aftnsep", CONTROL_DESTINATION, RTF_AFTNSEP, 0 },
    { "aftnsepc", CONTROL_DESTINATION, RTF_AFTNSEPC, 0 },
    { "aftnstart", CONTROL_VALUE, RTF_AFTNSTART, 1 },
    { "aftntj", CONTROL_FLAG, RTF_AFTNTJ, 0 },
    { "ai", CONTROL_TOGGLE, RTF_AI, 1 },
    { "alang", CONTROL_VALUE, RTF_ALANG, 0 },
    { "allowfieldendsel", CONTROL_FLAG, RTF_ALLOWFIELDENDSEL, 0 },
    { "allprot", CONTROL_FLAG, RTF_ALLPROT, 0 },
    { "alntblind", CONTROL_FLAG, RTF_ALNTBLIND, 0 },
    { "alt", CONTROL_FLAG, RTF_ALT, 0 },
    { "animtext", CONTROL_VALUE, RTF_ANIMTEXT, 0 },
    { "annotation", CONTROL_DESTINATION, RTF_ANNOTATION, 0 },
    { "annotprot", CONTROL_FLAG, RTF_ANNOTPROT, 0 },
    { "ansi", CONTROL_FLAG, RTF_ANSI, 0 },
    { "ansicpg", CONTROL_VALUE, RTF_ANSICPG, 0 },
    { "aoutl", CONTROL_TOGGLE, RTF_AOUTL, 1 },
    { "ApplyBrkRules", CONTROL_FLAG, RTF_APPLYBRKRULES, 0 },
    { "ascaps", CONTROL_TOGGLE, RTF_ASCAPS, 1 },
    { "ashad", CONTROL_TOGGLE, RTF_ASHAD, 1 },
    { "asianbrkrule", CONTROL_FLAG, RTF_ASIANBRKRULE, 0 },
    { "aspalpha", CONTROL_TOGGLE, RTF_ASPALPHA, 1 },
    { "aspnum", CONTROL_TOGGLE, RTF_ASPNUM, 1 },
    { "astrike", CONTROL_TOGGLE, RTF_ASTRIKE, 1 },
    { "atnauthor", CONTROL_DESTINATION, RTF_ATNAUTHOR, 0 },
    { "atndate", CONTROL_DESTINATION, RTF_ATNDATE, 0 },
    { "atnicn", CONTROL_DESTINATION, RTF_ATNICN, 0 },
    { "atnid", CONTROL_DESTINATION, RTF_ATNID, 0 },
    { "atnparent", CONTROL_DESTINATION, RTF_ATNPARENT, 0 },
    { "atnref", CONTROL_DESTINATION, RTF_ATNREF, 0 },
    { "atntime", CONTROL_DESTINATION, RTF_ATNTIME, 0 },
    { "atrfend", CONTROL_DESTINATION, RTF_ATRFEND, 0 },
    { "atrfstart", CONTROL_DESTINATION, RTF_ATRFSTART, 0 },
    { "aul", CONTROL_TOGGLE, RTF_AUL, 1 },
    { "auld", CONTROL_TOGGLE, RTF_AULD, 1 },
    { "auldb", CONTROL_TOGGLE, RTF_AULDB, 1 },
    { "aulnone", CONTROL_TOGGLE, RTF_AULNONE, 1 },
    { "aulw", CONTROL_TOGGLE, RTF_AULW, 1 },
    { "aup", CONTROL_VALUE, RTF_AUP, 6 },
    { "author", CONTROL_DESTINATION, RTF_AUTHOR, 0 },
    { "autofmtoverride", CONTROL_FLAG, RTF_AUTOFMTOVERRIDE, 0 },
    { "b", CONTROL_TOGGLE, RTF_B, 1 },
    { "background", CONTROL_DESTINATION, RTF_BACKGROUND, 0 },
    { "bdbfhdr", CONTROL_FLAG, RTF_BDBFHDR, 0 },
    { "bdrrlswsix", CONTROL_FLAG, RTF_BDRRLSWSIX, 0 },
    { "bgbdiag", CONTROL_FLAG, RTF_BGBDIAG, 0 },
    { "bgcross", CONTROL_FLAG, RTF_BGCROSS, 0 },
    { "bgdcross", CONTROL_FLAG, RTF_BGDCROSS, 0 },
    { "bgdkbdiag", CONTROL_FLAG, RTF_BGDKBDIAG, 0 },
    { "bgdkcross", CONTROL_FLAG, RTF_BGDKCROSS, 0 },
    { "bgdkdcross", CONTROL_FLAG, RTF_BGDKDCROSS, 0 },
    { "bgdkfdiag", CONTROL_FLAG, RTF_BGDKFDIAG, 0 },
    { "bgdkhoriz", CONTROL_FLAG, RTF_BGDKHORIZ, 0 },
    { "bgdkvert", CONTROL_FLAG, RTF_BGDKVERT, 0 },
    { "bgfdiag", CONTROL_FLAG, RTF_BGFDIAG, 0 },
    { "bghoriz", CONTROL_FLAG, RTF_BGHORIZ, 0 },
    { "bgvert", CONTROL_FLAG, RTF_BGVERT, 0 },
    { "bin", CONTROL_VALUE, RTF_BIN, 0 },
    { "binfsxn", CONTROL_VALUE, RTF_BINFSXN, 0 },
    { "binsxn", CONTROL_VALUE, RTF_BINSXN, 0 },
    { "bkmkcolf", CONTROL_VALUE, RTF_BKMKCOLF, 0 },
    { "bkmkcoll", CONTROL_VALUE, RTF_BKMKCOLL, 0 },
    { "bkmkend", CONTROL_DESTINATION, RTF_BKMKEND, 0 },
    { "bkmkpub", CONTROL_FLAG, RTF_BKMKPUB, 0 },
    { "bkmkstart", CONTROL_DESTINATION, RTF_BKMKSTART, 0 },
    { "bliptag", CONTROL_VALUE, RTF_BLIPTAG, 0 },
    { "blipuid", CONTROL_DESTINATION, RTF_BLIPUID, 0 },
    { "blipupi", CONTROL_VALUE, RTF_BLIPUPI, 0 },
    { "blue", CONTROL_VALUE, RTF_BLUE, 0 },
    { "bookfold", CONTROL_FLAG, RTF_BOOKFOLD, 0 },
    { "bookfoldrev", CONTROL_FLAG, RTF_BOOKFOLDREV, 0 },
    { "bookfoldsheets", CONTROL_VALUE, RTF_BOOKFOLDSHEETS, 0 },
    { "box", CONTROL_FLAG, RTF_BOX, 0 },
    { "brdrart", CONTROL_VALUE, RTF_BRDRART, 0 },
    { "brdrb", CONTROL_FLAG, RTF_BRDRB, 0 },
    { "brdrbar", CONTROL_FLAG, RTF_BRDRBAR, 0 },
    { "brdrbtw", CONTROL_FLAG, RTF_BRDRBTW, 0 },
    { "brdrcf", CONTROL_VALUE, RTF_BRDRCF, 0 },
    { "brdrdash", CONTROL_FLAG, RTF_BRDRDASH, 0 },
    { "brdrdashd", CONTROL_FLAG, RTF_BRDRDASHD, 0 },
    { "brdrdashdd", CONTROL_FLAG, RTF_BRDRDASHDD, 0 },
    { "brdrdashdotstr", CONTROL_FLAG, RTF_BRDRDASHDOTSTR, 0 },
    { "brdrdashsm", CONTROL_FLAG, RTF_BRDRDASHSM, 0 },
    { "brdrdb", CONTROL_FLAG, RTF_BRDRDB, 0 },
    { "brdrdot", CONTROL_FLAG, RTF_BRDRDOT, 0 },
    { "brdremboss", CONTROL_FLAG, RTF_BRDREMBOSS, 0 },
    { "brdrengrave", CONTROL_FLAG, RTF_BRDRENGRAVE, 0 },
    { "brdrframe", CONTROL_FLAG, RTF_BRDRFRAME, 0 },
    { "brdrhair", CONTROL_FLAG, RTF_BRDRHAIR, 0 },
    { "brdrinset", CONTROL_FLAG, RTF_BRDRINSET, 0 },
    { "brdrl", CONTROL_FLAG, RTF_BRDRL, 0 },
    { "brdrnil", CONTROL_FLAG, RTF_BRDRNIL, 0 },
    { "brdrnone", CONTROL_FLAG, RTF_BRDRNONE, 0 },
    { "brdroutset", CONTROL_FLAG, RTF_BRDROUTSET, 0 },
    { "brdrr", CONTROL_FLAG, RTF_BRDRR, 0 },
    { "brdrs", CONTROL_FLAG, RTF_BRDRS, 0 },
    { "brdrsh", CONTROL_FLAG, RTF_BRDRSH, 0 },
    { "brdrt", CONTROL_FLAG, RTF_BRDRT, 0 },
    { "brdrtbl", CONTROL_FLAG, RTF_BRDRTBL, 0 },
    { "brdrth", CONTROL_FLAG, RTF_BRDRTH, 0 },
    { "brdrthtnlg", CONTROL_FLAG, RTF_BRDRTHTNLG, 0 },
    { "brdrthtnmg", CONTROL_FLAG, RTF_BRDRTHTNMG, 0 },
    { "brdrthtnsg", CONTROL_FLAG, RTF_BRDRTHTNSG, 0 },
    { "brdrtnthlg", CONTROL_FLAG, RTF_BRDRTNTHLG, 0 },
    { "brdrtnthmg", CONTROL_FLAG, RTF_BRDRTNTHMG, 0 },
    { "brdrtnthsg", CONTROL_FLAG, RTF_BRDRTNTHSG, 0 },
    { "brdrtnthtnlg", CONTROL_FLAG, RTF_BRDRTNTHTNLG, 0 },
    { "brdrtnthtnmg", CONTROL_FLAG, RTF_BRDRTNTHTNMG, 0 },
    { "brdrtnthtnsg", CONTROL_FLAG, RTF_BRDRTNTHTNSG, 0 },
    { "brdrtriple", CONTROL_FLAG, RTF_BRDRTRIPLE, 0 },
    { "brdrw", CONTROL_VALUE, RTF_BRDRW, 0 },
    { "brdrwavy", CONTROL_FLAG, RTF_BRDRWAVY, 0 },
    { "brdrwavydb", CONTROL_FLAG, RTF_BRDRWAVYDB, 0 },
    { "brkfrm", CONTROL_FLAG, RTF_BRKFRM, 0 },
    { "brsp", CONTROL_VALUE, RTF_BRSP, 0 },
    { "bullet", CONTROL_SYMBOL, RTF_BULLET, 0 },
    { "buptim", CONTROL_DESTINATION, RTF_BUPTIM, 0 },
    { "bxe", CONTROL_FLAG, RTF_BXE, 0 },
    { "caccentfive", CONTROL_FLAG, RTF_CACCENTFIVE, 0 },
    { "caccentfour", CONTROL_FLAG, RTF_CACCENTFOUR, 0 },
    { "caccentone", CONTROL_FLAG, RTF_CACCENTONE, 0 },
    { "caccentsix", CONTROL_FLAG, RTF_CACCENTSIX, 0 },
    { "caccentthree", CONTROL_FLAG, RTF_CACCENTTHREE, 0 },
    { "caccenttwo", CONTROL_FLAG, RTF_CACCENTTWO, 0 },
    { "cachedcolbal", CONTROL_FLAG, RTF_CACHEDCOLBAL, 0 },
    { "caps", CONTROL_TOGGLE, RTF_CAPS, 1 },
    { "category", CONTROL_DESTINATION, RTF_CATEGORY, 0 },
    { "cb", CONTROL_VALUE, RTF_CB, 0 },
    { "cbackgroundone", CONTROL_FLAG, RTF_CBACKGROUNDONE, 0 },
    { "cbackgroundtwo", CONTROL_FLAG, RTF_CBACKGROUNDTWO, 0 },
    { "cbpat", CONTROL_VALUE, RTF_CBPAT, 0 },
    { "cchs", CONTROL_VALUE, RTF_CCHS, 0 },
    { "cell", CONTROL_SYMBOL, RTF_CELL, 0 },
    { "cellx", CONTROL_VALUE, RTF_CELLX, 0 },
    { "cf", CONTROL_VALUE, RTF_CF, 0 },
    { "cfollowedhyperlink", CONTROL_FLAG, RTF_CFOLLOWEDHYPERLINK, 0 },
    { "cfpat", CONTROL_VALUE, RTF_CFPAT, 0 },
    { "cgrid", CONTROL_VALUE, RTF_CGRID, 0 },
    { "charrsid", CONTROL_VALUE, RTF_CHARRSID, 0 },
    { "charscalex", CONTROL_VALUE, RTF_CHARSCALEX, 100 },
    { "chatn", CONTROL_SYMBOL, RTF_CHATN, 0 },
    { "chbgbdiag", CONTROL_FLAG, RTF_CHBGBDIAG, 0 },
    { "chbgcross", CONTROL_FLAG, RTF_CHBGCROSS, 0 },
    { "chbgdcross", CONTROL_FLAG, RTF_CHBGDCROSS, 0 },
    { "chbgdkbdiag", CONTROL_FLAG, RTF_CHBGDKBDIAG, 0 },
    { "chbgdkcross", CONTROL_FLAG, RTF_CHBGDKCROSS, 0 },
    { "chbgdkdcross", CONTROL_FLAG, RTF_CHBGDKDCROSS, 0 },
    { "chbgdkfdiag", CONTROL_FLAG, RTF_CHBGDKFDIAG, 0 },
    { "chbgdkhoriz", CONTROL_FLAG, RTF_CHBGDKHORIZ, 0 },
    { "chbgdkvert", CONTROL_FLAG, RTF_CHBGDKVERT, 0 },
    { "chbgfdiag", CONTROL_FLAG, RTF_CHBGFDIAG, 0 },
    { "chbghoriz", CONTROL_FLAG, RTF_CHBGHORIZ, 0 },
    { "chbgvert", CONTROL_FLAG, RTF_CHBGVERT, 0 },
    { "chbrdr", CONTROL_FLAG, RTF_CHBRDR, 0 },
    { "chcbpat", CONTROL_VALUE, RTF_CHCBPAT, 0 },
    { "chcfpat", CONTROL_VALUE, RTF_CHCFPAT, 0 },
    { "chdate", CONTROL_SYMBOL, RTF_CHDATE, 0 },
    { "chdpa", CONTROL_SYMBOL, RTF_CHDPA, 0 },
    { "chdpl", CONTROL_SYMBOL, RTF_CHDPL, 0 },
    { "chftn", CONTROL_SYMBOL, RTF_CHFTN, 0 },
    { "chftnsep", CONTROL_SYMBOL, RTF_CHFTNSEP, 0 },
    { "chftnsepc", CONTROL_SYMBOL, RTF_CHFTNSEPC, 0 },
    { "chpgn", CONTROL_SYMBOL, RTF_CHPGN, 0 },
    { "chhres", CONTROL_VALUE, RTF_CHHRES, 0 },
    { "chshdng", CONTROL_VALUE, RTF_CHSHDNG, 0 },
    { "chtime", CONTROL_SYMBOL, RTF_CHTIME, 0 },
    { "chyperlink", CONTROL_FLAG, RTF_CHYPERLINK, 0 },
    { "clbgbdiag", CONTROL_FLAG, RTF_CLBGBDIAG, 0 },
    { "clbgcross", CONTROL_FLAG, RTF_CLBGCROSS, 0 },
    { "clbgdcross", CONTROL_FLAG, RTF_CLBGDCROSS, 0 },
    { "clbgdkbdiag", CONTROL_FLAG, RTF_CLBGDKBDIAG, 0 },
    { "clbgdkcross", CONTROL_FLAG, RTF_CLBGDKCROSS, 0 },
    { "clbgdkdcross", CONTROL_FLAG, RTF_CLBGDKDCROSS, 0 },
    { "clbgdkfdiag", CONTROL_FLAG, RTF_CLBGDKFDIAG, 0 },
    { "clbgdkhor", CONTROL_FLAG, RTF_CLBGDKHOR, 0 },
    { "clbgdkvert", CONTROL_FLAG, RTF_CLBGDKVERT, 0 },
    { "clbgfdiag", CONTROL_FLAG, RTF_CLBGFDIAG, 0 },
    { "clbghoriz", CONTROL_FLAG, RTF_CLBGHORIZ, 0 },
    { "clbgvert", CONTROL_FLAG, RTF_CLBGVERT, 0 },
    { "clbrdrb", CONTROL_FLAG, RTF_CLBRDRB, 0 },
    { "clbrdrl", CONTROL_FLAG, RTF_CLBRDRL, 0 },
    { "clbrdrr", CONTROL_FLAG, RTF_CLBRDRR, 0 },
    { "clbrdrt", CONTROL_FLAG, RTF_CLBRDRT, 0 },
    { "clcbpat", CONTROL_VALUE, RTF_CLCBPAT, 0 },
    { "clcbpatraw", CONTROL_VALUE, RTF_CLCBPATRAW, 0 },
    { "clcfpat", CONTROL_VALUE, RTF_CLCFPAT, 0 },
    { "clcfpatraw", CONTROL_VALUE, RTF_CLCFPATRAW, 0 },
    { "cldel", CONTROL_FLAG, RTF_CLDEL, 0 },
    { "cldelauth", CONTROL_VALUE, RTF_CLDELAUTH, 0 },
    { "cldeldttm", CONTROL_VALUE, RTF_CLDELDTTM, 0 },
    { "cldgll", CONTROL_FLAG, RTF_CLDGLL, 0 },
    { "cldglu", CONTROL_FLAG, RTF_CLDGLU, 0 },
    { "clFitText", CONTROL_FLAG, RTF_CLFITTEXT, 0 },
    { "clftsWidth", CONTROL_VALUE, RTF_CLFTSWIDTH, 0 },
    { "clhidemark", CONTROL_FLAG, RTF_CLHIDEMARK, 0 },
    { "clins", CONTROL_FLAG, RTF_CLINS, 0 },
    { "clinsauth", CONTROL_VALUE, RTF_CLINSAUTH, 0 },
    { "clinsdttm", CONTROL_VALUE, RTF_CLINSDTTM, 0 },
    { "clmgf", CONTROL_FLAG, RTF_CLMGF, 0 },
    { "clmrg", CONTROL_FLAG, RTF_CLMRG, 0 },
    { "clmrgd", CONTROL_FLAG, RTF_CLMRGD, 0 },
    { "clmrgdauth", CONTROL_VALUE, RTF_CLMRGDAUTH, 0 },
    { "clmrgddttm", CONTROL_VALUE, RTF_CLMRGDDTTM, 0 },
    { "clmrgdr", CONTROL_FLAG, RTF_CLMRGDR, 0 },
    { "clNoWrap", CONTROL_FLAG, RTF_CLNOWRAP, 0 },
    { "clpadb", CONTROL_VALUE, RTF_CLPADB, 0 },
    { "clpadfb", CONTROL_VALUE, RTF_CLPADFB, 0 },
    { "clpadfl", CONTROL_VALUE, RTF_CLPADFL, 0 },
    { "clpadfr", CONTROL_VALUE, RTF_CLPADFR, 0 },
    { "clpadft", CONTROL_VALUE, RTF_CLPADFT, 0 },
    { "clpadl", CONTROL_VALUE, RTF_CLPADL, 0 },
    { "clpadr", CONTROL_VALUE, RTF_CLPADR, 0 },
    { "clpadt", CONTROL_VALUE, RTF_CLPADT, 0 },
    { "clspb", CONTROL_VALUE, RTF_CLSPB, 0 },
    { "clspfb", CONTROL_VALUE, RTF_CLSPFB, 0 },
    { "clspfl", CONTROL_VALUE, RTF_CLSPFL, 0 },
    { "clspfr", CONTROL_VALUE, RTF_CLSPFR, 0 },
    { "clspft", CONTROL_VALUE, RTF_CLSPFT, 0 },
    { "clspl", CONTROL_VALUE, RTF_CLSPL, 0 },
    { "clspr", CONTROL_VALUE, RTF_CLSPR, 0 },
    { "clspt", CONTROL_VALUE, RTF_CLSPT, 0 },
    { "clshdng", CONTROL_VALUE, RTF_CLSHDNG, 0 },
    { "clshdngraw", CONTROL_VALUE, RTF_CLSHDNGRAW, 0 },
    { "clshdrawnil", CONTROL_FLAG, RTF_CLSHDRAWNIL, 0 },
    { "clsplit", CONTROL_FLAG, RTF_CLSPLIT, 0 },
    { "clsplitr", CONTROL_FLAG, RTF_CLSPLITR, 0 },
    { "cltxbtlr", CONTROL_FLAG, RTF_CLTXBTLR, 0 },
    { "cltxlrtb", CONTROL_FLAG, RTF_CLTXLRTB, 0 },
    { "cltxlrtbv", CONTROL_FLAG, RTF_CLTXLRTBV, 0 },
    { "cltxtbrl", CONTROL_FLAG, RTF_CLTXTBRL, 0 },
    { "cltxtbrlv", CONTROL_FLAG, RTF_CLTXTBRLV, 0 },
    { "clvertalb", CONTROL_FLAG, RTF_CLVERTALB, 0 },
    { "clvertalc", CONTROL_FLAG, RTF_CLVERTALC, 0 },
    { "clvertalt", CONTROL_FLAG, RTF_CLVERTALT, 0 },
    { "clvmgf", CONTROL_FLAG, RTF_CLVMGF, 0 },
    { "clvmrg", CONTROL_FLAG, RTF_CLVMRG, 0 },
    { "clwWidth", CONTROL_VALUE, RTF_CLWWIDTH, 0 },
    { "cmaindarkone", CONTROL_FLAG, RTF_CMAINDARKONE, 0 },
    { "cmaindarktwo", CONTROL_FLAG, RTF_CMAINDARKTWO, 0 },
    { "cmainlightone", CONTROL_FLAG, RTF_CMAINLIGHTONE, 0 },
    { "cmainlighttwo", CONTROL_FLAG, RTF_CMAINLIGHTTWO, 0 },
    { "collapsed", CONTROL_FLAG, RTF_COLLAPSED, 0 },
    { "colno", CONTROL_VALUE, RTF_COLNO, 0 },
    { "colorschememapping", CONTROL_DESTINATION, RTF_COLORSCHEMEMAPPING, 0 },
    { "colortbl", CONTROL_DESTINATION, RTF_COLORTBL, 0 },
    { "cols", CONTROL_VALUE, RTF_COLS, 1 },
    { "colsr", CONTROL_VALUE, RTF_COLSR, 0 },
    { "colsx", CONTROL_VALUE, RTF_COLSX, 720 },
    { "column", CONTROL_SYMBOL, RTF_COLUMN, 0 },
    { "colw", CONTROL_VALUE, RTF_COLW, 0 },
    { "comment", CONTROL_DESTINATION, RTF_COMMENT, 0 },
    { "company", CONTROL_DESTINATION, RTF_COMPANY, 0 },
    { "contextualspace", CONTROL_FLAG, RTF_CONTEXTUALSPACE, 0 },
    { "cpg", CONTROL_VALUE, RTF_CPG, 0 },
    { "crauth", CONTROL_VALUE, RTF_CRAUTH, 0 },
    { "crdate", CONTROL_VALUE, RTF_CRDATE, 0 },
    { "creatim", CONTROL_DESTINATION, RTF_CREATIM, 0 },
    { "cs", CONTROL_VALUE, RTF_CS, 0 },
    { "cshade", CONTROL_VALUE, RTF_CSHADE, 0 },
    { "ctextone", CONTROL_FLAG, RTF_CTEXTONE, 0 },
    { "ctexttwo", CONTROL_FLAG, RTF_CTEXTTWO, 0 },
    { "ctint", CONTROL_VALUE, RTF_CTINT, 0 },
    { "ctrl", CONTROL_FLAG, RTF_CTRL, 0 },
    { "cts", CONTROL_VALUE, RTF_CTS, 0 },
    { "cufi", CONTROL_VALUE, RTF_CUFI, 0 },
    { "culi", CONTROL_VALUE, RTF_CULI, 0 },
    { "curi", CONTROL_VALUE, RTF_CURI, 0 },
    { "cvmme", CONTROL_FLAG, RTF_CVMME, 0 },
    { "datafield", CONTROL_DESTINATION, RTF_DATAFIELD, 0 },
    { "datastore", CONTROL_DESTINATION, RTF_DATASTORE, 0 },
    { "date", CONTROL_FLAG, RTF_DATE, 0 },
    { "dbch", CONTROL_FLAG, RTF_DBCH, 0 },
    { "defchp", CONTROL_DESTINATION, RTF_DEFCHP, 0 },
    { "deff", CONTROL_VALUE, RTF_DEFF, 0 },
    { "defformat", CONTROL_FLAG, RTF_DEFFORMAT, 0 },
    { "deflang", CONTROL_VALUE, RTF_DEFLANG, 0 },
    { "deflangfe", CONTROL_VALUE, RTF_DEFLANGFE, 0 },
    { "defpap", CONTROL_DESTINATION, RTF_DEFPAP, 0 },
    { "defshp", CONTROL_FLAG, RTF_DEFSHP, 0 },
    { "deftab", CONTROL_VALUE, RTF_DEFTAB, 720 },
    { "deleted", CONTROL_TOGGLE, RTF_DELETED, 1 },
    { "delrsid", CONTROL_VALUE, RTF_DELRSID, 0 },
    { "dfrauth", CONTROL_VALUE, RTF_DFRAUTH, 0 },
    { "dfrdate", CONTROL_VALUE, RTF_DFRDATE, 0 },
    { "dfrmtxtx", CONTROL_VALUE, RTF_DFRMTXTX, 0 },
    { "dfrmtxty", CONTROL_VALUE, RTF_DFRMTXTY, 0 },
    { "dfrstart", CONTROL_VALUE, RTF_DFRSTART, 0 },
    { "dfrstop", CONTROL_VALUE, RTF_DFRSTOP, 0 },
    { "dfrxst", CONTROL_VALUE, RTF_DFRXST, 0 },
    { "dghorigin", CONTROL_VALUE, RTF_DGHORIGIN, 1701 },
    { "dghshow", CONTROL_VALUE, RTF_DGHSHOW, 3 },
    { "dghspace", CONTROL_VALUE, RTF_DGHSPACE, 120 },
    { "dgmargin", CONTROL_FLAG, RTF_DGMARGIN, 0 },
    { "dgsnap", CONTROL_FLAG, RTF_DGSNAP, 0 },
    { "dgvorigin", CONTROL_VALUE, RTF_DGVORIGIN, 1984 },
    { "dgvshow", CONTROL_VALUE, RTF_DGVSHOW, 0 },
    { "dgvspace", CONTROL_VALUE, RTF_DGVSPACE, 120 },
    { "dibitmap", CONTROL_VALUE, RTF_DIBITMAP, 0 },
    { "disabled", CONTROL_TOGGLE, RTF_DISABLED, 1 },
    { "dn", CONTROL_VALUE, RTF_DN, 6 },
    { "dntblnsbdb", CONTROL_FLAG, RTF_DNTBLNSBDB, 0 },
    { "do", CONTROL_DESTINATION, RTF_DO, 0 },
    { "dobxcolumn", CONTROL_FLAG, RTF_DOBXCOLUMN, 0 },
    { "dobxmargin", CONTROL_FLAG, RTF_DOBXMARGIN, 0 },
    { "dobxpage", CONTROL_FLAG, RTF_DOBXPAGE, 0 },
    { "dobymargin", CONTROL_FLAG, RTF_DOBYMARGIN, 0 },
    { "dobypage", CONTROL_FLAG, RTF_DOBYPAGE, 0 },
    { "dobypara", CONTROL_FLAG, RTF_DOBYPARA, 0 },
    { "doccomm", CONTROL_DESTINATION, RTF_DOCCOMM, 0 },
    { "doctemp", CONTROL_FLAG, RTF_DOCTEMP, 0 },
    { "doctype", CONTROL_VALUE, RTF_DOCTYPE, 0 },
    { "docvar", CONTROL_DESTINATION, RTF_DOCVAR, 0 },
    { "dodhgt", CONTROL_VALUE, RTF_DODHGT, 0 },
    { "dolock", CONTROL_FLAG, RTF_DOLOCK, 0 },
    { "donotembedlingdata", CONTROL_VALUE, RTF_DONOTEMBEDLINGDATA, 0 },
    { "donotembedsysfont", CONTROL_VALUE, RTF_DONOTEMBEDSYSFONT, 0 },
    { "donotshowcomments", CONTROL_FLAG, RTF_DONOTSHOWCOMMENTS, 0 },
    { "donotshowinsdel", CONTROL_FLAG, RTF_DONOTSHOWINSDEL, 0 },
    { "donotshowmarkup", CONTROL_FLAG, RTF_DONOTSHOWMARKUP, 0 },
    { "donotshowprops", CONTROL_FLAG, RTF_DONOTSHOWPROPS, 0 },
    { "dpaendhol", CONTROL_FLAG, RTF_DPAENDHOL, 0 },
    { "dpaendl", CONTROL_VALUE, RTF_DPAENDL, 0 },
    { "dpaendsol", CONTROL_FLAG, RTF_DPAENDSOL, 0 },
    { "dpaendw", CONTROL_VALUE, RTF_DPAENDW, 0 },
    { "dparc", CONTROL_FLAG, RTF_DPARC, 0 },
    { "dparcflipx", CONTROL_FLAG, RTF_DPARCFLIPX, 0 },
    { "dparcflipy", CONTROL_FLAG, RTF_DPARCFLIPY, 0 },
    { "dpastarthol", CONTROL_FLAG, RTF_DPASTARTHOL, 0 },
    { "dpastartl", CONTROL_VALUE, RTF_DPASTARTL, 0 },
    { "dpastartsol", CONTROL_FLAG, RTF_DPASTARTSOL, 0 },
    { "dpastartw", CONTROL_VALUE, RTF_DPASTARTW, 0 },
    { "dpcallout", CONTROL_FLAG, RTF_DPCALLOUT, 0 },
    { "dpcoa", CONTROL_VALUE, RTF_DPCOA, 0 },
    { "dpcoaccent", CONTROL_FLAG, RTF_DPCOACCENT, 0 },
    { "dpcobestfit", CONTROL_FLAG, RTF_DPCOBESTFIT, 0 },
    { "dpcoborder", CONTROL_FLAG, RTF_DPCOBORDER, 0 },
    { "dpcodabs", CONTROL_FLAG, RTF_DPCODABS, 0 },
    { "dpcodbottom", CONTROL_FLAG, RTF_DPCODBOTTOM, 0 },
    { "dpcodcenter", CONTROL_FLAG, RTF_DPCODCENTER, 0 },
    { "dpcodescent", CONTROL_VALUE, RTF_DPCODESCENT, 0 },
    { "dpcodtop", CONTROL_FLAG, RTF_DPCODTOP, 0 },
    { "dpcolength", CONTROL_VALUE, RTF_DPCOLENGTH, 0 },
    { "dpcominusx", CONTROL_FLAG, RTF_DPCOMINUSX, 0 },
    { "dpcominusy", CONTROL_FLAG, RTF_DPCOMINUSY, 0 },
    { "dpcooffset", CONTROL_VALUE, RTF_DPCOOFFSET, 0 },
    { "dpcosmarta", CONTROL_FLAG, RTF_DPCOSMARTA, 0 },
    { "dpcotdouble", CONTROL_FLAG, RTF_DPCOTDOUBLE, 0 },
    { "dpcotright", CONTROL_FLAG, RTF_DPCOTRIGHT, 0 },
    { "dpcotsingle", CONTROL_FLAG, RTF_DPCOTSINGLE, 0 },
    { "dpcottriple", CONTROL_FLAG, RTF_DPCOTTRIPLE, 0 },
    { "dpcount", CONTROL_VALUE, RTF_DPCOUNT, 0 },
    { "dpellipse", CONTROL_FLAG, RTF_DPELLIPSE, 0 },
    { "dpendgroup", CONTROL_FLAG, RTF_DPENDGROUP, 0 },
    { "dpfillbgcb", CONTROL_VALUE, RTF_DPFILLBGCB, 0 },
    { "dpfillbgcg", CONTROL_VALUE, RTF_DPFILLBGCG, 0 },
    { "dpfillbgcr", CONTROL_VALUE, RTF_DPFILLBGCR, 0 },
    { "dpfillbggray", CONTROL_VALUE, RTF_DPFILLBGGRAY, 0 },
    { "dpfillbgpal", CONTROL_FLAG, RTF_DPFILLBGPAL, 0 },
    { "dpfillfgcb", CONTROL_VALUE, RTF_DPFILLFGCB, 0 },
    { "dpfillfgcg", CONTROL_VALUE, RTF_DPFILLFGCG, 0 },
    { "dpfillfgcr", CONTROL_VALUE, RTF_DPFILLFGCR, 0 },
    { "dpfillfggray", CONTROL_VALUE, RTF_DPFILLFGGRAY, 0 },
    { "dpfillfgpal", CONTROL_FLAG, RTF_DPFILLFGPAL, 0 },
    { "dpfillpat", CONTROL_VALUE, RTF_DPFILLPAT, 0 },
    { "dpgroup", CONTROL_FLAG, RTF_DPGROUP, 0 },
    { "dpline", CONTROL_FLAG, RTF_DPLINE, 0 },
    { "dplinecob", CONTROL_VALUE, RTF_DPLINECOB, 0 },
    { "dplinecog", CONTROL_VALUE, RTF_DPLINECOG, 0 },
    { "dplinecor", CONTROL_VALUE, RTF_DPLINECOR, 0 },
    { "dplinedado", CONTROL_FLAG, RTF_DPLINEDADO, 0 },
    { "dplinedadodo", CONTROL_FLAG, RTF_DPLINEDADODO, 0 },
    { "dplinedash", CONTROL_FLAG, RTF_DPLINEDASH, 0 },
    { "dplinedot", CONTROL_FLAG, RTF_DPLINEDOT, 0 },
    { "dplinegray", CONTROL_VALUE, RTF_DPLINEGRAY, 0 },
    { "dplinehollow", CONTROL_FLAG, RTF_DPLINEHOLLOW, 0 },
    { "dplinepal", CONTROL_FLAG, RTF_DPLINEPAL, 0 },
    { "dplinesolid", CONTROL_FLAG, RTF_DPLINESOLID, 0 },
    { "dplinew", CONTROL_VALUE, RTF_DPLINEW, 0 },
    { "dppolycount", CONTROL_VALUE, RTF_DPPOLYCOUNT, 0 },
    { "dppolygon", CONTROL_FLAG, RTF_DPPOLYGON, 0 },
    { "dppolyline", CONTROL_FLAG, RTF_DPPOLYLINE, 0 },
    { "dpptx", CONTROL_VALUE, RTF_DPPTX, 0 },
    { "dppty", CONTROL_VALUE, RTF_DPPTY, 0 },
    { "dprect", CONTROL_FLAG, RTF_DPRECT, 0 },
    { "dproundr", CONTROL_FLAG, RTF_DPROUNDR, 0 },
    { "dpshadow", CONTROL_FLAG, RTF_DPSHADOW, 0 },
    { "dpshadx", CONTROL_VALUE, RTF_DPSHADX, 0 },
    { "dpshady", CONTROL_VALUE, RTF_DPSHADY, 0 },
    { "dptxbtlr", CONTROL_FLAG, RTF_DPTXBTLR, 0 },
    { "dptxbx", CONTROL_FLAG, RTF_DPTXBX, 0 },
    { "dptxbxmar", CONTROL_VALUE, RTF_DPTXBXMAR, 0 },
    { "dptxbxtext", CONTROL_DESTINATION, RTF_DPTXBXTEXT, 0 },
    { "dptxlrtb", CONTROL_FLAG, RTF_DPTXLRTB, 0 },
    { "dptxlrtbv", CONTROL_FLAG, RTF_DPTXLRTBV, 0 },
    { "dptxtbrl", CONTROL_FLAG, RTF_DPTXTBRL, 0 },
    { "dptxtbrlv", CONTROL_FLAG, RTF_DPTXTBRLV, 0 },
    { "dpx", CONTROL_VALUE, RTF_DPX, 0 },
    { "dpxsize", CONTROL_VALUE, RTF_DPXSIZE, 0 },
    { "dpy", CONTROL_VALUE, RTF_DPY, 0 },
    { "dpysize", CONTROL_VALUE, RTF_DPYSIZE, 0 },
    { "dropcapli", CONTROL_VALUE, RTF_DROPCAPLI, 0 },
    { "dropcapt", CONTROL_VALUE, RTF_DROPCAPT, 0 },
    { "ds", CONTROL_VALUE, RTF_DS, 0 },
    { "dxfrtext", CONTROL_VALUE, RTF_DXFRTEXT, 0 },
    { "dy", CONTROL_VALUE, RTF_DY, 0 },
    { "ebcend", CONTROL_DESTINATION, RTF_EBCEND, 0 },
    { "ebcstart", CONTROL_DESTINATION, RTF_EBCSTART, 0 },
    { "edmins", CONTROL_VALUE, RTF_EDMINS, 0 },
    { "embo", CONTROL_TOGGLE, RTF_EMBO, 1 },
    { "emdash", CONTROL_SYMBOL, RTF_EMDASH, 0 },
    { "emfblip", CONTROL_FLAG, RTF_EMFBLIP, 0 },
    { "emspace", CONTROL_SYMBOL, RTF_EMSPACE, 0 },
    { "endash", CONTROL_SYMBOL, RTF_ENDASH, 0 },
    { "enddoc", CONTROL_FLAG, RTF_ENDDOC, 0 },
    { "endnhere", CONTROL_FLAG, RTF_ENDNHERE, 0 },
    { "endnotes", CONTROL_FLAG, RTF_ENDNOTES, 0 },
    { "enforceprot", CONTROL_VALUE, RTF_ENFORCEPROT, 0 },
    { "enspace", CONTROL_SYMBOL, RTF_ENSPACE, 0 },
    { "expnd", CONTROL_VALUE, RTF_EXPND, 0 },
    { "expndtw", CONTROL_VALUE, RTF_EXPNDTW, 0 },
    { "expshrtn", CONTROL_FLAG, RTF_EXPSHRTN, 0 },
    { "f", CONTROL_VALUE, RTF_F, 0 },
    { "faauto", CONTROL_FLAG, RTF_FAAUTO, 0 },
    { "facenter", CONTROL_FLAG, RTF_FACENTER, 0 },
    { "facingp", CONTROL_TOGGLE, RTF_FACINGP, 1 },
    { "factoidname", CONTROL_DESTINATION, RTF_FACTOIDNAME, 0 },
    { "fafixed", CONTROL_FLAG, RTF_FAFIXED, 0 },
    { "fahang", CONTROL_FLAG, RTF_FAHANG, 0 },
    { "falt", CONTROL_DESTINATION, RTF_FALT, 0 },
    { "faroman", CONTROL_FLAG, RTF_FAROMAN, 0 },
    { "favar", CONTROL_FLAG, RTF_FAVAR, 0 },
    { "fbias", CONTROL_VALUE, RTF_FBIAS, 0 },
    { "fbidi", CONTROL_FLAG, RTF_FBIDI, 0 },
    { "fbidis", CONTROL_FLAG, RTF_FBIDIS, 0 },
    { "fbimajor", CONTROL_FLAG, RTF_FBIMAJOR, 0 },
    { "fbiminor", CONTROL_FLAG, RTF_FBIMINOR, 0 },
    { "fchars", CONTROL_DESTINATION, RTF_FCHARS, 0 },
    { "fcharset", CONTROL_VALUE, RTF_FCHARSET, 0 },
    { "fcs", CONTROL_VALUE, RTF_FCS, 0 },
    { "fdbmajor", CONTROL_FLAG, RTF_FDBMAJOR, 0 },
    { "fdbminor", CONTROL_FLAG, RTF_FDBMINOR, 0 },
    { "fdecor", CONTROL_FLAG, RTF_FDECOR, 0 },
    { "felnbrelev", CONTROL_FLAG, RTF_FELNBRELEV, 0 },
    { "fet", CONTROL_VALUE, RTF_FET, 0 },
    { "fetch", CONTROL_FLAG, RTF_FETCH, 0 },
    { "ffdefres", CONTROL_VALUE, RTF_FFDEFRES, 0 },
    { "ffdeftext", CONTROL_DESTINATION, RTF_FFDEFTEXT, 0 },
    { "ffentrymcr", CONTROL_DESTINATION, RTF_FFENTRYMCR, 0 },
    { "ffexitmcr", CONTROL_DESTINATION, RTF_FFEXITMCR, 0 },
    { "ffformat", CONTROL_DESTINATION, RTF_FFFORMAT, 0 },
    { "ffhaslistbox", CONTROL_VALUE, RTF_FFHASLISTBOX, 0 },
    { "ffhelptext", CONTROL_DESTINATION, RTF_FFHELPTEXT, 0 },
    { "ffhps", CONTROL_VALUE, RTF_FFHPS, 0 },
    { "ffl", CONTROL_DESTINATION, RTF_FFL, 0 },
    { "ffmaxlen", CONTROL_VALUE, RTF_FFMAXLEN, 0 },
    { "ffname", CONTROL_DESTINATION, RTF_FFNAME, 0 },
    { "ffownhelp", CONTROL_VALUE, RTF_FFOWNHELP, 0 },
    { "ffownstat", CONTROL_VALUE, RTF_FFOWNSTAT, 0 },
    { "ffprot", CONTROL_VALUE, RTF_FFPROT, 0 },
    { "ffrecalc", CONTROL_VALUE, RTF_FFRECALC, 0 },
    { "ffres", CONTROL_VALUE, RTF_FFRES, 0 },
    { "ffsize", CONTROL_VALUE, RTF_FFSIZE, 0 },
    { "ffstattext", CONTROL_DESTINATION, RTF_FFSTATTEXT, 0 },
    { "fftype", CONTROL_VALUE, RTF_FFTYPE, 0 },
    { "fftypetxt", CONTROL_VALUE, RTF_FFTYPETXT, 0 },
    { "fhimajor", CONTROL_FLAG, RTF_FHIMAJOR, 0 },
    { "fhiminor", CONTROL_FLAG, RTF_FHIMINOR, 0 },
    { "fi", CONTROL_VALUE, RTF_FI, 0 },
    { "fid", CONTROL_VALUE, RTF_FID, 0 },
    { "field", CONTROL_DESTINATION, RTF_FIELD, 0 },
    { "file", CONTROL_DESTINATION, RTF_FILE, 0 },
    { "filetbl", CONTROL_DESTINATION, RTF_FILETBL, 0 },
    { "fittext", CONTROL_VALUE, RTF_FITTEXT, 0 },
    { "fjgothic", CONTROL_FLAG, RTF_FJGOTHIC, 0 },
    { "fjminchou", CONTROL_FLAG, RTF_FJMINCHOU, 0 },
    { "fldalt", CONTROL_FLAG, RTF_FLDALT, 0 },
    { "flddirty", CONTROL_FLAG, RTF_FLDDIRTY, 0 },
    { "fldedit", CONTROL_FLAG, RTF_FLDEDIT, 0 },
    { "fldinst", CONTROL_DESTINATION, RTF_FLDINST, 0 },
    { "fldlock", CONTROL_FLAG, RTF_FLDLOCK, 0 },
    { "fldpriv", CONTROL_FLAG, RTF_FLDPRIV, 0 },
    { "fldrslt", CONTROL_DESTINATION, RTF_FLDRSLT, 0 },
    { "fldtype", CONTROL_DESTINATION, RTF_FLDTYPE, 0 },
    { "flomajor", CONTROL_FLAG, RTF_FLOMAJOR, 0 },
    { "flominor", CONTROL_FLAG, RTF_FLOMINOR, 0 },
    { "fmodern", CONTROL_FLAG, RTF_FMODERN, 0 },
    { "fn", CONTROL_VALUE, RTF_FN, 0 },
    { "fname", CONTROL_DESTINATION, RTF_FNAME, 0 },
    { "fnetwork", CONTROL_FLAG, RTF_FNETWORK, 0 },
    { "fnil", CONTROL_FLAG, RTF_FNIL, 0 },
    { "fnonfilesys", CONTROL_FLAG, RTF_FNONFILESYS, 0 },
    { "fontemb", CONTROL_DESTINATION, RTF_FONTEMB, 0 },
    { "fontfile", CONTROL_DESTINATION, RTF_FONTFILE, 0 },
    { "fonttbl", CONTROL_DESTINATION, RTF_FONTTBL, 0 },
    { "footer", CONTROL_DESTINATION, RTF_FOOTER, 0 },
    { "footerf", CONTROL_DESTINATION, RTF_FOOTERF, 0 },
    { "footerl", CONTROL_DESTINATION, RTF_FOOTERL, 0 },
    { "footerr", CONTROL_DESTINATION, RTF_FOOTERR, 0 },
    { "footery", CONTROL_VALUE, RTF_FOOTERY, 720 },
    { "footnote", CONTROL_DESTINATION, RTF_FOOTNOTE, 0 },
    { "forceupgrade", CONTROL_FLAG, RTF_FORCEUPGRADE, 0 },
    { "formdisp", CONTROL_FLAG, RTF_FORMDISP, 0 },
    { "formfield", CONTROL_DESTINATION, RTF_FORMFIELD, 0 },
    { "formprot", CONTROL_FLAG, RTF_FORMPROT, 0 },
    { "formshade", CONTROL_FLAG, RTF_FORMSHADE, 0 },
    { "fosnum", CONTROL_VALUE, RTF_FOSNUM, 0 },
    { "fprq", CONTROL_VALUE, RTF_FPRQ, 0 },
    { "fracwidth", CONTROL_FLAG, RTF_FRACWIDTH, 0 },
    { "frelative", CONTROL_VALUE, RTF_FRELATIVE, 0 },
    { "frmtxbtlr", CONTROL_FLAG, RTF_FRMTXBTLR, 0 },
    { "frmtxlrtb", CONTROL_FLAG, RTF_FRMTXLRTB, 0 },
    { "frmtxlrtbv", CONTROL_FLAG, RTF_FRMTXLRTBV, 0 },
    { "frmtxtbrl", CONTROL_FLAG, RTF_FRMTXTBRL, 0 },
    { "frmtxtbrlv", CONTROL_FLAG, RTF_FRMTXTBRLV, 0 },
    { "froman", CONTROL_FLAG, RTF_FROMAN, 0 },
    { "fromhtml", CONTROL_VALUE, RTF_FROMHTML, 0 },
    { "fromtext", CONTROL_FLAG, RTF_FROMTEXT, 0 },
    { "fs", CONTROL_VALUE, RTF_FS, 24 },
    { "fscript", CONTROL_FLAG, RTF_FSCRIPT, 0 },
    { "fswiss", CONTROL_FLAG, RTF_FSWISS, 0 },
    { "ftech", CONTROL_FLAG, RTF_FTECH, 0 },
    { "ftnalt", CONTROL_FLAG, RTF_FTNALT, 0 },
    { "ftnbj", CONTROL_FLAG, RTF_FTNBJ, 0 },
    { "ftncn", CONTROL_DESTINATION, RTF_FTNCN, 0 },
    { "ftnil", CONTROL_FLAG, RTF_FTNIL, 0 },
    { "ftnlytwnine", CONTROL_FLAG, RTF_FTNLYTWNINE, 0 },
    { "ftnnalc", CONTROL_FLAG, RTF_FTNNALC, 0 },
    { "ftnnar", CONTROL_FLAG, RTF_FTNNAR, 0 },
    { "ftnnauc", CONTROL_FLAG, RTF_FTNNAUC, 0 },
    { "ftnnchi", CONTROL_FLAG, RTF_FTNNCHI, 0 },
    { "ftnnchosung", CONTROL_FLAG, RTF_FTNNCHOSUNG, 0 },
    { "ftnncnum", CONTROL_FLAG, RTF_FTNNCNUM, 0 },
    { "ftnndbar", CONTROL_FLAG, RTF_FTNNDBAR, 0 },
    { "ftnndbnum", CONTROL_FLAG, RTF_FTNNDBNUM, 0 },
    { "ftnndbnumd", CONTROL_FLAG, RTF_FTNNDBNUMD, 0 },
    { "ftnndbnumk", CONTROL_FLAG, RTF_FTNNDBNUMK, 0 },
    { "ftnndbnumt", CONTROL_FLAG, RTF_FTNNDBNUMT, 0 },
    { "ftnnganada", CONTROL_FLAG, RTF_FTNNGANADA, 0 },
    { "ftnngbnum", CONTROL_FLAG, RTF_FTNNGBNUM, 0 },
    { "ftnngbnumd", CONTROL_FLAG, RTF_FTNNGBNUMD, 0 },
    { "ftnngbnumk", CONTROL_FLAG, RTF_FTNNGBNUMK, 0 },
    { "ftnngbnuml", CONTROL_FLAG, RTF_FTNNGBNUML, 0 },
    { "ftnnrlc", CONTROL_FLAG, RTF_FTNNRLC, 0 },
    { "ftnnruc", CONTROL_FLAG, RTF_FTNNRUC, 0 },
    { "ftnnzodiac", CONTROL_FLAG, RTF_FTNNZODIAC, 0 },
    { "ftnnzodiacd", CONTROL_FLAG, RTF_FTNNZODIACD, 0 },
    { "ftnnzodiacl", CONTROL_FLAG, RTF_FTNNZODIACL, 0 },
    { "ftnrestart", CONTROL_FLAG, RTF_FTNRESTART, 0 },
    { "ftnrstcont", CONTROL_FLAG, RTF_FTNRSTCONT, 0 },
    { "ftnrstpg", CONTROL_FLAG, RTF_FTNRSTPG, 0 },
    { "ftnsep", CONTROL_DESTINATION, RTF_FTNSEP, 0 },
    { "ftnsepc", CONTROL_DESTINATION, RTF_FTNSEPC, 0 },
    { "ftnstart", CONTROL_VALUE, RTF_FTNSTART, 1 },
    { "ftntj", CONTROL_FLAG, RTF_FTNTJ, 0 },
    { "fttruetype", CONTROL_FLAG, RTF_FTTRUETYPE, 0 },
    { "fvaliddos", CONTROL_FLAG, RTF_FVALIDDOS, 0 },
    { "fvalidhpfs", CONTROL_FLAG, RTF_FVALIDHPFS, 0 },
    { "fvalidmac", CONTROL_FLAG, RTF_FVALIDMAC, 0 },
    { "fvalidntfs", CONTROL_FLAG, RTF_FVALIDNTFS, 0 },
    { "g", CONTROL_DESTINATION, RTF_G, 0 },
    { "gcw", CONTROL_VALUE, RTF_GCW, 0 },
    { "generator", CONTROL_DESTINATION, RTF_GENERATOR, 0 },
    { "green", CONTROL_VALUE, RTF_GREEN, 0 },
    { "grfdocevents", CONTROL_VALUE, RTF_GRFDOCEVENTS, 0 },
    { "gridtbl", CONTROL_DESTINATION, RTF_GRIDTBL, 0 },
    { "gutter", CONTROL_VALUE, RTF_GUTTER, 0 },
    { "gutterprl", CONTROL_FLAG, RTF_GUTTERPRL, 0 },
    { "guttersxn", CONTROL_VALUE, RTF_GUTTERSXN, 0 },
    { "header", CONTROL_DESTINATION, RTF_HEADER, 0 },
    { "headerf", CONTROL_DESTINATION, RTF_HEADERF, 0 },
    { "headerl", CONTROL_DESTINATION, RTF_HEADERL, 0 },
    { "headerr", CONTROL_DESTINATION, RTF_HEADERR, 0 },
    { "headery", CONTROL_VALUE, RTF_HEADERY, 720 },
    { "hich", CONTROL_FLAG, RTF_HICH, 0 },
    { "highlight", CONTROL_VALUE, RTF_HIGHLIGHT, 0 },
    { "hl", CONTROL_DESTINATION, RTF_HL, 0 },
    { "hlfr", CONTROL_DESTINATION, RTF_HLFR, 0 },
    { "hlinkbase", CONTROL_DESTINATION, RTF_HLINKBASE, 0 },
    { "hlloc", CONTROL_DESTINATION, RTF_HLLOC, 0 },
    { "hlsrc", CONTROL_DESTINATION, RTF_HLSRC, 0 },
    { "horzdoc", CONTROL_FLAG, RTF_HORZDOC, 0 },
    { "horzsect", CONTROL_FLAG, RTF_HORZSECT, 0 },
    { "horzvert", CONTROL_VALUE, RTF_HORZVERT, 0 },
    { "hr", CONTROL_VALUE, RTF_HR, 0 },
    { "hres", CONTROL_VALUE, RTF_HRES, 0 },
    { "hrule", CONTROL_FLAG, RTF_HRULE, 0 },
    { "hsv", CONTROL_DESTINATION, RTF_HSV, 0 },
    { "htmautsp", CONTROL_FLAG, RTF_HTMAUTSP, 0 },
    { "htmlbase", CONTROL_FLAG, RTF_HTMLBASE, 0 },
    { "htmlrtf", CONTROL_TOGGLE, RTF_HTMLRTF, 1 },
    { "htmltag", CONTROL_DESTINATION, RTF_HTMLTAG, 0 },
    { "hwelev", CONTROL_FLAG, RTF_HWELEV, 0 },
    { "hyphauto", CONTROL_TOGGLE, RTF_HYPHAUTO, 1 },
    { "hyphcaps", CONTROL_TOGGLE, RTF_HYPHCAPS, 1 },
    { "hyphconsec", CONTROL_VALUE, RTF_HYPHCONSEC, 0 },
    { "hyphhotz", CONTROL_VALUE, RTF_HYPHHOTZ, 0 },
    { "hyphpar", CONTROL_TOGGLE, RTF_HYPHPAR, 1 },
    { "i", CONTROL_TOGGLE, RTF_I, 1 },
    { "id", CONTROL_VALUE, RTF_ID, 0 },
    { "ignoremixedcontent", CONTROL_VALUE, RTF_IGNOREMIXEDCONTENT, 0 },
    { "ilfomacatclnup", CONTROL_VALUE, RTF_ILFOMACATCLNUP, 0 },
    { "ilvl", CONTROL_VALUE, RTF_ILVL, 0 },
    { "impr", CONTROL_TOGGLE, RTF_IMPR, 1 },
    { "indmirror", CONTROL_FLAG, RTF_INDMIRROR, 0 },
    { "indrlsweleven", CONTROL_FLAG, RTF_INDRLSWELEVEN, 0 },
    { "info", CONTROL_DESTINATION, RTF_INFO, 0 },
    { "insrsid", CONTROL_VALUE, RTF_INSRSID, 0 },
    { "intbl", CONTROL_FLAG, RTF_INTBL, 0 },
    { "ipgp", CONTROL_VALUE, RTF_IPGP, 0 },
    { "irowband", CONTROL_VALUE, RTF_IROWBAND, 0 },
    { "irow", CONTROL_VALUE, RTF_IROW, 0 },
    { "itap", CONTROL_VALUE, RTF_ITAP, 1 },
    { "ixe", CONTROL_FLAG, RTF_IXE, 0 },
    { "jcompress", CONTROL_FLAG, RTF_JCOMPRESS, 0 },
    { "jexpand", CONTROL_FLAG, RTF_JEXPAND, 0 },
    { "jis", CONTROL_FLAG, RTF_JIS, 0 },
    { "jpegblip", CONTROL_FLAG, RTF_JPEGBLIP, 0 },
    { "jsksu", CONTROL_FLAG, RTF_JSKSU, 0 },
    { "keep", CONTROL_FLAG, RTF_KEEP, 0 },
    { "keepn", CONTROL_FLAG, RTF_KEEPN, 0 },
    { "kerning", CONTROL_VALUE, RTF_KERNING, 0 },
    { "keycode", CONTROL_DESTINATION, RTF_KEYCODE, 0 },
    { "keywords", CONTROL_DESTINATION, RTF_KEYWORDS, 0 },
    { "krnprsnet", CONTROL_FLAG, RTF_KRNPRSNET, 0 },
    { "ksulang", CONTROL_VALUE, RTF_KSULANG, 0 },
    { "jclisttab", CONTROL_FLAG, RTF_JCLISTTAB, 0 },
    { "landscape", CONTROL_FLAG, RTF_LANDSCAPE, 0 },
    { "lang", CONTROL_VALUE, RTF_LANG, 0 },
    { "langfe", CONTROL_VALUE, RTF_LANGFE, 0 },
    { "langfenp", CONTROL_VALUE, RTF_LANGFENP, 0 },
    { "langnp", CONTROL_VALUE, RTF_LANGNP, 0 },
    { "lastrow", CONTROL_FLAG, RTF_LASTROW, 0 },
    { "latentstyles", CONTROL_DESTINATION, RTF_LATENTSTYLES, 0 },
    { "lbr", CONTROL_VALUE, RTF_LBR, 0 },
    { "lchars", CONTROL_DESTINATION, RTF_LCHARS, 0 },
    { "ldblquote", CONTROL_SYMBOL, RTF_LDBLQUOTE, 0 },
    { "level", CONTROL_VALUE, RTF_LEVEL, 0 },
    { "levelfollow", CONTROL_VALUE, RTF_LEVELFOLLOW, 0 },
    { "levelindent", CONTROL_VALUE, RTF_LEVELINDENT, 0 },
    { "leveljc", CONTROL_VALUE, RTF_LEVELJC, 0 },
    { "leveljcn", CONTROL_VALUE, RTF_LEVELJCN, 0 },
    { "levellegal", CONTROL_VALUE, RTF_LEVELLEGAL, 0 },
    { "levelnfc", CONTROL_VALUE, RTF_LEVELNFC, 0 },
    { "levelnfcn", CONTROL_VALUE, RTF_LEVELNFCN, 0 },
    { "levelnorestart", CONTROL_VALUE, RTF_LEVELNORESTART, 0 },
    { "levelnumbers", CONTROL_DESTINATION, RTF_LEVELNUMBERS, 0 },
    { "levelold", CONTROL_VALUE, RTF_LEVELOLD, 0 },
    { "levelpicture", CONTROL_VALUE, RTF_LEVELPICTURE, 0 },
    { "levelpicturenosize", CONTROL_FLAG, RTF_LEVELPICTURENOSIZE, 0 },
    { "levelprev", CONTROL_VALUE, RTF_LEVELPREV, 0 },
    { "levelprevspace", CONTROL_VALUE, RTF_LEVELPREVSPACE, 0 },
    { "levelspace", CONTROL_VALUE, RTF_LEVELSPACE, 0 },
    { "levelstartat", CONTROL_VALUE, RTF_LEVELSTARTAT, 0 },
    { "leveltemplateid", CONTROL_VALUE, RTF_LEVELTEMPLATEID, 0 },
    { "leveltext", CONTROL_DESTINATION, RTF_LEVELTEXT, 0 },
    { "lfolevel", CONTROL_DESTINATION, RTF_LFOLEVEL, 0 },
    { "li", CONTROL_VALUE, RTF_LI, 0 },
    { "line", CONTROL_SYMBOL, RTF_LINE, 0 },
    { "linebetcol", CONTROL_FLAG, RTF_LINEBETCOL, 0 },
    { "linecont", CONTROL_FLAG, RTF_LINECONT, 0 },
    { "linemod", CONTROL_VALUE, RTF_LINEMOD, 1 },
    { "lineppage", CONTROL_FLAG, RTF_LINEPPAGE, 0 },
    { "linerestart", CONTROL_FLAG, RTF_LINERESTART, 0 },
    { "linestart", CONTROL_VALUE, RTF_LINESTART, 1 },
    { "linestarts", CONTROL_VALUE, RTF_LINESTARTS, 1 },
    { "linex", CONTROL_VALUE, RTF_LINEX, 360 },
    { "linkself", CONTROL_FLAG, RTF_LINKSELF, 0 },
    { "linkstyles", CONTROL_FLAG, RTF_LINKSTYLES, 0 },
    { "linkval", CONTROL_DESTINATION, RTF_LINKVAL, 0 },
    { "lin", CONTROL_VALUE, RTF_LIN, 0 },
    { "lisa", CONTROL_VALUE, RTF_LISA, 0 },
    { "lisb", CONTROL_VALUE, RTF_LISB, 0 },
    { "list", CONTROL_DESTINATION, RTF_LIST, 0 },
    { "listhybrid", CONTROL_FLAG, RTF_LISTHYBRID, 0 },
    { "listid", CONTROL_VALUE, RTF_LISTID, 0 },
    { "listlevel", CONTROL_DESTINATION, RTF_LISTLEVEL, 0 },
    { "listname", CONTROL_DESTINATION, RTF_LISTNAME, 0 },
    { "listoverride", CONTROL_DESTINATION, RTF_LISTOVERRIDE, 0 },
    { "listoverridecount", CONTROL_VALUE, RTF_LISTOVERRIDECOUNT, 0 },
    { "listoverrideformat", CONTROL_VALUE, RTF_LISTOVERRIDEFORMAT, 0 },
    { "listoverridestartat", CONTROL_FLAG, RTF_LISTOVERRIDESTARTAT, 0 },
    { "listoverridetable", CONTROL_DESTINATION, RTF_LISTOVERRIDETABLE, 0 },
    { "listpicture", CONTROL_DESTINATION, RTF_LISTPICTURE, 0 },
    { "listrestarthdn", CONTROL_VALUE, RTF_LISTRESTARTHDN, 0 },
    { "listsimple", CONTROL_VALUE, RTF_LISTSIMPLE, 0 },
    { "liststyleid", CONTROL_VALUE, RTF_LISTSTYLEID, 0 },
    { "liststylename", CONTROL_DESTINATION, RTF_LISTSTYLENAME, 0 },
    { "listtable", CONTROL_DESTINATION, RTF_LISTTABLE, 0 },
    { "listtemplateid", CONTROL_VALUE, RTF_LISTTEMPLATEID, 0 },
    { "listtext", CONTROL_DESTINATION, RTF_LISTTEXT, 0 },
    { "lnbrkrule", CONTROL_FLAG, RTF_LNBRKRULE, 0 },
    { "lndscpsxn", CONTROL_FLAG, RTF_LNDSCPSXN, 0 },
    { "lnongrid", CONTROL_FLAG, RTF_LNONGRID, 0 },
    { "loch", CONTROL_FLAG, RTF_LOCH, 0 },
    { "lquote", CONTROL_SYMBOL, RTF_LQUOTE, 0 },
    { "ls", CONTROL_VALUE, RTF_LS, 0 },
    { "lsdlocked", CONTROL_VALUE, RTF_LSDLOCKED, 0 },
    { "lsdlockeddef", CONTROL_VALUE, RTF_LSDLOCKEDDEF, 0 },
    { "lsdlockedexcept", CONTROL_DESTINATION, RTF_LSDLOCKEDEXCEPT, 0 },
    { "lsdpriority", CONTROL_VALUE, RTF_LSDPRIORITY, 0 },
    { "lsdprioritydef", CONTROL_VALUE, RTF_LSDPRIORITYDEF, 0 },
    { "lsdqformat", CONTROL_VALUE, RTF_LSDQFORMAT, 0 },
    { "lsdqformatdef", CONTROL_VALUE, RTF_LSDQFORMATDEF, 0 },
    { "lsdsemihidden", CONTROL_VALUE, RTF_LSDSEMIHIDDEN, 0 },
    { "lsdsemihiddendef", CONTROL_VALUE, RTF_LSDSEMIHIDDENDEF, 0 },
    { "lsdstimax", CONTROL_VALUE, RTF_LSDSTIMAX, 0 },
    { "lsdunhideused", CONTROL_VALUE, RTF_LSDUNHIDEUSED, 0 },
    { "lsdunhideuseddef", CONTROL_VALUE, RTF_LSDUNHIDEUSEDDEF, 0 },
    { "ltrch", CONTROL_FLAG, RTF_LTRCH, 0 },
    { "ltrdoc", CONTROL_FLAG, RTF_LTRDOC, 0 },
    { "ltrmark", CONTROL_SYMBOL, RTF_LTRMARK, 0 },
    { "ltrpar", CONTROL_FLAG, RTF_LTRPAR, 0 },
    { "ltrrow", CONTROL_FLAG, RTF_LTRROW, 0 },
    { "ltrsect", CONTROL_FLAG, RTF_LTRSECT, 0 },
    { "lvltentative", CONTROL_FLAG, RTF_LVLTENTATIVE, 0 },
    { "lytcalctblwd", CONTROL_FLAG, RTF_LYTCALCTBLWD, 0 },
    { "lytexcttp", CONTROL_FLAG, RTF_LYTEXCTTP, 0 },
    { "lytprtmet", CONTROL_FLAG, RTF_LYTPRTMET, 0 },
    { "lyttblrtgr", CONTROL_FLAG, RTF_LYTTBLRTGR, 0 },
    { "mac", CONTROL_FLAG, RTF_MAC, 0 },
    { "macc", CONTROL_DESTINATION, RTF_MACC, 0 },
    { "maccPr", CONTROL_DESTINATION, RTF_MACCPR, 0 },
    { "macpict", CONTROL_FLAG, RTF_MACPICT, 0 },
    { "mailmerge", CONTROL_DESTINATION, RTF_MAILMERGE, 0 },
    { "makebackup", CONTROL_FLAG, RTF_MAKEBACKUP, 0 },
    { "maln", CONTROL_DESTINATION, RTF_MALN, 0 },
    { "malnScr", CONTROL_DESTINATION, RTF_MALNSCR, 0 },
    { "manager", CONTROL_DESTINATION, RTF_MANAGER, 0 },
    { "margb", CONTROL_VALUE, RTF_MARGB, 1440 },
    { "margbsxn", CONTROL_VALUE, RTF_MARGBSXN, 0 },
    { "margl", CONTROL_VALUE, RTF_MARGL, 1800 },
    { "marglsxn", CONTROL_VALUE, RTF_MARGLSXN, 0 },
    { "margmirror", CONTROL_FLAG, RTF_MARGMIRROR, 0 },
    { "margmirsxn", CONTROL_FLAG, RTF_MARGMIRSXN, 0 },
    { "margPr", CONTROL_DESTINATION, RTF_MARGPR, 0 },
    { "margr", CONTROL_VALUE, RTF_MARGR, 1800 },
    { "margrsxn", CONTROL_VALUE, RTF_MARGRSXN, 0 },
    { "margSz", CONTROL_VALUE, RTF_MARGSZ, 0 },
    { "margt", CONTROL_VALUE, RTF_MARGT, 1440 },
    { "margtsxn", CONTROL_VALUE, RTF_MARGTSXN, 0 },
    { "mbar", CONTROL_DESTINATION, RTF_MBAR, 0 },
    { "mbarPr", CONTROL_DESTINATION, RTF_MBARPR, 0 },
    { "mbaseJc", CONTROL_DESTINATION, RTF_MBASEJC, 0 },
    { "mbegChr", CONTROL_DESTINATION, RTF_MBEGCHR, 0 },
    { "mborderBox", CONTROL_DESTINATION, RTF_MBORDERBOX, 0 },
    { "mborderBoxPr", CONTROL_DESTINATION, RTF_MBORDERBOXPR, 0 },
    { "mbox", CONTROL_DESTINATION, RTF_MBOX, 0 },
    { "mboxPr", CONTROL_DESTINATION, RTF_MBOXPR, 0 },
    { "mbrk", CONTROL_VALUE, RTF_MBRK, 0 },
    { "mbrkBin", CONTROL_VALUE, RTF_MBRKBIN, 0 },
    { "mbrkBinSub", CONTROL_VALUE, RTF_MBRKBINSUB, 0 },
    { "mcGp", CONTROL_VALUE, RTF_MCGP, 0 },
    { "mcGpRule", CONTROL_VALUE, RTF_MCGPRULE, 0 },
    { "mchr", CONTROL_DESTINATION, RTF_MCHR, 0 },
    { "mcount", CONTROL_DESTINATION, RTF_MCOUNT, 0 },
    { "mcSp", CONTROL_VALUE, RTF_MCSP, 0 },
    { "mctrlPr", CONTROL_DESTINATION, RTF_MCTRLPR, 0 },
    { "md", CONTROL_DESTINATION, RTF_MD, 0 },
    { "mdefJc", CONTROL_VALUE, RTF_MDEFJC, 0 },
    { "mdeg", CONTROL_DESTINATION, RTF_MDEG, 0 },
    { "mdegHide", CONTROL_DESTINATION, RTF_MDEGHIDE, 0 },
    { "mden", CONTROL_DESTINATION, RTF_MDEN, 0 },
    { "mdiff", CONTROL_DESTINATION, RTF_MDIFF, 0 },
    { "mdiffSty", CONTROL_VALUE, RTF_MDIFFSTY, 0 },
    { "mdispdef", CONTROL_VALUE, RTF_MDISPDEF, 1 },
    { "mdPr", CONTROL_DESTINATION, RTF_MDPR, 0 },
    { "me", CONTROL_DESTINATION, RTF_ME, 0 },
    { "mendChr", CONTROL_DESTINATION, RTF_MENDCHR, 0 },
    { "meqArr", CONTROL_DESTINATION, RTF_MEQARR, 0 },
    { "meqArrPr", CONTROL_DESTINATION, RTF_MEQARRPR, 0 },
    { "mf", CONTROL_DESTINATION, RTF_MF, 0 },
    { "mfName", CONTROL_DESTINATION, RTF_MFNAME, 0 },
    { "mfPr", CONTROL_DESTINATION, RTF_MFPR, 0 },
    { "mfunc", CONTROL_DESTINATION, RTF_MFUNC, 0 },
    { "mfuncPr", CONTROL_DESTINATION, RTF_MFUNCPR, 0 },
    { "mgroupChr", CONTROL_DESTINATION, RTF_MGROUPCHR, 0 },
    { "mgroupChrPr", CONTROL_DESTINATION, RTF_MGROUPCHRPR, 0 },
    { "mgrow", CONTROL_DESTINATION, RTF_MGROW, 0 },
    { "mhideBot", CONTROL_DESTINATION, RTF_MHIDEBOT, 0 },
    { "mhideLeft", CONTROL_DESTINATION, RTF_MHIDELEFT, 0 },
    { "mhideRight", CONTROL_DESTINATION, RTF_MHIDERIGHT, 0 },
    { "mhideTop", CONTROL_DESTINATION, RTF_MHIDETOP, 0 },
    { "mhtmltag", CONTROL_DESTINATION, RTF_MHTMLTAG, 0 },
    { "min", CONTROL_VALUE, RTF_MIN, 0 },
    { "minterSp", CONTROL_VALUE, RTF_MINTERSP, 0 },
    { "mintLim", CONTROL_VALUE, RTF_MINTLIM, 0 },
    { "mintraSp", CONTROL_VALUE, RTF_MINTRASP, 0 },
    { "mjc", CONTROL_VALUE, RTF_MJC, 0 },
    { "mlim", CONTROL_DESTINATION, RTF_MLIM, 0 },
    { "mlimloc", CONTROL_DESTINATION, RTF_MLIMLOC, 0 },
    { "mlimLoc", CONTROL_DESTINATION, RTF_MLIMLOC, 0 },
    { "mlimlow", CONTROL_DESTINATION, RTF_MLIMLOW, 0 },
    { "mlimLow", CONTROL_DESTINATION, RTF_MLIMLOW, 0 },
    { "mlimlowPr", CONTROL_DESTINATION, RTF_MLIMLOWPR, 0 },
    { "mlimLowPr", CONTROL_DESTINATION, RTF_MLIMLOWPR, 0 },
    { "mlimupp", CONTROL_DESTINATION, RTF_MLIMUPP, 0 },
    { "mlimUpp", CONTROL_DESTINATION, RTF_MLIMUPP, 0 },
    { "mlimuppPr", CONTROL_DESTINATION, RTF_MLIMUPPPR, 0 },
    { "mlimUppPr", CONTROL_DESTINATION, RTF_MLIMUPPPR, 0 },
    { "mlit", CONTROL_FLAG, RTF_MLIT, 0 },
    { "mlMargin", CONTROL_VALUE, RTF_MLMARGIN, 0 },
    { "mm", CONTROL_DESTINATION, RTF_MM, 0 },
    { "mmaddfieldname", CONTROL_DESTINATION, RTF_MMADDFIELDNAME, 0 },
    { "mmath", CONTROL_DESTINATION, RTF_MMATH, 0 },
    { "mmathFont", CONTROL_VALUE, RTF_MMATHFONT, 0 },
    { "mmathPict", CONTROL_DESTINATION, RTF_MMATHPICT, 0 },
    { "mmathPr", CONTROL_DESTINATION, RTF_MMATHPR, 0 },
    { "mmattach", CONTROL_FLAG, RTF_MMATTACH, 0 },
    { "mmaxdist", CONTROL_DESTINATION, RTF_MMAXDIST, 0 },
    { "mmblanklines", CONTROL_FLAG, RTF_MMBLANKLINES, 0 },
    { "mmc", CONTROL_DESTINATION, RTF_MMC, 0 },
    { "mmcJc", CONTROL_DESTINATION, RTF_MMCJC, 0 },
    { "mmconnectstr", CONTROL_DESTINATION, RTF_MMCONNECTSTR, 0 },
    { "mmconnectstrdata", CONTROL_DESTINATION, RTF_MMCONNECTSTRDATA, 0 },
    { "mmcPr", CONTROL_DESTINATION, RTF_MMCPR, 0 },
    { "mmcs", CONTROL_DESTINATION, RTF_MMCS, 0 },
    { "mmdatasource", CONTROL_DESTINATION, RTF_MMDATASOURCE, 0 },
    { "mmdatatypeaccess", CONTROL_FLAG, RTF_MMDATATYPEACCESS, 0 },
    { "mmdatatypeexcel", CONTROL_FLAG, RTF_MMDATATYPEEXCEL, 0 },
    { "mmdatatypefile", CONTROL_FLAG, RTF_MMDATATYPEFILE, 0 },
    { "mmdatatypeodbc", CONTROL_FLAG, RTF_MMDATATYPEODBC, 0 },
    { "mmdatatypeodso", CONTROL_FLAG, RTF_MMDATATYPEODSO, 0 },
    { "mmdatatypeqt", CONTROL_FLAG, RTF_MMDATATYPEQT, 0 },
    { "mmdefaultsql", CONTROL_FLAG, RTF_MMDEFAULTSQL, 0 },
    { "mmdestemail", CONTROL_FLAG, RTF_MMDESTEMAIL, 0 },
    { "mmdestfax", CONTROL_FLAG, RTF_MMDESTFAX, 0 },
    { "mmdestnewdoc", CONTROL_FLAG, RTF_MMDESTNEWDOC, 0 },
    { "mmdestprinter", CONTROL_FLAG, RTF_MMDESTPRINTER, 0 },
    { "mmerrors", CONTROL_VALUE, RTF_MMERRORS, 0 },
    { "mmfttypeaddress", CONTROL_FLAG, RTF_MMFTTYPEADDRESS, 0 },
    { "mmfttypebarcode", CONTROL_FLAG, RTF_MMFTTYPEBARCODE, 0 },
    { "mmfttypedbcolumn", CONTROL_FLAG, RTF_MMFTTYPEDBCOLUMN, 0 },
    { "mmfttypemapped", CONTROL_FLAG, RTF_MMFTTYPEMAPPED, 0 },
    { "mmfttypenull", CONTROL_FLAG, RTF_MMFTTYPENULL, 0 },
    { "mmfttypesalutation", CONTROL_FLAG, RTF_MMFTTYPESALUTATION, 0 },
    { "mmheadersource", CONTROL_DESTINATION, RTF_MMHEADERSOURCE, 0 },
    { "mmjdsotype", CONTROL_VALUE, RTF_MMJDSOTYPE, 0 },
    { "mmlinktoquery", CONTROL_FLAG, RTF_MMLINKTOQUERY, 0 },
    { "mmmailsubject", CONTROL_DESTINATION, RTF_MMMAILSUBJECT, 0 },
    { "mmmaintypecatalog", CONTROL_FLAG, RTF_MMMAINTYPECATALOG, 0 },
    { "mmmaintypeemail", CONTROL_FLAG, RTF_MMMAINTYPEEMAIL, 0 },
    { "mmmaintypeenvelopes", CONTROL_FLAG, RTF_MMMAINTYPEENVELOPES, 0 },
    { "mmmaintypefax", CONTROL_FLAG, RTF_MMMAINTYPEFAX, 0 },
    { "mmmaintypelabels", CONTROL_FLAG, RTF_MMMAINTYPELABELS, 0 },
    { "mmmaintypeletters", CONTROL_FLAG, RTF_MMMAINTYPELETTERS, 0 },
    { "mmodso", CONTROL_DESTINATION, RTF_MMODSO, 0 },
    { "mmodsoactive", CONTROL_VALUE, RTF_MMODSOACTIVE, 0 },
    { "mmodsocoldelim", CONTROL_VALUE, RTF_MMODSOCOLDELIM, 0 },
    { "mmodsocolumn", CONTROL_VALUE, RTF_MMODSOCOLUMN, 0 },
    { "mmodsodynaddr", CONTROL_VALUE, RTF_MMODSODYNADDR, 0 },
    { "mmodsofhdr", CONTROL_VALUE, RTF_MMODSOFHDR, 0 },
    { "mmodsofilter", CONTROL_DESTINATION, RTF_MMODSOFILTER, 0 },
    { "mmodsofldmpdata", CONTROL_DESTINATION, RTF_MMODSOFLDMPDATA, 0 },
    { "mmodsofmcolumn", CONTROL_VALUE, RTF_MMODSOFMCOLUMN, 0 },
    { "mmodsohash", CONTROL_VALUE, RTF_MMODSOHASH, 0 },
    { "mmodsolid", CONTROL_VALUE, RTF_MMODSOLID, 0 },
    { "mmodsomappedname", CONTROL_DESTINATION, RTF_MMODSOMAPPEDNAME, 0 },
    { "mmodsoname", CONTROL_DESTINATION, RTF_MMODSONAME, 0 },
    { "mmodsorecipdata", CONTROL_DESTINATION, RTF_MMODSORECIPDATA, 0 },
    { "mmodsosort", CONTROL_DESTINATION, RTF_MMODSOSORT, 0 },
    { "mmodsosrc", CONTROL_DESTINATION, RTF_MMODSOSRC, 0 },
    { "mmodsotable", CONTROL_DESTINATION, RTF_MMODSOTABLE, 0 },
    { "mmodsoudl", CONTROL_DESTINATION, RTF_MMODSOUDL, 0 },
    { "mmodsoudldata", CONTROL_DESTINATION, RTF_MMODSOUDLDATA, 0 },
    { "mmodsouniquetag", CONTROL_DESTINATION, RTF_MMODSOUNIQUETAG, 0 },
    { "mmPr", CONTROL_DESTINATION, RTF_MMPR, 0 },
    { "mmquery", CONTROL_DESTINATION, RTF_MMQUERY, 0 },
    { "mmr", CONTROL_DESTINATION, RTF_MMR, 0 },
    { "mmreccur", CONTROL_VALUE, RTF_MMRECCUR, 0 },
    { "mmshowdata", CONTROL_FLAG, RTF_MMSHOWDATA, 0 },
    { "mnary", CONTROL_DESTINATION, RTF_MNARY, 0 },
    { "mnaryLim", CONTROL_VALUE, RTF_MNARYLIM, 0 },
    { "mnaryPr", CONTROL_DESTINATION, RTF_MNARYPR, 0 },
    { "mnoBreak", CONTROL_DESTINATION, RTF_MNOBREAK, 0 },
    { "mnor", CONTROL_FLAG, RTF_MNOR, 0 },
    { "mnum", CONTROL_DESTINATION, RTF_MNUM, 0 },
    { "mo", CONTROL_VALUE, RTF_MO, 0 },
    { "mobjDist", CONTROL_DESTINATION, RTF_MOBJDIST, 0 },
    { "moMath", CONTROL_DESTINATION, RTF_MOMATH, 0 },
    { "moMathPara", CONTROL_DESTINATION, RTF_MOMATHPARA, 0 },
    { "moMathParaPr", CONTROL_DESTINATION, RTF_MOMATHPARAPR, 0 },
    { "mopEmu", CONTROL_DESTINATION, RTF_MOPEMU, 0 },
    { "mphant", CONTROL_DESTINATION, RTF_MPHANT, 0 },
    { "mphantPr", CONTROL_DESTINATION, RTF_MPHANTPR, 0 },
    { "mplcHide", CONTROL_DESTINATION, RTF_MPLCHIDE, 0 },
    { "mpos", CONTROL_DESTINATION, RTF_MPOS, 0 },
    { "mpostSp", CONTROL_VALUE, RTF_MPOSTSP, 0 },
    { "mpreSp", CONTROL_VALUE, RTF_MPRESP, 0 },
    { "mr", CONTROL_DESTINATION, RTF_MR, 0 },
    { "mrad", CONTROL_DESTINATION, RTF_MRAD, 0 },
    { "mradPr", CONTROL_DESTINATION, RTF_MRADPR, 0 },
    { "mrMargin", CONTROL_VALUE, RTF_MRMARGIN, 0 },
    { "mrPr", CONTROL_DESTINATION, RTF_MRPR, 0 },
    { "mrSp", CONTROL_VALUE, RTF_MRSP, 0 },
    { "mrSpRule", CONTROL_VALUE, RTF_MRSPRULE, 0 },
    { "mscr", CONTROL_VALUE, RTF_MSCR, 0 },
    { "msepChr", CONTROL_DESTINATION, RTF_MSEPCHR, 0 },
    { "mshow", CONTROL_DESTINATION, RTF_MSHOW, 0 },
    { "mshp", CONTROL_DESTINATION, RTF_MSHP, 0 },
    { "msmallFrac", CONTROL_VALUE, RTF_MSMALLFRAC, 0 },
    { "msmcap", CONTROL_FLAG, RTF_MSMCAP, 0 },
    { "msPre", CONTROL_DESTINATION, RTF_MSPRE, 0 },
    { "msPrePr", CONTROL_DESTINATION, RTF_MSPREPR, 0 },
    { "msSub", CONTROL_DESTINATION, RTF_MSSUB, 0 },
    { "msSubPr", CONTROL_DESTINATION, RTF_MSSUBPR, 0 },
    { "msSubSup", CONTROL_DESTINATION, RTF_MSSUBSUP, 0 },
    { "msSubSupPr", CONTROL_DESTINATION, RTF_MSSUBSUPPR, 0 },
    { "msSup", CONTROL_DESTINATION, RTF_MSSUP, 0 },
    { "msSupPr", CONTROL_DESTINATION, RTF_MSSUPPR, 0 },
    { "mstrikeBLTR", CONTROL_DESTINATION, RTF_MSTRIKEBLTR, 0 },
    { "mstrikeH", CONTROL_DESTINATION, RTF_MSTRIKEH, 0 },
    { "mstrikeTLBR", CONTROL_DESTINATION, RTF_MSTRIKETLBR, 0 },
    { "mstrikeV", CONTROL_DESTINATION, RTF_MSTRIKEV, 0 },
    { "msty", CONTROL_VALUE, RTF_MSTY, 0 },
    { "msub", CONTROL_DESTINATION, RTF_MSUB, 0 },
    { "msubHide", CONTROL_DESTINATION, RTF_MSUBHIDE, 0 },
    { "msup", CONTROL_DESTINATION, RTF_MSUP, 0 },
    { "msupHide", CONTROL_DESTINATION, RTF_MSUPHIDE, 0 },
    { "mtransp", CONTROL_DESTINATION, RTF_MTRANSP, 0 },
    { "mtype", CONTROL_DESTINATION, RTF_MTYPE, 0 },
    { "muser", CONTROL_FLAG, RTF_MUSER, 0 },
    { "mvauth", CONTROL_VALUE, RTF_MVAUTH, 0 },
    { "mvdate", CONTROL_VALUE, RTF_MVDATE, 0 },
    { "mvertJc", CONTROL_DESTINATION, RTF_MVERTJC, 0 },
    { "mvf", CONTROL_FLAG, RTF_MVF, 0 },
    { "mvfmf", CONTROL_DESTINATION, RTF_MVFMF, 0 },
    { "mvfml", CONTROL_DESTINATION, RTF_MVFML, 0 },
    { "mvt", CONTROL_FLAG, RTF_MVT, 0 },
    { "mvtof", CONTROL_DESTINATION, RTF_MVTOF, 0 },
    { "mvtol", CONTROL_DESTINATION, RTF_MVTOL, 0 },
    { "mwrapIndent", CONTROL_VALUE, RTF_MWRAPINDENT, 1440 },
    { "mwrapRight", CONTROL_VALUE, RTF_MWRAPRIGHT, 0 },
    { "mzeroAsc", CONTROL_DESTINATION, RTF_MZEROASC, 0 },
    { "mzeroDesc", CONTROL_DESTINATION, RTF_MZERODESC, 0 },
    { "mzeroWid", CONTROL_DESTINATION, RTF_MZEROWID, 0 },
    { "nestcell", CONTROL_SYMBOL, RTF_NESTCELL, 0 },
    { "nestrow", CONTROL_SYMBOL, RTF_NESTROW, 0 },
    { "nesttableprops", CONTROL_DESTINATION, RTF_NESTTABLEPROPS, 0 },
    { "newtblstyruls", CONTROL_FLAG, RTF_NEWTBLSTYRULS, 0 },
    { "nextfile", CONTROL_DESTINATION, RTF_NEXTFILE, 0 },
    { "noafcnsttbl", CONTROL_FLAG, RTF_NOAFCNSTTBL, 0 },
    { "nobrkwrptbl", CONTROL_FLAG, RTF_NOBRKWRPTBL, 0 },
    { "nocolbal", CONTROL_FLAG, RTF_NOCOLBAL, 0 },
    { "nocompatoptions", CONTROL_FLAG, RTF_NOCOMPATOPTIONS, 0 },
    { "nocwrap", CONTROL_FLAG, RTF_NOCWRAP, 0 },
    { "nocxsptable", CONTROL_FLAG, RTF_NOCXSPTABLE, 0 },
    { "noextrasprl", CONTROL_FLAG, RTF_NOEXTRASPRL, 0 },
    { "nofchars", CONTROL_VALUE, RTF_NOFCHARS, 0 },
    { "nofcharsws", CONTROL_VALUE, RTF_NOFCHARSWS, 0 },
    { "nofeaturethrottle", CONTROL_FLAG, RTF_NOFEATURETHROTTLE, 0 },
    { "nofpages", CONTROL_VALUE, RTF_NOFPAGES, 0 },
    { "nofwords", CONTROL_VALUE, RTF_NOFWORDS, 0 },
    { "nogrowautofit", CONTROL_FLAG, RTF_NOGROWAUTOFIT, 0 },
    { "noindnmbrts", CONTROL_FLAG, RTF_NOINDNMBRTS, 0 },
    { "nojkernpunct", CONTROL_FLAG, RTF_NOJKERNPUNCT, 0 },
    { "nolead", CONTROL_FLAG, RTF_NOLEAD, 0 },
    { "noline", CONTROL_FLAG, RTF_NOLINE, 0 },
    { "nolnhtadjtbl", CONTROL_FLAG, RTF_NOLNHTADJTBL, 0 },
    { "nonesttables", CONTROL_DESTINATION, RTF_NONESTTABLES, 0 },
    { "nonshppict", CONTROL_FLAG, RTF_NONSHPPICT, 0 },
    { "nooverflow", CONTROL_FLAG, RTF_NOOVERFLOW, 0 },
    { "noproof", CONTROL_FLAG, RTF_NOPROOF, 0 },
    { "noqfpromote", CONTROL_FLAG, RTF_NOQFPROMOTE, 0 },
    { "nosectexpand", CONTROL_FLAG, RTF_NOSECTEXPAND, 0 },
    { "nosnaplinegrid", CONTROL_FLAG, RTF_NOSNAPLINEGRID, 0 },
    { "nospaceforul", CONTROL_FLAG, RTF_NOSPACEFORUL, 0 },
    { "nosupersub", CONTROL_FLAG, RTF_NOSUPERSUB, 0 },
    { "notabind", CONTROL_FLAG, RTF_NOTABIND, 0 },
    { "notbrkcnstfrctbl", CONTROL_FLAG, RTF_NOTBRKCNSTFRCTBL, 0 },
    { "notcvasp", CONTROL_FLAG, RTF_NOTCVASP, 0 },
    { "notvatxbx", CONTROL_FLAG, RTF_NOTVATXBX, 0 },
    { "nouicompat", CONTROL_FLAG, RTF_NOUICOMPAT, 0 },
    { "noultrlspc", CONTROL_FLAG, RTF_NOULTRLSPC, 0 },
    { "nowidctlpar", CONTROL_FLAG, RTF_NOWIDCTLPAR, 0 },
    { "nowrap", CONTROL_FLAG, RTF_NOWRAP, 0 },
    { "nowwrap", CONTROL_FLAG, RTF_NOWWRAP, 0 },
    { "noxlattoyen", CONTROL_FLAG, RTF_NOXLATTOYEN, 0 },
    { "objalias", CONTROL_DESTINATION, RTF_OBJALIAS, 0 },
    { "objalign", CONTROL_VALUE, RTF_OBJALIGN, 0 },
    { "objattph", CONTROL_FLAG, RTF_OBJATTPH, 0 },
    { "objautlink", CONTROL_FLAG, RTF_OBJAUTLINK, 0 },
    { "objclass", CONTROL_DESTINATION, RTF_OBJCLASS, 0 },
    { "objcropb", CONTROL_VALUE, RTF_OBJCROPB, 0 },
    { "objcropl", CONTROL_VALUE, RTF_OBJCROPL, 0 },
    { "objcropr", CONTROL_VALUE, RTF_OBJCROPR, 0 },
    { "objcropt", CONTROL_VALUE, RTF_OBJCROPT, 0 },
    { "objdata", CONTROL_DESTINATION, RTF_OBJDATA, 0 },
    { "object", CONTROL_DESTINATION, RTF_OBJECT, 0 },
    { "objemb", CONTROL_FLAG, RTF_OBJEMB, 0 },
    { "objh", CONTROL_VALUE, RTF_OBJH, 0 },
    { "objhtml", CONTROL_FLAG, RTF_OBJHTML, 0 },
    { "objicemb", CONTROL_FLAG, RTF_OBJICEMB, 0 },
    { "objlink", CONTROL_FLAG, RTF_OBJLINK, 0 },
    { "objlock", CONTROL_FLAG, RTF_OBJLOCK, 0 },
    { "objname", CONTROL_DESTINATION, RTF_OBJNAME, 0 },
    { "objocx", CONTROL_FLAG, RTF_OBJOCX, 0 },
    { "objpub", CONTROL_FLAG, RTF_OBJPUB, 0 },
    { "objscalex", CONTROL_VALUE, RTF_OBJSCALEX, 0 },
    { "objscaley", CONTROL_VALUE, RTF_OBJSCALEY, 0 },
    { "objsect", CONTROL_DESTINATION, RTF_OBJSECT, 0 },
    { "objsetsize", CONTROL_FLAG, RTF_OBJSETSIZE, 0 },
    { "objsub", CONTROL_FLAG, RTF_OBJSUB, 0 },
    { "objtime", CONTROL_DESTINATION, RTF_OBJTIME, 0 },
    { "objtransy", CONTROL_VALUE, RTF_OBJTRANSY, 0 },
    { "objupdate", CONTROL_FLAG, RTF_OBJUPDATE, 0 },
    { "objw", CONTROL_VALUE, RTF_OBJW, 0 },
    { "ogutter", CONTROL_VALUE, RTF_OGUTTER, 0 },
    { "oldas", CONTROL_FLAG, RTF_OLDAS, 0 },
    { "oldcprops", CONTROL_DESTINATION, RTF_OLDCPROPS, 0 },
    { "oldlinewrap", CONTROL_FLAG, RTF_OLDLINEWRAP, 0 },
    { "oldpprops", CONTROL_DESTINATION, RTF_OLDPPROPS, 0 },
    { "oldsprops", CONTROL_DESTINATION, RTF_OLDSPROPS, 0 },
    { "oldtprops", CONTROL_DESTINATION, RTF_OLDTPROPS, 0 },
    { "oleclsid", CONTROL_DESTINATION, RTF_OLECLSID, 0 },
    { "operator", CONTROL_DESTINATION, RTF_OPERATOR, 0 },
    { "otblrul", CONTROL_FLAG, RTF_OTBLRUL, 0 },
    { "outl", CONTROL_TOGGLE, RTF_OUTL, 1 },
    { "outlinelevel", CONTROL_VALUE, RTF_OUTLINELEVEL, 0 },
    { "overlay", CONTROL_FLAG, RTF_OVERLAY, 0 },
    { "page", CONTROL_SYMBOL, RTF_PAGE, 0 },
    { "pagebb", CONTROL_FLAG, RTF_PAGEBB, 0 },
    { "panose", CONTROL_DESTINATION, RTF_PANOSE, 0 },
    { "paperh", CONTROL_VALUE, RTF_PAPERH, 15840 },
    { "paperw", CONTROL_VALUE, RTF_PAPERW, 12240 },
    { "par", CONTROL_SYMBOL, RTF_PAR, 0 },
    { "pararsid", CONTROL_VALUE, RTF_PARARSID, 0 },
    { "pard", CONTROL_FLAG, RTF_PARD, 0 },
    { "password", CONTROL_DESTINATION, RTF_PASSWORD, 0 },
    { "passwordhash", CONTROL_DESTINATION, RTF_PASSWORDHASH, 0 },
    { "pc", CONTROL_FLAG, RTF_PC, 0 },
    { "pca", CONTROL_FLAG, RTF_PCA, 0 },
    { "pgbrdrb", CONTROL_FLAG, RTF_PGBRDRB, 0 },
    { "pgbrdrfoot", CONTROL_FLAG, RTF_PGBRDRFOOT, 0 },
    { "pgbrdrhead", CONTROL_FLAG, RTF_PGBRDRHEAD, 0 },
    { "pgbrdrl", CONTROL_FLAG, RTF_PGBRDRL, 0 },
    { "pgbrdropt", CONTROL_VALUE, RTF_PGBRDROPT, 0 },
    { "pgbrdrr", CONTROL_FLAG, RTF_PGBRDRR, 0 },
    { "pgbrdrsnap", CONTROL_FLAG, RTF_PGBRDRSNAP, 0 },
    { "pgbrdrt", CONTROL_FLAG, RTF_PGBRDRT, 0 },
    { "pghsxn", CONTROL_VALUE, RTF_PGHSXN, 0 },
    { "pgnbidia", CONTROL_FLAG, RTF_PGNBIDIA, 0 },
    { "pgnbidib", CONTROL_FLAG, RTF_PGNBIDIB, 0 },
    { "pgnchosung", CONTROL_FLAG, RTF_PGNCHOSUNG, 0 },
    { "pgncnum", CONTROL_FLAG, RTF_PGNCNUM, 0 },
    { "pgncont", CONTROL_FLAG, RTF_PGNCONT, 0 },
    { "pgndbnum", CONTROL_FLAG, RTF_PGNDBNUM, 0 },
    { "pgndbnumd", CONTROL_FLAG, RTF_PGNDBNUMD, 0 },
    { "pgndbnumk", CONTROL_FLAG, RTF_PGNDBNUMK, 0 },
    { "pgndbnumt", CONTROL_FLAG, RTF_PGNDBNUMT, 0 },
    { "pgndec", CONTROL_FLAG, RTF_PGNDEC, 0 },
    { "pgndecd", CONTROL_FLAG, RTF_PGNDECD, 0 },
    { "pgnganada", CONTROL_FLAG, RTF_PGNGANADA, 0 },
    { "pgngbnum", CONTROL_FLAG, RTF_PGNGBNUM, 0 },
    { "pgngbnumd", CONTROL_FLAG, RTF_PGNGBNUMD, 0 },
    { "pgngbnumk", CONTROL_FLAG, RTF_PGNGBNUMK, 0 },
    { "pgngbnuml", CONTROL_FLAG, RTF_PGNGBNUML, 0 },
    { "pgnhindia", CONTROL_FLAG, RTF_PGNHINDIA, 0 },
    { "pgnhindib", CONTROL_FLAG, RTF_PGNHINDIB, 0 },
    { "pgnhindic", CONTROL_FLAG, RTF_PGNHINDIC, 0 },
    { "pgnhindid", CONTROL_FLAG, RTF_PGNHINDID, 0 },
    { "pgnhn", CONTROL_VALUE, RTF_PGNHN, 0 },
    { "pgnhnsc", CONTROL_FLAG, RTF_PGNHNSC, 0 },
    { "pgnhnsh", CONTROL_FLAG, RTF_PGNHNSH, 0 },
    { "pgnhnsm", CONTROL_FLAG, RTF_PGNHNSM, 0 },
    { "pgnhnsn", CONTROL_FLAG, RTF_PGNHNSN, 0 },
    { "pgnhnsp", CONTROL_FLAG, RTF_PGNHNSP, 0 },
    { "pgnid", CONTROL_FLAG, RTF_PGNID, 0 },
    { "pgnlcltr", CONTROL_FLAG, RTF_PGNLCLTR, 0 },
    { "pgnlcrm", CONTROL_FLAG, RTF_PGNLCRM, 0 },
    { "pgnrestart", CONTROL_FLAG, RTF_PGNRESTART, 0 },
    { "pgnstart", CONTROL_VALUE, RTF_PGNSTART, 1 },
    { "pgnstarts", CONTROL_VALUE, RTF_PGNSTARTS, 1 },
    { "pgnthaia", CONTROL_FLAG, RTF_PGNTHAIA, 0 },
    { "pgnthaib", CONTROL_FLAG, RTF_PGNTHAIB, 0 },
    { "pgnthaic", CONTROL_FLAG, RTF_PGNTHAIC, 0 },
    { "pgnucltr", CONTROL_FLAG, RTF_PGNUCLTR, 0 },
    { "pgnucrm", CONTROL_FLAG, RTF_PGNUCRM, 0 },
    { "pgnvieta", CONTROL_FLAG, RTF_PGNVIETA, 0 },
    { "pgnx", CONTROL_VALUE, RTF_PGNX, 720 },
    { "pgny", CONTROL_VALUE, RTF_PGNY, 720 },
    { "pgnzodiac", CONTROL_FLAG, RTF_PGNZODIAC, 0 },
    { "pgnzodiacd", CONTROL_FLAG, RTF_PGNZODIACD, 0 },
    { "pgnzodiacl", CONTROL_FLAG, RTF_PGNZODIACL, 0 },
    { "pgp", CONTROL_DESTINATION, RTF_PGP, 0 },
    { "pgptbl", CONTROL_DESTINATION, RTF_PGPTBL, 0 },
    { "pgwsxn", CONTROL_VALUE, RTF_PGWSXN, 0 },
    { "phcol", CONTROL_FLAG, RTF_PHCOL, 0 },
    { "phmrg", CONTROL_FLAG, RTF_PHMRG, 0 },
    { "phpg", CONTROL_FLAG, RTF_PHPG, 0 },
    { "picbmp", CONTROL_FLAG, RTF_PICBMP, 0 },
    { "picbpp", CONTROL_VALUE, RTF_PICBPP, 0 },
    { "piccropb", CONTROL_VALUE, RTF_PICCROPB, 0 },
    { "piccropl", CONTROL_VALUE, RTF_PICCROPL, 0 },
    { "piccropr", CONTROL_VALUE, RTF_PICCROPR, 0 },
    { "piccropt", CONTROL_VALUE, RTF_PICCROPT, 0 },
    { "pich", CONTROL_VALUE, RTF_PICH, 0 },
    { "pichgoal", CONTROL_VALUE, RTF_PICHGOAL, 0 },
    { "pichGoal", CONTROL_VALUE, RTF_PICHGOAL, 0 },
    { "picprop", CONTROL_DESTINATION, RTF_PICPROP, 0 },
    { "picscaled", CONTROL_FLAG, RTF_PICSCALED, 0 },
    { "picscalex", CONTROL_VALUE, RTF_PICSCALEX, 100 },
    { "picscaley", CONTROL_VALUE, RTF_PICSCALEY, 100 },
    { "pict", CONTROL_DESTINATION, RTF_PICT, 0 },
    { "picw", CONTROL_VALUE, RTF_PICW, 0 },
    { "picwgoal", CONTROL_VALUE, RTF_PICWGOAL, 0 },
    { "picwGoal", CONTROL_VALUE, RTF_PICWGOAL, 0 },
    { "pindtabqc", CONTROL_FLAG, RTF_PINDTABQC, 0 },
    { "pindtabql", CONTROL_FLAG, RTF_PINDTABQL, 0 },
    { "pindtabqr", CONTROL_FLAG, RTF_PINDTABQR, 0 },
    { "plain", CONTROL_FLAG, RTF_PLAIN, 0 },
    { "pmartabqc", CONTROL_FLAG, RTF_PMARTABQC, 0 },
    { "pmartabql", CONTROL_FLAG, RTF_PMARTABQL, 0 },
    { "pmartabqr", CONTROL_FLAG, RTF_PMARTABQR, 0 },
    { "pmmetafile", CONTROL_VALUE, RTF_PMMETAFILE, 0 },
    { "pn", CONTROL_DESTINATION, RTF_PN, 0 },
    { "pnacross", CONTROL_FLAG, RTF_PNACROSS, 0 },
    { "pnaiu", CONTROL_FLAG, RTF_PNAIU, 0 },
    { "pnaiud", CONTROL_FLAG, RTF_PNAIUD, 0 },
    { "pnaiueo", CONTROL_FLAG, RTF_PNAIUEO, 0 },
    { "pnaiueod", CONTROL_FLAG, RTF_PNAIUEOD, 0 },
    { "pnb", CONTROL_TOGGLE, RTF_PNB, 1 },
    { "pnbidia", CONTROL_FLAG, RTF_PNBIDIA, 0 },
    { "pnbidib", CONTROL_FLAG, RTF_PNBIDIB, 0 },
    { "pncaps", CONTROL_TOGGLE, RTF_PNCAPS, 1 },
    { "pncard", CONTROL_FLAG, RTF_PNCARD, 0 },
    { "pncf", CONTROL_VALUE, RTF_PNCF, 0 },
    { "pnchosung", CONTROL_FLAG, RTF_PNCHOSUNG, 0 },
    { "pncnum", CONTROL_FLAG, RTF_PNCNUM, 0 },
    { "pndbnum", CONTROL_FLAG, RTF_PNDBNUM, 0 },
    { "pndbnumd", CONTROL_FLAG, RTF_PNDBNUMD, 0 },
    { "pndbnumk", CONTROL_FLAG, RTF_PNDBNUMK, 0 },
    { "pndbnuml", CONTROL_FLAG, RTF_PNDBNUML, 0 },
    { "pndbnumt", CONTROL_FLAG, RTF_PNDBNUMT, 0 },
    { "pndec", CONTROL_FLAG, RTF_PNDEC, 0 },
    { "pndecd", CONTROL_FLAG, RTF_PNDECD, 0 },
    { "pnf", CONTROL_VALUE, RTF_PNF, 0 },
    { "pnfs", CONTROL_VALUE, RTF_PNFS, 0 },
    { "pnganada", CONTROL_FLAG, RTF_PNGANADA, 0 },
    { "pngblip", CONTROL_FLAG, RTF_PNGBLIP, 0 },
    { "pngbnum", CONTROL_FLAG, RTF_PNGBNUM, 0 },
    { "pngbnumd", CONTROL_FLAG, RTF_PNGBNUMD, 0 },
    { "pngbnumk", CONTROL_FLAG, RTF_PNGBNUMK, 0 },
    { "pngbnuml", CONTROL_FLAG, RTF_PNGBNUML, 0 },
    { "pnhang", CONTROL_FLAG, RTF_PNHANG, 0 },
    { "pni", CONTROL_TOGGLE, RTF_PNI, 1 },
    { "pnindent", CONTROL_VALUE, RTF_PNINDENT, 0 },
    { "pniroha", CONTROL_FLAG, RTF_PNIROHA, 0 },
    { "pnirohad", CONTROL_FLAG, RTF_PNIROHAD, 0 },
    { "pnlcltr", CONTROL_FLAG, RTF_PNLCLTR, 0 },
    { "pnlcrm", CONTROL_FLAG, RTF_PNLCRM, 0 },
    { "pnlvl", CONTROL_VALUE, RTF_PNLVL, 0 },
    { "pnlvlblt", CONTROL_FLAG, RTF_PNLVLBLT, 0 },
    { "pnlvlbody", CONTROL_FLAG, RTF_PNLVLBODY, 0 },
    { "pnlvlcont", CONTROL_FLAG, RTF_PNLVLCONT, 0 },
    { "pnnumonce", CONTROL_FLAG, RTF_PNNUMONCE, 0 },
    { "pnord", CONTROL_FLAG, RTF_PNORD, 0 },
    { "pnordt", CONTROL_FLAG, RTF_PNORDT, 0 },
    { "pnprev", CONTROL_FLAG, RTF_PNPREV, 0 },
    { "pnqc", CONTROL_FLAG, RTF_PNQC, 0 },
    { "pnql", CONTROL_FLAG, RTF_PNQL, 0 },
    { "pnqr", CONTROL_FLAG, RTF_PNQR, 0 },
    { "pnrauth", CONTROL_VALUE, RTF_PNRAUTH, 0 },
    { "pnrdate", CONTROL_VALUE, RTF_PNRDATE, 0 },
    { "pnrestart", CONTROL_FLAG, RTF_PNRESTART, 0 },
    { "pnrnfc", CONTROL_VALUE, RTF_PNRNFC, 0 },
    { "pnrnot", CONTROL_FLAG, RTF_PNRNOT, 0 },
    { "pnrpnbr", CONTROL_VALUE, RTF_PNRPNBR, 0 },
    { "pnrrgb", CONTROL_VALUE, RTF_PNRRGB, 0 },
    { "pnrstart", CONTROL_VALUE, RTF_PNRSTART, 0 },
    { "pnrstop", CONTROL_VALUE, RTF_PNRSTOP, 0 },
    { "pnrxst", CONTROL_VALUE, RTF_PNRXST, 0 },
    { "pnscaps", CONTROL_TOGGLE, RTF_PNSCAPS, 1 },
    { "pnseclvl", CONTROL_DESTINATION, RTF_PNSECLVL, 0 },
    { "pnsp", CONTROL_VALUE, RTF_PNSP, 0 },
    { "pnstart", CONTROL_VALUE, RTF_PNSTART, 0 },
    { "pnstrike", CONTROL_TOGGLE, RTF_PNSTRIKE, 1 },
    { "pntext", CONTROL_DESTINATION, RTF_PNTEXT, 0 },
    { "pntxta", CONTROL_DESTINATION, RTF_PNTXTA, 0 },
    { "pntxtb", CONTROL_DESTINATION, RTF_PNTXTB, 0 },
    { "pnucltr", CONTROL_FLAG, RTF_PNUCLTR, 0 },
    { "pnucrm", CONTROL_FLAG, RTF_PNUCRM, 0 },
    { "pnul", CONTROL_TOGGLE, RTF_PNUL, 1 },
    { "pnuld", CONTROL_FLAG, RTF_PNULD, 0 },
    { "pnuldash", CONTROL_FLAG, RTF_PNULDASH, 0 },
    { "pnuldashd", CONTROL_FLAG, RTF_PNULDASHD, 0 },
    { "pnuldashdd", CONTROL_FLAG, RTF_PNULDASHDD, 0 },
    { "pnuldb", CONTROL_FLAG, RTF_PNULDB, 0 },
    { "pnulhair", CONTROL_FLAG, RTF_PNULHAIR, 0 },
    { "pnulnone", CONTROL_FLAG, RTF_PNULNONE, 0 },
    { "pnulth", CONTROL_FLAG, RTF_PNULTH, 0 },
    { "pnulw", CONTROL_FLAG, RTF_PNULW, 0 },
    { "pnulwave", CONTROL_FLAG, RTF_PNULWAVE, 0 },
    { "pnzodiac", CONTROL_FLAG, RTF_PNZODIAC, 0 },
    { "pnzodiacd", CONTROL_FLAG, RTF_PNZODIACD, 0 },
    { "pnzodiacl", CONTROL_FLAG, RTF_PNZODIACL, 0 },
    { "posnegx", CONTROL_VALUE, RTF_POSNEGX, 0 },
    { "posnegy", CONTROL_VALUE, RTF_POSNEGY, 0 },
    { "posx", CONTROL_VALUE, RTF_POSX, 0 },
    { "posxc", CONTROL_FLAG, RTF_POSXC, 0 },
    { "posxi", CONTROL_FLAG, RTF_POSXI, 0 },
    { "posxl", CONTROL_FLAG, RTF_POSXL, 0 },
    { "posxo", CONTROL_FLAG, RTF_POSXO, 0 },
    { "posxr", CONTROL_FLAG, RTF_POSXR, 0 },
    { "posy", CONTROL_VALUE, RTF_POSY, 0 },
    { "posyb", CONTROL_FLAG, RTF_POSYB, 0 },
    { "posyc", CONTROL_FLAG, RTF_POSYC, 0 },
    { "posyil", CONTROL_FLAG, RTF_POSYIL, 0 },
    { "posyin", CONTROL_FLAG, RTF_POSYIN, 0 },
    { "posyout", CONTROL_FLAG, RTF_POSYOUT, 0 },
    { "posyt", CONTROL_FLAG, RTF_POSYT, 0 },
    { "prauth", CONTROL_VALUE, RTF_PRAUTH, 0 },
    { "prcolbl", CONTROL_FLAG, RTF_PRCOLBL, 0 },
    { "prdate", CONTROL_VALUE, RTF_PRDATE, 0 },
    { "printdata", CONTROL_FLAG, RTF_PRINTDATA, 0 },
    { "printim", CONTROL_DESTINATION, RTF_PRINTIM, 0 },
    { "private", CONTROL_DESTINATION, RTF_PRIVATE, 0 },
    { "propname", CONTROL_DESTINATION, RTF_PROPNAME, 0 },
    { "proptype", CONTROL_VALUE, RTF_PROPTYPE, 0 },
    { "protect", CONTROL_TOGGLE, RTF_PROTECT, 1 },
    { "protend", CONTROL_DESTINATION, RTF_PROTEND, 0 },
    { "protlevel", CONTROL_VALUE, RTF_PROTLEVEL, 0 },
    { "protstart", CONTROL_DESTINATION, RTF_PROTSTART, 0 },
    { "protusertbl", CONTROL_DESTINATION, RTF_PROTUSERTBL, 0 },
    { "psover", CONTROL_FLAG, RTF_PSOVER, 0 },
    { "psz", CONTROL_VALUE, RTF_PSZ, 0 },
    { "ptabldot", CONTROL_FLAG, RTF_PTABLDOT, 0 },
    { "ptablmdot", CONTROL_FLAG, RTF_PTABLMDOT, 0 },
    { "ptablminus", CONTROL_FLAG, RTF_PTABLMINUS, 0 },
    { "ptablnone", CONTROL_FLAG, RTF_PTABLNONE, 0 },
    { "ptabluscore", CONTROL_FLAG, RTF_PTABLUSCORE, 0 },
    { "pubauto", CONTROL_FLAG, RTF_PUBAUTO, 0 },
    { "pvmrg", CONTROL_FLAG, RTF_PVMRG, 0 },
    { "pvpara", CONTROL_FLAG, RTF_PVPARA, 0 },
    { "pvpg", CONTROL_FLAG, RTF_PVPG, 0 },
    { "pwd", CONTROL_VALUE, RTF_PWD, 0 },
    { "pxe", CONTROL_DESTINATION, RTF_PXE, 0 },
    { "qc", CONTROL_FLAG, RTF_QC, 0 },
    { "qd", CONTROL_FLAG, RTF_QD, 0 },
    { "qj", CONTROL_FLAG, RTF_QJ, 0 },
    { "qk", CONTROL_VALUE, RTF_QK, 0 },
    { "ql", CONTROL_FLAG, RTF_QL, 0 },
    { "qmspace", CONTROL_SYMBOL, RTF_QMSPACE, 0 },
    { "qr", CONTROL_FLAG, RTF_QR, 0 },
    { "qt", CONTROL_FLAG, RTF_QT, 0 },
    { "rawclbgdkbdiag", CONTROL_FLAG, RTF_RAWCLBGDKBDIAG, 0 },
    { "rawclbgbdiag", CONTROL_FLAG, RTF_RAWCLBGBDIAG, 0 },
    { "rawclbgcross", CONTROL_FLAG, RTF_RAWCLBGCROSS, 0 },
    { "rawclbgdcross", CONTROL_FLAG, RTF_RAWCLBGDCROSS, 0 },
    { "rawclbgdkcross", CONTROL_FLAG, RTF_RAWCLBGDKCROSS, 0 },
    { "rawclbgdkdcross", CONTROL_FLAG, RTF_RAWCLBGDKDCROSS, 0 },
    { "rawclbgdkfdiag", CONTROL_FLAG, RTF_RAWCLBGDKFDIAG, 0 },
    { "rawclbgdkhor", CONTROL_FLAG, RTF_RAWCLBGDKHOR, 0 },
    { "rawclbgdkvert", CONTROL_FLAG, RTF_RAWCLBGDKVERT, 0 },
    { "rawclbgfdiag", CONTROL_FLAG, RTF_RAWCLBGFDIAG, 0 },
    { "rawclbghoriz", CONTROL_FLAG, RTF_RAWCLBGHORIZ, 0 },
    { "rawclbgvert", CONTROL_FLAG, RTF_RAWCLBGVERT, 0 },
    { "rdblquote", CONTROL_SYMBOL, RTF_RDBLQUOTE, 0 },
    { "readonlyrecommended", CONTROL_FLAG, RTF_READONLYRECOMMENDED, 0 },
    { "readprot", CONTROL_FLAG, RTF_READPROT, 0 },
    { "red", CONTROL_VALUE, RTF_RED, 0 },
    { "relyonvml", CONTROL_VALUE, RTF_RELYONVML, 0 },
    { "remdttm", CONTROL_FLAG, RTF_REMDTTM, 0 },
    { "rempersonalinfo", CONTROL_FLAG, RTF_REMPERSONALINFO, 0 },
    { "result", CONTROL_DESTINATION, RTF_RESULT, 0 },
    { "revauth", CONTROL_VALUE, RTF_REVAUTH, 0 },
    { "revauthdel", CONTROL_VALUE, RTF_REVAUTHDEL, 0 },
    { "revbar", CONTROL_VALUE, RTF_REVBAR, 3 },
    { "revdttm", CONTROL_VALUE, RTF_REVDTTM, 0 },
    { "revdttmdel", CONTROL_VALUE, RTF_REVDTTMDEL, 0 },
    { "revised", CONTROL_TOGGLE, RTF_REVISED, 1 },
    { "revisions", CONTROL_FLAG, RTF_REVISIONS, 0 },
    { "revprop", CONTROL_VALUE, RTF_REVPROP, 3 },
    { "revprot", CONTROL_FLAG, RTF_REVPROT, 0 },
    { "revtbl", CONTROL_DESTINATION, RTF_REVTBL, 0 },
    { "revtim", CONTROL_DESTINATION, RTF_REVTIM, 0 },
    { "ri", CONTROL_VALUE, RTF_RI, 0 },
    { "rin", CONTROL_VALUE, RTF_RIN, 0 },
    { "row", CONTROL_SYMBOL, RTF_ROW, 0 },
    { "rquote", CONTROL_SYMBOL, RTF_RQUOTE, 0 },
    { "rsid", CONTROL_VALUE, RTF_RSID, 0 },
    { "rsidroot", CONTROL_VALUE, RTF_RSIDROOT, 0 },
    { "rsidtbl", CONTROL_DESTINATION, RTF_RSIDTBL, 0 },
    { "rsltbmp", CONTROL_FLAG, RTF_RSLTBMP, 0 },
    { "rslthtml", CONTROL_FLAG, RTF_RSLTHTML, 0 },
    { "rsltmerge", CONTROL_FLAG, RTF_RSLTMERGE, 0 },
    { "rsltpict", CONTROL_FLAG, RTF_RSLTPICT, 0 },
    { "rsltrtf", CONTROL_FLAG, RTF_RSLTRTF, 0 },
    { "rslttxt", CONTROL_FLAG, RTF_RSLTTXT, 0 },
    { "rtf", CONTROL_DESTINATION, RTF_RTF, 0 },
    { "rtlch", CONTROL_FLAG, RTF_RTLCH, 0 },
    { "rtldoc", CONTROL_FLAG, RTF_RTLDOC, 0 },
    { "rtlgutter", CONTROL_FLAG, RTF_RTLGUTTER, 0 },
    { "rtlmark", CONTROL_SYMBOL, RTF_RTLMARK, 0 },
    { "rtlpar", CONTROL_FLAG, RTF_RTLPAR, 0 },
    { "rtlrow", CONTROL_FLAG, RTF_RTLROW, 0 },
    { "rtlsect", CONTROL_FLAG, RTF_RTLSECT, 0 },
    { "rxe", CONTROL_DESTINATION, RTF_RXE, 0 },
    { "s", CONTROL_VALUE, RTF_S, 0 },
    { "sa", CONTROL_VALUE, RTF_SA, 0 },
    { "saauto", CONTROL_TOGGLE, RTF_SAAUTO, 1 },
    { "saftnnalc", CONTROL_FLAG, RTF_SAFTNNALC, 0 },
    { "saftnnar", CONTROL_FLAG, RTF_SAFTNNAR, 0 },
    { "saftnnauc", CONTROL_FLAG, RTF_SAFTNNAUC, 0 },
    { "saftnnchi", CONTROL_FLAG, RTF_SAFTNNCHI, 0 },
    { "saftnnchosung", CONTROL_FLAG, RTF_SAFTNNCHOSUNG, 0 },
    { "saftnncnum", CONTROL_FLAG, RTF_SAFTNNCNUM, 0 },
    { "saftnndbar", CONTROL_FLAG, RTF_SAFTNNDBAR, 0 },
    { "saftnndbnum", CONTROL_FLAG, RTF_SAFTNNDBNUM, 0 },
    { "saftnndbnumd", CONTROL_FLAG, RTF_SAFTNNDBNUMD, 0 },
    { "saftnndbnumk", CONTROL_FLAG, RTF_SAFTNNDBNUMK, 0 },
    { "saftnndbnumt", CONTROL_FLAG, RTF_SAFTNNDBNUMT, 0 },
    { "saftnnganada", CONTROL_FLAG, RTF_SAFTNNGANADA, 0 },
    { "saftnngbnum", CONTROL_FLAG, RTF_SAFTNNGBNUM, 0 },
    { "saftnngbnumd", CONTROL_FLAG, RTF_SAFTNNGBNUMD, 0 },
    { "saftnngbnumk", CONTROL_FLAG, RTF_SAFTNNGBNUMK, 0 },
    { "saftnngbnuml", CONTROL_FLAG, RTF_SAFTNNGBNUML, 0 },
    { "saftnnrlc", CONTROL_FLAG, RTF_SAFTNNRLC, 0 },
    { "saftnnruc", CONTROL_FLAG, RTF_SAFTNNRUC, 0 },
    { "saftnnzodiac", CONTROL_FLAG, RTF_SAFTNNZODIAC, 0 },
    { "saftnnzodiacd", CONTROL_FLAG, RTF_SAFTNNZODIACD, 0 },
    { "saftnnzodiacl", CONTROL_FLAG, RTF_SAFTNNZODIACL, 0 },
    { "saftnrestart", CONTROL_FLAG, RTF_SAFTNRESTART, 0 },
    { "saftnrstcont", CONTROL_FLAG, RTF_SAFTNRSTCONT, 0 },
    { "saftnstart", CONTROL_VALUE, RTF_SAFTNSTART, 1 },
    { "sautoupd", CONTROL_FLAG, RTF_SAUTOUPD, 0 },
    { "saveinvalidxml", CONTROL_FLAG, RTF_SAVEINVALIDXML, 0 },
    { "saveprevpict", CONTROL_FLAG, RTF_SAVEPREVPICT, 0 },
    { "sb", CONTROL_VALUE, RTF_SB, 0 },
    { "sbasedon", CONTROL_VALUE, RTF_SBASEDON, 222 },
    { "sbauto", CONTROL_TOGGLE, RTF_SBAUTO, 1 },
    { "sbkcol", CONTROL_FLAG, RTF_SBKCOL, 0 },
    { "sbkeven", CONTROL_FLAG, RTF_SBKEVEN, 0 },
    { "sbknone", CONTROL_FLAG, RTF_SBKNONE, 0 },
    { "sbkodd", CONTROL_FLAG, RTF_SBKODD, 0 },
    { "sbkpage", CONTROL_FLAG, RTF_SBKPAGE, 0 },
    { "sbys", CONTROL_FLAG, RTF_SBYS, 0 },
    { "scaps", CONTROL_TOGGLE, RTF_SCAPS, 1 },
    { "scompose", CONTROL_FLAG, RTF_SCOMPOSE, 0 },
    { "sec", CONTROL_VALUE, RTF_SEC, 0 },
    { "sect", CONTROL_SYMBOL, RTF_SECT, 0 },
    { "sectd", CONTROL_FLAG, RTF_SECTD, 0 },
    { "sectdefaultcl", CONTROL_FLAG, RTF_SECTDEFAULTCL, 0 },
    { "sectexpand", CONTROL_VALUE, RTF_SECTEXPAND, 0 },
    { "sectlinegrid", CONTROL_VALUE, RTF_SECTLINEGRID, 0 },
    { "sectnum", CONTROL_SYMBOL, RTF_SECTNUM, 0 },
    { "sectrsid", CONTROL_VALUE, RTF_SECTRSID, 0 },
    { "sectspecifycl", CONTROL_FLAG, RTF_SECTSPECIFYCL, 0 },
    { "sectspecifygenN", CONTROL_FLAG, RTF_SECTSPECIFYGENN, 0 },
    { "sectspecifyl", CONTROL_FLAG, RTF_SECTSPECIFYL, 0 },
    { "sectunlocked", CONTROL_FLAG, RTF_SECTUNLOCKED, 0 },
    { "sftnbj", CONTROL_FLAG, RTF_SFTNBJ, 0 },
    { "sftnnalc", CONTROL_FLAG, RTF_SFTNNALC, 0 },
    { "sftnnar", CONTROL_FLAG, RTF_SFTNNAR, 0 },
    { "sftnnauc", CONTROL_FLAG, RTF_SFTNNAUC, 0 },
    { "sftnnchi", CONTROL_FLAG, RTF_SFTNNCHI, 0 },
    { "sftnnchosung", CONTROL_FLAG, RTF_SFTNNCHOSUNG, 0 },
    { "sftnncnum", CONTROL_FLAG, RTF_SFTNNCNUM, 0 },
    { "sftnndbar", CONTROL_FLAG, RTF_SFTNNDBAR, 0 },
    { "sftnndbnum", CONTROL_FLAG, RTF_SFTNNDBNUM, 0 },
    { "sftnndbnumd", CONTROL_FLAG, RTF_SFTNNDBNUMD, 0 },
    { "sftnndbnumk", CONTROL_FLAG, RTF_SFTNNDBNUMK, 0 },
    { "sftnndbnumt", CONTROL_FLAG, RTF_SFTNNDBNUMT, 0 },
    { "sftnnganada", CONTROL_FLAG, RTF_SFTNNGANADA, 0 },
    { "sftnngbnum", CONTROL_FLAG, RTF_SFTNNGBNUM, 0 },
    { "sftnngbnumd", CONTROL_FLAG, RTF_SFTNNGBNUMD, 0 },
    { "sftnngbnumk", CONTROL_FLAG, RTF_SFTNNGBNUMK, 0 },
    { "sftnngbnuml", CONTROL_FLAG, RTF_SFTNNGBNUML, 0 },
    { "sftnnrlc", CONTROL_FLAG, RTF_SFTNNRLC, 0 },
    { "sftnnruc", CONTROL_FLAG, RTF_SFTNNRUC, 0 },
    { "sftnnzodiac", CONTROL_FLAG, RTF_SFTNNZODIAC, 0 },
    { "sftnnzodiacd", CONTROL_FLAG, RTF_SFTNNZODIACD, 0 },
    { "sftnnzodiacl", CONTROL_FLAG, RTF_SFTNNZODIACL, 0 },
    { "sftnrestart", CONTROL_FLAG, RTF_SFTNRESTART, 0 },
    { "sftnrstcont", CONTROL_FLAG, RTF_SFTNRSTCONT, 0 },
    { "sftnrstpg", CONTROL_FLAG, RTF_SFTNRSTPG, 0 },
    { "sftnstart", CONTROL_VALUE, RTF_SFTNSTART, 1 },
    { "sftntj", CONTROL_FLAG, RTF_SFTNTJ, 0 },
    { "shad", CONTROL_TOGGLE, RTF_SHAD, 1 },
    { "shading", CONTROL_VALUE, RTF_SHADING, 0 },
    { "shidden", CONTROL_FLAG, RTF_SHIDDEN, 0 },
    { "shift", CONTROL_FLAG, RTF_SHIFT, 0 },
    { "showplaceholdtext", CONTROL_VALUE, RTF_SHOWPLACEHOLDTEXT, 0 },
    { "showxmlerrors", CONTROL_VALUE, RTF_SHOWXMLERRORS, 0 },
    { "shp", CONTROL_DESTINATION, RTF_SHP, 0 },
    { "shpbottom", CONTROL_VALUE, RTF_SHPBOTTOM, 0 },
    { "shpbxcolumn", CONTROL_FLAG, RTF_SHPBXCOLUMN, 0 },
    { "shpbxignore", CONTROL_FLAG, RTF_SHPBXIGNORE, 0 },
    { "shpbxmargin", CONTROL_FLAG, RTF_SHPBXMARGIN, 0 },
    { "shpbxpage", CONTROL_FLAG, RTF_SHPBXPAGE, 0 },
    { "shpbyignore", CONTROL_FLAG, RTF_SHPBYIGNORE, 0 },
    { "shpbymargin", CONTROL_FLAG, RTF_SHPBYMARGIN, 0 },
    { "shpbypage", CONTROL_FLAG, RTF_SHPBYPAGE, 0 },
    { "shpbypara", CONTROL_FLAG, RTF_SHPBYPARA, 0 },
    { "shpfblwtxt", CONTROL_VALUE, RTF_SHPFBLWTXT, 0 },
    { "shpfhdr", CONTROL_VALUE, RTF_SHPFHDR, 0 },
    { "shpgrp", CONTROL_DESTINATION, RTF_SHPGRP, 0 },
    { "shpinst", CONTROL_DESTINATION, RTF_SHPINST, 0 },
    { "shpleft", CONTROL_VALUE, RTF_SHPLEFT, 0 },
    { "shplid", CONTROL_VALUE, RTF_SHPLID, 0 },
    { "shplockanchor", CONTROL_FLAG, RTF_SHPLOCKANCHOR, 0 },
    { "shppict", CONTROL_DESTINATION, RTF_SHPPICT, 0 },
    { "shpright", CONTROL_VALUE, RTF_SHPRIGHT, 0 },
    { "shprslt", CONTROL_DESTINATION, RTF_SHPRSLT, 0 },
    { "shptop", CONTROL_VALUE, RTF_SHPTOP, 0 },
    { "shptxt", CONTROL_DESTINATION, RTF_SHPTXT, 0 },
    { "shpwrk", CONTROL_VALUE, RTF_SHPWRK, 0 },
    { "shpwr", CONTROL_VALUE, RTF_SHPWR, 0 },
    { "shpz", CONTROL_VALUE, RTF_SHPZ, 0 },
    { "sl", CONTROL_VALUE, RTF_SL, 0 },
    { "slink", CONTROL_VALUE, RTF_SLINK, 0 },
    { "slmult", CONTROL_VALUE, RTF_SLMULT, 0 },
    { "slocked", CONTROL_FLAG, RTF_SLOCKED, 0 },
    { "sn", CONTROL_DESTINATION, RTF_SN, 0 },
    { "snaptogridincell", CONTROL_FLAG, RTF_SNAPTOGRIDINCELL, 0 },
    { "snext", CONTROL_VALUE, RTF_SNEXT, 0 },
    { "softcol", CONTROL_FLAG, RTF_SOFTCOL, 0 },
    { "softlheight", CONTROL_VALUE, RTF_SOFTLHEIGHT, 0 },
    { "softline", CONTROL_FLAG, RTF_SOFTLINE, 0 },
    { "softpage", CONTROL_FLAG, RTF_SOFTPAGE, 0 },
    { "sp", CONTROL_DESTINATION, RTF_SP, 0 },
    { "spersonal", CONTROL_FLAG, RTF_SPERSONAL, 0 },
    { "spltpgpar", CONTROL_FLAG, RTF_SPLTPGPAR, 0 },
    { "splytwnine", CONTROL_FLAG, RTF_SPLYTWNINE, 0 },
    { "spriority", CONTROL_VALUE, RTF_SPRIORITY, 0 },
    { "sprsbsp", CONTROL_FLAG, RTF_SPRSBSP, 0 },
    { "sprslnsp", CONTROL_FLAG, RTF_SPRSLNSP, 0 },
    { "sprsspbf", CONTROL_FLAG, RTF_SPRSSPBF, 0 },
    { "sprstsm", CONTROL_FLAG, RTF_SPRSTSM, 0 },
    { "sprstsp", CONTROL_FLAG, RTF_SPRSTSP, 0 },
    { "spv", CONTROL_FLAG, RTF_SPV, 0 },
    { "sqformat", CONTROL_FLAG, RTF_SQFORMAT, 0 },
    { "srauth", CONTROL_VALUE, RTF_SRAUTH, 0 },
    { "srdate", CONTROL_VALUE, RTF_SRDATE, 0 },
    { "sreply", CONTROL_FLAG, RTF_SREPLY, 0 },
    { "ssemihidden", CONTROL_VALUE, RTF_SSEMIHIDDEN, 0 },
    { "staticval", CONTROL_DESTINATION, RTF_STATICVAL, 0 },
    { "stextflow", CONTROL_VALUE, RTF_STEXTFLOW, 0 },
    { "strike", CONTROL_TOGGLE, RTF_STRIKE, 1 },
    { "striked", CONTROL_TOGGLE, RTF_STRIKED, 1 },
    { "stshfbi", CONTROL_VALUE, RTF_STSHFBI, 0 },
    { "stshfdbch", CONTROL_VALUE, RTF_STSHFDBCH, 0 },
    { "stshfhich", CONTROL_VALUE, RTF_STSHFHICH, 0 },
    { "stshfloch", CONTROL_VALUE, RTF_STSHFLOCH, 0 },
    { "stylelock", CONTROL_FLAG, RTF_STYLELOCK, 0 },
    { "stylelockbackcomp", CONTROL_FLAG, RTF_STYLELOCKBACKCOMP, 0 },
    { "stylelockenforced", CONTROL_FLAG, RTF_STYLELOCKENFORCED, 0 },
    { "stylelockqfset", CONTROL_FLAG, RTF_STYLELOCKQFSET, 0 },
    { "stylelocktheme", CONTROL_FLAG, RTF_STYLELOCKTHEME, 0 },
    { "stylesheet", CONTROL_DESTINATION, RTF_STYLESHEET, 0 },
    { "stylesortmethod", CONTROL_VALUE, RTF_STYLESORTMETHOD, 1 },
    { "styrsid", CONTROL_VALUE, RTF_STYRSID, 0 },
    { "sub", CONTROL_FLAG, RTF_SUB, 0 },
    { "subdocument", CONTROL_VALUE, RTF_SUBDOCUMENT, 0 },
    { "subfontbysize", CONTROL_FLAG, RTF_SUBFONTBYSIZE, 0 },
    { "subject", CONTROL_DESTINATION, RTF_SUBJECT, 0 },
    { "sunhideused", CONTROL_VALUE, RTF_SUNHIDEUSED, 0 },
    { "super", CONTROL_FLAG, RTF_SUPER, 0 },
    { "sv", CONTROL_DESTINATION, RTF_SV, 0 },
    { "svb", CONTROL_DESTINATION, RTF_SVB, 0 },
    { "swpbdr", CONTROL_FLAG, RTF_SWPBDR, 0 },
    { "tab", CONTROL_SYMBOL, RTF_TAB, 0 },
    { "tabsnoovrlp", CONTROL_FLAG, RTF_TABSNOOVRLP, 0 },
    { "taprtl", CONTROL_FLAG, RTF_TAPRTL, 0 },
    { "tb", CONTROL_VALUE, RTF_TB, 0 },
    { "tblind", CONTROL_VALUE, RTF_TBLIND, 0 },
    { "tblindtype", CONTROL_VALUE, RTF_TBLINDTYPE, 0 },
    { "tbllkbestfit", CONTROL_FLAG, RTF_TBLLKBESTFIT, 0 },
    { "tbllkborder", CONTROL_FLAG, RTF_TBLLKBORDER, 0 },
    { "tbllkcolor", CONTROL_FLAG, RTF_TBLLKCOLOR, 0 },
    { "tbllkfont", CONTROL_FLAG, RTF_TBLLKFONT, 0 },
    { "tbllkhdrcols", CONTROL_FLAG, RTF_TBLLKHDRCOLS, 0 },
    { "tbllkhdrrows", CONTROL_FLAG, RTF_TBLLKHDRROWS, 0 },
    { "tbllklastcol", CONTROL_FLAG, RTF_TBLLKLASTCOL, 0 },
    { "tbllklastrow", CONTROL_FLAG, RTF_TBLLKLASTROW, 0 },
    { "tbllknocolband", CONTROL_FLAG, RTF_TBLLKNOCOLBAND, 0 },
    { "tbllknorowband", CONTROL_FLAG, RTF_TBLLKNOROWBAND, 0 },
    { "tbllkshading", CONTROL_FLAG, RTF_TBLLKSHADING, 0 },
    { "tblrsid", CONTROL_VALUE, RTF_TBLRSID, 0 },
    { "tc", CONTROL_DESTINATION, RTF_TC, 0 },
    { "tcelld", CONTROL_FLAG, RTF_TCELLD, 0 },
    { "tcf", CONTROL_VALUE, RTF_TCF, 67 },
    { "tcl", CONTROL_VALUE, RTF_TCL, 0 },
    { "tcn", CONTROL_FLAG, RTF_TCN, 0 },
    { "tdfrmtxtBottom", CONTROL_VALUE, RTF_TDFRMTXTBOTTOM, 0 },
    { "tdfrmtxtLeft", CONTROL_VALUE, RTF_TDFRMTXTLEFT, 0 },
    { "tdfrmtxtRight", CONTROL_VALUE, RTF_TDFRMTXTRIGHT, 0 },
    { "tdfrmtxtTop", CONTROL_VALUE, RTF_TDFRMTXTTOP, 0 },
    { "template", CONTROL_DESTINATION, RTF_TEMPLATE, 0 },
    { "themedata", CONTROL_DESTINATION, RTF_THEMEDATA, 0 },
    { "themelang", CONTROL_VALUE, RTF_THEMELANG, 0 },
    { "themelangcs", CONTROL_VALUE, RTF_THEMELANGCS, 0 },
    { "themelangfe", CONTROL_VALUE, RTF_THEMELANGFE, 0 },
    { "time", CONTROL_FLAG, RTF_TIME, 0 },
    { "title", CONTROL_DESTINATION, RTF_TITLE, 0 },
    { "titlepg", CONTROL_FLAG, RTF_TITLEPG, 0 },
    { "tldot", CONTROL_FLAG, RTF_TLDOT, 0 },
    { "tleq", CONTROL_FLAG, RTF_TLEQ, 0 },
    { "tlhyph", CONTROL_FLAG, RTF_TLHYPH, 0 },
    { "tlmdot", CONTROL_FLAG, RTF_TLMDOT, 0 },
    { "tlth", CONTROL_FLAG, RTF_TLTH, 0 },
    { "tlul", CONTROL_FLAG, RTF_TLUL, 0 },
    { "toplinepunct", CONTROL_FLAG, RTF_TOPLINEPUNCT, 0 },
    { "tphcol", CONTROL_FLAG, RTF_TPHCOL, 0 },
    { "tphmrg", CONTROL_FLAG, RTF_TPHMRG, 0 },
    { "tphpg", CONTROL_FLAG, RTF_TPHPG, 0 },
    { "tposnegx", CONTROL_VALUE, RTF_TPOSNEGX, 0 },
    { "tposnegy", CONTROL_VALUE, RTF_TPOSNEGY, 0 },
    { "tposxc", CONTROL_FLAG, RTF_TPOSXC, 0 },
    { "tposxi", CONTROL_FLAG, RTF_TPOSXI, 0 },
    { "tposxl", CONTROL_FLAG, RTF_TPOSXL, 0 },
    { "tposx", CONTROL_VALUE, RTF_TPOSX, 0 },
    { "tposxo", CONTROL_FLAG, RTF_TPOSXO, 0 },
    { "tposxr", CONTROL_FLAG, RTF_TPOSXR, 0 },
    { "tposy", CONTROL_VALUE, RTF_TPOSY, 0 },
    { "tposyb", CONTROL_FLAG, RTF_TPOSYB, 0 },
    { "tposyc", CONTROL_FLAG, RTF_TPOSYC, 0 },
    { "tposyil", CONTROL_FLAG, RTF_TPOSYIL, 0 },
    { "tposyin", CONTROL_FLAG, RTF_TPOSYIN, 0 },
    { "tposyout", CONTROL_FLAG, RTF_TPOSYOUT, 0 },
    { "tposyt", CONTROL_FLAG, RTF_TPOSYT, 0 },
    { "tpvmrg", CONTROL_FLAG, RTF_TPVMRG, 0 },
    { "tpvpara", CONTROL_FLAG, RTF_TPVPARA, 0 },
    { "tpvpg", CONTROL_FLAG, RTF_TPVPG, 0 },
    { "tqc", CONTROL_FLAG, RTF_TQC, 0 },
    { "tqdec", CONTROL_FLAG, RTF_TQDEC, 0 },
    { "tqr", CONTROL_FLAG, RTF_TQR, 0 },
    { "trackformatting", CONTROL_VALUE, RTF_TRACKFORMATTING, 0 },
    { "trackmoves", CONTROL_VALUE, RTF_TRACKMOVES, 0 },
    { "transmf", CONTROL_FLAG, RTF_TRANSMF, 0 },
    { "trauth", CONTROL_VALUE, RTF_TRAUTH, 0 },
    { "trautofit", CONTROL_TOGGLE, RTF_TRAUTOFIT, 1 },
    { "trbgbdiag", CONTROL_FLAG, RTF_TRBGBDIAG, 0 },
    { "trbgcross", CONTROL_FLAG, RTF_TRBGCROSS, 0 },
    { "trbgdcross", CONTROL_FLAG, RTF_TRBGDCROSS, 0 },
    { "trbgdkbdiag", CONTROL_FLAG, RTF_TRBGDKBDIAG, 0 },
    { "trbgdkcross", CONTROL_FLAG, RTF_TRBGDKCROSS, 0 },
    { "trbgdkdcross", CONTROL_FLAG, RTF_TRBGDKDCROSS, 0 },
    { "trbgdkfdiag", CONTROL_FLAG, RTF_TRBGDKFDIAG, 0 },
    { "trbgdkhor", CONTROL_FLAG, RTF_TRBGDKHOR, 0 },
    { "trbgdkvert", CONTROL_FLAG, RTF_TRBGDKVERT, 0 },
    { "trbgfdiag", CONTROL_FLAG, RTF_TRBGFDIAG, 0 },
    { "trbghoriz", CONTROL_FLAG, RTF_TRBGHORIZ, 0 },
    { "trbgvert", CONTROL_FLAG, RTF_TRBGVERT, 0 },
    { "trbrdrb", CONTROL_FLAG, RTF_TRBRDRB, 0 },
    { "trbrdrh", CONTROL_FLAG, RTF_TRBRDRH, 0 },
    { "trbrdrl", CONTROL_FLAG, RTF_TRBRDRL, 0 },
    { "trbrdrr", CONTROL_FLAG, RTF_TRBRDRR, 0 },
    { "trbrdrt", CONTROL_FLAG, RTF_TRBRDRT, 0 },
    { "trbrdrv", CONTROL_FLAG, RTF_TRBRDRV, 0 },
    { "trcbpat", CONTROL_VALUE, RTF_TRCBPAT, 0 },
    { "trcfpat", CONTROL_VALUE, RTF_TRCFPAT, 0 },
    { "trdate", CONTROL_VALUE, RTF_TRDATE, 0 },
    { "trftsWidthA", CONTROL_VALUE, RTF_TRFTSWIDTHA, 0 },
    { "trftsWidthB", CONTROL_VALUE, RTF_TRFTSWIDTHB, 0 },
    { "trftsWidth", CONTROL_VALUE, RTF_TRFTSWIDTH, 0 },
    { "trgaph", CONTROL_VALUE, RTF_TRGAPH, 0 },
    { "trhdr", CONTROL_FLAG, RTF_TRHDR, 0 },
    { "trkeep", CONTROL_FLAG, RTF_TRKEEP, 0 },
    { "trkeepfollow", CONTROL_FLAG, RTF_TRKEEPFOLLOW, 0 },
    { "trleft", CONTROL_VALUE, RTF_TRLEFT, 0 },
    { "trowd", CONTROL_FLAG, RTF_TROWD, 0 },
    { "trpaddb", CONTROL_VALUE, RTF_TRPADDB, 0 },
    { "trpaddfb", CONTROL_VALUE, RTF_TRPADDFB, 0 },
    { "trpaddfl", CONTROL_VALUE, RTF_TRPADDFL, 0 },
    { "trpaddfr", CONTROL_VALUE, RTF_TRPADDFR, 0 },
    { "trpaddft", CONTROL_VALUE, RTF_TRPADDFT, 0 },
    { "trpaddl", CONTROL_VALUE, RTF_TRPADDL, 0 },
    { "trpaddr", CONTROL_VALUE, RTF_TRPADDR, 0 },
    { "trpaddt", CONTROL_VALUE, RTF_TRPADDT, 0 },
    { "trpadob", CONTROL_VALUE, RTF_TRPADOB, 0 },
    { "trpadofb", CONTROL_VALUE, RTF_TRPADOFB, 0 },
    { "trpadofl", CONTROL_VALUE, RTF_TRPADOFL, 0 },
    { "trpadofr", CONTROL_VALUE, RTF_TRPADOFR, 0 },
    { "trpadoft", CONTROL_VALUE, RTF_TRPADOFT, 0 },
    { "trpadol", CONTROL_VALUE, RTF_TRPADOL, 0 },
    { "trpador", CONTROL_VALUE, RTF_TRPADOR, 0 },
    { "trpadot", CONTROL_VALUE, RTF_TRPADOT, 0 },
    { "trpat", CONTROL_VALUE, RTF_TRPAT, 0 },
    { "trqc", CONTROL_FLAG, RTF_TRQC, 0 },
    { "trql", CONTROL_FLAG, RTF_TRQL, 0 },
    { "trqr", CONTROL_FLAG, RTF_TRQR, 0 },
    { "trrh", CONTROL_VALUE, RTF_TRRH, 0 },
    { "trshdng", CONTROL_VALUE, RTF_TRSHDNG, 0 },
    { "trspdb", CONTROL_VALUE, RTF_TRSPDB, 0 },
    { "trspdfb", CONTROL_VALUE, RTF_TRSPDFB, 0 },
    { "trspdfl", CONTROL_VALUE, RTF_TRSPDFL, 0 },
    { "trspdfr", CONTROL_VALUE, RTF_TRSPDFR, 0 },
    { "trspdft", CONTROL_VALUE, RTF_TRSPDFT, 0 },
    { "trspdl", CONTROL_VALUE, RTF_TRSPDL, 0 },
    { "trspdr", CONTROL_VALUE, RTF_TRSPDR, 0 },
    { "trspdt", CONTROL_VALUE, RTF_TRSPDT, 0 },
    { "trspob", CONTROL_VALUE, RTF_TRSPOB, 0 },
    { "trspofb", CONTROL_VALUE, RTF_TRSPOFB, 0 },
    { "trspofl", CONTROL_VALUE, RTF_TRSPOFL, 0 },
    { "trspofr", CONTROL_VALUE, RTF_TRSPOFR, 0 },
    { "trspoft", CONTROL_VALUE, RTF_TRSPOFT, 0 },
    { "trspol", CONTROL_VALUE, RTF_TRSPOL, 0 },
    { "trspor", CONTROL_VALUE, RTF_TRSPOR, 0 },
    { "trspot", CONTROL_VALUE, RTF_TRSPOT, 0 },
    { "truncatefontheight", CONTROL_FLAG, RTF_TRUNCATEFONTHEIGHT, 0 },
    { "truncex", CONTROL_FLAG, RTF_TRUNCEX, 0 },
    { "trwWidthA", CONTROL_VALUE, RTF_TRWWIDTHA, 0 },
    { "trwWidthB", CONTROL_VALUE, RTF_TRWWIDTHB, 0 },
    { "trwWidth", CONTROL_VALUE, RTF_TRWWIDTH, 0 },
    { "ts", CONTROL_VALUE, RTF_TS, 0 },
    { "tsbgbdiag", CONTROL_FLAG, RTF_TSBGBDIAG, 0 },
    { "tsbgcross", CONTROL_FLAG, RTF_TSBGCROSS, 0 },
    { "tsbgdcross", CONTROL_FLAG, RTF_TSBGDCROSS, 0 },
    { "tsbgdkbdiag", CONTROL_FLAG, RTF_TSBGDKBDIAG, 0 },
    { "tsbgdkcross", CONTROL_FLAG, RTF_TSBGDKCROSS, 0 },
    { "tsbgdkdcross", CONTROL_FLAG, RTF_TSBGDKDCROSS, 0 },
    { "tsbgdkfdiag", CONTROL_FLAG, RTF_TSBGDKFDIAG, 0 },
    { "tsbgdkhor", CONTROL_FLAG, RTF_TSBGDKHOR, 0 },
    { "tsbgdkvert", CONTROL_FLAG, RTF_TSBGDKVERT, 0 },
    { "tsbgfdiag", CONTROL_FLAG, RTF_TSBGFDIAG, 0 },
    { "tsbghoriz", CONTROL_FLAG, RTF_TSBGHORIZ, 0 },
    { "tsbgvert", CONTROL_FLAG, RTF_TSBGVERT, 0 },
    { "tsbrdrb", CONTROL_FLAG, RTF_TSBRDRB, 0 },
    { "tsbrdrdgl", CONTROL_FLAG, RTF_TSBRDRDGL, 0 },
    { "tsbrdrdgr", CONTROL_FLAG, RTF_TSBRDRDGR, 0 },
    { "tsbrdrh", CONTROL_FLAG, RTF_TSBRDRH, 0 },
    { "tsbrdrl", CONTROL_FLAG, RTF_TSBRDRL, 0 },
    { "tsbrdrr", CONTROL_FLAG, RTF_TSBRDRR, 0 },
    { "tsbrdrt", CONTROL_FLAG, RTF_TSBRDRT, 0 },
    { "tsbrdrv", CONTROL_FLAG, RTF_TSBRDRV, 0 },
    { "tscbandhorzeven", CONTROL_FLAG, RTF_TSCBANDHORZEVEN, 0 },
    { "tscbandhorzodd", CONTROL_FLAG, RTF_TSCBANDHORZODD, 0 },
    { "tscbandsh", CONTROL_VALUE, RTF_TSCBANDSH, 0 },
    { "tscbandsv", CONTROL_VALUE, RTF_TSCBANDSV, 0 },
    { "tscbandverteven", CONTROL_FLAG, RTF_TSCBANDVERTEVEN, 0 },
    { "tscbandvertodd", CONTROL_FLAG, RTF_TSCBANDVERTODD, 0 },
    { "tscellcbpat", CONTROL_VALUE, RTF_TSCELLCBPAT, 0 },
    { "tscellcfpat", CONTROL_VALUE, RTF_TSCELLCFPAT, 0 },
    { "tscellpaddb", CONTROL_VALUE, RTF_TSCELLPADDB, 0 },
    { "tscellpaddfb", CONTROL_VALUE, RTF_TSCELLPADDFB, 0 },
    { "tscellpaddfl", CONTROL_VALUE, RTF_TSCELLPADDFL, 0 },
    { "tscellpaddfr", CONTROL_VALUE, RTF_TSCELLPADDFR, 0 },
    { "tscellpaddft", CONTROL_VALUE, RTF_TSCELLPADDFT, 0 },
    { "tscellpaddl", CONTROL_VALUE, RTF_TSCELLPADDL, 0 },
    { "tscellpaddr", CONTROL_VALUE, RTF_TSCELLPADDR, 0 },
    { "tscellpaddt", CONTROL_VALUE, RTF_TSCELLPADDT, 0 },
    { "tscellpct", CONTROL_VALUE, RTF_TSCELLPCT, 0 },
    { "tscellwidth", CONTROL_VALUE, RTF_TSCELLWIDTH, 0 },
    { "tscellwidthfts", CONTROL_VALUE, RTF_TSCELLWIDTHFTS, 0 },
    { "tscfirstcol", CONTROL_FLAG, RTF_TSCFIRSTCOL, 0 },
    { "tscfirstrow", CONTROL_FLAG, RTF_TSCFIRSTROW, 0 },
    { "tsclastcol", CONTROL_FLAG, RTF_TSCLASTCOL, 0 },
    { "tsclastrow", CONTROL_FLAG, RTF_TSCLASTROW, 0 },
    { "tscnecell", CONTROL_FLAG, RTF_TSCNECELL, 0 },
    { "tscnwcell", CONTROL_FLAG, RTF_TSCNWCELL, 0 },
    { "tscsecell", CONTROL_FLAG, RTF_TSCSECELL, 0 },
    { "tscswcell", CONTROL_FLAG, RTF_TSCSWCELL, 0 },
    { "tsd", CONTROL_FLAG, RTF_TSD, 0 },
    { "tsnowrap", CONTROL_FLAG, RTF_TSNOWRAP, 0 },
    { "tsrowd", CONTROL_FLAG, RTF_TSROWD, 0 },
    { "tsvertalb", CONTROL_FLAG, RTF_TSVERTALB, 0 },
    { "tsvertalc", CONTROL_FLAG, RTF_TSVERTALC, 0 },
    { "tsvertalt", CONTROL_FLAG, RTF_TSVERTALT, 0 },
    { "twoinone", CONTROL_VALUE, RTF_TWOINONE, 0 },
    { "twoonone", CONTROL_FLAG, RTF_TWOONONE, 0 },
    { "tx", CONTROL_VALUE, RTF_TX, 0 },
    { "txbxtwalways", CONTROL_FLAG, RTF_TXBXTWALWAYS, 0 },
    { "txbxtwfirst", CONTROL_FLAG, RTF_TXBXTWFIRST, 0 },
    { "txbxtwfirstlast", CONTROL_FLAG, RTF_TXBXTWFIRSTLAST, 0 },
    { "txbxtwlast", CONTROL_FLAG, RTF_TXBXTWLAST, 0 },
    { "txbxtwno", CONTROL_FLAG, RTF_TXBXTWNO, 0 },
    { "txe", CONTROL_DESTINATION, RTF_TXE, 0 },
    { "u", CONTROL_VALUE, RTF_U, 0 },
    { "uc", CONTROL_VALUE, RTF_UC, 1 },
    { "ud", CONTROL_DESTINATION, RTF_UD, 0 },
    { "ul", CONTROL_TOGGLE, RTF_UL, 1 },
    { "ulc", CONTROL_VALUE, RTF_ULC, 0 },
    { "uld", CONTROL_FLAG, RTF_ULD, 0 },
    { "uldash", CONTROL_TOGGLE, RTF_ULDASH, 1 },
    { "uldashd", CONTROL_TOGGLE, RTF_ULDASHD, 1 },
    { "uldashdd", CONTROL_TOGGLE, RTF_ULDASHDD, 1 },
    { "uldb", CONTROL_TOGGLE, RTF_ULDB, 1 },
    { "ulhair", CONTROL_TOGGLE, RTF_ULHAIR, 1 },
    { "ulhwave", CONTROL_TOGGLE, RTF_ULHWAVE, 1 },
    { "ulldash", CONTROL_TOGGLE, RTF_ULLDASH, 1 },
    { "ulnone", CONTROL_FLAG, RTF_ULNONE, 0 },
    { "ulth", CONTROL_TOGGLE, RTF_ULTH, 1 },
    { "ulthd", CONTROL_TOGGLE, RTF_ULTHD, 1 },
    { "ulthdash", CONTROL_TOGGLE, RTF_ULTHDASH, 1 },
    { "ulthdashd", CONTROL_TOGGLE, RTF_ULTHDASHD, 1 },
    { "ulthdashdd", CONTROL_TOGGLE, RTF_ULTHDASHDD, 1 },
    { "ulthldash", CONTROL_TOGGLE, RTF_ULTHLDASH, 1 },
    { "ululdbwave", CONTROL_TOGGLE, RTF_ULULDBWAVE, 1 },
    { "ulw", CONTROL_FLAG, RTF_ULW, 0 },
    { "ulwave", CONTROL_TOGGLE, RTF_ULWAVE, 1 },
    { "up", CONTROL_VALUE, RTF_UP, 6 },
    { "upr", CONTROL_DESTINATION, RTF_UPR, 0 },
    { "urtf", CONTROL_VALUE, RTF_URTF, 0 },
    { "useltbaln", CONTROL_FLAG, RTF_USELTBALN, 0 },
    { "usenormstyforlist", CONTROL_FLAG, RTF_USENORMSTYFORLIST, 0 },
    { "userprops", CONTROL_DESTINATION, RTF_USERPROPS, 0 },
    { "usexform", CONTROL_FLAG, RTF_USEXFORM, 0 },
    { "utinl", CONTROL_FLAG, RTF_UTINL, 0 },
    { "v", CONTROL_TOGGLE, RTF_V, 1 },
    { "validatexml", CONTROL_VALUE, RTF_VALIDATEXML, 0 },
    { "vern", CONTROL_VALUE, RTF_VERN, 0 },
    { "version", CONTROL_VALUE, RTF_VERSION, 0 },
    { "vertal", CONTROL_FLAG, RTF_VERTAL, 0 },
    { "vertalb", CONTROL_FLAG, RTF_VERTALB, 0 },
    { "vertalc", CONTROL_FLAG, RTF_VERTALC, 0 },
    { "vertalj", CONTROL_FLAG, RTF_VERTALJ, 0 },
    { "vertalt", CONTROL_FLAG, RTF_VERTALT, 0 },
    { "vertdoc", CONTROL_FLAG, RTF_VERTDOC, 0 },
    { "vertsect", CONTROL_FLAG, RTF_VERTSECT, 0 },
    { "viewbksp", CONTROL_VALUE, RTF_VIEWBKSP, 0 },
    { "viewkind", CONTROL_VALUE, RTF_VIEWKIND, 0 },
    { "viewnobound", CONTROL_FLAG, RTF_VIEWNOBOUND, 0 },
    { "viewscale", CONTROL_VALUE, RTF_VIEWSCALE, 100 },
    { "viewzk", CONTROL_VALUE, RTF_VIEWZK, 0 },
    { "wbitmap", CONTROL_VALUE, RTF_WBITMAP, 0 },
    { "wbmbitspixel", CONTROL_VALUE, RTF_WBMBITSPIXEL, 1 },
    { "wbmplanes", CONTROL_VALUE, RTF_WBMPLANES, 0 },
    { "wbmwidthbyte", CONTROL_VALUE, RTF_WBMWIDTHBYTE, 0 },
    { "webhidden", CONTROL_FLAG, RTF_WEBHIDDEN, 0 },
    { "wgrffmtfilter", CONTROL_DESTINATION, RTF_WGRFFMTFILTER, 0 },
    { "widctlpar", CONTROL_FLAG, RTF_WIDCTLPAR, 0 },
    { "widowctrl", CONTROL_FLAG, RTF_WIDOWCTRL, 0 },
    { "windowcaption", CONTROL_DESTINATION, RTF_WINDOWCAPTION, 0 },
    { "wmetafile", CONTROL_VALUE, RTF_WMETAFILE, 1 },
    { "wpeqn", CONTROL_FLAG, RTF_WPEQN, 0 },
    { "wpjst", CONTROL_FLAG, RTF_WPJST, 0 },
    { "wpsp", CONTROL_FLAG, RTF_WPSP, 0 },
    { "wraparound", CONTROL_FLAG, RTF_WRAPAROUND, 0 },
    { "wrapdefault", CONTROL_FLAG, RTF_WRAPDEFAULT, 0 },
    { "wrapthrough", CONTROL_FLAG, RTF_WRAPTHROUGH, 0 },
    { "wraptight", CONTROL_FLAG, RTF_WRAPTIGHT, 0 },
    { "wraptrsp", CONTROL_FLAG, RTF_WRAPTRSP, 0 },
    { "writereservation", CONTROL_DESTINATION, RTF_WRITERESERVATION, 0 },
    { "writereservhash", CONTROL_DESTINATION, RTF_WRITERESERVHASH, 0 },
    { "wrppunct", CONTROL_FLAG, RTF_WRPPUNCT, 0 },
    { "xe", CONTROL_DESTINATION, RTF_XE, 0 },
    { "xef", CONTROL_VALUE, RTF_XEF, 0 },
    { "xform", CONTROL_DESTINATION, RTF_XFORM, 0 },
    { "xmlattr", CONTROL_FLAG, RTF_XMLATTR, 0 },
    { "xmlattrname", CONTROL_DESTINATION, RTF_XMLATTRNAME, 0 },
    { "xmlattrns", CONTROL_VALUE, RTF_XMLATTRNS, 0 },
    { "xmlattrvalue", CONTROL_DESTINATION, RTF_XMLATTRVALUE, 0 },
    { "xmlclose", CONTROL_DESTINATION, RTF_XMLCLOSE, 0 },
    { "xmlname", CONTROL_DESTINATION, RTF_XMLNAME, 0 },
    { "xmlns", CONTROL_VALUE, RTF_XMLNS, 0 },
    { "xmlnstbl", CONTROL_DESTINATION, RTF_XMLNSTBL, 0 },
    { "xmlopen", CONTROL_DESTINATION, RTF_XMLOPEN, 0 },
    { "xmlsdttcell", CONTROL_FLAG, RTF_XMLSDTTCELL, 0 },
    { "xmlsdttpara", CONTROL_FLAG, RTF_XMLSDTTPARA, 0 },
    { "xmlsdttregular", CONTROL_FLAG, RTF_XMLSDTTREGULAR, 0 },
    { "xmlsdttrow", CONTROL_FLAG, RTF_XMLSDTTROW, 0 },
    { "xmlsdttunknown", CONTROL_FLAG, RTF_XMLSDTTUNKNOWN, 0 },
    { "yr", CONTROL_VALUE, RTF_YR, 0 },
    { "yts", CONTROL_VALUE, RTF_YTS, 0 },
    { "yxe", CONTROL_FLAG, RTF_YXE, 0 },
    { "zwbo", CONTROL_SYMBOL, RTF_ZWBO, 0 },
    { "zwj", CONTROL_SYMBOL, RTF_ZWJ, 0 },
    { "zwnbo", CONTROL_SYMBOL, RTF_ZWNBO, 0 },
    { "zwnj", CONTROL_SYMBOL, RTF_ZWNJ, 0 },
    { "flymaincnt", CONTROL_DESTINATION, RTF_FLYMAINCNT, 0 },
    { "flyvert", CONTROL_VALUE, RTF_FLYVERT, 0 },
    { "flyhorz", CONTROL_VALUE, RTF_FLYHORZ, 0 },
    { "flyanchor", CONTROL_VALUE, RTF_FLYANCHOR, 0 },
};
int nRTFControlWords = SAL_N_ELEMENTS(aRTFControlWords);

bool RTFSymbol::operator<(const RTFSymbol& rOther) const
{
    return std::strcmp(m_sKeyword, rOther.m_sKeyword) < 0;
}

RTFMathSymbol const aRTFMathControlWords[] = {
    // eKeyword nToken eDestination
    { RTF_MOMATH, M_TOKEN(oMath), Destination::MOMATH },
    { RTF_MF, M_TOKEN(f), Destination::MF },
    { RTF_MFPR, M_TOKEN(fPr), Destination::MFPR },
    { RTF_MCTRLPR, M_TOKEN(ctrlPr), Destination::MCTRLPR },
    { RTF_MNUM, M_TOKEN(num), Destination::MNUM },
    { RTF_MDEN, M_TOKEN(den), Destination::MDEN },
    { RTF_MACC, M_TOKEN(acc), Destination::MACC },
    { RTF_MACCPR, M_TOKEN(accPr), Destination::MACCPR },
    { RTF_MBAR, M_TOKEN(bar), Destination::MBAR },
    { RTF_MBARPR, M_TOKEN(barPr), Destination::MBARPR },
    { RTF_ME, M_TOKEN(e), Destination::ME },
    { RTF_MD, M_TOKEN(d), Destination::MD },
    { RTF_MDPR, M_TOKEN(dPr), Destination::MDPR },
    { RTF_MFUNC, M_TOKEN(func), Destination::MFUNC },
    { RTF_MFUNCPR, M_TOKEN(funcPr), Destination::MFUNCPR },
    { RTF_MFNAME, M_TOKEN(fName), Destination::MFNAME },
    { RTF_MLIMLOW, M_TOKEN(limLow), Destination::MLIMLOW },
    { RTF_MLIMLOWPR, M_TOKEN(limLowPr), Destination::MLIMLOWPR },
    { RTF_MLIM, M_TOKEN(lim), Destination::MLIM },
    { RTF_MM, M_TOKEN(m), Destination::MM },
    { RTF_MMPR, M_TOKEN(mPr), Destination::MMPR },
    { RTF_MMR, M_TOKEN(mr), Destination::MMR },
    { RTF_MNARY, M_TOKEN(nary), Destination::MNARY },
    { RTF_MNARYPR, M_TOKEN(naryPr), Destination::MNARYPR },
    { RTF_MSUB, M_TOKEN(sub), Destination::MSUB },
    { RTF_MSUP, M_TOKEN(sup), Destination::MSUP },
    { RTF_MLIMUPP, M_TOKEN(limUpp), Destination::MLIMUPP },
    { RTF_MLIMUPPPR, M_TOKEN(limUppPr), Destination::MLIMUPPPR },
    { RTF_MGROUPCHR, M_TOKEN(groupChr), Destination::MGROUPCHR },
    { RTF_MGROUPCHRPR, M_TOKEN(groupChrPr), Destination::MGROUPCHRPR },
    { RTF_MBORDERBOX, M_TOKEN(borderBox), Destination::MBORDERBOX },
    { RTF_MBORDERBOXPR, M_TOKEN(borderBoxPr), Destination::MBORDERBOXPR },
    { RTF_MRAD, M_TOKEN(rad), Destination::MRAD },
    { RTF_MRADPR, M_TOKEN(radPr), Destination::MRADPR },
    { RTF_MDEG, M_TOKEN(deg), Destination::MDEG },
    { RTF_MSSUB, M_TOKEN(sSub), Destination::MSSUB },
    { RTF_MSSUBPR, M_TOKEN(sSubPr), Destination::MSSUBPR },
    { RTF_MSSUP, M_TOKEN(sSup), Destination::MSSUP },
    { RTF_MSSUPPR, M_TOKEN(sSupPr), Destination::MSSUPPR },
    { RTF_MSSUBSUP, M_TOKEN(sSubSup), Destination::MSSUBSUP },
    { RTF_MSSUBSUPPR, M_TOKEN(sSubSupPr), Destination::MSSUBSUPPR },
    { RTF_MSPRE, M_TOKEN(sPre), Destination::MSPRE },
    { RTF_MSPREPR, M_TOKEN(sPrePr), Destination::MSPREPR },
    { RTF_MBOX, M_TOKEN(box), Destination::MBOX },
    { RTF_MEQARR, M_TOKEN(eqArr), Destination::MEQARR },
};
int nRTFMathControlWords = SAL_N_ELEMENTS(aRTFMathControlWords);

bool RTFMathSymbol::operator<(const RTFMathSymbol& rOther) const
{
    return m_eKeyword < rOther.m_eKeyword;
}

} // namespace rtftok
} // namespace writerfilter

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
