# spec file for package loolwsd
#
# Copyright (c) 2015 Collabora
#
# This file is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

%if 0%{?name_suffix:1}
Name:           loolwsd%{name_suffix}
%else
Name:           loolwsd
%endif
Version:        6.0.7.2
Release:        1%{?dist}
Vendor:         %{vendor}
Summary:        LibreOffice Online WebSocket Daemon
License:        MPL
Source0:        loolwsd-6.0.7.2.tar.gz
BuildRequires:  libcap-devel libpng-devel poco-devel >= 1.7.5
%if 0%{?fedora} || 0%{?rhel} >= 7
BuildRequires:  libpcap kernel-headers
%else
%if 0%{?suse_version}
BuildRequires:  libcap-progs linux-glibc-devel systemd-rpm-macros
%endif
%endif

Requires:       %{lo_rpm_list}
Requires:       systemd
Requires(post): coreutils grep sed
%if 0%{?fedora} || 0%{?rhel} >= 7
# loolwsd dependencies
Requires:       expat keyutils-libs krb5-libs libattr libcap libcom_err libgcc libpng libselinux openssl-libs pcre xz-libs zlib
Requires:       poco-crypto >= 1.7.5 poco-foundation >= 1.7.5 poco-json >= 1.7.5 poco-net >= 1.7.5 poco-netssl >= 1.7.5 poco-util >= 1.7.5 poco-xml >= 1.7.5
# LibreOffice dependencies (unfortunately upstream LibreOffice RPM packages (from TDF) do not have real dependencies)
Requires:       atk avahi-glib avahi-libs bzip2-libs cairo cups-libs dbus-glib dbus-libs fontconfig freetype GConf2 gdk-pixbuf2 glib2 gnome-vfs2 graphite2 gstreamer gstreamer-plugins-base gtk2 harfbuzz libdrm libffi libICE libSM libuuid libX11 libXau libxcb libXcomposite libXcursor libXdamage libXext libXfixes libXi libXinerama libXrandr libXrender libxshmfence libXt libXxf86vm mesa-libEGL mesa-libgbm mesa-libGL mesa-libglapi pango pixman
%else
%if 0%{?suse_version}
# loolwsd dependencies
Requires(post): libcap-progs
Requires:       libcap2 libopenssl1_0_0 libpng12-0 libpcre1 libz1 %{?systemd_requires} %{fillup_prereq}
Requires:       libPocoCrypto48 >= 1.7.8 libPocoFoundation48 >= 1.7.8 libPocoJSON48 >= 1.7.8 libPocoNet48 >= 1.7.8 libPocoNetSSL48 >= 1.7.8 libPocoUtil48 >= 1.7.8 libPocoXML48 >= 1.7.8
# LibreOffice dependencies (unfortunately upstream LibreOffice RPM packages (from TDF) do not have real dependencies)
Requires:       Mesa-libEGL1 Mesa-libGL1 Mesa-libglapi0 cups-libs dbus-1-glib fontconfig libatk-1_0-0 libavahi-client3 libavahi-common3 libavahi-glib1 libbz2-1 libcairo2 libcom_err2 libdbus-1-3 libdrm2 libexpat1 libfreetype6 libgbm1 libgio-2_0-0 libglib-2_0-0 libgmodule-2_0-0 libgobject-2_0-0 libgraphite2-3 libgthread-2_0-0 libgtk-2_0-0 libharfbuzz0 libkeyutils1 liblzma5 libpixman-1-0 libpng16-16 libuuid1 libxml2 libffi4 libgbm1 libICE6 libselinux1 libSM6 libwayland-client0 libwayland-server0 libX11-6 libX11-xcb1 libXau6 libxcb1 libxcb-dri2-0 libxcb-dri3-0 libxcb-glx0 libxcb-present0 libxcb-render0 libxcb-shm0 libxcb-sync1 libxcb-xfixes0 libXdamage1 libXext6 libXfixes3 libXrender1 libxshmfence1 libXxf86vm1
%endif
%endif
%if 0%{?name_suffix:1}
Provides:       loleaflet = 1.5.8, loolwsd
%else
Provides:       loleaflet = 1.5.8
%endif
Obsoletes:      loleaflet <= 1.5.8

%description

%if 0%{?suse_version}
%debug_package
%endif
%prep
%setup -n loolwsd-6.0.7.2

%build
%configure \
	--enable-silent-rules \
	--with-lokit-path=bundled/include \
	--with-lo-path=%{loroot} \
%if 0%{?config_options:1}
	%{config_options}
%endif

env BUILDING_FROM_RPMBUILD=yes make %{?_smp_mflags}

%check
#env BUILDING_FROM_RPMBUILD=yes make check

%install
env BUILDING_FROM_RPMBUILD=yes make install DESTDIR=%{buildroot}
%__install -D -m 444 loolwsd.service %{buildroot}%{_unitdir}/loolwsd.service
install -d -m 755 %{buildroot}/var/adm/fillup-templates
%if 0%{?fedora} || 0%{?rhel} >= 7
install -D -m 644 sysconfig.loolwsd %{buildroot}/etc/sysconfig/loolwsd
%else
%if 0%{?suse_version}
install -D -m 644 sysconfig.loolwsd %{buildroot}/var/adm/fillup-templates
%endif
%endif
mkdir -p %{buildroot}/etc/cron.d
echo "#Remove old tiles once every 10 days at midnight" > %{buildroot}/etc/cron.d/loolwsd.cron
echo "0 0 */1 * * root find /var/cache/loolwsd -type f -a -atime +10 -exec rm {} \;" >> %{buildroot}/etc/cron.d/loolwsd.cron

%files
/usr/bin/loolwsd
/usr/bin/loolwsd-systemplate-setup
/usr/bin/loolmap
/usr/bin/loolforkit
/usr/bin/loolmount
/usr/bin/loolstress
/usr/bin/looltool
/usr/bin/loolconfig
/usr/share/loolwsd/discovery.xml
/usr/share/loolwsd/favicon.ico
/usr/share/loolwsd/robots.txt
/usr/share/loolwsd/loleaflet
/usr/share/doc/loolwsd/README
/usr/share/doc/loolwsd/README.vars
/usr/share/doc/loolwsd/protocol.txt
/usr/share/doc/loolwsd/reference.txt
%{_unitdir}/loolwsd.service
%if 0%{?fedora} || 0%{?rhel} >= 7
%config(noreplace) /etc/sysconfig/loolwsd
%else
%if 0%{?suse_version}
/var/adm/fillup-templates/sysconfig.loolwsd
%endif
%endif

%config(noreplace) /etc/cron.d/loolwsd.cron
%config(noreplace) %attr(640, lool, root) /etc/loolwsd/loolwsd.xml
%config /etc/loolwsd/loolkitconfig.xcu

%doc README

%pre
%if 0%{?suse_version}
%service_add_pre loolwsd.service
%endif

getent group lool >/dev/null || groupadd -r lool
getent passwd lool >/dev/null || useradd -g lool -r lool

%post
setcap cap_fowner,cap_mknod,cap_sys_chroot=ep /usr/bin/loolforkit
setcap cap_sys_admin=ep /usr/bin/loolmount

mkdir -p /var/cache/loolwsd && chown lool:lool /var/cache/loolwsd
rm -rf /var/cache/loolwsd/*

# Figure out where LO is installed, let's hope it is not a mount point
# Create a directory for loolwsd on the same file system
loroot=%{loroot}
loolparent=`cd ${loroot} && cd .. && /bin/pwd`

rm -rf ${loolparent}/lool
mkdir -p ${loolparent}/lool/child-roots
chown lool:lool ${loolparent}/lool
chown lool:lool ${loolparent}/lool/child-roots

fc-cache ${loroot}/share/fonts/truetype
su lool -c "loolwsd-systemplate-setup ${loolparent}/lool/systemplate ${loroot} >/dev/null 2>&1"

%if 0%{?fedora} || 0%{?rhel} >= 7
%systemd_post loolwsd.service
%else
%if 0%{?suse_version}
%service_add_post loolwsd.service
%{fillup_only -n loolwsd}
%endif
%endif


%preun
%if 0%{?fedora} || 0%{?rhel} >= 7
%systemd_preun loolwsd.service
%else
%if 0%{?suse_version}
%service_del_preun loolwsd.service
%endif
%endif

%postun
%if 0%{?fedora} || 0%{?rhel} >= 7
%systemd_postun loolwsd.service
%else
%if 0%{?suse_version}
%service_del_postun loolwsd.service
%endif
%endif

%changelog
* Mon Aug 03 2015 Mihai Varga
- added the cronjob
* Tue May 19 2015 Tor Lillqvist
- Initial RPM release
