#pragma mapbox: define lowp vec4 outline_color
#pragma mapbox: define lowp float opacity

varying vec2 v_pos;

void main() {
    #pragma mapbox: initialize lowp vec4 outline_color
    #pragma mapbox: initialize lowp float opacity

    float dist = length(v_pos - gl_FragCoord.xy);
    float alpha = smoothstep(1.0, 0.0, dist);
    gl_FragColor = outline_color * (alpha * opacity);

#ifdef OVERDRAW_INSPECTOR
    gl_FragColor = vec4(1.0);
#endif
}
