/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import proguard.io.DataEntry;

public class FileDataEntry
implements DataEntry {
    private final File directory;
    private final File file;
    private InputStream inputStream;

    public FileDataEntry(File file, File file2) {
        this.directory = file;
        this.file = file2;
    }

    @Override
    public String getName() {
        return this.file.equals(this.directory) ? this.file.getName() : this.file.getPath().substring(this.directory.getPath().length() + File.separator.length()).replace(File.separatorChar, '/');
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            this.inputStream = new BufferedInputStream(new FileInputStream(this.file));
        }
        return this.inputStream;
    }

    @Override
    public void closeInputStream() throws IOException {
        this.inputStream.close();
        this.inputStream = null;
    }

    @Override
    public DataEntry getParent() {
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

