/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberDescriptorFilter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.StringMatcher;

public class DynamicMemberReferenceInitializer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final boolean DEBUG = false;
    public static final int CLASS_INDEX = 0x40000000;
    public static final int MEMBER_NAME_INDEX = 0x40000001;
    public static final int TYPE_CLASS_INDEX = 0x40000002;
    public static final int PARAMETER0_CLASS_INDEX = 0x40000003;
    public static final int PARAMETER1_CLASS_INDEX = 0x40000004;
    public static final int PARAMETER2_CLASS_INDEX = 0x40000005;
    public static final int PARAMETER3_CLASS_INDEX = 0x40000006;
    private final Constant[] GET_FIELD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getField"), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/reflect/Field;")};
    private final Constant[] GET_DECLARED_FIELD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getDeclaredField"), new Utf8Constant("(Ljava/lang/String;)Ljava/lang/reflect/Field;")};
    private final Constant[] GET_CONSTRUCTOR_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getConstructor"), new Utf8Constant("([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;")};
    private final Constant[] GET_DECLARED_CONSTRUCTOR_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getDeclaredConstructor"), new Utf8Constant("([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;")};
    private final Constant[] GET_METHOD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getMethod"), new Utf8Constant("(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;")};
    private final Constant[] GET_DECLARED_METHOD_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/lang/Class"), new Utf8Constant("getDeclaredMethod"), new Utf8Constant("(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;")};
    private final Constant[] NEW_INTEGER_UPDATER_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/util/concurrent/atomic/AtomicIntegerFieldUpdater"), new Utf8Constant("newUpdater"), new Utf8Constant("(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;")};
    private final Constant[] NEW_LONG_UPDATER_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/util/concurrent/atomic/AtomicLongFieldUpdater"), new Utf8Constant("newUpdater"), new Utf8Constant("(Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicLongFieldUpdater;")};
    private final Constant[] NEW_REFERENCE_UPDATER_CONSTANTS = new Constant[]{new MethodrefConstant(1, 2, null, null), new ClassConstant(3, null), new NameAndTypeConstant(4, 5), new Utf8Constant("java/util/concurrent/atomic/AtomicReferenceFieldUpdater"), new Utf8Constant("newUpdater"), new Utf8Constant("(Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/String;)Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;")};
    private final Instruction[] CONSTANT_GET_FIELD_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new ConstantInstruction(-74, 0)};
    private final Instruction[] CONSTANT_GET_METHOD_INSTRUCTIONS0 = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new SimpleInstruction(3), new ConstantInstruction(-67, 1), new ConstantInstruction(-74, 0)};
    private final Instruction[] CONSTANT_GET_METHOD_INSTRUCTIONS1 = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new SimpleInstruction(4), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] CONSTANT_GET_METHOD_INSTRUCTIONS2 = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new SimpleInstruction(5), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new SimpleInstruction(89), new SimpleInstruction(4), new ConstantInstruction(18, 0x40000004), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] CONSTANT_NEW_PRIMITIVE_UPDATER_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000001), new ConstantInstruction(-72, 0)};
    private final Instruction[] CONSTANT_NEW_REFERENCE_UPDATER_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000000), new ConstantInstruction(18, 0x40000002), new ConstantInstruction(18, 0x40000001), new ConstantInstruction(-72, 0)};
    private final Instruction[] GET_FIELD_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000001), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_CONSTRUCTOR_INSTRUCTIONS1 = new Instruction[]{new SimpleInstruction(4), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_CONSTRUCTOR_INSTRUCTIONS2 = new Instruction[]{new SimpleInstruction(5), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new SimpleInstruction(89), new SimpleInstruction(4), new ConstantInstruction(18, 0x40000004), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_METHOD_INSTRUCTIONS0 = new Instruction[]{new ConstantInstruction(18, 0x40000001), new SimpleInstruction(3), new ConstantInstruction(-67, 1), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_METHOD_INSTRUCTIONS1 = new Instruction[]{new ConstantInstruction(18, 0x40000001), new SimpleInstruction(4), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] GET_METHOD_INSTRUCTIONS2 = new Instruction[]{new ConstantInstruction(18, 0x40000001), new SimpleInstruction(5), new ConstantInstruction(-67, 1), new SimpleInstruction(89), new SimpleInstruction(3), new ConstantInstruction(18, 0x40000003), new SimpleInstruction(83), new SimpleInstruction(89), new SimpleInstruction(4), new ConstantInstruction(18, 0x40000004), new SimpleInstruction(83), new ConstantInstruction(-74, 0)};
    private final Instruction[] NEW_UPDATER_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(18, 0x40000001), new ConstantInstruction(-72, 0)};
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private final StringMatcher noteFieldExceptionMatcher;
    private final StringMatcher noteMethodExceptionMatcher;
    private final InstructionSequenceMatcher constantGetFieldMatcher = new InstructionSequenceMatcher(this.GET_FIELD_CONSTANTS, this.CONSTANT_GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher constantGetDeclaredFieldMatcher = new InstructionSequenceMatcher(this.GET_DECLARED_FIELD_CONSTANTS, this.CONSTANT_GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher constantGetMethodMatcher0 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher constantGetDeclaredMethodMatcher0 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher constantGetMethodMatcher1 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher constantGetDeclaredMethodMatcher1 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher constantGetMethodMatcher2 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS2);
    private final InstructionSequenceMatcher constantGetDeclaredMethodMatcher2 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.CONSTANT_GET_METHOD_INSTRUCTIONS2);
    private final InstructionSequenceMatcher constantGetIntegerUpdaterMatcher = new InstructionSequenceMatcher(this.NEW_INTEGER_UPDATER_CONSTANTS, this.CONSTANT_NEW_PRIMITIVE_UPDATER_INSTRUCTIONS);
    private final InstructionSequenceMatcher constantGetLongUpdaterMatcher = new InstructionSequenceMatcher(this.NEW_LONG_UPDATER_CONSTANTS, this.CONSTANT_NEW_PRIMITIVE_UPDATER_INSTRUCTIONS);
    private final InstructionSequenceMatcher constantGetReferenceUpdaterMatcher = new InstructionSequenceMatcher(this.NEW_REFERENCE_UPDATER_CONSTANTS, this.CONSTANT_NEW_REFERENCE_UPDATER_INSTRUCTIONS);
    private final InstructionSequenceMatcher getFieldMatcher = new InstructionSequenceMatcher(this.GET_FIELD_CONSTANTS, this.GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher getDeclaredFieldMatcher = new InstructionSequenceMatcher(this.GET_DECLARED_FIELD_CONSTANTS, this.GET_FIELD_INSTRUCTIONS);
    private final InstructionSequenceMatcher getConstructorMatcher1 = new InstructionSequenceMatcher(this.GET_CONSTRUCTOR_CONSTANTS, this.GET_CONSTRUCTOR_INSTRUCTIONS1);
    private final InstructionSequenceMatcher getDeclaredConstructorMatcher1 = new InstructionSequenceMatcher(this.GET_DECLARED_CONSTRUCTOR_CONSTANTS, this.GET_CONSTRUCTOR_INSTRUCTIONS1);
    private final InstructionSequenceMatcher getConstructorMatcher2 = new InstructionSequenceMatcher(this.GET_CONSTRUCTOR_CONSTANTS, this.GET_CONSTRUCTOR_INSTRUCTIONS2);
    private final InstructionSequenceMatcher getDeclaredConstructorMatcher2 = new InstructionSequenceMatcher(this.GET_DECLARED_CONSTRUCTOR_CONSTANTS, this.GET_CONSTRUCTOR_INSTRUCTIONS2);
    private final InstructionSequenceMatcher getMethodMatcher0 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher getDeclaredMethodMatcher0 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS0);
    private final InstructionSequenceMatcher getMethodMatcher1 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher getDeclaredMethodMatcher1 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS1);
    private final InstructionSequenceMatcher getMethodMatcher2 = new InstructionSequenceMatcher(this.GET_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS2);
    private final InstructionSequenceMatcher getDeclaredMethodMatcher2 = new InstructionSequenceMatcher(this.GET_DECLARED_METHOD_CONSTANTS, this.GET_METHOD_INSTRUCTIONS2);
    private final InstructionSequenceMatcher getIntegerUpdaterMatcher = new InstructionSequenceMatcher(this.NEW_INTEGER_UPDATER_CONSTANTS, this.NEW_UPDATER_INSTRUCTIONS);
    private final InstructionSequenceMatcher getLongUpdaterMatcher = new InstructionSequenceMatcher(this.NEW_LONG_UPDATER_CONSTANTS, this.NEW_UPDATER_INSTRUCTIONS);
    private final InstructionSequenceMatcher getReferenceUpdaterMatcher = new InstructionSequenceMatcher(this.NEW_REFERENCE_UPDATER_CONSTANTS, this.NEW_UPDATER_INSTRUCTIONS);
    private final MemberFinder memberFinder = new MemberFinder();
    private Clazz referencedClass;
    private String descriptor;
    private boolean isDeclared;
    private boolean isField;

    public DynamicMemberReferenceInitializer(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, StringMatcher stringMatcher, StringMatcher stringMatcher2) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.notePrinter = warningPrinter;
        this.noteFieldExceptionMatcher = stringMatcher;
        this.noteMethodExceptionMatcher = stringMatcher2;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetFieldMatcher, this.getFieldMatcher, true, false, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredFieldMatcher, this.getDeclaredFieldMatcher, true, true, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, null, this.getConstructorMatcher1, false, false, "<init>", null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, null, this.getDeclaredConstructorMatcher1, false, true, "<init>", null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, null, this.getConstructorMatcher2, false, false, "<init>", null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, null, this.getDeclaredConstructorMatcher2, false, true, "<init>", null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetMethodMatcher0, this.getMethodMatcher0, false, false, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredMethodMatcher0, this.getDeclaredMethodMatcher0, false, true, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetMethodMatcher1, this.getMethodMatcher1, false, false, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredMethodMatcher1, this.getDeclaredMethodMatcher1, false, true, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetMethodMatcher2, this.getMethodMatcher2, false, false, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetDeclaredMethodMatcher2, this.getDeclaredMethodMatcher2, false, true, null, null);
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetIntegerUpdaterMatcher, this.getIntegerUpdaterMatcher, true, false, null, "I");
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetLongUpdaterMatcher, this.getLongUpdaterMatcher, true, false, null, "J");
        this.matchGetMember(clazz, method, codeAttribute, n, instruction, this.constantGetReferenceUpdaterMatcher, this.getReferenceUpdaterMatcher, true, false, null, null);
    }

    private void matchGetMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction, InstructionSequenceMatcher instructionSequenceMatcher, InstructionSequenceMatcher instructionSequenceMatcher2, boolean bl, boolean bl2, String string, String string2) {
        if (instructionSequenceMatcher != null) {
            instruction.accept(clazz, method, codeAttribute, n, instructionSequenceMatcher);
            if (instructionSequenceMatcher.isMatching()) {
                this.initializeStringReference(clazz, instructionSequenceMatcher, bl, bl2, string2);
                instructionSequenceMatcher2.reset();
            }
        }
        instruction.accept(clazz, method, codeAttribute, n, instructionSequenceMatcher2);
        if (instructionSequenceMatcher2.isMatching()) {
            this.printDynamicInvocationNote(clazz, instructionSequenceMatcher2, bl, bl2, string, string2);
        }
    }

    private void initializeStringReference(Clazz clazz, InstructionSequenceMatcher instructionSequenceMatcher, boolean bl, boolean bl2, String string) {
        this.isField = bl;
        this.isDeclared = bl2;
        int n = instructionSequenceMatcher.matchedConstantIndex(0x40000000);
        clazz.constantPoolEntryAccept(n, this);
        int n2 = instructionSequenceMatcher.matchedConstantIndex(0x40000002);
        this.descriptor = n2 <= 0 ? string : ClassUtil.internalTypeFromClassName(clazz.getClassName(n2));
        int n3 = instructionSequenceMatcher.matchedConstantIndex(0x40000001);
        clazz.constantPoolEntryAccept(n3, this);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.referencedClass = ClassUtil.isInternalArrayType(classConstant.getName(clazz)) ? null : classConstant.referencedClass;
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (this.referencedClass != null) {
            Member member;
            String string = stringConstant.getString(clazz);
            Member member2 = this.isDeclared ? (this.isField ? this.referencedClass.findField(string, this.descriptor) : this.referencedClass.findMethod(string, this.descriptor)) : (member = this.memberFinder.findMember(clazz, this.referencedClass, string, this.descriptor, this.isField));
            if (member != null) {
                stringConstant.referencedMember = member;
                stringConstant.referencedClass = this.isDeclared ? this.referencedClass : this.memberFinder.correspondingClass();
            }
        }
    }

    private void printDynamicInvocationNote(Clazz clazz, InstructionSequenceMatcher instructionSequenceMatcher, boolean bl, boolean bl2, String string, String string2) {
        if (this.notePrinter != null && this.notePrinter.accepts(clazz.getName())) {
            String string3;
            StringMatcher stringMatcher = bl ? this.noteFieldExceptionMatcher : this.noteMethodExceptionMatcher;
            int n = instructionSequenceMatcher.matchedConstantIndex(0x40000001);
            String string4 = string3 = n <= 0 ? string : clazz.getStringString(n);
            if (stringMatcher == null || !stringMatcher.matches(string3)) {
                ClassVisitor classVisitor;
                String string5 = string3;
                if (!bl) {
                    string5 = string5 + '(';
                    for (int i = 0; i < 2; ++i) {
                        int n2 = instructionSequenceMatcher.matchedConstantIndex(0x40000003 + i);
                        if (n2 <= 0) continue;
                        if (i > 0) {
                            string5 = string5 + ',';
                        }
                        String string6 = clazz.getClassName(n2);
                        string5 = string5 + (ClassUtil.isInternalArrayType(string6) ? ClassUtil.externalType(string6) : ClassUtil.externalClassName(string6));
                    }
                    string5 = string5 + ')';
                }
                this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " accesses a " + (bl2 ? "declared " : "") + (bl ? "field" : (string3.equals("<init>") ? "constructor" : "method")) + " '" + string5 + "' dynamically");
                if (bl) {
                    classVisitor = string2 == null ? new AllFieldVisitor(new MemberNameFilter(string3, (MemberVisitor)this)) : new AllFieldVisitor(new MemberNameFilter(string3, (MemberVisitor)new MemberDescriptorFilter(string2, (MemberVisitor)this)));
                } else {
                    String string7 = "(";
                    for (int i = 0; i < 2; ++i) {
                        int n3 = instructionSequenceMatcher.matchedConstantIndex(0x40000003 + i);
                        if (n3 <= 0) continue;
                        String string8 = clazz.getClassName(n3);
                        string7 = string7 + (ClassUtil.isInternalArrayType(string8) ? string8 : ClassUtil.internalTypeFromClassName(string8));
                    }
                    string7 = string7 + ")L***;";
                    classVisitor = new AllMethodVisitor(new MemberNameFilter(string3, (MemberVisitor)new MemberDescriptorFilter(string7, (MemberVisitor)this)));
                }
                this.programClassPool.classesAcceptAlphabetically(classVisitor);
                this.libraryClassPool.classesAcceptAlphabetically(classVisitor);
            }
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.notePrinter.accepts(programClass.getName())) {
            System.out.println("      Maybe this is program field '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, programField.getName(programClass), programField.getDescriptor(programClass)) + "; }'");
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.notePrinter.accepts(programClass.getName())) {
            System.out.println("      Maybe this is program method '" + ClassUtil.externalFullClassDescription(0, programClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(programClass.getName(), 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)) + "; }'");
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        if (this.notePrinter.accepts(libraryClass.getName())) {
            System.out.println("      Maybe this is library field '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullFieldDescription(0, libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass)) + "; }'");
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.notePrinter.accepts(libraryClass.getName())) {
            System.out.println("      Maybe this is library method '" + ClassUtil.externalFullClassDescription(0, libraryClass.getName()) + " { " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), 0, libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass)) + "; }'");
        }
    }
}

