/*
 * Copyright (C) 2011 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef MediaStreamEvent_h
#define MediaStreamEvent_h

#include "modules/EventModules.h"
#include "modules/mediastream/MediaStream.h"
#include "modules/mediastream/MediaStreamEventInit.h"
#include "platform/wtf/text/AtomicString.h"

namespace blink {

class MediaStreamEvent final : public Event {
  DEFINE_WRAPPERTYPEINFO();

 public:
  ~MediaStreamEvent() override;

  static MediaStreamEvent* Create(const AtomicString& type, MediaStream*);
  static MediaStreamEvent* Create(const AtomicString& type,
                                  const MediaStreamEventInit& initializer);

  MediaStream* stream() const;
  MediaStream* stream(bool&) const;

  const AtomicString& InterfaceName() const override;

  virtual void Trace(blink::Visitor*);

 private:
  MediaStreamEvent(const AtomicString& type, MediaStream*);
  MediaStreamEvent(const AtomicString& type, const MediaStreamEventInit&);

  Member<MediaStream> stream_;
};

}  // namespace blink

#endif  // MediaStreamEvent_h
