/****************************************************************************
**
** Copyright (C) 2014 Klaralvdalens Datakonsult AB (KDAB).
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt3D module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QT3DRENDER_QMESH_P_H
#define QT3DRENDER_QMESH_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <Qt3DCore/private/qdownloadhelperservice_p.h>
#include <Qt3DRender/private/qgeometryrenderer_p.h>
#include <Qt3DRender/private/qt3drender_global_p.h>
#include <QUrl>

QT_BEGIN_NAMESPACE

namespace Qt3DRender {

class QMesh;

class QT3DRENDERSHARED_PRIVATE_EXPORT QMeshPrivate : public QGeometryRendererPrivate
{
public:
    QMeshPrivate();

    Q_DECLARE_PUBLIC(QMesh)
    static QMeshPrivate *get(QMesh *q);

    void setScene(Qt3DCore::QScene *scene) override;
    void updateFunctor();

    QUrl m_source;
    QString m_meshName;
};

class Q_AUTOTEST_EXPORT MeshDownloadRequest : public Qt3DCore::QDownloadRequest
{
public:
    MeshDownloadRequest(Qt3DCore::QNodeId mesh, QUrl source, Qt3DCore::QAspectEngine *engine);

    void onCompleted() Q_DECL_OVERRIDE;

private:
    Qt3DCore::QNodeId m_mesh;
    Qt3DCore::QAspectEngine *m_engine;
};

class Q_AUTOTEST_EXPORT MeshLoaderFunctor : public QGeometryFactory
{
public :
    MeshLoaderFunctor(QMesh *mesh, Qt3DCore::QAspectEngine *engine, const QByteArray &sourceData = QByteArray());
    QGeometry *operator()() Q_DECL_OVERRIDE;
    bool operator ==(const QGeometryFactory &other) const Q_DECL_OVERRIDE;
    QT3D_FUNCTOR(MeshLoaderFunctor)

    Qt3DCore::QNodeId m_mesh;
    QUrl m_sourcePath;
    QString m_meshName;
    Qt3DCore::QAspectEngine *m_engine;
    QByteArray m_sourceData;
};


} // namespace Qt3DRender

QT_END_NAMESPACE

#endif // QT3DRENDER_QMESH_P_H
