// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only WITH Qt-GPL-exception-1.0

#ifndef GESTURE_H
#define GESTURE_H

#include <QGestureRecognizer>
#include <QGesture>

class ThreeFingerSlideGesture : public QGesture
{
    Q_OBJECT
public:
    static Qt::GestureType Type;

    ThreeFingerSlideGesture(QObject *parent = nullptr) : QGesture(parent) { }

    bool gestureFired;
};

class ThreeFingerSlideGestureRecognizer : public QGestureRecognizer
{
private:
    QGesture *create(QObject *target);
    QGestureRecognizer::Result recognize(QGesture *state, QObject *watched, QEvent *event);
    void reset(QGesture *state);
};

class RotateGestureRecognizer : public QGestureRecognizer
{
public:
    RotateGestureRecognizer();

private:
    QGesture *create(QObject *target);
    QGestureRecognizer::Result recognize(QGesture *state, QObject *watched, QEvent *event);
    void reset(QGesture *state);
};

#endif // GESTURE_H
