# Copyright (C) 2022 The Qt Company Ltd.
# SPDX-License-Identifier: LicenseRef-Qt-Commercial

import os
from pathlib import Path
import subprocess
import sys

# Wrapper script providing the shibokenwizard entry point of the package


def main():
    main_script = os.fspath(Path(__file__).resolve().parents[0] / 'main.py')
    command = [sys.executable, main_script]
    if len(sys.argv) > 1:
        command.extend(sys.argv[1:])
    sys.exit(subprocess.call(command))


if __name__ == '__main__':
    main()
