/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#pragma once

#include "projectpart.h"
#include "projects.h"
#include "clangdocument.h"
#include "clangdocuments.h"
#include "clangdocumentprocessors.h"
#include "clangjobrequest.h"
#include "unsavedfiles.h"

#include <clangcodemodelserverinterface.h>
#include <ipcclientprovider.h>
#include <utf8string.h>

#include <QScopedPointer>
#include <QTimer>

namespace ClangBackEnd {

struct DocumentResetInfo {
    Document documentToRemove;
    FileContainer fileContainer;
};
using DocumentResetInfos = QVector<DocumentResetInfo>;

class ClangCodeModelServer : public ClangCodeModelServerInterface,
                             public IpcClientProvider<ClangCodeModelClientInterface>
{
public:
    ClangCodeModelServer();

    void end() override;
    void registerTranslationUnitsForEditor(const RegisterTranslationUnitForEditorMessage &message) override;
    void updateTranslationUnitsForEditor(const UpdateTranslationUnitsForEditorMessage &message) override;
    void unregisterTranslationUnitsForEditor(const UnregisterTranslationUnitsForEditorMessage &message) override;
    void registerProjectPartsForEditor(const RegisterProjectPartsForEditorMessage &message) override;
    void unregisterProjectPartsForEditor(const UnregisterProjectPartsForEditorMessage &message) override;
    void registerUnsavedFilesForEditor(const RegisterUnsavedFilesForEditorMessage &message) override;
    void unregisterUnsavedFilesForEditor(const UnregisterUnsavedFilesForEditorMessage &message) override;
    void completeCode(const CompleteCodeMessage &message) override;
    void updateVisibleTranslationUnits(const UpdateVisibleTranslationUnitsMessage &message) override;
    void requestDocumentAnnotations(const RequestDocumentAnnotationsMessage &message) override;
    void requestReferences(const RequestReferencesMessage &message) override;
    void requestFollowSymbol(const RequestFollowSymbolMessage &message) override;
    void requestToolTip(const RequestToolTipMessage &message) override;

public: // for tests
    const Documents &documentsForTestOnly() const;
    QList<Jobs::RunningJob> runningJobsForTestsOnly();
    int queueSizeForTestsOnly();
    bool isTimerRunningForTestOnly() const;
    void setUpdateDocumentAnnotationsTimeOutInMsForTestsOnly(int value);
    void setUpdateVisibleButNotCurrentDocumentsTimeOutInMsForTestsOnly(int value);
    DocumentProcessors &documentProcessors();

private:
    void processInitialJobsForDocuments(const std::vector<Document> &documents);
    void processJobsForDirtyAndVisibleDocuments();
    void processJobsForDirtyCurrentDocument();
    void processTimerForVisibleButNotCurrentDocuments();
    void processSuspendResumeJobs(const std::vector<Document> &documents);

    void categorizeFileContainers(const QVector<FileContainer> &fileContainers,
                                  QVector<FileContainer> &toCreate,
                                  DocumentResetInfos &toReset) const;
    std::vector<Document> resetDocuments(const DocumentResetInfos &infos);

    void addAndRunUpdateJobs(std::vector<Document> documents);

private:
    ProjectParts projects;
    UnsavedFiles unsavedFiles;
    Documents documents;

    QScopedPointer<DocumentProcessors> documentProcessors_; // Delayed initialization

    QTimer updateDocumentAnnotationsTimer;
    int updateDocumentAnnotationsTimeOutInMs = 1500;

    QTimer updateVisibleButNotCurrentDocumentsTimer;
    int updateVisibleButNotCurrentDocumentsTimeOutInMs = 2000;
};

} // namespace ClangBackEnd
