/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt Creator.
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
****************************************************************************/

#include "styledoutputpaneplaceholder.h"
#include "theming.h"

#include <utils/fileutils.h>

#include <QChildEvent>
#include <QTabWidget>

namespace QmlDesigner {
namespace Internal {

StyledOutputpanePlaceHolder::StyledOutputpanePlaceHolder(Core::Id mode, QSplitter *parent)
    : Core::OutputPanePlaceHolder(mode, parent)
{
    QByteArray sheet = Utils::FileReader::fetchQrc(":/qmldesigner/scrollbar.css");
    m_customStylesheet = Theming::replaceCssColors(QString::fromUtf8(sheet));
}

void StyledOutputpanePlaceHolder::childEvent(QChildEvent *event)
{
    Core::OutputPanePlaceHolder::childEvent(event);

    if (event->type() == QEvent::ChildAdded) {
        if (QWidget *child = qobject_cast<QWidget*>(event->child())) {
            QList<QTabWidget*> widgets = child->findChildren<QTabWidget*>();
            if (!widgets.isEmpty())
                widgets.first()->parentWidget()->setStyleSheet(m_customStylesheet);
        }
    } else if (event->type() == QEvent::ChildRemoved) {
        QWidget *child = qobject_cast<QWidget*>(event->child());
        if (child) {
            QList<QTabWidget*> widgets = child->findChildren<QTabWidget*>();
            if (!widgets.isEmpty())
                widgets.first()->parentWidget()->setStyleSheet(QString());
        }
    }
}

} // namespace Internal
} // namespace QmlDesigner
