// Copyright (C) 2017 Ford Motor Company
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause

#include "client.h"

// constructor
Client::Client(QSharedPointer<SimpleSwitchReplica> ptr) :
    QObject(nullptr), clientSwitchState(false), reptr(ptr)
{
    //connect signal for replica initialized with initialization slot
    initConnections();
    // We can connect to SimpleSwitchReplica signals/slots
    //directly because our Replica was generated by repc
}

//destructor
Client::~Client()
{

}


void Client::initConnections(void)
{
    // initialize connections between signals and slots

    // connect source replica signal currStateChanged() with client's recSwitchState() slot to receive source's current state
    QObject::connect(reptr.data(), &SimpleSwitchReplica::currStateChanged, this, &Client::recSwitchState_slot);
    // connect client's echoSwitchState(..) signal with replica's server_slot(..) to echo back received state
    QObject::connect(this, &Client::echoSwitchState, reptr.data(), &SimpleSwitchReplica::server_slot);
}

void Client::recSwitchState_slot(bool value)
{
    qDebug() << "Received source state "<< value << reptr.data()->currState();
    clientSwitchState = reptr.data()->currState();
    Q_EMIT echoSwitchState(clientSwitchState); // Emit signal to echo received state back to server
}
