/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.play_billing;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.android.billingclient.api.AcknowledgePurchaseParams;
import com.android.billingclient.api.BillingFlowParams;
import com.android.billingclient.api.BillingResult;
import com.android.billingclient.api.ConsumeParams;
import com.android.billingclient.api.Purchase;
import com.android.billingclient.api.zzaq;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.json.JSONException;

public final class zza {
    public static final int zza = Runtime.getRuntime().availableProcessors();

    /*
     * Enabled aggressive block sorting
     */
    public static int zza(Bundle object, String string) {
        if (object == null) {
            com.google.android.gms.internal.play_billing.zza.zzk(string, "Unexpected null bundle received!");
            return 6;
        }
        if ((object = object.get("RESPONSE_CODE")) == null) {
            com.google.android.gms.internal.play_billing.zza.zzj(string, "getResponseCodeFromBundle() got null response code, assuming OK");
            return 0;
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        object = String.valueOf(object.getClass().getName());
        String string2 = "Unexpected type for bundle response code: ";
        object = ((String)object).length() != 0 ? string2.concat((String)object) : new String(string2);
        com.google.android.gms.internal.play_billing.zza.zzk(string, (String)object);
        return 6;
    }

    public static Bundle zzb(AcknowledgePurchaseParams acknowledgePurchaseParams, String string) {
        acknowledgePurchaseParams = new Bundle();
        acknowledgePurchaseParams.putString("playBillingLibraryVersion", string);
        return acknowledgePurchaseParams;
    }

    public static Bundle zzc(ConsumeParams consumeParams, boolean bl, String string) {
        consumeParams = new Bundle();
        if (bl) {
            consumeParams.putString("playBillingLibraryVersion", string);
        }
        return consumeParams;
    }

    public static Bundle zzd(int n, boolean bl, String arrayList, @Nullable String string, ArrayList<zzaq> arrayList2) {
        string = new Bundle();
        if (n >= 9) {
            string.putString("playBillingLibraryVersion", (String)((Object)arrayList));
        }
        if (n >= 9 && bl) {
            string.putBoolean("enablePendingPurchases", true);
        }
        if (n >= 14) {
            arrayList = new ArrayList<Object>();
            int n2 = arrayList2.size();
            bl = false;
            for (n = 0; n < n2; ++n) {
                zzaq cfr_ignored_0 = (zzaq)arrayList2.get(n);
                arrayList.add(null);
                bl |= TextUtils.isEmpty(null) ^ true;
            }
            if (bl) {
                string.putStringArrayList("SKU_OFFER_ID_TOKEN_LIST", arrayList);
            }
        }
        return string;
    }

    public static Bundle zze(BillingFlowParams billingFlowParams, boolean bl, boolean bl2, String arrayList) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", (String)((Object)arrayList));
        if (billingFlowParams.zzb() != 0) {
            bundle.putInt("prorationMode", billingFlowParams.zzb());
        }
        if (!TextUtils.isEmpty((CharSequence)billingFlowParams.zzf())) {
            bundle.putString("accountId", billingFlowParams.zzf());
        }
        if (!TextUtils.isEmpty((CharSequence)billingFlowParams.zzg())) {
            bundle.putString("obfuscatedProfileId", billingFlowParams.zzg());
        }
        if (billingFlowParams.getVrPurchaseFlow()) {
            bundle.putBoolean("vr", true);
        }
        if (!TextUtils.isEmpty(null)) {
            String[] stringArray = new String[]{null};
            arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            bundle.putStringArrayList("skusToReplace", arrayList);
        }
        if (!TextUtils.isEmpty((CharSequence)billingFlowParams.zzh())) {
            bundle.putString("oldSkuPurchaseToken", billingFlowParams.zzh());
        }
        if (!TextUtils.isEmpty(null)) {
            bundle.putString("oldSkuPurchaseId", null);
        }
        if (!TextUtils.isEmpty(null)) {
            bundle.putString("paymentsPurchaseParams", null);
        }
        if (bl && bl2) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        return bundle;
    }

    public static Bundle zzf(boolean bl, boolean bl2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("playBillingLibraryVersion", string);
        if (bl && bl2) {
            bundle.putBoolean("enablePendingPurchases", true);
        }
        return bundle;
    }

    public static BillingResult zzg(Intent object, String string) {
        if (object == null) {
            com.google.android.gms.internal.play_billing.zza.zzk("BillingHelper", "Got null intent!");
            object = BillingResult.newBuilder();
            ((BillingResult.Builder)object).setResponseCode(6);
            ((BillingResult.Builder)object).setDebugMessage("An internal error occurred.");
            return ((BillingResult.Builder)object).build();
        }
        BillingResult.Builder builder = BillingResult.newBuilder();
        builder.setResponseCode(com.google.android.gms.internal.play_billing.zza.zza(object.getExtras(), string));
        builder.setDebugMessage(com.google.android.gms.internal.play_billing.zza.zzh(object.getExtras(), string));
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Purchase zzl(String object, String string) {
        if (object == null || string == null) {
            com.google.android.gms.internal.play_billing.zza.zzk("BillingHelper", "Received a bad purchase data.");
            return null;
        }
        try {
            Purchase purchase = new Purchase((String)object, string);
            return purchase;
        }
        catch (JSONException jSONException) {
            object = String.valueOf((Object)jSONException);
            string = String.valueOf(object);
            int n = string.length();
            StringBuilder stringBuilder = new StringBuilder(n + 47);
            stringBuilder.append("Got JSONException while parsing purchase data: ");
            stringBuilder.append((String)object);
            com.google.android.gms.internal.play_billing.zza.zzk("BillingHelper", stringBuilder.toString());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String zzh(Bundle object, String string) {
        String string2 = "";
        if (object == null) {
            com.google.android.gms.internal.play_billing.zza.zzk(string, "Unexpected null bundle received!");
            return string2;
        }
        if ((object = object.get("DEBUG_MESSAGE")) == null) {
            com.google.android.gms.internal.play_billing.zza.zzj(string, "getDebugMessageFromBundle() got null response code, assuming OK");
            return string2;
        }
        if (object instanceof String) {
            return (String)object;
        }
        object = String.valueOf(object.getClass().getName());
        String string3 = "Unexpected type for debug message: ";
        object = ((String)object).length() != 0 ? string3.concat((String)object) : new String(string3);
        com.google.android.gms.internal.play_billing.zza.zzk(string, (String)object);
        return string2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static List<Purchase> zzi(Bundle object) {
        if (object == null) {
            return null;
        }
        ArrayList arrayList = object.getStringArrayList("INAPP_PURCHASE_DATA_LIST");
        ArrayList arrayList2 = object.getStringArrayList("INAPP_DATA_SIGNATURE_LIST");
        ArrayList<Purchase> arrayList3 = new ArrayList<Purchase>();
        if (arrayList == null || arrayList2 == null) {
            com.google.android.gms.internal.play_billing.zza.zzk("BillingHelper", "Couldn't find purchase lists, trying to find single data.");
            Purchase purchase = com.google.android.gms.internal.play_billing.zza.zzl(object.getString("INAPP_PURCHASE_DATA"), object.getString("INAPP_DATA_SIGNATURE"));
            if (purchase == null) {
                com.google.android.gms.internal.play_billing.zza.zzk("BillingHelper", "Couldn't find single purchase data as well.");
                return null;
            }
            arrayList3.add(purchase);
            return arrayList3;
        } else {
            void var0_3;
            boolean bl = false;
            while (var0_3 < arrayList.size() && var0_3 < arrayList2.size()) {
                Purchase purchase = com.google.android.gms.internal.play_billing.zza.zzl((String)arrayList.get((int)var0_3), (String)arrayList2.get((int)var0_3));
                if (purchase != null) {
                    arrayList3.add(purchase);
                }
                ++var0_3;
            }
        }
        return arrayList3;
    }

    public static void zzj(String string, String string2) {
        if (Log.isLoggable((String)string, (int)2)) {
            Log.v((String)string, (String)string2);
            return;
        }
    }

    public static void zzk(String string, String string2) {
        if (Log.isLoggable((String)string, (int)5)) {
            Log.w((String)string, (String)string2);
            return;
        }
    }
}

