//+sc0.275862 +sr0.083682 +ec0.457680 +er0.887029 oysters    38:05 w/ blur 10   4:57

//+sc0.670846 +sr0.016736 +ec0.818182 +er0.301255 place sign

#version 3.6;

#include "colors.inc"
#include "functions.inc"
#include "transforms.inc"

#declare do_rad = true;
#declare do_oysters = true;
#declare do_media = true;
#declare do_ice = true;
#declare do_blur = false;
#declare Blur_count = 10;

global_settings {
  assumed_gamma 1.0
	//     max_trace_level  10
	#if(do_rad)
	  ambient_light 1
	  radiosity {
	    pretrace_start 0.08     // start pretrace at this size
	    pretrace_end   0.02     // end pretrace at this size
	    count 100               // higher -> higher quality (1..1600) [35]
	    nearest_count 5        // higher -> higher quality (1..10) [5]
	    error_bound 0.5         // higher -> smoother, less accurate [1.8]
	    recursion_limit 1       // how much interreflections are calculated (1..5+) [3]
	    low_error_factor .2     // reduce error_bound during last pretrace step
	    gray_threshold 0.1      // increase for weakening colors (0..1) [0]
	    minimum_reuse 0.015     // reuse of old radiosity samples [0.015]
	    brightness 1            // brightness of radiosity effects (0..1) [1]
	
	    adc_bailout 0.01/2
	    normal on               // take surface normals into account [off]
	    media off                // take media into account [off]
	    //save_file "file_name"   // save radiosity data
	    //load_file "file_name"   // load saved radiosity data
	    //always_sample off       // turn sampling in final trace off [on]
	    //max_sample 1.0          // maximum brightness of samples
	  }
	#else
		ambient_light 1
	#end
}

// ----------------------------------------

camera {
  location  <5.0, 15, -15.0> //was y=15, z=-15
  look_at   <0.0, 0.0,  0.0>
	#if(do_blur)
	  focal_point <0,0,3>    // pink sphere in focus
	  aperture 0.6     // a nice compromise
	  blur_samples Blur_count       // fewer samples, faster to render
	#end
}

#if(!do_rad)
	light_source {
	    <0, 0, 0>
	    color rgb <1, 1, 1>
	    translate <-10, 30, -100>
	}
	
	light_source {
	    <0, 0, 0>
	    color rgb <1, 1, 1>/4
	    translate <30, 50, -100>
	}
	
	light_source {
	    <0, 0, 0>
	    color rgb <1, 1, 1>/10
	    translate <60, 60, 90>
	}
#end
// ----------------------------------------

// radiosity sphere
sphere {
	0,2000
   pigment{bozo pigment_map{[0 rgb<0.9,0.9,1.0>][1 rgb<0.5,0.5,0.7>]}}
   finish{ambient 1}
   inverse
}

// 'room'
difference{
	box{<-500,-20,-30>,<500,100,150>}
	box{<-450,-19,-40>,<450,90,145>}
	pigment{bozo pigment_map{[0 White][1 Gray20]}}
	finish{ambient 0 diffuse 1}
}
box{<-455,-18, 25>,<455,-17,155> pigment{granite scale 3 pigment_map{[0 Gray10][1 Gray50]}}}

// marble counter
#declare Counter =
plane{
	y,-3.51 //-2.01
 	pigment{agate scale 3 turbulence 0.75 pigment_map{[0.0 rgb<0.1,0.1,0.1>*0.9][0.75 rgb<1,1,0.9>*0.9]}}
	finish{diffuse 0.75 ambient 0 specular 0.5 roughness 0.01}
	normal{wrinkles 1 scale 2} 	
}

// planks
#declare GammaFact = 2.5;
#declare IW_Quality = 2;
#include "isowood3.inc"
#include "iw_textures.inc"

#declare Plank_Finish =
finish{
  ambient 0
  diffuse 0.95
  brilliance 1.1
  specular 0.1
  roughness 0.02
}

#declare Plank_Normal =
normal{wrinkles 0.1}

#declare Plank =
object{
	IW_Plank_Round(1, 3/3, 0.74/3, 100/3, 15, 25, 0.05, 0.001, pigment{P_IW_02 color_map{CM_IW_05}}, Plank_Finish, Plank_Normal)
	scale 3
}

#declare PlankCount = 0;
#declare Planks=
union{
	#while(PlankCount < 20)
		object{Plank translate<0,-2.75,-50> translate x*(PlankCount*5 - 50)}
		object{Plank rotate y*90 translate<-50,-3.5,0> translate z*(PlankCount*12 - 120)}
		#declare PlankCount = PlankCount + 1;
	#end
}	

intersection{
	union{
		object{Counter}
		object{Planks}
	}
	plane{z,27 pigment{White}}
}
	
// polystyrene box
#declare Rounded_Box = superellipsoid {<0.1,0.1>}
#declare Ep_pigment = pigment{bozo pigment_map{[0 rgb<1,1,1>*0.8][1 rgb<1,1,1>*0.75]}};
#declare Ep_material = 
material{
	texture{
	  pigment{Ep_pigment}
	  finish{
	    specular 0.1
	    roughness 0.01
	    diffuse 0.9
	    ambient 0
	  }
	  normal{crackle 0.5 scale 0.15 turbulence 0.5}
	}
//	interior{
//		media{method 3 scattering{1, 6 extinction 1}}// density{wrinkles}}
//	}
}



// best os 30,20,23, / 546,56,965
// oysters
#if(do_oysters)
	#declare OSArray = array[10]
//	{<0,0,0>,<10,10,10>,<30,10,60>,<30,20,23>,<25,40,45>,<10,10,10>,<30,10,60>,<925,334,25>,<0,0,0>,<546,56,965>}
	{<0,0,0>,<30,20,23>,<30,10,60>,<30,20,23>,<25,40,45>,<10,10,10>,<30,10,60>,<546,56,965>,<0,0,0>,<546,56,965>}
	#declare OPArray = array[10]
//	{x<1,2>,<2,-1>,<-2,-1.5>,<-2,4>,<3,4.5>,<0,-5>,<3.25,-5>,x<1.25,-2.75>,<-2,-5>,<-3,2>};
	{<1,2>,<2,-1>,<-2,-1.5>,<-2,4>,<3,4.5>,<0,-5>,<3.25,-5>,<1.25,-2.75>,<-2,-5>,<-3,2>};
	#include "tm_oop.inc"
	#declare MOS = seed(33243);
	#declare OCount = 0;
	#declare OMax = 9;
	#declare Oysters_Final =
	union{
		#while(OCount <= OMax)
			MakeOyster(
				rand(MOS)*1000,
				OSArray[OCount].x, OSArray[OCount].y, OSArray[OCount].z,
				rand(MOS)*1000
			)
			object{
				FinalOyster
				rotate z*(rand(MOS)*30-15) rotate x*(rand(MOS)*30-15) rotate y*(rand(MOS)*360)
				translate<OPArray[OCount].u,0,OPArray[OCount].v>
			}
			#declare OCount = OCount + 1;
		#end
	}

#end

// ice
#if(do_ice)
	#declare Ice_Mat =
	material {
		texture {
			pigment {rgbf <1,1,1,0.5>}
			normal {average 2 normal_map{[1 granite 3 scale 2][1 wrinkles 1 scale 0.2]}}
			finish {
				diffuse 0.85
				ambient 0.15 
				specular 1.0
				roughness 0.001
			  reflection {fresnel}
			  conserve_energy
			}        
		}
		interior {
			ior 1.4
			#if(do_media)
				media{method 3 scattering{1, 0.45 extinction 1}}// density{wrinkles}}
				media{method 3 emission 0.02}
			#end
		}
	}

	#declare IS1 = 3;
	#declare IS2 = 1;
	#declare F_Ice = function(x,y,z) {
		z
		- f_ridged_mf(x*IS1,y*IS1,0, 0, 2.5, 4, 2, 5, 2)/5
		+ f_noise3d(x*IS2,y*IS2,0)
		-1
	}
	
#end

// signs - orrible hack, no time, no time!
#declare PlaceTex=
texture{
	pigment{rgb 1}
	finish{reflection{0.05}}
}
texture{
	pigment{
		image_map {
		  png "place.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
		  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
		  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
		  once           // for no repetitive tiling
		}
	}
	finish{reflection{0.05}}
}

#declare PlaceSign =
box{
	<-0.25,-1,0>,<1.25,1,0.05>
	texture{PlaceTex}
}

#declare OisterTex=
texture{
	pigment{rgb 1}
	finish{reflection{0.05}}
	normal{bozo 0.2 scale 0.1}
}
texture{
	pigment{
		image_map {
		  png "oisters.png" // the file to read (iff/tga/gif/png/jpeg/tiff/sys)
		  map_type 0        // 0=planar, 1=spherical, 2=cylindrical, 5=torus
		  interpolate 2     // 0=none, 1=linear, 2=bilinear, 4=normalized distance
		  once           // for no repetitive tiling
		}
	}
	finish{reflection{0.05}}
	normal{bozo 0.2 scale 0.1}
}

#declare OisterSign =
box{
	<-0.25,-1,0>,<1.25,1,0.05>
	texture{OisterTex}
}

// boxes w/o and w/ oysters
#declare Full_Box =
union{
	difference{
		object{Rounded_Box}
		object{Rounded_Box scale<0.85,1,0.95> translate y*0.55}
		scale<5.75,2,7.35>
		material{Ep_material}
		hollow
	}
	#if(do_ice)
		height_field{
			function 100,100 {F_Ice(x*10,y*14,0)}
			scale<10,1/2,14>	
			material{Ice_Mat}
			hollow
			translate<-5,0,-7>
		}
	#else
		sphere{0,0.001 pigment{rgbt 1}}
	#end
}

#declare Full_Box_Oysters =
union{
	object{Full_Box}
	#if(do_oysters)
		object{Oysters_Final translate y*0.5}
	#else
		sphere{0,0.001 pigment{rgbt 1}}
	#end
	object{OisterSign scale 3 rotate x*15 rotate y*-5 rotate z*7 translate z*6 translate y*3.25 translate x*-0.75}
}

#declare Full_Box_Place =
union{
	object{Full_Box}
	object{PlaceSign scale 3 rotate x*35 rotate y*-5 rotate z*-7 translate z*6 translate y*3}
}
                         
object{Full_Box_Oysters rotate y*15 translate x*-6 translate z*-3}
object{Full_Box_Place rotate y*-30 translate x*6.75 translate z*7}



