// FirePlace 
//
// ORIGIN is in the center of the fireplace on the back against the wall

#include "Colors.inc"
#include "Stones.inc"           
#include "Woods.inc"

#local base_height = 12;
#local base_width = 64;
#local base_depth = 36;

#local hearth_height = 23.5;
#local hearth_depth = 22.5;
#local hearth_front_width = 36;
#local hearth_back_width = 28;

#local fireplace_base = union
  {
  box 
    {
    <- (base_width / 2), 0, 0> 
    <(base_width / 2), base_height, - base_depth>
    texture 
      {
      brick texture{T_Grnt0}, texture{T_Stone21}      
      translate<0,0.5,0>
      }
    }
  }
                                  
#local fireplace_hearth = union
  { 
  // bottom
  box
    {
    <-(hearth_front_width / 2),12,-hearth_depth>
    < (hearth_front_width / 2),15,-0.0>
    texture
      {
      brick texture{T_Grnt1},texture{T_Grnt2}
      rotate <90,0,0>
      translate<0,0.5,0>
      }
    }        
  // right wall
  box
    {
    <0,0,0><-3,hearth_height,-hearth_depth>
    texture
      {
      brick texture{T_Grnt1},texture{T_Grnt2}
      translate<0.5,0.5,0>
      }              
    translate <0,0,hearth_depth>
    rotate<0,-10,0>
    translate <hearth_front_width / 2, 3 + base_height,-hearth_depth>
    }
  // left wall
  box
    {
    <0,0,0><3,hearth_height,-hearth_depth>
    texture
      {
      brick texture{T_Grnt1},texture{T_Grnt2}
      translate<0.5,0.5,0>
      }              
    translate <0,0,hearth_depth>
    rotate<0,10,0>
    translate <- hearth_front_width / 2, 3 + base_height,-hearth_depth>
    }
  // back wall
  box
    {
    <-hearth_back_width / 2, 0, 0><hearth_back_width / 2, hearth_height, -3>
    texture
      {
      brick texture{T_Grnt1},texture{T_Grnt2}
      rotate<0,0,0>
      translate<0,0.5,0>
      }              
    translate<0,3 + base_height,0>
    }  
  }    
  
#local fireplace_casing_v = union
  {
  // right_front
  box
    {
    <0,0,0><8,hearth_height + 3,1>
    texture {T_Wood4}
    }                    
  cone
    {
    <1,0,0> 1
    <1,hearth_height + 3,0> 1
    texture {T_Wood4}
    }  
  cone
    {
    <7,0,0> 1
    <7,hearth_height + 3,0> 1
    texture {T_Wood4}
    }  
  cone
    {
    <3,0,0> 0.5
    <3,hearth_height + 3,0> 1
    texture {T_Wood4}
    }  
  cone
    {
    <4,0,0> 0.5
    <4,hearth_height + 3,0> 1
    texture {T_Wood4}
    }  
  cone
    {
    <5,0,0> 0.5
    <5,hearth_height + 3,0> 1
    texture {T_Wood4}
    }  
    
  translate <-4,12,0>
  }                 
                
#local fireplace_casing_s = union
  {
  box
    {
    <0,0,0><1,hearth_height+3+12,-hearth_depth>
    translate<-0.5,12,0>
    texture {T_Wood4}
    }
  }                
            
#local fireplace_casing_t = union
  {
  box
    {
    <hearth_front_width / 2 + 5,hearth_height+3,0><-hearth_front_width / 2 - 5, hearth_height + 15,-1>
    texture {T_Wood4}              
    translate<0,12,0>
    }
  }            
                
#local fireplace_casing = union
  {
  object
    {
    fireplace_casing_v
    translate<hearth_front_width / 2 + 1,0,-hearth_depth - 1>
    }
  object
    {
    fireplace_casing_v
    translate<-hearth_front_width / 2 - 1,0,-hearth_depth - 1>
    }                            
  object
    {
    fireplace_casing_s
    translate<hearth_front_width / 2 + 5,0,0>
    }
  object
    {
    fireplace_casing_s
    translate<-hearth_front_width / 2 - 5,0,0>
    }              
  object
    {
    fireplace_casing_t
    translate<0,0,-hearth_depth - 1>
    }
  }  
            
#declare fireplace_mantle = union
  {
  box
    {
    < hearth_front_width / 2 + 9,hearth_height + 15, 0>
    <-hearth_front_width / 2 - 9,hearth_height + 17,-hearth_depth - 3>
    }
  cone 
    {
    < hearth_front_width / 2 + 9,hearth_height + 16, 0> 1
    < hearth_front_width / 2 + 9,hearth_height + 16, -hearth_depth - 3> 1
    }
  cone 
    {
    <-hearth_front_width / 2 - 9,hearth_height + 16, 0> 1
    <-hearth_front_width / 2 - 9,hearth_height + 16, -hearth_depth - 3> 1
    }  
  cone  
    {
    < hearth_front_width / 2 + 9,hearth_height + 16, -hearth_depth - 3> 1
    <-hearth_front_width / 2 - 9,hearth_height + 16, -hearth_depth - 3> 1
    }
  sphere
    {
    < hearth_front_width / 2 + 9,hearth_height + 16, -hearth_depth - 3> 1    
    }
  sphere
    {
    <-hearth_front_width / 2 - 9,hearth_height + 16, -hearth_depth - 3> 1    
    }
  texture {T_Stone12}
  translate<0,12,0>
  }            
                     
#declare fireplace = union
  {
  object
    {
    fireplace_base
    }      
  object
    {
    fireplace_hearth
    }        
  object
    {
    fireplace_casing
    }    
  object
    {
    fireplace_mantle
    }
  }                     



