#include "colors.inc"
#include "rand.inc"

global_settings
{
    max_trace_level 25
    photons
    {
        spacing 0.05
        //save_file "desertdessert.ph"
        //load_file "desertdessert.ph"
        autostop 0
    }
    ambient_light 0
    radiosity
    {
        pretrace_start 0.16
        pretrace_end   0.04          
        count 35                      
        nearest_count 5               
        error_bound 1.8               
        recursion_limit 3             
        low_error_factor .5           
        gray_threshold 0.0            
        minimum_reuse 0.015           
        brightness 1                  
    
        adc_bailout 0.01/2
        //save_file "desertdessert.rad"
        //load_file "desertdessert.rad"
    }
}
  
  
// texturetables
#declare CupTex =
    array[2]
    {
        texture
        {
            pigment{color rgb .5}
            finish
            {
                ambient 0.35
                brilliance 2
                diffuse 0.3
                metallic
                specular 0.80
                roughness 1/20
                reflection 0.1
            }
            
            normal
            {
                bozo
                bump_size .01
                scale<10,.1,10>
            }
        },
        texture
        {
            pigment{color rgb .5}
            finish
            {
                ambient 0.35
                brilliance 2
                diffuse 0.3
                metallic
                specular 0.80
                roughness 1/20
                reflection 0.1
            }
            
            normal
            {
                average
                normal_map
                {
                    [1 bozo bump_size .01 scale <.1,10,.1>]
                    [.3 wood bump_size .01 scale <.1,.1,10> rotate 90*x]
                }
            }
        }
        
    }
    
#declare StoneSpheresTex =
    array[3]
    {
        texture
        {
            pigment
            {
                granite
                color_map
                {
                    [0,.25 color White color White]
                    [.5 Gray75]
                    [1 Gray25]
                }
                turbulence 1.2
                scale 2
            }
            finish
            {
                ambient .25
            }
        },
        texture
        {
            pigment
            {
                agate
                color_map
                {
                    [0,.5 color DarkBrown color Brown]
                    [.75 Gray25]
                    [1 Black]
                }
                turbulence 2
                scale 2
            }
            finish
            {
                ambient .25
            }
        },
        texture
        {
            pigment
            {
                marble
                color_map
                {
                    [0,1 color Yellow-Gray25 color Yellow/2]
                }
                turbulence 2
                scale 2
            }
            finish
            {
                ambient .25
            }
        }
    }
    
#declare SandHeapTex =
    array[1]
    {
        texture
        {
            pigment
            {
                bozo
                color_map
                {
                    [0 Yellow/2]
                    [1 (Yellow+White)/2]
                }
                scale .1
            }
            normal
            {
                bozo
                bump_size .5
                scale .1
            }
        }
    }    

#declare CactusTex =
    array[2]
    {
        texture
        {
            pigment{color Khaki}
        },
        texture
        {
            pigment{color Khaki*2}
        }
    }
    
// the cup for the des(s)ert
 
#declare Cup =
#union
{
    //read texturetable CupTex
    #local CupMetal = CupTex[0];
    #local CupMetalConcentricRings = CupTex[1];
    
    #local CHeight = 10;
    #local COuterRad = 5.001;
    #local CInnerRad = 5;
    
    //cup
    difference
    {
        sphere
        {
            0,COuterRad
        }
        box
        {
            <-COuterRad-.001,0,-COuterRad-.001>,
            <COuterRad+.001,COuterRad+.001,COuterRad+.001>
        }
        sphere
        {
            0,CInnerRad
        }
        translate (CHeight)*y
    }
    
    //foot
    difference
    {
        union
        {
            cylinder
            {
                <0,0,0>,<0,.01*CHeight,0>,.75*CInnerRad
            }
            torus
            {
                .75*CInnerRad,.01*CHeight
            }
        }
        box
        {
            <(.75*-CInnerRad)-.001,.75*.5*.01*CHeight,(-75*-CInnerRad)-.001>,
            <(.75*CInnerRad)+.001,0,(.75*CInnerRad)+.001>
        }
        
        texture{CupMetalConcentricRings}
    }

    //stem
    cylinder
    {
        <0,0,0>,<0,CHeight-CInnerRad,0>,.05*CHeight
    }

    texture{CupMetal}
}

// the sand-filling
#declare SandFilling =
difference
{
    
    //read texturetable SandHeapTex
    #declare SandTex = SandHeapTex[0];
    
    #local SFillingRad = CInnerRad;
    
    sphere
    {
        0,SFillingRad
    }
    box
    {
        <-SFillingRad-.001,-(.2*SFillingRad),-SFillingRad-.001>,
        SFillingRad+.001
    }
    
    texture{SandTex}

    translate (CHeight)*y    
}

// the stonespheres
#declare StoneSpheres =
union
{
     //read texturetable StoneSpheresTex
    #local Stone1Tex = StoneSpheresTex[0];
    #local Stone2Tex = StoneSpheresTex[1];
    #local Stone3Tex = StoneSpheresTex[2];
    
    sphere
    {
        <.5*CInnerRad,0,0>,sqrt(CInnerRad)-.05*CInnerRad
        texture{Stone1Tex}
    }
    sphere
    {
        <.5*CInnerRad,0,0>,sqrt(CInnerRad)-.05*CInnerRad
        texture{Stone2Tex}
        rotate 120*y
    }
    sphere
    {
        <.5*CInnerRad,0,0>,sqrt(CInnerRad)-.05*CInnerRad
        texture{Stone3Tex}
        rotate -120*y
    }
    translate CHeight*y
    rotate 13*y
}

// the sandheap
#declare SandHeap =
    sor
    {
        //read texturetable SanHeapTex
        #local Sand2Tex = SandHeapTex[0];
        
        4,
        <10,(.2*SFillingRad)-.001>,
        <(7/8)*SFillingRad,(.2*SFillingRad)>,
        <0,((3/2)*CHeight)-.001>,
        <0,((3/2)*CHeight)>
        
        texture{Sand2Tex}
        translate .8*CHeight*y
    }

// the cactus
#declare Cactus =
    union
    {
        //read texturetable CactusTex
        #local CactusBody = CactusTex[0];
        #local PeaksTex = CactusTex[1];
        
        union
        {
            sphere
            {
                0,5
                scale<.25,1,.25>
            }
            #local I = 0;
            #while(I<5)
                
                sphere
                {
                    0,5.5
                    scale<.1,(5/5.5),.25>
                    rotate I*(360/5)*y
                }
                
                #local I = I+1;
            #end
            
            texture{CactusBody}
        }
        union
        {
            #local I = 0;
            #while(I<5)
                #local Peaks = 250;
                #while (Peaks>0)
                    #local PeakRotate = RRand(-180,45,RdmB);
                    #local PeakJitter = RRand(-7.5,7.5,RdmB);
                    #local PeakHead = vrotate(6.5*z,PeakRotate*x);
                    #local PeakHead = vrotate(PeakHead,PeakJitter*y);
                    cone
                    {
                        0,.35
                        PeakHead,0
                        
                        scale<.25,(5/5.5),.25>
                        rotate I*(360/5)*y 
                    }
                    
                    #local Peaks =Peaks-1;
                #end
                #local I = I+1;
            #end
            texture {PeaksTex}
        }
        
        rotate 30*z
        translate (11/8)*CHeight*y
        rotate (180+73)*y
    }

#declare WaterGlass = difference
    {
        merge
        {
            cone
            {
                0,4
                15*y,5
            }
            torus
            {
                4.95,.05
                translate 15*y
            }
        }
        
        cone
        {
            15.001*y,4.9
            2*y,4
        }
                
        texture
        {
            pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
        }
        
        finish
        {
            ambient 0.1
            diffuse 0.1
            reflection 0.1
            specular 0.8
            roughness 0.0003
            phong 1 
            phong_size 400           
        }
        
        interior
        {
            ior Crown_Glass_Ior
        }
        
}

#declare Water =
intersection
{
    cylinder
    {
        0,14*y,5
                
        texture
        {
            pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
            normal{ripples bump_size .25 scale .25}
        }
        
        finish
        {
            ambient 0.1
            diffuse 0.1
            reflection 0.1
            specular 0.8
            roughness 0.0003
            phong 1 
            phong_size 400           
        }
        
        interior
        {
            ior Water_Ior
            dispersion Water_Dispersion
            dispersion_samples 7
        }
    
    }
    
    cone
    {
        15.001*y,4.9
        2.001*y,4
    
        texture
        {
            pigment { rgbf <0.98, 0.98, 0.98, 0.9> }
        }
        
        finish
        {
            ambient 0.1
            diffuse 0.1
            reflection 0.1
            specular 0.8
            roughness 0.0003
            phong 1 
            phong_size 400           
        }
        
        interior
        {
            ior Water_Ior
            dispersion Water_Dispersion
            dispersion_samples 7
        }
    
    }
}


// the assembled cup
union
{
    object{Cup}
    object{SandFilling}
    object{StoneSpheres}
    object{SandHeap}
    object{Cactus}

    translate -5*x-2.5*z
}

// the assembled glass of water
union
{
    object{WaterGlass}
    object{Water}
    photons
    {
        target 1.0          
        refraction on
        reflection on
        collect off         
    }
    
    double_illuminate
    split_union off
    translate 7.5*x+2.5*z 
}


light_source
{
    <-.25,.1,.5>*1000,(Orange+Red+White)/3
    photons
    {
        refraction on
        reflection on
    }
}

#declare TableTex =
    texture
    {
        pigment
        {
            checker
            color Green
            color Yellow
        }
        scale 7.5
        translate 15*x+25*z
        rotate 35*y
    }    

#declare TableNorm = normal
    {
        quilted
        bump_size .5
        scale .5
        rotate 35*y
    }

plane
{
    y,0
    texture{TableTex}
    normal{TableNorm}
}

sky_sphere
{
    #local AG_Cloud2 =
    pigment {
        wrinkles
        turbulence 0.65
        octaves 6
        omega 0.7
        lambda 2
        color_map {
            [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                        color red 0.75 green 0.75 blue 0.75]
            [0.1, 0.5   color red 0.75 green 0.75 blue 0.75
                        color rgb <0.435, 0.258, 0.258>  ]
            [0.5, 1.001 color rgb <0.435, 0.258, 0.258>
                        color rgb <0.435, 0.258, 0.258> ]
        }
        scale <6, 1, 6>
    }
    #local AG_Cloud3 =
    pigment {
        bozo
        color_map {
            [0.0, 0.1   color red 0.85 green 0.85 blue 0.85
                        color red 0.65 green 0.60 blue 0.55]
            [0.1, 0.5   color red 0.65 green 0.60 blue 0.55
                        color rgb <0.309, 0.184, 0.184> ]
            [0.5, 1.001 color rgb <0.309, 0.184, 0.184>
                        color rgb <0.2, 0.1, 0.1>]
        }
        turbulence 0.65
        octaves 6
        omega 0.707
        lambda 2
        scale <6, 4, 6>
    }    
    
    pigment
    {
        gradient y
        pigment_map {
            [0.01 rgb <0.847, 0.749, 0.847> ] // horizon
            [0.25 AG_Cloud2 scale 0.25 rotate z*5]
            [0.60 AG_Cloud3 scale <0.25, 0.15, 0.25> rotate z*10]
        }
    }
}

camera
{
    location 23*y-23*z
    look_at 7.5*y-2*z    
    
    up y
    right -2.35*z
    
    aperture .4
    blur_samples 20
    focal_point 7.5*y
}