#include "palm_g.inc"
#include "palm_k.inc"
#include "palm_f.inc"

#declare Palmenstammtextur = texture {
   finish {
      ambient rgb <0.0588235, 0.0588235, 0.0588235>
      diffuse 0.6
   }
   
   normal {
      crackle
      5
   }
   
   pigment {
      crackle
      
      color_map {
         [ 0 color rgb <0.290196, 0.243137, 0.231373>
         ]
         [ 0.05 color rgb <0.317647, 0.266667, 0.25098>
         ]
         [ 0.1 color rgb <0.729412, 0.611765, 0.576471>
         ]
         [ 1 color rgb <0.729412, 0.611765, 0.576471>
         ]
      }
   }
   scale <0.2, 0.04, 0.2>
}

#declare Blaetter1 = pigment {
	 bumps

      color_map {
         [ 0.45 color rgb <0.1,0.8,0.6> ] 
	 [ 0.65  color rgb <0.9,0.9,0.5> ]
     }
     scale 2
}

#declare Blaetter2 = pigment {
	 bumps

      color_map {
	 [ 0.35  color rgb <0.9,0.9,0.5>*0.4 ]
	 [ 0.75  color rgb <0.9,0.9,0.5> ]
     }
     scale 0.5
}

#declare Palmenblaetter = pigment {
      gradient y

      pigment_map {
         [ 0.35 Blaetter1 ] 
	 [ 0.65 Blaetter2 ]
     }
     scale 15
     translate 6*y
}

#declare palm_g = union {
	 object {
            palm_13_stems
            texture { Palmenstammtextur }
         }
         object {
            palm_13_leaves
            pigment { Palmenblaetter }
	 }
	 scale 0.5
}

#declare palm_k = union {
	 object {
            palm2_17_stems
            texture { Palmenstammtextur }
         }
         object {
            palm2_17_leaves
            pigment { Palmenblaetter }
         }
	 scale 0.5
}

#declare palm_f = union {
	 object {
            fanpalm_13_stems
            texture { Palmenstammtextur }
         }
         object {
            fanpalm_13_leaves
            pigment { Blaetter1 }
         }
	 scale 0.7
}

#declare Palme_lang_gerade = object {
   palm_g
   rotate 177*y
   translate -1*y
}

#declare Palme_lang_krumm = object {
  palm_g
  scale 0.9
  rotate 88*y
  translate -1*y
}

#declare Palme_kurz_gerade = object {
   palm_k
   rotate 270*y
   translate -1*y
}

#declare Palme_kurz_krumm = object {
  palm_f
  scale 0.9
  rotate 139*y
  translate -1*y
}

#declare Palmen_3er = union {
   object {
      palm_k
      rotate 11*y
      translate <-0.67, -0.5, -0.25>
   }
   
   object {
      palm_g
      rotate y*22
      translate <0, -0.7, 0>
   }
   
   object {
      palm_k
      scale 0.9
      translate <0.67, 0, 0.4>
   }

   translate -y
}

#declare Palmen_6er = union {
   object {
      palm_g
      scale 0.9
      rotate y*82
      translate <0.5, -0.8, -1>
   }
   
   object {
      palm_k
      rotate y*45
      translate <1.4, 0, -1>
   }
   
   object {
      palm_k
      scale 1.1
      rotate 8*y
      translate <-0.67, 0, -0.25>
   }
   
   object {
      palm_f
      scale .7
      rotate y*(-14)
      translate <1.5, 0, 0.15>
   }
   
   object {
      palm_g
      scale 1.1
      rotate y*(-28)
      translate <0.45, 0, -0.15>
   }
   
   object {
      palm_k
      scale 1.1
      rotate y*(-88)
      translate <0.5, 0, 1>
   }

   translate -y
}

