#declare MakeFrameFile = false;  
#declare MaxFrame = 5000; 	// This should be rather obvious, shouldn't it? The number of frames
#declare GroundLimit = 10000000;	// Something big
//#declare GroundSeed = 1+int( (MaxFrame*clock));  //for animations
//#declare GroundSeed = 5001;	//for stills.  1031, type 1 is an excellent mountain range.


//Usage of this macro:
//Groundseed is the frame number from the test files
//TerrainType is an integer 1-5 (else default), sets terrain distribution
//heightShift adjusts the base height of the terrain.  (only tested with TerrainType 5, but should work all around)
//example: MakeTerrainRoot(4805, 5, -.05)
#macro MakeTerrainRoot (GroundSeed, TerrainType )

#local GroundRandom = seed( GroundSeed  );

#debug concat( "Ground seed ",  str (GroundSeed, 1.0, 1.0), "\n" )

#if (MakeFrameFile = true)
	#fopen FrameFile concat("FrameFile", str(GroundSeed,1,0)) write
	#write (FrameFile concat("Random Number Statistics from test.pov for GroundSeed ", str(GroundSeed,1,0),".\n"))
	#debug "Producing frame file.\n"
#end

//Possible TerrainTypes:
//1: flatlands with steep, medium-height mountains.  Few hills or ridges, and almost no valleys below the "plains"
//2: smooth, rolling hills
//3: mountains that rise more sharply and less high than type 1, some flatland correction, notable for lowlands and river/lake valleys
//4: mimics original 6-point linear function, but without the slope-change lines
//5: a variation of 4, with very slight flatland correction
//all others, including zero: the original 6-point linear setup.  Parses fastest. Leaves rings in the bathtub.

#declare BareBonesMode = 0;
#switch (TerrainType)
		#case (1)  //pointy mountains, large flatland correction
		
//			How this works:
//			Heights are distributed according to any fifth order equation:
//			equation is in the form penta*w^5 + tetra*w^4 - tri*w^3 - di*w^2 + mono*w + nudge
//			where w = (x + ioffset) and the entire result is multiplied by yscalar
//			to test and modify, use with a graphing calculator program in the domain 0 < x < 1
			
			
			#declare penta = .6;  
			#declare tetra = 2.2; 
			#declare tri = 1.4;  
			#declare di = 1.2;   
			#declare mono = 1;  //works as a kind of linear correction: higher values yield a more linear graph
			#declare nudge = -.07; //Vertical nudge; use tiny positive or negative values to adjust mountain heights.
			#declare ioffset = .06;  //use SMALL positive values to increase mountain height, or negative to lower mountains (shifts graph left or right)
			#declare yscalar = 1.5; //height multiplies by this.  Scaling Landscape object is probably better.
			
			#declare maxheight = 2; //map is this at 1.00; any value higher than this generated by the equation is replaced with maxheight
			#declare TurbSeed = .55;	//higher values yield more complex, bumpier landscapes
		#break
		
		#case (2)  //rolling hills, no flatlands added
		
			#declare penta = .4;  
			#declare tetra = 1.4; 
			#declare tri = 1.4;  
			#declare di = 1.2;   
			#declare mono = 2;  
			#declare nudge = -.5;
			#declare ioffset = .09;  
			#declare yscalar = 1.4; 
			
			#declare maxheight = 1.5;
			#declare TurbSeed = .25;
			#declare CrackLevel = .75; //previously .65
		#break
		
		#case (3) 
			#declare penta = .95;  
			#declare tetra = 2.4; 
			#declare tri = 1.4;  
			#declare di = 1.25;   
			#declare mono = 1.03;
			#declare nudge = -.07;
			#declare ioffset = -.1;
			#declare yscalar = 2.3;
			
			#declare maxheight = 2;
			#declare TurbSeed = .4;
		#break
		
		#case (4)
			#declare penta = 1;  
			#declare tetra = 1.1; 
			#declare tri = 0;  
			#declare di = 0;   
			#declare mono = .5;
			#declare nudge = 0;
			#declare ioffset = -.05;
			#declare yscalar = 1;
			
			#declare maxheight = 2;
			#declare TurbSeed = .55;
		#break
		
		#case (5)
			#declare penta = 1.3;  
			#declare tetra = 2.6; 
			#declare tri = 1.3;  
			#declare di = 0;   
			#declare mono = .4;
			#declare nudge = .3;
			#declare ioffset = -.05;
			#declare yscalar = .8;
			
			#declare maxheight = 2;
			#declare TurbSeed = .55;
		#break
		
		#case (6)  //rolling hills, no flatlands added
		
			#declare penta = .35;  
			#declare tetra = 1.4; 
			#declare tri = 1.4;  
			#declare di = 1.2;   
			#declare mono = 2;  
			#declare nudge = -.5;
			#declare ioffset = .19;  
			#declare yscalar = 1.2; 
			
			#declare maxheight = 1.5;
			#declare TurbSeed = .45;
			#declare CrackLevel = .75; //previously .65
		#break
		
		#else
			#declare BareBonesMode = 1;
			#declare TurbSeed = .55;
	#end

#declare PatternRoot = 
pigment {
	bozo 
	

//Now, generate the terrain's color map.
	#if (BareBonesMode = 1)  //use old code
	
		#if (MakeFrameFile = true)
			#write (FrameFile, "\nBareBonesMode is on.\n")
		#end
	
		#declare LowPoint = 0.1+0.2*rand( GroundRandom );			// These change the low end slightly
		#declare MidPoint = LowPoint+0.1+0.2*rand( GroundRandom );
		#declare MiddPoint = MidPoint + 0.1 +0.2*rand( GroundRandom);  //unused now, but do not comment out (rand() needs to be called)
		
		color_map {
			[ 0.000 rgb <0,0,0> ]	//black
			[ LowPoint rgb <0.1,0.1,0.1> ]
			[ MidPoint rgb <0.3,0.3,0.3> ]
			[ MidPoint + 0.2 rgb <0.5,0.5,0.5> ]
			[ 0.8 rgb 1 ]
			[ 1.000 rgb<2, 2, 2> ]	//white
		}
	#else  //use new code
	
		#if (MakeFrameFile = true)
			#write (FrameFile, concat("\nBareBonesMode is off, using TerrainType ", str(TerrainType,1,0), ".\n"))
		#end
		//To produce the same results as the first testbatch, rand must be called 3 times 
		//between the beginning of PatternRoot and the turbulence calls.
		#local foo = rand( GroundRandom);
		#local bar = rand( GroundRandom);
		#local baz = rand( GroundRandom);
	
	#ifndef( heightShift )
		#declare heightShift = 0;
	#end
	#ifndef( heightShiftLimit )
		#declare heightShiftLimit = 0;
	#end
	
	
	color_map {
		#local i = 0;
		#local height = 0;
		#while (i < 1.0)
			#local k = i + ioffset;
			#local height = yscalar * ((penta*(pow(k,5)))+(tetra*(pow(k,4))) -(tri*(pow(k,3))) - (di*pow(k,2)) + (mono * k) + nudge);
			#if (height < maxheight)
				#if( height < heightShiftLimit )
					#local height = height + heightShift;
				#end
				[ i rgb height ]
				//Use this line for debugging; it's messy otherwise.
				//#debug concat("Height at ", str(i, 5, 3), " is ", str(height, 7, 4), ".\n")
			#else
				[i rgb maxheight]
				//#debug concat("\nHeight exceeded maxheight, placing ", str(maxheight, 3, 3), " at ", str(i, 5, 2), ".")
			#end
			#local i = i + 0.005;
			#end
		[1 rgb maxheight]
	}
	#end

}

//Generate random values for terrains color map.

#ifndef (TurbVal)
	#local TurbVal = TurbSeed + 0.2*rand( GroundRandom );
#end
#ifndef (TransValX)
	#local TransValX = GroundLimit*rand( GroundRandom );
#end
#ifndef (TransValY)
	#local TransValY = GroundLimit*rand( GroundRandom );
#end
#ifndef (TransValZ)
	#local TransValZ = GroundLimit*rand( GroundRandom );
#end
#ifndef (ClrMapScale)
	#local ClrMapScale = 3.75+2*rand( GroundRandom );
#end
	
#if (MakeFrameFile = true)
	#write (FrameFile, "\nValues for this frame's root color map:\n")
	#write (FrameFile, concat("Turbulence: ", str(TurbVal, 12, 12), "\n"))
	#write (FrameFile, concat("Translated by ", str(TransValX, 10, 5), " ", str(TransValY, 10, 5), " ", str(TransValZ, 10, 5), "\n"))
	#write (FrameFile, concat("Scaled by ", str(ClrMapScale, 10, 10), "\n\n"))
#end

//The pattern to apply over PatternRoot's mountains
#declare  PatternMount = 
pigment {
	crackle 
//	metric 2
//	offset .7
	color_map {
		//[ 0.000 rgb <-.15, -.15, -.15> ]	//black
		[ 0.000 rgb <0, 0, 0> ]	//black
		[ 1.000 rgb <1.0, 1.0, 1.0> ]	//white
	}
	//turbulence .15
	translate 18000
	scale .24
//	scale <.15, .25, .15> //new
}

#ifndef (CrackLevel)
	#declare CrackLevel = .375;
#end

//The merging of Root and Mount
#declare PatternRange = 
pigment{
	bozo
	pigment_map{
	[CrackLevel PatternRoot]
	[1.0 PatternMount ]
	}
	turbulence TurbVal
	translate <TransValX,TransValY,TransValZ>
	scale ClrMapScale
}

//Re-declare Root with transformations
#declare PatternRoot =
pigment{
	PatternRoot
	turbulence TurbVal
	translate <TransValX,TransValY,TransValZ>
	scale ClrMapScale
}


#declare LandScale =2+2*rand(GroundRandom);
#declare CamRand = rand(GroundRandom);
#declare CamRand2 = rand(GroundRandom);



//The final pigment to send to the extruder
#declare PatternFour=
pigment{
	average
	pigment_map{
	[.5 PatternRange ]
	[1.3 PatternRoot ]
	}
}

PatternFour	//fin
	#end
	