/*
	Smoke.cpp
*/

#include "stdafx.h"
#include "CRays.h"
#include "CRaysDoc.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "colors.inc"
#include "finish.inc"


class FireTexture : public Texture {
public:
   FireTexture() : Texture(White) { 
   		ambient = 3;
		diffuse = 3;
		brilliance = 3 ;
		specular = 0;
		roughness = 0;
		metalness = 0;
		reflectivity = 0;
	   }

protected:
	Texture* proc(Hit& hit, Shader const* shader) const 
{
		Texture* pptx = new Texture(*this) ; // the returned texture

		// Find distance from intersection point to axis of cylinder
		Ray axis;	
		axis.org = ((Cylinder*)(hit.pObject))->center1;
		axis.dir = ((Cylinder*)(hit.pObject))->rZ;
		scalar edge = distance(hit.ray->point(hit.t), axis);

		// Get the altitude of the intersection point
		scalar alt = hit.ray->point(hit.t).y;

		// Texture looks better if we scale y
		Vector3 v = Vector(hit.ray->point(hit.t));
		v.y /= 2.;

		scalar u ;
		u = ABS(turbulence(2.*v, .25));
		// Transparency is based on random noise, altitude and distance from axis.
		pptx->transparency = 0;
		if (alt > 0) {
			pptx->transparency += 5*(edge+u)/3;
			pptx->transparency += (alt+u);
			pptx->transparency /= 4.5;
			if (pptx->transparency > 1.8)
				hit.flags |= NULLIFY;
			pptx->transparency = MIN(1, pptx->transparency);
			}

	// Color is determined from the Perlin Noise Function.
	// After experimentation, 2 colors (Red, Yellow) seemed best.
	u = ABS(turbulence(4.*v, .125));
	scalar irange0 = 0, range0,range1;
	if (u > irange0) {
		range0 = irange0;  // initial range was for black
		range1 = range0 + (1 - irange0)/3.;
		if (u < range1)
			pptx->color = Yellow*3*(u - range0)
						+ Red*3*(range1 - u);
		else {
			range0 = range1;	// This was for orange
			range1 = range0 + (1 - irange0)/3.;
			if (u < range1)
				pptx->color = Red*3*(u - range0)
							+ Yellow*3*(range1 - u);
			else {
				range0 = range1;
				range1 = range0 + (1 - irange0)/3.;
				pptx->color = Red*3*(u - range0)
							+ Red*3*(range1 - u);
				}
			}
		}
/*
	else {
		pptx->color.x = pptx->color.y = pptx->color.z = u; // near black
		}
*/
	return pptx ;
	}

	};

Union* fire() {
	Union* column = new Union;
	Cylinder* pCyl = new Cylinder(Position(0,0,0),	// Center 1
									Yaxis,			// Axis
									20,				// Height
									1,				// major radius
									.3,				// ratio of minor radius
									Direction(1,0,0));	// reference direction
	pCyl->rotate(0,-RADIANS(110),0);
	pCyl->move(1.7,.1,3.35);
	column->add(pCyl);

	column->setTexture(new FireTexture);
	return column;
	}
