#declare StoneType_NonISO = 1;
#declare StoneType_Pitted = 2;
#declare StoneType_Rough = 3;
#declare StoneType_Rougher = 8;
#declare StoneType_RougherCracked = 9;
#declare StoneType_VeryRough = 4;
#declare StoneType_LightlyPitted = 5;
#declare StoneType_Rippled = 6;
#declare StoneType_Sandstone = 7;
#declare StoneType_ImbedSample = 10;
#declare StoneType_WildBlue = 11;
#declare StoneType_RockTest = 12;
#declare StoneType_Wavy = 13;

#declare BrickType_NonISO = 1;
#declare BrickType_Rounded = 2;
#declare BrickType_SmoothCut = 3;
#declare BrickType_SmoothFace = 4;


#macro Wavy(Rand)
  #ifdef (fn_surface)
    #undef fn_surface 
  #end
  #declare fn_surface=function
  {
    pigment
    {
      dents 
      //turbulence .5
      //agate
      color_map { [0 rgb 0.0][1 rgb .55] }
      //color_map { [0 rgb 0.0][.5 rgb 0.1][.8 rgb 0.3][1 rgb .5] }
      scale .25
      translate <1.3*Rand,4.63*Rand,5.2*Rand>
    }
   }
#end


#local GlassBricksTexture=
  texture
  {
    pigment{ Col_Glass_Old }
    finish{ F_Glass5 }
  }

#local GlassBricksTextureMap=
  texture_map
  {
    [1 GlassBricksTexture ]
  }
  

#macro StoneSurface( StoneType )
  //#debug concat( "-----------------------------------> HERE ", str(StoneType,7,3) )
  #ifdef (fn_Stone)
    #undef fn_Stone
  #end
  #declare fn_Stone=
    function(x,y,z,xMine,yMine,zMine){ f_rounded_box(x,y,z,0.01,.5*xMine,.5*yMine,.5*zMine)+(fn_surface(x*2,y*2,z*2).gray*.0250)}
  #declare MaxGradient=
        1; 
#end // StoneSurface

#declare MortorTexture=
  texture
  {
    pigment{ Gray }
    normal
    {
      agate
      agate_turb .5
      scale .020
    }
  }

#macro Stone( StartVect, EndVect, BrickType, StoneType, Interior, UseTextureCallback, TextureMap, TranslateTextures, StoneRandom, isStone )
  #local xSize = abs(EndVect.x-StartVect.x);
  #local ySize = abs(EndVect.y-StartVect.y);
  #local zSize = abs(EndVect.z-StartVect.z);
  #local textureRandomizer = rand(StoneRandom)*71;
  Wavy(textureRandomizer)
  StoneSurface( StoneType )
  #declare StoneObjectLarge =
    object
    {
      isosurface
      {
        #local padding = 0;//.001;
        function{ fn_Stone( x, y, z, xSize, ySize, zSize ) }
        max_gradient MaxGradient
        contained_by 
        { 
          box 
          { 
            <-(xSize/2)-padding,-(ySize/2)-padding,-(zSize/2)-padding>,<(xSize/2)+padding,(ySize/2)+padding,(zSize/2)+padding>
          } 
        }  
        all_intersections
        #if (isStone)
          texture 
          {
            function{fn_surface(x,y,z).gray}
            texture_map { TextureMap }
            #if ( TranslateTextures != 0 )
              translate <1.3*textureRandomizer,4.63*textureRandomizer,5.2*textureRandomizer>
            #end
          }
        #else
          texture
          {
            MortorTexture
          }
        #end // if isStone
      }

    }
  #declare StoneObject =  //StoneObjectLarge
  #if (isStone)
    difference
    {
      object{ StoneObjectLarge }
      object
      {
        isosurface
        { 
          #local xSize2 = xSize * .75;
          #local ySize2 = ySize * .75;
          #local zSize2 = zSize * .75;
          #local padding = 0;//.001;
          function{ fn_Stone( x, y, z, xSize, ySize, zSize ) }
          max_gradient MaxGradient
          contained_by 
          { 
            box 
            { 
              <-(xSize2/2)-padding,-(ySize2/2)-padding,-(zSize2/2)-padding>,<(xSize2/2)+padding,(ySize2/2)+padding,(zSize2/2)+padding>
            } 
          }  
          all_intersections
          texture 
          {
            function{fn_surface(x,y,z).gray}
            texture_map { TextureMap }
            #if ( TranslateTextures != 0 )
              translate <1.3*textureRandomizer,4.63*textureRandomizer,5.2*textureRandomizer>
            #end
          }
        }
      }
      translate< StartVect.x+(xSize/2), StartVect.y+(ySize/2), StartVect.z+(zSize/2) > 
    }
  #else
    object
    {
      StoneObjectLarge
      translate< StartVect.x+(xSize/2), StartVect.y+(ySize/2), StartVect.z+(zSize/2) >
    }
  #end // if isStone
#end // Stone macro

#macro MakeStoneWall(StoneSize, MortorSize, MortorDepth, WallSize, Interior, UseTextureCallback, TextureMap, TranslateTexture, BrickType, StoneType, Translucent, Stagger, RandomSeed)
  
  #local StoneRandom = seed(RandomSeed);

  #declare xWidth = StoneSize.x*WallSize.x;//(((StoneSize.x+MortorSize.x)*WallSize.x)-MortorSize.x);
  #declare yWidth = StoneSize.y*WallSize.y;//(((StoneSize.y+MortorSize.y)*WallSize.y)-MortorSize.y);
  #declare zWidth = StoneSize.z*WallSize.z;//(((StoneSize.z+MortorSize.z)*WallSize.z)-MortorSize.z);
  
  #declare xLoc = (0 - (xWidth/2)) + (StoneSize.x/2);
  #declare yLoc = (0 - (yWidth/2)) + (StoneSize.y/2);
  #declare zLoc = (0 - (zWidth/2)) + (StoneSize.z/2);

  #local MortorObject =
  object
  {
    //box { <-xWidth/2+MortorDepth.x+MortorSize.x,-yWidth/2+MortorDepth.y+MortorSize.y,-zWidth/2+MortorDepth.z+MortorSize.z>, <xWidth/2-MortorDepth.x-MortorSize.x,yWidth/2-MortorDepth.y-MortorSize.y,zWidth/2-MortorDepth.z-MortorSize.x> }
    #local xMortor = xWidth-(MortorSize.x+MortorDepth.z);
    #local yMortor = yWidth-(MortorSize.y+MortorDepth.x);
    #local zMortor = zWidth-(MortorSize.z+MortorDepth.y);
    box { <0,0,0>,<xMortor,yMortor,zMortor> }
    //+MortorSize.x,-yWidth/2+MortorDepth.y+MortorSize.y,-zWidth/2+MortorDepth.z+MortorSize.z>, <xWidth/2-MortorDepth.x-MortorSize.x,yWidth/2-MortorDepth.y-MortorSize.y,zWidth/2-MortorDepth.z-MortorSize.x> }
    texture { MortorTexture }
    translate< -(xMortor/2), -(yMortor/2), -(zMortor/2) >
  }
  
  #local Stones =
  union
  {
    #local currentOffset = 0;
    #local xMinLimit = (0 - (xWidth/2));
    #local yMinLimit = (0 - (yWidth/2));
    #local xMaxLimit = (xWidth/2);
    #local yMaxLimit = (yWidth/2);
    #local zStart = (0 - (zWidth/2)) + (StoneSize.z/2);
    #local iCount = 0;
    
    //#debug concat( "Widths: ", str(xWidth,7,2), " : ", str(yWidth,7,2), " : ", str(zWidth,7,2), "\n" )
    
    #local xAddon = 0;
    #if ( Stagger != 0 )
      #local xAddon = 1;
    #end
    #local iz = 0;
    #while (iz < WallSize.z)
      #local iy = 0;
      #while (iy < WallSize.y)
        #local ix = 0;
        #while (ix < WallSize.x + xAddon)
          #local xStart = (ix*StoneSize.x)+currentOffset;
          #local xEnd = xStart + StoneSize.x;
          #if (xStart < 0)
            #local xStart = 0;
          #end
          #if (xEnd > xWidth)
            #local xEnd = xWidth;
          #end
          #local yStart = iy*StoneSize.y;
          #local yEnd = yStart + StoneSize.y;
          #local zStart = iz*StoneSize.z;
          #local zEnd = zStart + StoneSize.z;
          #local StoneRandom = seed(RandomSeed);
          #local RandomSeed = RandomSeed + 1;
          //#debug concat( "Here . . . ", str(currentOffset,7,2), " : ", str(xStart,7,2), ",", str(yStart,7,2), ",", str(zStart,7,2), " : ", str(xEnd,7,2), ",", str(yEnd,7,2), ",", str(zEnd,7,2), "\n" )
          #if (xStart != xEnd)
            Stone( <xStart+(MortorSize.x/2),yStart+(MortorSize.y/2),zStart+(MortorSize.z/2)>, <xEnd-(MortorSize.x/2),yEnd-(MortorSize.y/2),zEnd-(MortorSize.z/2)>, BrickType, StoneType, Interior, UseTextureCallback, TextureMap, TranslateTexture, StoneRandom, true )
            
            object{
              StoneObject
            }
          #end           
          #local ix = ix + 1;
        #end // ix
        //#debug concat( "\n" )
        #local currentOffset = currentOffset - Stagger;
        #if ( currentOffset <= -StoneSize.x )
          #local currentOffset = currentOffset + StoneSize.x;
        #end
        #local iy = iy + 1;
      #end // iy
      #local iz = iz + 1;
    #end // iz
    translate ( <-(xWidth/2), -(yWidth/2), -(zWidth/2)> )
    //texture{ T_Stone1 }  
  } // Stones union
  #local NegativeStones=
  object
  {
    #local StoneRandom = seed(RandomSeed);
  
    #local xWidth = StoneSize.x*WallSize.x;//(((StoneSize.x+MortorSize.x)*WallSize.x)-MortorSize.x);
    #local yWidth = StoneSize.y*WallSize.y;//(((StoneSize.y+MortorSize.y)*WallSize.y)-MortorSize.y);
    #local zWidth = StoneSize.z*WallSize.z;//(((StoneSize.z+MortorSize.z)*WallSize.z)-MortorSize.z);
    
    #local xLoc = (0 - (xWidth/2)) + (StoneSize.x/2);
    #local yLoc = (0 - (yWidth/2)) + (StoneSize.y/2);
    #local zLoc = (0 - (zWidth/2)) + (StoneSize.z/2);
    union
    {
      #local currentOffset = 0;
      #local xMinLimit = (0 - (xWidth/2));
      #local yMinLimit = (0 - (yWidth/2));
      #local xMaxLimit = (xWidth/2);
      #local yMaxLimit = (yWidth/2);
      #local zStart = (0 - (zWidth/2)) + (StoneSize.z/2);
      #local iCount = 0;
      
      //#debug concat( "difference Widths: ", str(xWidth,7,2), " : ", str(yWidth,7,2), " : ", str(zWidth,7,2), "\n" )
      
      #local xAddon = 0;
      #if ( Stagger != 0 )
        #local xAddon = 1;
      #end
      #local iz = 0;
      #while (iz < WallSize.z)
        #local iy = 0;
        #while (iy < WallSize.y)
          #local ix = 0;
          #while (ix < WallSize.x + xAddon)
            #local xStart = (ix*StoneSize.x)+currentOffset;
            #local xEnd = xStart + StoneSize.x;
            #if (xStart < 0)
              #local xStart = 0;
            #end
            #if (xEnd > xWidth)
              #local xEnd = xWidth;
            #end
            #local yStart = iy*StoneSize.y;
            #local yEnd = yStart + StoneSize.y;
            #local zStart = iz*StoneSize.z;
            #local zEnd = zStart + StoneSize.z;
            
            //#debug concat( "d Here . . . ", str(currentOffset,7,2), " : ", str(xStart,7,2), ",", str(yStart,7,2), ",", str(zStart,7,2), " : ", str(xEnd,7,2), ",", str(yEnd,7,2), ",", str(zEnd,7,2), "\n" )
            #if (xStart != xEnd)
              Stone( <xStart+(MortorSize.x/2),yStart+(MortorSize.y/2),zStart+(MortorSize.z/2)>, <xEnd-(MortorSize.x/2),yEnd-(MortorSize.y/2),zEnd-(MortorSize.z/2)>, BrickType, StoneType, Interior, UseTextureCallback, TextureMap, TranslateTexture, StoneRandom, false )
              
              object{
                StoneObject
              }
            #end           
            #local ix = ix + 1;
          #end // ix
          //#debug concat( "\n" )
          #local currentOffset = currentOffset - Stagger;
          #if ( currentOffset <= -StoneSize.x )
            #local currentOffset = currentOffset + StoneSize.x;
          #end
          #local iy = iy + 1;
        #end // iy
        #local iz = iz + 1;
      #end // iz
      translate ( <-(xWidth/2), -(yWidth/2), -(zWidth/2)> )
      //texture{ T_Stone1 }  
    } // Stones union
  } // NegativeStones
  #declare StoneWall =
    #if (Translucent = false)
      union
      {    
        object{ Stones }
        object{ MortorObject }
      } 
    #else
      union
      {    
        object{ Stones }
        difference
        {
          object{ MortorObject }
          object{ NegativeStones }
        }
      } 
    #end

#end // MakeStoneWall macro


// some samples

#declare Interior_Stone=
  interior {
//    ior 1.5
//    fade_distance 1.0
//    fade_power 2
//    fade_color Col_Glass_Old
  }
#declare Interior_Glass=
  interior {
    ior 2.0
    fade_distance 1.0
    fade_power 2
    fade_color Col_Glass_Old
  }

MakeStoneWall(<.5,0.5,.125>, <.025,.025,.025>, <.018,.018,.018>, <3,8,1>, Interior_Glass, 0, GlassBricksTextureMap, 0,  BrickType_Rounded, StoneType_Wavy, true, .00, 1)
    
